// SPDX-License-Identifier: GPL-2.0-or-later
#ifndef INKSCAPE_LIVEPATHEFFECT_PARAMETER_ORIGINALPATHARRAY_H
#define INKSCAPE_LIVEPATHEFFECT_PARAMETER_ORIGINALPATHARRAY_H

/*
 * Inkscape::LivePathEffectParameters
 *
 * Copyright (C) Theodore Janeczko 2012 <flutterguy317@gmail.com>
 *
 * Released under GNU GPL v2+, read the file 'COPYING' for more information.
 */

#include <vector>

#include <gtkmm/box.h>
#include <gtkmm/treeview.h>
#include <gtkmm/treestore.h>
#include <gtkmm/scrolledwindow.h>

#include "live_effects/parameter/parameter.h"
#include "live_effects/parameter/path-reference.h"

#include "svg/svg.h"
#include "svg/stringstream.h"
#include "path-reference.h"

class SPObject;

namespace Inkscape {

namespace LivePathEffect {

class PathAndDirectionAndVisible {
public:
    PathAndDirectionAndVisible(SPObject *owner)
    : href(nullptr),
    ref(owner),
    _pathvector(Geom::PathVector()),
    reversed(false),
    visibled(true)
    {
        
    }
    gchar *href;
    URIReference ref;
    Geom::PathVector _pathvector;
    bool reversed;
    bool visibled;
    
    sigc::connection linked_changed_connection;
    sigc::connection linked_delete_connection;
    sigc::connection linked_modified_connection;
};

class PathArrayParam : public Parameter
{
public:
    class ModelColumns;

    PathArrayParam(const Glib::ustring &label, const Glib::ustring &tip, const Glib::ustring &key,
                   Inkscape::UI::Widget::Registry *wr, Effect *effect);

    ~PathArrayParam() override;

    Gtk::Widget * param_newWidget() override;
    std::vector<SPObject *> param_get_satellites() override;
    bool param_readSVGValue(const gchar * strvalue) override;
    Glib::ustring param_getSVGValue() const override;
    Glib::ustring param_getDefaultSVGValue() const override;
    void param_set_default() override;
    void param_update_default(const gchar * default_value) override{};
    /** Disable the canvas indicators of parent class by overriding this method */
    void param_editOncanvas(SPItem * /*item*/, SPDesktop * /*dt*/) override {};
    /** Disable the canvas indicators of parent class by overriding this method */
    void addCanvasIndicators(SPLPEItem const* /*lpeitem*/, std::vector<Geom::PathVector> & /*hp_vec*/) override {};
    void setFromOriginalD(bool from_original_d){ _from_original_d = from_original_d; update();};
    void allowOnlyBsplineSpiro(bool allow_only_bspline_spiro){ _allow_only_bspline_spiro = allow_only_bspline_spiro; update();};
    void setUpdating(bool updating) {_updating = updating;};
    std::vector<PathAndDirectionAndVisible*> _vector;
    ParamType paramType() const override { return ParamType::PATH_ARRAY; };
protected:
    friend class LPEFillBetweenMany;
    bool _updateLink(const Gtk::TreeIter& iter, PathAndDirectionAndVisible* pd);
    bool _selectIndex(const Gtk::TreeIter& iter, int* i);
    void unlink(PathAndDirectionAndVisible* to);
    void start_listening();
    void setPathVector(SPObject *linked_obj, guint flags, PathAndDirectionAndVisible* to);
    
    void linked_changed(SPObject *old_obj, SPObject *new_obj, PathAndDirectionAndVisible* to);
    void linked_modified(SPObject *linked_obj, guint flags, PathAndDirectionAndVisible* to);
    void linked_delete(SPObject *deleted, PathAndDirectionAndVisible* to);
    
    ModelColumns *_model;
    Glib::RefPtr<Gtk::TreeStore> _store;
    Gtk::TreeView *_tree;
    Gtk::ScrolledWindow *_scroller;
    
    void on_link_button_click();
    void on_remove_button_click();
    void on_up_button_click();
    void on_down_button_click();
    void on_reverse_toggled(const Glib::ustring& path);
    void on_visible_toggled(const Glib::ustring& path);
    
private:
    bool _from_original_d;
    bool _allow_only_bspline_spiro;
    bool _updating = false;
    void update();
    void initui();
    PathArrayParam(const PathArrayParam &) = delete;
    PathArrayParam &operator=(const PathArrayParam &) = delete;
};

} //namespace LivePathEffect

} //namespace Inkscape

#endif

/*
  Local Variables:
  mode:c++
  c-file-style:"stroustrup"
  c-file-offsets:((innamespace . 0)(inline-open . 0)(case-label . +))
  indent-tabs-mode:nil
  fill-column:99
  End:
*/
// vim: filetype=cpp:expandtab:shiftwidth=4:tabstop=8:softtabstop=4 :
