#!/usr/bin/env python

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA



import sys
import urllib2
import gtk
from os import system
import HTML2Text



def findLink(htmlpiece):
	begin = htmlpiece.find('/tor/')
	einde = htmlpiece.find('>',begin)
	return  'http://www.mininova.org' + htmlpiece[begin:einde-1].replace('/tor/','/get/')



def buildResultList(deZoekterm,sites):
	results = {} # results is a dictionary
	if sites[0]== True:
		results = buildResultListTPB(deZoekterm, results)
	if sites[1]==True:
		results = buildResultListMiniNova(deZoekterm, results)
	if sites[2]==True:
		results = buildResultListTorrentz(deZoekterm, results)
	return results

def buildResultListTorrentz(deZoekterm, results):
	#################################################################################
#				Torrentz					#
#				Torrentz					#
#				Torrentz					#
#				Torrentz					#
#				Torrentz					#
#				Torrentz					#
#				Torrentz					#
#################################################################################	

	zoekBegin = '<div class="results">'
	zoekEinde = 'Previous</span>'
	html2text = HTML2Text.html2txt()

	
#replace space with + 
	urlZoekterm = 'http://www.torrentz.com/search?q=' + deZoekterm.replace(' ','+')
	response = urllib2.urlopen(urlZoekterm)
	resultsQuery = response.read()
	response.close()	
	beginHoofdBlok = resultsQuery.find(zoekBegin,0)
	# No results.... panic!!
	if beginHoofdBlok == -1:
		return results
	eindeHoofdBlok = resultsQuery.find(zoekEinde, beginHoofdBlok)
	if eindeHoofdBlok == -1:
		return results

	line = resultsQuery[beginHoofdBlok:eindeHoofdBlok + 8]
	
	
#start processing results	
	lineBeginMarker = '<dl><dt>'
	lineEndMarker = '</dl>'
# get a newline from the results
	startOfNewLine = line.find(lineBeginMarker,0)
	while startOfNewLine <> -1:
		endOfNewLine = line.find(lineEndMarker, startOfNewLine)
		newResult = line[startOfNewLine:endOfNewLine]
		startterm = newResult.find('href="',0)
		eindterm = newResult.find('</dt>',startterm)
		category = newResult[newResult.find('&#187; ')+7:newResult.find('</dt>')] 
		if not results.has_key(category):
			results[category]= [[]] #initialize this new category with an empty list
		else:
			#add a new (empty) list to this category 
			results[category].append([])

# this is the link to download (when resolved)
		link = 'http://www.torrentz.com' + newResult[startterm+6:newResult.find('>',startterm)-1] # add the link to the end of the sub-list
		siteAndLink = ['Torrentz',link]
		results[category][len(results[category])-1].insert( 5, siteAndLink )
#and add the text of the http link to the list
		results[category][len(results[category])-1].insert( len(results[category][len(results[category])-1])-1,newResult[newResult.find('>',startterm)+1:newResult.find('</a',startterm)])
		plaintext = newResult[newResult.find('<span class="s">')+16:newResult.find('</span>',newResult.find('<span class="s">'))]
		results[category][len(results[category])-1].insert( len(results[category][len(results[category])-1])-1,plaintext)
		plaintext = newResult[newResult.find('<span class="u">')+16:newResult.find('</span>',newResult.find('<span class="u">'))]
		results[category][len(results[category])-1].insert( len(results[category][len(results[category])-1])-1,plaintext)
		plaintext = newResult[newResult.find('<span class="d">')+16:newResult.find('</span>',newResult.find('<span class="d">'))]
		results[category][len(results[category])-1].insert( len(results[category][len(results[category])-1])-1,plaintext)
		startOfNewLine = line.find(lineBeginMarker,endOfNewLine)
	
	return results

def buildResultListTPB(deZoekterm, results):
	#################################################################################
#				thepiratebay.org				#
#				thepiratebay.org				#
#				thepiratebay.org				#
#				thepiratebay.org				#
#				thepiratebay.org				#
#				thepiratebay.org				#
#				thepiratebay.org				#
#################################################################################
	zoekBegin = '<table id="searchResult">'
	zoekEinde = '</table>'
	html2text = HTML2Text.html2txt()
	urlZoekterm = 'http://thepiratebay.org/search/' + deZoekterm.replace(' ','%20')
	response = urllib2.urlopen(urlZoekterm)
	fil = response.read()
	response.close()
	beginHoofdBlok = fil.find(zoekBegin,0)
	# ok no piratebay results so lets just return mininova
	if beginHoofdBlok == -1:
		return results
	eindeHoofdBlok = fil.find(zoekEinde, beginHoofdBlok)
	if eindeHoofdBlok == -1:
		return results
	
	line = fil[beginHoofdBlok:eindeHoofdBlok + 8]
	

#start processing http returned result
	index = 0
	startterm = 0
	eindterm = 0
	while startterm <> -1:
		startterm = line.find('<td',eindterm)
		eindterm = line.find('</td>',startterm)
		index = (index + 1) % 7
		
		html2text.reset()
		html2text.feed(line[startterm:eindterm+5])
		html2text.close()
#strip html tags
		plaintext = html2text.output()
		if index==1:
			#this is the category
			category = plaintext.lstrip().rstrip()
			if not results.has_key(category):
				results[category]= [[]] #initialize this new category
			else:
				#add a new list to this 
				results[category].append([])
		elif index == 3:
			continue
		elif index == 4:
			#this is the link so put it at the end of the sublist
			
			siteAndLinks = ['TPB', line[startterm + line[startterm:eindterm+5].find('href=') + 6:startterm+line[startterm:eindterm+5].find('"',line[startterm:eindterm+5].find('href=') + 6)], rightmouseLink]
			results[category][len(results[category])-1].insert( 5, siteAndLinks  )
			continue
		else:
			if index==2:
				rightmouseLink = 'http://www.thepiratebay.org' + line[startterm + line[startterm:eindterm+5].find('href=') + 6:startterm+line[startterm:eindterm+5].find('"',line[startterm:eindterm+5].find('href=') + 6)]
			results[category][len(results[category])-1].insert( len(results[category][len(results[category])-1])-1,plaintext)

	return results

def buildResultListMiniNova(deZoekterm, results):
	zoekBegin = '<table class="maintable"'
	zoekEinde = '</table>'
	html2text = HTML2Text.html2txt()

#replace space with + 
	urlZoekterm = 'http://www.mininova.org/search/?search=' + deZoekterm.replace(' ','+')
	response = urllib2.urlopen(urlZoekterm)
	fil = response.read()
	response.close()	
	beginHoofdBlok = fil.find(zoekBegin,0)
	# No results.... panic!!
	if beginHoofdBlok == -1:
		return results
	eindeHoofdBlok = fil.find(zoekEinde, beginHoofdBlok)
	if eindeHoofdBlok == -1:
		return results

	line = fil[beginHoofdBlok:eindeHoofdBlok + 8]
	

#start processing results	
	index = 0		
	startterm = 0
	eindterm = 0
	htmltext = ''
	category=''
	while startterm <> -1:
		startterm = line.find('<td',eindterm)
		eindterm = line.find('</td>',startterm)
		index = (index + 1) % 6	
		# necessary to strip html tags and get the clean text	
		html2text.reset()
		html2text.feed(line[startterm:eindterm+5])
		html2text.close()
		plaintext = html2text.output()
		if index == 1:
			continue
		elif index == 2: #mininova category
			category = plaintext.lstrip().rstrip()
			if not results.has_key(category):
				results[category]= [[]] #initialize this new category
			else:
				#add a new list to this 
				results[category].append([])
		elif index == 3:
# this is the link to download (when resolved)
			orglink = line[startterm:eindterm+5] # add the link to the end of the sub-list

			siteAndLinks = ['Mininova', findLink(orglink),'http://www.mininova.org' +  orglink[orglink.find('/tor/'):orglink.find('>',orglink.find('/tor/'))-1]] #the site, the left mouse click link, the rightmouse click link
			results[category][len(results[category])-1].insert( 5, siteAndLinks )
#and add the text of the http link to the list
			results[category][len(results[category])-1].insert( len(results[category][len(results[category])-1])-1,plaintext)
		else:
			#add to the currentRecord
			results[category][len(results[category])-1].insert( len(results[category][len(results[category])-1])-1,plaintext)
	return results
