package CParse::Op::NotEqual;

use 5.6.0;
use strict;
use warnings;

use CParse::Op;

use CExpr::NotEqual;

our @ISA = qw/CParse::Op/;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $left = shift;
    my $right = shift;

    my $self = {left => $left,
                right => $right,
               };
    bless $self, $class;
    return $self;
  }

sub args
  {
    my $self = shift;
    return ($self->{left}, $self->{right});
  }

sub dump_c
  {
    my $self = shift;
    my $left = $self->{left}->dump_c;
    my $right = $self->{right}->dump_c;

    return "($left != $right)";
  }

sub get_expr
  {
    my $self = shift;
    my $namespace = shift;

    my $left = $self->{left}->get_expr($namespace);
    my $right = $self->{right}->get_expr($namespace);

    return new CExpr::NotEqual $left, $right;
  }

1;
