/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.jive.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;

import javax.swing.border.AbstractBorder;

public class BottomEtchedBorder extends AbstractBorder {

    private static final long serialVersionUID = 1L;
    private static final Color darkColor = new Color(199, 199, 199);
    private static final Color lightColor = Color.white;

    public BottomEtchedBorder() {
        super();
    }

    @Override
    public void paintBorder(Component comp, Graphics g, int x, int y, int width, int height) {

        int ypos = y + height - 2;
        
        g.setColor(darkColor);
        g.drawLine(x, ypos, width - 1, ypos);
        g.setColor(lightColor);
        g.drawLine(x, ypos + 1, width - 1, ypos + 1);
    }
    
    @Override
    public Insets getBorderInsets(Component comp) {
        return new Insets(2, 2, 2, 2);
    }
    
    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}
