--------------------------------------------------------------------------------
-- |
-- Module      :  Graphics.Rendering.OpenGL.Raw.NV.TextureShader3
-- Copyright   :  (c) Sven Panne 2009
-- License     :  BSD-style (see the file LICENSE)
--
-- Maintainer  :  sven.panne@aedion.de
-- Stability   :  stable
-- Portability :  portable
--
-- All raw functions and tokens from the NV_texture_shader3 extension, see
-- <http://www.opengl.org/registry/specs/NV/texture_shader3.txt>.
--
--------------------------------------------------------------------------------

module Graphics.Rendering.OpenGL.Raw.NV.TextureShader3 (
   -- * Tokens
   gl_OFFSET_PROJECTIVE_TEXTURE_2D,
   gl_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE,
   gl_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE,
   gl_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE,
   gl_OFFSET_HILO_TEXTURE_2D,
   gl_OFFSET_HILO_TEXTURE_RECTANGLE,
   gl_OFFSET_HILO_PROJECTIVE_TEXTURE_2D,
   gl_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE,
   gl_DEPENDENT_HILO_TEXTURE_2D,
   gl_DEPENDENT_RGB_TEXTURE_3D,
   gl_DEPENDENT_RGB_TEXTURE_CUBE_MAP,
   gl_DOT_PRODUCT_PASS_THROUGH,
   gl_DOT_PRODUCT_TEXTURE_1D,
   gl_DOT_PRODUCT_AFFINE_DEPTH_REPLACE,
   gl_HILO8,
   gl_SIGNED_HILO8,
   gl_FORCE_BLUE_TO_ONE
) where

import Graphics.Rendering.OpenGL.Raw.Core32

gl_OFFSET_PROJECTIVE_TEXTURE_2D :: GLenum
gl_OFFSET_PROJECTIVE_TEXTURE_2D = 0x8850

gl_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE :: GLenum
gl_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE = 0x8851

gl_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE :: GLenum
gl_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE = 0x8852

gl_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE :: GLenum
gl_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE = 0x8853

gl_OFFSET_HILO_TEXTURE_2D :: GLenum
gl_OFFSET_HILO_TEXTURE_2D = 0x8854

gl_OFFSET_HILO_TEXTURE_RECTANGLE :: GLenum
gl_OFFSET_HILO_TEXTURE_RECTANGLE = 0x8855

gl_OFFSET_HILO_PROJECTIVE_TEXTURE_2D :: GLenum
gl_OFFSET_HILO_PROJECTIVE_TEXTURE_2D = 0x8856

gl_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE :: GLenum
gl_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE = 0x8857

gl_DEPENDENT_HILO_TEXTURE_2D :: GLenum
gl_DEPENDENT_HILO_TEXTURE_2D = 0x8858

gl_DEPENDENT_RGB_TEXTURE_3D :: GLenum
gl_DEPENDENT_RGB_TEXTURE_3D = 0x8859

gl_DEPENDENT_RGB_TEXTURE_CUBE_MAP :: GLenum
gl_DEPENDENT_RGB_TEXTURE_CUBE_MAP = 0x885A

gl_DOT_PRODUCT_PASS_THROUGH :: GLenum
gl_DOT_PRODUCT_PASS_THROUGH = 0x885B

gl_DOT_PRODUCT_TEXTURE_1D :: GLenum
gl_DOT_PRODUCT_TEXTURE_1D = 0x885C

gl_DOT_PRODUCT_AFFINE_DEPTH_REPLACE :: GLenum
gl_DOT_PRODUCT_AFFINE_DEPTH_REPLACE = 0x885D

gl_HILO8 :: GLenum
gl_HILO8 = 0x885E

gl_SIGNED_HILO8 :: GLenum
gl_SIGNED_HILO8 = 0x885F

gl_FORCE_BLUE_TO_ONE :: GLenum
gl_FORCE_BLUE_TO_ONE = 0x8860
