#ifndef MIV_IHC_VERSION_H
#define MIV_IHC_VERSION_H

/*******************************************************************************
 * Copyright 2021-2022 Microchip FPGA Embedded Systems Solutions.
 *
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to
 * deal in the Software without restriction, including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 *
 *
 *
 */

/*******************************************************************************
 * @file miv_ihc_version.h
 * @author Microchip-FPGA Embedded Systems Solutions
 * @brief Version file miv Inter Hart Communication driver
 *
 */

#ifdef __cplusplus
extern "C" {
#endif

/*-------------------------------------------------------------------------*//**

  ## Version of the MiV Inter Hart Communication driver

  |constant|Value|
  |-------------------------------------------------| -------------------------|
  | **MIV_IHC_VERSION_MAJOR**                       | **0**                    |
  | **MIV_IHC_VERSION_MINOR**                       | **1**                    |
  | **MIV_IHC_VERSION_MINOR**                       | **1**                    |

 */
#define MIV_IHC_VERSION_MAJOR 0
#define MIV_IHC_VERSION_MINOR 1
#define MIV_IHC_VERSION_PATCH 1

#ifdef __cplusplus
}
#endif

#endif /* end MIV_IHC_VERSION_H */
