/***************************************************************************
 *   Copyright (C) 2003-2007 by Spiros Georgaras <sng@hellug.gr>           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/

#ifndef EXIF_H
#define EXIF_H
#include <qstring.h>
#include <qfile.h>
#include <qdatastream.h>

//#define offset 12
#define mDate 0x0132
#define cDate 0xFFFF9003
#define subID 0xFFFF8769
/**
  *@author Spiros Georgaras
  */

class EXIF {
public: 
	EXIF(QString fName);
	~EXIF();
  bool isExif;
  QString getExifDate(int mode);
private:
	quint32 getIFDoffset(void);
	quint16 getNumOFIFDEntries(void);
	QString getDate(qint16 EntryID);
  quint32 getSubOffset(void);
  quint16 getNumOfSunEntries(void);
	bool checkExif(void);
	QString fileName;
  QFile ff;
  QDataStream ds;
// 	int fileType; old impl
	QDataStream::ByteOrder fileType;
	quint32 IFDoffset;
	quint16 numOfEntries;
	quint32 subIFDoffset;
	quint16 numOfSunEntries;
	quint16 offset;
};

#endif
