/* Groundhog -- a simple logic game
 * Copyright (C) 1998-2002 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <algorithm>
#include <functional>

#include "ball.h"
#include "pocket.h"


Pocket::Pocket(GtkWidget* table, int row, int col) : _table(table), 
						     _element(0), _ball(0)
{
   /* a pixmap widget to contain the pixmap */
   _pixmapwid = gtk_image_new_from_stock(GROUNDHOG_STOCK_LEFT_RED, 
					 Icons::Size());
/*   gtk_table_attach_defaults(GTK_TABLE(_table), _pixmapwid, col, col + 1, 
     row, row + 1); */
   gtk_table_attach(GTK_TABLE(_table), _pixmapwid, col, col + 1, 
		    row, row + 1, GTK_EXPAND, GTK_EXPAND, 0, 0);
}

void 
Pocket::PutBall(Ball* ball)
{
   const gchar* stock_id = 0;

   _ball = ball;
   switch (ball->GetColor()) {
   case Ball::Red:
      stock_id = GetRedPixmap();
      break;
   case Ball::Green:
      stock_id = GetGreenPixmap();
      break;
   case Ball::Blue:
      stock_id = GetBluePixmap();
      break;
   case Ball::Yellow:
      stock_id = GetYellowPixmap();
      break;
   }
   gtk_image_set_from_stock(GTK_IMAGE(_pixmapwid), stock_id, Icons::Size());
   Element::PutBall(ball);
}

bool
Pocket::Contains(Ball::Color color)
{
   return _ball->GetColor() == color;
}

void
SetOffPockets::Eject()
{
   for_each(_set.begin(), _set.end(), std::mem_fun(&Pocket::Eject));
}

bool 
SetOffPockets::HasRightBalls()
{
   return 
      find_if(_set.begin(), _set.end(), 
	      std::not1(std::mem_fun(&Pocket::HasRightBall))) == _set.end();
}

void 
LeftPocket::MoveBall(Ball* ball)
{
   if (ball->GetDirection() == Ball::MovingLeft) {
      ball->SetDirection(Ball::NotMoving);
      _ball = ball;
   } else { 
      _element->PutBall(ball);
      _ball = 0;
   }
}

void 
LeftPocket::Eject()
{
   _ball->SetDirection(Ball::MovingRight);
}

void 
UpperPocket::MoveBall(Ball* ball)
{
   if (ball->GetDirection() == Ball::MovingUp) {
      ball->SetDirection(Ball::NotMoving);
      _ball = ball;
   } else {
      _element->PutBall(ball);
      _ball = 0;
   }
}

void
UpperPocket::Eject()
{
   _ball->SetDirection(Ball::MovingDown);
}

void 
RightPocket::MoveBall(Ball* ball)
{
   if (ball->GetDirection() == Ball::MovingRight) {
      ball->SetDirection(Ball::NotMoving);
      _ball = ball;
   } else {
      _element->PutBall(ball);
      _ball = 0;
   }
}

void
RightPocket::Eject()
{
   _ball->SetDirection(Ball::MovingLeft);
}

void 
LowerPocket::MoveBall(Ball* ball)
{
   if (ball->GetDirection() == Ball::MovingDown) {
      ball->SetDirection(Ball::NotMoving);
      _ball = ball;
   } else {
      _element->PutBall(ball);
      _ball = 0;
   }
}

void
LowerPocket::Eject()
{
   _ball->SetDirection(Ball::MovingUp);
}
