/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pcc;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import com.dsi.ant.plugins.antplus.pcc.defines.BatteryStatus;
import com.dsi.ant.plugins.antplus.pcc.defines.EventFlag;
import com.dsi.ant.plugins.antplus.pccbase.AntPluginPcc;
import com.dsi.ant.plugins.antplus.pccbase.AntPlusCommonPcc;
import com.dsi.ant.plugins.antplus.pccbase.AsyncScanController;
import com.dsi.ant.plugins.antplus.pccbase.PccReleaseHandle;
import java.math.BigDecimal;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntPlusStrideSdmPcc
extends AntPlusCommonPcc {
    IInstantaneousSpeedReceiver mInstantaneousSpeedReceiver;
    IInstantaneousCadenceReceiver mInstantaneousCadenceReceiver;
    IDistanceReceiver mDistanceReceiver;
    IStrideCountReceiver mStrideCountReceiver;
    IComputationTimestampReceiver mComputationTimestampReceiver;
    IDataLatencyReceiver mDataLatencyReceiver;
    ICalorieDataReceiver mCalorieDataReceiver;
    ISensorStatusReceiver mSensorStatusReceiver;

    @Override
    protected int getRequiredServiceVersionForBind() {
        return 0;
    }

    public static PccReleaseHandle<AntPlusStrideSdmPcc> requestAccess(Activity userActivity, Context bindToContext, boolean skipPreferredSearch, int searchProximityThreshold, AntPluginPcc.IPluginAccessResultReceiver<AntPlusStrideSdmPcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        AntPlusStrideSdmPcc potentialRetObj = new AntPlusStrideSdmPcc();
        return AntPlusStrideSdmPcc.requestAccess_Helper_SearchActivity(userActivity, bindToContext, skipPreferredSearch, searchProximityThreshold, potentialRetObj, resultReceiver, stateReceiver);
    }

    public static PccReleaseHandle<AntPlusStrideSdmPcc> requestAccess(Activity userActivity, Context bindToContext, AntPluginPcc.IPluginAccessResultReceiver<AntPlusStrideSdmPcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        return AntPlusStrideSdmPcc.requestAccess(userActivity, bindToContext, false, -1, resultReceiver, stateReceiver);
    }

    public static PccReleaseHandle<AntPlusStrideSdmPcc> requestAccess(Context bindToContext, int antDeviceNumber, int searchProximityThreshold, AntPluginPcc.IPluginAccessResultReceiver<AntPlusStrideSdmPcc> resultReceiver, AntPluginPcc.IDeviceStateChangeReceiver stateReceiver) {
        AntPlusStrideSdmPcc potentialRetObj = new AntPlusStrideSdmPcc();
        return AntPlusStrideSdmPcc.requestAccess_Helper_AsyncSearchByDevNumber(bindToContext, antDeviceNumber, searchProximityThreshold, potentialRetObj, resultReceiver, stateReceiver);
    }

    public static AsyncScanController<AntPlusStrideSdmPcc> requestAsyncScanController(Context bindToContext, int searchProximityThreshold, AsyncScanController.IAsyncScanResultReceiver scanResultReceiver) {
        AntPlusStrideSdmPcc potentialRetObj = new AntPlusStrideSdmPcc();
        return AntPlusStrideSdmPcc.requestAccess_Helper_AsyncScanController(bindToContext, searchProximityThreshold, potentialRetObj, scanResultReceiver);
    }

    private AntPlusStrideSdmPcc() {
    }

    @Override
    protected Intent getServiceBindIntent() {
        Intent it = new Intent();
        it.setComponent(new ComponentName("com.dsi.ant.plugins.antplus", "com.dsi.ant.plugins.antplus.stridesdm.StrideSdmService"));
        return it;
    }

    @Override
    protected String getPluginPrintableName() {
        return "ANT+ Plugin: Stride Based Speed and Distance";
    }

    @Override
    protected void handlePluginEvent(Message eventMsg) {
        switch (eventMsg.arg1) {
            case 201: {
                if (this.mInstantaneousSpeedReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                BigDecimal instantaneousSpeed = (BigDecimal)b.getSerializable("decimal_instantaneousSpeed");
                this.mInstantaneousSpeedReceiver.onNewInstantaneousSpeed(estTimestamp, eventFlags, instantaneousSpeed);
                break;
            }
            case 202: {
                if (this.mInstantaneousCadenceReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                BigDecimal instantaneousCadence = (BigDecimal)b.getSerializable("decimal_instantaneousCadence");
                this.mInstantaneousCadenceReceiver.onNewInstantaneousCadence(estTimestamp, eventFlags, instantaneousCadence);
                break;
            }
            case 203: {
                if (this.mDistanceReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                BigDecimal cumulativeDistance = (BigDecimal)b.getSerializable("decimal_cumulativeDistance");
                this.mDistanceReceiver.onNewDistance(estTimestamp, eventFlags, cumulativeDistance);
                break;
            }
            case 204: {
                if (this.mStrideCountReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                long cumulativeStrides = b.getLong("long_cumulativeStrides");
                this.mStrideCountReceiver.onNewStrideCount(estTimestamp, eventFlags, cumulativeStrides);
                break;
            }
            case 205: {
                if (this.mComputationTimestampReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                BigDecimal timestampOfLastComputation = (BigDecimal)b.getSerializable("decimal_timestampOfLastComputation");
                this.mComputationTimestampReceiver.onNewComputationTimestamp(estTimestamp, eventFlags, timestampOfLastComputation);
                break;
            }
            case 206: {
                if (this.mDataLatencyReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                BigDecimal updateLatency = (BigDecimal)b.getSerializable("decimal_updateLatency");
                this.mDataLatencyReceiver.onNewDataLatency(estTimestamp, eventFlags, updateLatency);
                break;
            }
            case 207: {
                if (this.mCalorieDataReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                long cumulativeCalories = b.getLong("long_cumulativeCalories");
                this.mCalorieDataReceiver.onNewCalorieData(estTimestamp, eventFlags, cumulativeCalories);
                break;
            }
            case 208: {
                if (this.mSensorStatusReceiver == null) break;
                Bundle b = eventMsg.getData();
                long estTimestamp = b.getLong("long_EstTimestamp");
                EnumSet<EventFlag> eventFlags = EventFlag.getEventFlagsFromLong(b.getLong("long_EventFlags"));
                SensorLocation sensorLocation = SensorLocation.getValueFromInt(b.getInt("int_SensorLocation"));
                BatteryStatus batteryStatus = BatteryStatus.getValueFromInt(b.getInt("int_BatteryStatus"));
                SensorHealth sensorHealth = SensorHealth.getValueFromInt(b.getInt("int_SensorHealth"));
                SensorUseState useState = SensorUseState.getValueFromInt(b.getInt("int_UseState"));
                this.mSensorStatusReceiver.onNewSensorStatus(estTimestamp, eventFlags, sensorLocation, batteryStatus, sensorHealth, useState);
                break;
            }
            default: {
                super.handlePluginEvent(eventMsg);
            }
        }
    }

    public void subscribeInstantaneousSpeedEvent(IInstantaneousSpeedReceiver InstantaneousSpeedReceiver) {
        this.mInstantaneousSpeedReceiver = InstantaneousSpeedReceiver;
        if (InstantaneousSpeedReceiver != null) {
            this.subscribeToEvent(201);
        } else {
            this.unsubscribeFromEvent(201);
        }
    }

    public void subscribeInstantaneousCadenceEvent(IInstantaneousCadenceReceiver InstantaneousCadenceReceiver) {
        this.mInstantaneousCadenceReceiver = InstantaneousCadenceReceiver;
        if (InstantaneousCadenceReceiver != null) {
            this.subscribeToEvent(202);
        } else {
            this.unsubscribeFromEvent(202);
        }
    }

    public void subscribeDistanceEvent(IDistanceReceiver DistanceReceiver) {
        this.mDistanceReceiver = DistanceReceiver;
        if (DistanceReceiver != null) {
            this.subscribeToEvent(203);
        } else {
            this.unsubscribeFromEvent(203);
        }
    }

    public void subscribeStrideCountEvent(IStrideCountReceiver StrideCountReceiver) {
        this.mStrideCountReceiver = StrideCountReceiver;
        if (StrideCountReceiver != null) {
            this.subscribeToEvent(204);
        } else {
            this.unsubscribeFromEvent(204);
        }
    }

    public void subscribeComputationTimestampEvent(IComputationTimestampReceiver ComputationTimestampReceiver) {
        this.mComputationTimestampReceiver = ComputationTimestampReceiver;
        if (ComputationTimestampReceiver != null) {
            this.subscribeToEvent(205);
        } else {
            this.unsubscribeFromEvent(205);
        }
    }

    public void subscribeDataLatencyEvent(IDataLatencyReceiver DataLatencyReceiver) {
        this.mDataLatencyReceiver = DataLatencyReceiver;
        if (DataLatencyReceiver != null) {
            this.subscribeToEvent(206);
        } else {
            this.unsubscribeFromEvent(206);
        }
    }

    public void subscribeCalorieDataEvent(ICalorieDataReceiver CalorieDataReceiver) {
        this.mCalorieDataReceiver = CalorieDataReceiver;
        if (CalorieDataReceiver != null) {
            this.subscribeToEvent(207);
        } else {
            this.unsubscribeFromEvent(207);
        }
    }

    public void subscribeSensorStatusEvent(ISensorStatusReceiver SensorStatusReceiver) {
        this.mSensorStatusReceiver = SensorStatusReceiver;
        if (SensorStatusReceiver != null) {
            this.subscribeToEvent(208);
        } else {
            this.unsubscribeFromEvent(208);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SensorUseState {
        INACTIVE(0),
        ACTIVE(1),
        UNRECOGNIZED(-1);

        private int intValue;

        private SensorUseState(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static SensorUseState getValueFromInt(int intValue) {
            for (SensorUseState state : SensorUseState.values()) {
                if (state.getIntValue() != intValue) continue;
                return state;
            }
            SensorUseState unrecognized = UNRECOGNIZED;
            unrecognized.intValue = intValue;
            return unrecognized;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SensorHealth {
        OK(0),
        ERROR(1),
        WARNING(2),
        UNRECOGNIZED(-1);

        private int intValue;

        private SensorHealth(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static SensorHealth getValueFromInt(int intValue) {
            for (SensorHealth health : SensorHealth.values()) {
                if (health.getIntValue() != intValue) continue;
                return health;
            }
            SensorHealth unrecognized = UNRECOGNIZED;
            unrecognized.intValue = intValue;
            return unrecognized;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SensorLocation {
        LACES(0),
        MIDSOLE(1),
        OTHER(2),
        ANKLE(3),
        UNRECOGNIZED(-1);

        private int intValue;

        private SensorLocation(int intValue) {
            this.intValue = intValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        public static SensorLocation getValueFromInt(int intValue) {
            for (SensorLocation location : SensorLocation.values()) {
                if (location.getIntValue() != intValue) continue;
                return location;
            }
            SensorLocation unrecognized = UNRECOGNIZED;
            unrecognized.intValue = intValue;
            return unrecognized;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ISensorStatusReceiver {
        public void onNewSensorStatus(long var1, EnumSet<EventFlag> var3, SensorLocation var4, BatteryStatus var5, SensorHealth var6, SensorUseState var7);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ICalorieDataReceiver {
        public void onNewCalorieData(long var1, EnumSet<EventFlag> var3, long var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IDataLatencyReceiver {
        public void onNewDataLatency(long var1, EnumSet<EventFlag> var3, BigDecimal var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IComputationTimestampReceiver {
        public void onNewComputationTimestamp(long var1, EnumSet<EventFlag> var3, BigDecimal var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IStrideCountReceiver {
        public void onNewStrideCount(long var1, EnumSet<EventFlag> var3, long var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IDistanceReceiver {
        public void onNewDistance(long var1, EnumSet<EventFlag> var3, BigDecimal var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IInstantaneousCadenceReceiver {
        public void onNewInstantaneousCadence(long var1, EnumSet<EventFlag> var3, BigDecimal var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IInstantaneousSpeedReceiver {
        public void onNewInstantaneousSpeed(long var1, EnumSet<EventFlag> var3, BigDecimal var4);
    }

    public class IpcDefines {
        public static final String PATH_ANTPLUS_STRIDESDMPLUGIN_PKG = "com.dsi.ant.plugins.antplus";
        public static final String PATH_ANTPLUS_STRIDESDMPLUGIN_SERVICE = "com.dsi.ant.plugins.antplus.stridesdm.StrideSdmService";
        public static final int MSG_EVENT_STRIDESDM_whatINSTANTANEOUSSPEED = 201;
        public static final String MSG_EVENT_STRIDESDM_INSTANTANEOUSSPEED_PARAM_decimalINSTANTANEOUSSPEED = "decimal_instantaneousSpeed";
        public static final int MSG_EVENT_STRIDESDM_whatINSTANTANEOUSCADENCE = 202;
        public static final String MSG_EVENT_STRIDESDM_INSTANTANEOUSCADENCE_PARAM_decimalINSTANTANEOUSCADENCE = "decimal_instantaneousCadence";
        public static final int MSG_EVENT_STRIDESDM_whatDISTANCE = 203;
        public static final String MSG_EVENT_STRIDESDM_DISTANCE_PARAM_decimalCUMULATIVEDISTANCE = "decimal_cumulativeDistance";
        public static final int MSG_EVENT_STRIDESDM_whatSTRIDECOUNT = 204;
        public static final String MSG_EVENT_STRIDESDM_STRIDECOUNT_PARAM_longCUMULATIVESTRIDES = "long_cumulativeStrides";
        public static final int MSG_EVENT_STRIDESDM_whatCOMPUTATIONTIMESTAMP = 205;
        public static final String MSG_EVENT_STRIDESDM_COMPUTATIONTIMESTAMP_PARAM_decimalTIMESTAMPOFLASTCOMPUTATION = "decimal_timestampOfLastComputation";
        public static final int MSG_EVENT_STRIDESDM_whatDATALATENCY = 206;
        public static final String MSG_EVENT_STRIDESDM_DATALATENCY_PARAM_decimalUPDATELATENCY = "decimal_updateLatency";
        public static final int MSG_EVENT_STRIDESDM_whatCALORIEDATA = 207;
        public static final String MSG_EVENT_STRIDESDM_CALORIEDATA_PARAM_longCUMULATIVECALORIES = "long_cumulativeCalories";
        public static final int MSG_EVENT_STRIDESDM_whatSENSORSTATUS = 208;
        public static final String MSG_EVENT_STRIDESDM_SENSORSTATUS_PARAM_intSENSORLOCATION = "int_SensorLocation";
        public static final String MSG_EVENT_STRIDESDM_SENSORSTATUS_PARAM_intBATTERYSTATUS = "int_BatteryStatus";
        public static final String MSG_EVENT_STRIDESDM_SENSORSTATUS_PARAM_intSENSORHEALTH = "int_SensorHealth";
        public static final String MSG_EVENT_STRIDESDM_SENSORSTATUS_PARAM_intUSESTATE = "int_UseState";
    }
}

