/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by counterfeiter. DO NOT EDIT.
package httpfakes

import (
	httpa "net/http"
	"sync"

	"sigs.k8s.io/release-utils/http"
)

type FakeAgentImplementation struct {
	SendGetRequestStub        func(*httpa.Client, string) (*httpa.Response, error)
	sendGetRequestMutex       sync.RWMutex
	sendGetRequestArgsForCall []struct {
		arg1 *httpa.Client
		arg2 string
	}
	sendGetRequestReturns struct {
		result1 *httpa.Response
		result2 error
	}
	sendGetRequestReturnsOnCall map[int]struct {
		result1 *httpa.Response
		result2 error
	}
	SendPostRequestStub        func(*httpa.Client, string, []byte, string) (*httpa.Response, error)
	sendPostRequestMutex       sync.RWMutex
	sendPostRequestArgsForCall []struct {
		arg1 *httpa.Client
		arg2 string
		arg3 []byte
		arg4 string
	}
	sendPostRequestReturns struct {
		result1 *httpa.Response
		result2 error
	}
	sendPostRequestReturnsOnCall map[int]struct {
		result1 *httpa.Response
		result2 error
	}
	invocations      map[string][][]interface{}
	invocationsMutex sync.RWMutex
}

func (fake *FakeAgentImplementation) SendGetRequest(arg1 *httpa.Client, arg2 string) (*httpa.Response, error) {
	fake.sendGetRequestMutex.Lock()
	ret, specificReturn := fake.sendGetRequestReturnsOnCall[len(fake.sendGetRequestArgsForCall)]
	fake.sendGetRequestArgsForCall = append(fake.sendGetRequestArgsForCall, struct {
		arg1 *httpa.Client
		arg2 string
	}{arg1, arg2})
	stub := fake.SendGetRequestStub
	fakeReturns := fake.sendGetRequestReturns
	fake.recordInvocation("SendGetRequest", []interface{}{arg1, arg2})
	fake.sendGetRequestMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeAgentImplementation) SendGetRequestCallCount() int {
	fake.sendGetRequestMutex.RLock()
	defer fake.sendGetRequestMutex.RUnlock()
	return len(fake.sendGetRequestArgsForCall)
}

func (fake *FakeAgentImplementation) SendGetRequestCalls(stub func(*httpa.Client, string) (*httpa.Response, error)) {
	fake.sendGetRequestMutex.Lock()
	defer fake.sendGetRequestMutex.Unlock()
	fake.SendGetRequestStub = stub
}

func (fake *FakeAgentImplementation) SendGetRequestArgsForCall(i int) (*httpa.Client, string) {
	fake.sendGetRequestMutex.RLock()
	defer fake.sendGetRequestMutex.RUnlock()
	argsForCall := fake.sendGetRequestArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2
}

func (fake *FakeAgentImplementation) SendGetRequestReturns(result1 *httpa.Response, result2 error) {
	fake.sendGetRequestMutex.Lock()
	defer fake.sendGetRequestMutex.Unlock()
	fake.SendGetRequestStub = nil
	fake.sendGetRequestReturns = struct {
		result1 *httpa.Response
		result2 error
	}{result1, result2}
}

func (fake *FakeAgentImplementation) SendGetRequestReturnsOnCall(i int, result1 *httpa.Response, result2 error) {
	fake.sendGetRequestMutex.Lock()
	defer fake.sendGetRequestMutex.Unlock()
	fake.SendGetRequestStub = nil
	if fake.sendGetRequestReturnsOnCall == nil {
		fake.sendGetRequestReturnsOnCall = make(map[int]struct {
			result1 *httpa.Response
			result2 error
		})
	}
	fake.sendGetRequestReturnsOnCall[i] = struct {
		result1 *httpa.Response
		result2 error
	}{result1, result2}
}

func (fake *FakeAgentImplementation) SendPostRequest(arg1 *httpa.Client, arg2 string, arg3 []byte, arg4 string) (*httpa.Response, error) {
	var arg3Copy []byte
	if arg3 != nil {
		arg3Copy = make([]byte, len(arg3))
		copy(arg3Copy, arg3)
	}
	fake.sendPostRequestMutex.Lock()
	ret, specificReturn := fake.sendPostRequestReturnsOnCall[len(fake.sendPostRequestArgsForCall)]
	fake.sendPostRequestArgsForCall = append(fake.sendPostRequestArgsForCall, struct {
		arg1 *httpa.Client
		arg2 string
		arg3 []byte
		arg4 string
	}{arg1, arg2, arg3Copy, arg4})
	stub := fake.SendPostRequestStub
	fakeReturns := fake.sendPostRequestReturns
	fake.recordInvocation("SendPostRequest", []interface{}{arg1, arg2, arg3Copy, arg4})
	fake.sendPostRequestMutex.Unlock()
	if stub != nil {
		return stub(arg1, arg2, arg3, arg4)
	}
	if specificReturn {
		return ret.result1, ret.result2
	}
	return fakeReturns.result1, fakeReturns.result2
}

func (fake *FakeAgentImplementation) SendPostRequestCallCount() int {
	fake.sendPostRequestMutex.RLock()
	defer fake.sendPostRequestMutex.RUnlock()
	return len(fake.sendPostRequestArgsForCall)
}

func (fake *FakeAgentImplementation) SendPostRequestCalls(stub func(*httpa.Client, string, []byte, string) (*httpa.Response, error)) {
	fake.sendPostRequestMutex.Lock()
	defer fake.sendPostRequestMutex.Unlock()
	fake.SendPostRequestStub = stub
}

func (fake *FakeAgentImplementation) SendPostRequestArgsForCall(i int) (*httpa.Client, string, []byte, string) {
	fake.sendPostRequestMutex.RLock()
	defer fake.sendPostRequestMutex.RUnlock()
	argsForCall := fake.sendPostRequestArgsForCall[i]
	return argsForCall.arg1, argsForCall.arg2, argsForCall.arg3, argsForCall.arg4
}

func (fake *FakeAgentImplementation) SendPostRequestReturns(result1 *httpa.Response, result2 error) {
	fake.sendPostRequestMutex.Lock()
	defer fake.sendPostRequestMutex.Unlock()
	fake.SendPostRequestStub = nil
	fake.sendPostRequestReturns = struct {
		result1 *httpa.Response
		result2 error
	}{result1, result2}
}

func (fake *FakeAgentImplementation) SendPostRequestReturnsOnCall(i int, result1 *httpa.Response, result2 error) {
	fake.sendPostRequestMutex.Lock()
	defer fake.sendPostRequestMutex.Unlock()
	fake.SendPostRequestStub = nil
	if fake.sendPostRequestReturnsOnCall == nil {
		fake.sendPostRequestReturnsOnCall = make(map[int]struct {
			result1 *httpa.Response
			result2 error
		})
	}
	fake.sendPostRequestReturnsOnCall[i] = struct {
		result1 *httpa.Response
		result2 error
	}{result1, result2}
}

func (fake *FakeAgentImplementation) Invocations() map[string][][]interface{} {
	fake.invocationsMutex.RLock()
	defer fake.invocationsMutex.RUnlock()
	fake.sendGetRequestMutex.RLock()
	defer fake.sendGetRequestMutex.RUnlock()
	fake.sendPostRequestMutex.RLock()
	defer fake.sendPostRequestMutex.RUnlock()
	copiedInvocations := map[string][][]interface{}{}
	for key, value := range fake.invocations {
		copiedInvocations[key] = value
	}
	return copiedInvocations
}

func (fake *FakeAgentImplementation) recordInvocation(key string, args []interface{}) {
	fake.invocationsMutex.Lock()
	defer fake.invocationsMutex.Unlock()
	if fake.invocations == nil {
		fake.invocations = map[string][][]interface{}{}
	}
	if fake.invocations[key] == nil {
		fake.invocations[key] = [][]interface{}{}
	}
	fake.invocations[key] = append(fake.invocations[key], args)
}

var _ http.AgentImplementation = new(FakeAgentImplementation)
