/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta2

// ResourcePoolApplyConfiguration represents a declarative configuration of the ResourcePool type for use
// with apply.
type ResourcePoolApplyConfiguration struct {
	Name               *string `json:"name,omitempty"`
	Generation         *int64  `json:"generation,omitempty"`
	ResourceSliceCount *int64  `json:"resourceSliceCount,omitempty"`
}

// ResourcePoolApplyConfiguration constructs a declarative configuration of the ResourcePool type for use with
// apply.
func ResourcePool() *ResourcePoolApplyConfiguration {
	return &ResourcePoolApplyConfiguration{}
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *ResourcePoolApplyConfiguration) WithName(value string) *ResourcePoolApplyConfiguration {
	b.Name = &value
	return b
}

// WithGeneration sets the Generation field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Generation field is set to the value of the last call.
func (b *ResourcePoolApplyConfiguration) WithGeneration(value int64) *ResourcePoolApplyConfiguration {
	b.Generation = &value
	return b
}

// WithResourceSliceCount sets the ResourceSliceCount field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ResourceSliceCount field is set to the value of the last call.
func (b *ResourcePoolApplyConfiguration) WithResourceSliceCount(value int64) *ResourcePoolApplyConfiguration {
	b.ResourceSliceCount = &value
	return b
}
