// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/rpc/context/attribute_context.proto

package attribute_context

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_struct "github.com/golang/protobuf/ptypes/struct"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// This message defines the standard attribute vocabulary for Google APIs.
//
// An attribute is a piece of metadata that describes an activity on a network
// service. For example, the size of an HTTP request, or the status code of
// an HTTP response.
//
// Each attribute has a type and a name, which is logically defined as
// a proto message field in `AttributeContext`. The field type becomes the
// attribute type, and the field path becomes the attribute name. For example,
// the attribute `source.ip` maps to field `AttributeContext.source.ip`.
//
// This message definition is guaranteed not to have any wire breaking change.
// So you can use it directly for passing attributes across different systems.
//
// NOTE: Different system may generate different subset of attributes. Please
// verify the system specification before relying on an attribute generated
// a system.
type AttributeContext struct {
	// The origin of a network activity. In a multi hop network activity,
	// the origin represents the sender of the first hop. For the first hop,
	// the `source` and the `origin` must have the same content.
	Origin *AttributeContext_Peer `protobuf:"bytes,7,opt,name=origin,proto3" json:"origin,omitempty"`
	// The source of a network activity, such as starting a TCP connection.
	// In a multi hop network activity, the source represents the sender of the
	// last hop.
	Source *AttributeContext_Peer `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// The destination of a network activity, such as accepting a TCP connection.
	// In a multi hop network activity, the destination represents the receiver of
	// the last hop.
	Destination *AttributeContext_Peer `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	// Represents a network request, such as an HTTP request.
	Request *AttributeContext_Request `protobuf:"bytes,3,opt,name=request,proto3" json:"request,omitempty"`
	// Represents a network response, such as an HTTP response.
	Response *AttributeContext_Response `protobuf:"bytes,4,opt,name=response,proto3" json:"response,omitempty"`
	// Represents a target resource that is involved with a network activity.
	// If multiple resources are involved with an activity, this must be the
	// primary one.
	Resource *AttributeContext_Resource `protobuf:"bytes,5,opt,name=resource,proto3" json:"resource,omitempty"`
	// Represents an API operation that is involved to a network activity.
	Api                  *AttributeContext_Api `protobuf:"bytes,6,opt,name=api,proto3" json:"api,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *AttributeContext) Reset()         { *m = AttributeContext{} }
func (m *AttributeContext) String() string { return proto.CompactTextString(m) }
func (*AttributeContext) ProtoMessage()    {}
func (*AttributeContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_f2b5252148978b42, []int{0}
}

func (m *AttributeContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttributeContext.Unmarshal(m, b)
}
func (m *AttributeContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttributeContext.Marshal(b, m, deterministic)
}
func (m *AttributeContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttributeContext.Merge(m, src)
}
func (m *AttributeContext) XXX_Size() int {
	return xxx_messageInfo_AttributeContext.Size(m)
}
func (m *AttributeContext) XXX_DiscardUnknown() {
	xxx_messageInfo_AttributeContext.DiscardUnknown(m)
}

var xxx_messageInfo_AttributeContext proto.InternalMessageInfo

func (m *AttributeContext) GetOrigin() *AttributeContext_Peer {
	if m != nil {
		return m.Origin
	}
	return nil
}

func (m *AttributeContext) GetSource() *AttributeContext_Peer {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *AttributeContext) GetDestination() *AttributeContext_Peer {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (m *AttributeContext) GetRequest() *AttributeContext_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *AttributeContext) GetResponse() *AttributeContext_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *AttributeContext) GetResource() *AttributeContext_Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *AttributeContext) GetApi() *AttributeContext_Api {
	if m != nil {
		return m.Api
	}
	return nil
}

// This message defines attributes for a node that handles a network request.
// The node can be either a service or an application that sends, forwards,
// or receives the request. Service peers should fill in
// `principal` and `labels` as appropriate.
type AttributeContext_Peer struct {
	// The IP address of the peer.
	Ip string `protobuf:"bytes,1,opt,name=ip,proto3" json:"ip,omitempty"`
	// The network port of the peer.
	Port int64 `protobuf:"varint,2,opt,name=port,proto3" json:"port,omitempty"`
	// The labels associated with the peer.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The identity of this peer. Similar to `Request.auth.principal`, but
	// relative to the peer instead of the request. For example, the
	// idenity associated with a load balancer that forwared the request.
	Principal string `protobuf:"bytes,7,opt,name=principal,proto3" json:"principal,omitempty"`
	// The CLDR country/region code associated with the above IP address.
	// If the IP address is private, the `region_code` should reflect the
	// physical location where this peer is running.
	RegionCode           string   `protobuf:"bytes,8,opt,name=region_code,json=regionCode,proto3" json:"region_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AttributeContext_Peer) Reset()         { *m = AttributeContext_Peer{} }
func (m *AttributeContext_Peer) String() string { return proto.CompactTextString(m) }
func (*AttributeContext_Peer) ProtoMessage()    {}
func (*AttributeContext_Peer) Descriptor() ([]byte, []int) {
	return fileDescriptor_f2b5252148978b42, []int{0, 0}
}

func (m *AttributeContext_Peer) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttributeContext_Peer.Unmarshal(m, b)
}
func (m *AttributeContext_Peer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttributeContext_Peer.Marshal(b, m, deterministic)
}
func (m *AttributeContext_Peer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttributeContext_Peer.Merge(m, src)
}
func (m *AttributeContext_Peer) XXX_Size() int {
	return xxx_messageInfo_AttributeContext_Peer.Size(m)
}
func (m *AttributeContext_Peer) XXX_DiscardUnknown() {
	xxx_messageInfo_AttributeContext_Peer.DiscardUnknown(m)
}

var xxx_messageInfo_AttributeContext_Peer proto.InternalMessageInfo

func (m *AttributeContext_Peer) GetIp() string {
	if m != nil {
		return m.Ip
	}
	return ""
}

func (m *AttributeContext_Peer) GetPort() int64 {
	if m != nil {
		return m.Port
	}
	return 0
}

func (m *AttributeContext_Peer) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *AttributeContext_Peer) GetPrincipal() string {
	if m != nil {
		return m.Principal
	}
	return ""
}

func (m *AttributeContext_Peer) GetRegionCode() string {
	if m != nil {
		return m.RegionCode
	}
	return ""
}

// This message defines attributes associated with API operations, such as
// a network API request. The terminology is based on the conventions used
// by Google APIs, Istio, and OpenAPI.
type AttributeContext_Api struct {
	// The API service name. It is a logical identifier for a networked API,
	// such as "pubsub.googleapis.com". The naming syntax depends on the
	// API management system being used for handling the request.
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// The API operation name. For gRPC requests, it is the fully qualified API
	// method name, such as "google.pubsub.v1.Publisher.Publish". For OpenAPI
	// requests, it is the `operationId`, such as "getPet".
	Operation string `protobuf:"bytes,2,opt,name=operation,proto3" json:"operation,omitempty"`
	// The API protocol used for sending the request, such as "http", "https",
	// "grpc", or "internal".
	Protocol string `protobuf:"bytes,3,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// The API version associated with the API operation above, such as "v1" or
	// "v1alpha1".
	Version              string   `protobuf:"bytes,4,opt,name=version,proto3" json:"version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AttributeContext_Api) Reset()         { *m = AttributeContext_Api{} }
func (m *AttributeContext_Api) String() string { return proto.CompactTextString(m) }
func (*AttributeContext_Api) ProtoMessage()    {}
func (*AttributeContext_Api) Descriptor() ([]byte, []int) {
	return fileDescriptor_f2b5252148978b42, []int{0, 1}
}

func (m *AttributeContext_Api) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttributeContext_Api.Unmarshal(m, b)
}
func (m *AttributeContext_Api) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttributeContext_Api.Marshal(b, m, deterministic)
}
func (m *AttributeContext_Api) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttributeContext_Api.Merge(m, src)
}
func (m *AttributeContext_Api) XXX_Size() int {
	return xxx_messageInfo_AttributeContext_Api.Size(m)
}
func (m *AttributeContext_Api) XXX_DiscardUnknown() {
	xxx_messageInfo_AttributeContext_Api.DiscardUnknown(m)
}

var xxx_messageInfo_AttributeContext_Api proto.InternalMessageInfo

func (m *AttributeContext_Api) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

func (m *AttributeContext_Api) GetOperation() string {
	if m != nil {
		return m.Operation
	}
	return ""
}

func (m *AttributeContext_Api) GetProtocol() string {
	if m != nil {
		return m.Protocol
	}
	return ""
}

func (m *AttributeContext_Api) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

// This message defines request authentication attributes. Terminology is
// based on the JSON Web Token (JWT) standard, but the terms also
// correlate to concepts in other standards.
type AttributeContext_Auth struct {
	// The authenticated principal. Reflects the issuer (`iss`) and subject
	// (`sub`) claims within a JWT. The issuer and subject should be `/`
	// delimited, with `/` percent-encoded within the subject fragment. For
	// Google accounts, the principal format is:
	// "https://accounts.google.com/{id}"
	Principal string `protobuf:"bytes,1,opt,name=principal,proto3" json:"principal,omitempty"`
	// The intended audience(s) for this authentication information. Reflects
	// the audience (`aud`) claim within a JWT. The audience
	// value(s) depends on the `issuer`, but typically include one or more of
	// the following pieces of information:
	//
	// *  The services intended to receive the credential such as
	//    ["pubsub.googleapis.com", "storage.googleapis.com"]
	// *  A set of service-based scopes. For example,
	//    ["https://www.googleapis.com/auth/cloud-platform"]
	// *  The client id of an app, such as the Firebase project id for JWTs
	//    from Firebase Auth.
	//
	// Consult the documentation for the credential issuer to determine the
	// information provided.
	Audiences []string `protobuf:"bytes,2,rep,name=audiences,proto3" json:"audiences,omitempty"`
	// The authorized presenter of the credential. Reflects the optional
	// Authorized Presenter (`azp`) claim within a JWT or the
	// OAuth client id. For example, a Google Cloud Platform client id looks
	// as follows: "123456789012.apps.googleusercontent.com".
	Presenter string `protobuf:"bytes,3,opt,name=presenter,proto3" json:"presenter,omitempty"`
	// Structured claims presented with the credential. JWTs include
	// `{key: value}` pairs for standard and private claims. The following
	// is a subset of the standard required and optional claims that would
	// typically be presented for a Google-based JWT:
	//
	//    {'iss': 'accounts.google.com',
	//     'sub': '113289723416554971153',
	//     'aud': ['123456789012', 'pubsub.googleapis.com'],
	//     'azp': '123456789012.apps.googleusercontent.com',
	//     'email': 'jsmith@example.com',
	//     'iat': 1353601026,
	//     'exp': 1353604926}
	//
	// SAML assertions are similarly specified, but with an identity provider
	// dependent structure.
	Claims *_struct.Struct `protobuf:"bytes,4,opt,name=claims,proto3" json:"claims,omitempty"`
	// A list of access level resource names that allow resources to be
	// accessed by authenticated requester. It is part of Secure GCP processing
	// for the incoming request. An access level string has the format:
	// "//{api_service_name}/accessPolicies/{policy_id}/accessLevels/{short_name}"
	//
	// Example:
	// "//accesscontextmanager.googleapis.com/accessPolicies/MY_POLICY_ID/accessLevels/MY_LEVEL"
	AccessLevels         []string `protobuf:"bytes,5,rep,name=access_levels,json=accessLevels,proto3" json:"access_levels,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AttributeContext_Auth) Reset()         { *m = AttributeContext_Auth{} }
func (m *AttributeContext_Auth) String() string { return proto.CompactTextString(m) }
func (*AttributeContext_Auth) ProtoMessage()    {}
func (*AttributeContext_Auth) Descriptor() ([]byte, []int) {
	return fileDescriptor_f2b5252148978b42, []int{0, 2}
}

func (m *AttributeContext_Auth) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttributeContext_Auth.Unmarshal(m, b)
}
func (m *AttributeContext_Auth) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttributeContext_Auth.Marshal(b, m, deterministic)
}
func (m *AttributeContext_Auth) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttributeContext_Auth.Merge(m, src)
}
func (m *AttributeContext_Auth) XXX_Size() int {
	return xxx_messageInfo_AttributeContext_Auth.Size(m)
}
func (m *AttributeContext_Auth) XXX_DiscardUnknown() {
	xxx_messageInfo_AttributeContext_Auth.DiscardUnknown(m)
}

var xxx_messageInfo_AttributeContext_Auth proto.InternalMessageInfo

func (m *AttributeContext_Auth) GetPrincipal() string {
	if m != nil {
		return m.Principal
	}
	return ""
}

func (m *AttributeContext_Auth) GetAudiences() []string {
	if m != nil {
		return m.Audiences
	}
	return nil
}

func (m *AttributeContext_Auth) GetPresenter() string {
	if m != nil {
		return m.Presenter
	}
	return ""
}

func (m *AttributeContext_Auth) GetClaims() *_struct.Struct {
	if m != nil {
		return m.Claims
	}
	return nil
}

func (m *AttributeContext_Auth) GetAccessLevels() []string {
	if m != nil {
		return m.AccessLevels
	}
	return nil
}

// This message defines attributes for an HTTP request. If the actual
// request is not an HTTP request, the runtime system should try to map
// the actual request to an equivalent HTTP request.
type AttributeContext_Request struct {
	// The unique ID for a request, which can be propagated to downstream
	// systems. The ID should have low probability of collision
	// within a single day for a specific service.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The HTTP request method, such as `GET`, `POST`.
	Method string `protobuf:"bytes,2,opt,name=method,proto3" json:"method,omitempty"`
	// The HTTP request headers. If multiple headers share the same key, they
	// must be merged according to the HTTP spec. All header keys must be
	// lowercased, because HTTP header keys are case-insensitive.
	Headers map[string]string `protobuf:"bytes,3,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The HTTP URL path.
	Path string `protobuf:"bytes,4,opt,name=path,proto3" json:"path,omitempty"`
	// The HTTP request `Host` header value.
	Host string `protobuf:"bytes,5,opt,name=host,proto3" json:"host,omitempty"`
	// The HTTP URL scheme, such as `http` and `https`.
	Scheme string `protobuf:"bytes,6,opt,name=scheme,proto3" json:"scheme,omitempty"`
	// The HTTP URL query in the format of `name1=value1&name2=value2`, as it
	// appears in the first line of the HTTP request. No decoding is performed.
	Query string `protobuf:"bytes,7,opt,name=query,proto3" json:"query,omitempty"`
	// The timestamp when the `destination` service receives the first byte of
	// the request.
	Time *timestamp.Timestamp `protobuf:"bytes,9,opt,name=time,proto3" json:"time,omitempty"`
	// The HTTP request size in bytes. If unknown, it must be -1.
	Size int64 `protobuf:"varint,10,opt,name=size,proto3" json:"size,omitempty"`
	// The network protocol used with the request, such as "http/1.1",
	// "spdy/3", "h2", "h2c", "webrtc", "tcp", "udp", "quic". See
	// https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids
	// for details.
	Protocol string `protobuf:"bytes,11,opt,name=protocol,proto3" json:"protocol,omitempty"`
	// A special parameter for request reason. It is used by security systems
	// to associate auditing information with a request.
	Reason string `protobuf:"bytes,12,opt,name=reason,proto3" json:"reason,omitempty"`
	// The request authentication. May be absent for unauthenticated requests.
	// Derived from the HTTP request `Authorization` header or equivalent.
	Auth                 *AttributeContext_Auth `protobuf:"bytes,13,opt,name=auth,proto3" json:"auth,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *AttributeContext_Request) Reset()         { *m = AttributeContext_Request{} }
func (m *AttributeContext_Request) String() string { return proto.CompactTextString(m) }
func (*AttributeContext_Request) ProtoMessage()    {}
func (*AttributeContext_Request) Descriptor() ([]byte, []int) {
	return fileDescriptor_f2b5252148978b42, []int{0, 3}
}

func (m *AttributeContext_Request) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttributeContext_Request.Unmarshal(m, b)
}
func (m *AttributeContext_Request) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttributeContext_Request.Marshal(b, m, deterministic)
}
func (m *AttributeContext_Request) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttributeContext_Request.Merge(m, src)
}
func (m *AttributeContext_Request) XXX_Size() int {
	return xxx_messageInfo_AttributeContext_Request.Size(m)
}
func (m *AttributeContext_Request) XXX_DiscardUnknown() {
	xxx_messageInfo_AttributeContext_Request.DiscardUnknown(m)
}

var xxx_messageInfo_AttributeContext_Request proto.InternalMessageInfo

func (m *AttributeContext_Request) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *AttributeContext_Request) GetMethod() string {
	if m != nil {
		return m.Method
	}
	return ""
}

func (m *AttributeContext_Request) GetHeaders() map[string]string {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *AttributeContext_Request) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *AttributeContext_Request) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *AttributeContext_Request) GetScheme() string {
	if m != nil {
		return m.Scheme
	}
	return ""
}

func (m *AttributeContext_Request) GetQuery() string {
	if m != nil {
		return m.Query
	}
	return ""
}

func (m *AttributeContext_Request) GetTime() *timestamp.Timestamp {
	if m != nil {
		return m.Time
	}
	return nil
}

func (m *AttributeContext_Request) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *AttributeContext_Request) GetProtocol() string {
	if m != nil {
		return m.Protocol
	}
	return ""
}

func (m *AttributeContext_Request) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func (m *AttributeContext_Request) GetAuth() *AttributeContext_Auth {
	if m != nil {
		return m.Auth
	}
	return nil
}

// This message defines attributes for a typical network response. It
// generally models semantics of an HTTP response.
type AttributeContext_Response struct {
	// The HTTP response status code, such as `200` and `404`.
	Code int64 `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	// The HTTP response size in bytes. If unknown, it must be -1.
	Size int64 `protobuf:"varint,2,opt,name=size,proto3" json:"size,omitempty"`
	// The HTTP response headers. If multiple headers share the same key, they
	// must be merged according to HTTP spec. All header keys must be
	// lowercased, because HTTP header keys are case-insensitive.
	Headers map[string]string `protobuf:"bytes,3,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The timestamp when the `destination` service generates the first byte of
	// the response.
	Time                 *timestamp.Timestamp `protobuf:"bytes,4,opt,name=time,proto3" json:"time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *AttributeContext_Response) Reset()         { *m = AttributeContext_Response{} }
func (m *AttributeContext_Response) String() string { return proto.CompactTextString(m) }
func (*AttributeContext_Response) ProtoMessage()    {}
func (*AttributeContext_Response) Descriptor() ([]byte, []int) {
	return fileDescriptor_f2b5252148978b42, []int{0, 4}
}

func (m *AttributeContext_Response) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttributeContext_Response.Unmarshal(m, b)
}
func (m *AttributeContext_Response) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttributeContext_Response.Marshal(b, m, deterministic)
}
func (m *AttributeContext_Response) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttributeContext_Response.Merge(m, src)
}
func (m *AttributeContext_Response) XXX_Size() int {
	return xxx_messageInfo_AttributeContext_Response.Size(m)
}
func (m *AttributeContext_Response) XXX_DiscardUnknown() {
	xxx_messageInfo_AttributeContext_Response.DiscardUnknown(m)
}

var xxx_messageInfo_AttributeContext_Response proto.InternalMessageInfo

func (m *AttributeContext_Response) GetCode() int64 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *AttributeContext_Response) GetSize() int64 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *AttributeContext_Response) GetHeaders() map[string]string {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *AttributeContext_Response) GetTime() *timestamp.Timestamp {
	if m != nil {
		return m.Time
	}
	return nil
}

// This message defines core attributes for a resource. A resource is an
// addressable (named) entity provided by the destination service. For
// example, a file stored on a network storage service.
type AttributeContext_Resource struct {
	// The name of the service that this resource belongs to, such as
	// `pubsub.googleapis.com`. The service may be different from the DNS
	// hostname that actually serves the request.
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// The stable identifier (name) of a resource on the `service`. A resource
	// can be logically identified as "//{resource.service}/{resource.name}".
	// The differences between a resource name and a URI are:
	//
	// *   Resource name is a logical identifier, independent of network
	//     protocol and API version. For example,
	//     `//pubsub.googleapis.com/projects/123/topics/news-feed`.
	// *   URI often includes protocol and version information, so it can
	//     be used directly by applications. For example,
	//     `https://pubsub.googleapis.com/v1/projects/123/topics/news-feed`.
	//
	// See https://cloud.google.com/apis/design/resource_names for details.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The type of the resource. The syntax is platform-specific because
	// different platforms define their resources differently.
	//
	// For Google APIs, the type format must be "{service}/{kind}".
	Type string `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	// The labels or tags on the resource, such as AWS resource tags and
	// Kubernetes resource labels.
	Labels               map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *AttributeContext_Resource) Reset()         { *m = AttributeContext_Resource{} }
func (m *AttributeContext_Resource) String() string { return proto.CompactTextString(m) }
func (*AttributeContext_Resource) ProtoMessage()    {}
func (*AttributeContext_Resource) Descriptor() ([]byte, []int) {
	return fileDescriptor_f2b5252148978b42, []int{0, 5}
}

func (m *AttributeContext_Resource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AttributeContext_Resource.Unmarshal(m, b)
}
func (m *AttributeContext_Resource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AttributeContext_Resource.Marshal(b, m, deterministic)
}
func (m *AttributeContext_Resource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AttributeContext_Resource.Merge(m, src)
}
func (m *AttributeContext_Resource) XXX_Size() int {
	return xxx_messageInfo_AttributeContext_Resource.Size(m)
}
func (m *AttributeContext_Resource) XXX_DiscardUnknown() {
	xxx_messageInfo_AttributeContext_Resource.DiscardUnknown(m)
}

var xxx_messageInfo_AttributeContext_Resource proto.InternalMessageInfo

func (m *AttributeContext_Resource) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

func (m *AttributeContext_Resource) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *AttributeContext_Resource) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *AttributeContext_Resource) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func init() {
	proto.RegisterType((*AttributeContext)(nil), "google.rpc.context.AttributeContext")
	proto.RegisterType((*AttributeContext_Peer)(nil), "google.rpc.context.AttributeContext.Peer")
	proto.RegisterMapType((map[string]string)(nil), "google.rpc.context.AttributeContext.Peer.LabelsEntry")
	proto.RegisterType((*AttributeContext_Api)(nil), "google.rpc.context.AttributeContext.Api")
	proto.RegisterType((*AttributeContext_Auth)(nil), "google.rpc.context.AttributeContext.Auth")
	proto.RegisterType((*AttributeContext_Request)(nil), "google.rpc.context.AttributeContext.Request")
	proto.RegisterMapType((map[string]string)(nil), "google.rpc.context.AttributeContext.Request.HeadersEntry")
	proto.RegisterType((*AttributeContext_Response)(nil), "google.rpc.context.AttributeContext.Response")
	proto.RegisterMapType((map[string]string)(nil), "google.rpc.context.AttributeContext.Response.HeadersEntry")
	proto.RegisterType((*AttributeContext_Resource)(nil), "google.rpc.context.AttributeContext.Resource")
	proto.RegisterMapType((map[string]string)(nil), "google.rpc.context.AttributeContext.Resource.LabelsEntry")
}

func init() {
	proto.RegisterFile("google/rpc/context/attribute_context.proto", fileDescriptor_f2b5252148978b42)
}

var fileDescriptor_f2b5252148978b42 = []byte{
	// 815 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0xc1, 0x6e, 0x1c, 0x45,
	0x10, 0xd5, 0xec, 0x8c, 0x77, 0x3d, 0xb5, 0x0e, 0x44, 0x2d, 0x30, 0xa3, 0x91, 0xa5, 0x58, 0x70,
	0x31, 0x08, 0x66, 0xa5, 0x20, 0x24, 0x62, 0xc4, 0x61, 0x13, 0x81, 0x40, 0x04, 0xc9, 0x74, 0xc2,
	0x85, 0x8b, 0xd5, 0x9e, 0x2d, 0x76, 0x5b, 0xcc, 0x4e, 0x77, 0xba, 0x7b, 0x2c, 0xcc, 0x2f, 0xf0,
	0x3f, 0xfc, 0x03, 0x27, 0xee, 0xfc, 0x06, 0x1c, 0x38, 0xa2, 0xae, 0xee, 0x59, 0x3b, 0xeb, 0x24,
	0xda, 0x91, 0x6f, 0x55, 0x35, 0xfd, 0x5e, 0x77, 0x55, 0xbd, 0x2a, 0x0d, 0x7c, 0xb4, 0x54, 0x6a,
	0xd9, 0xe0, 0xcc, 0xe8, 0x7a, 0x56, 0xab, 0xd6, 0xe1, 0xaf, 0x6e, 0x26, 0x9c, 0x33, 0xf2, 0xa2,
	0x73, 0x78, 0x1e, 0x23, 0x95, 0x36, 0xca, 0x29, 0xc6, 0xc2, 0xd9, 0xca, 0xe8, 0xba, 0x8a, 0x5f,
	0xca, 0xa3, 0x88, 0xa7, 0x13, 0x17, 0xdd, 0xcf, 0x33, 0xeb, 0x4c, 0x57, 0x47, 0x44, 0xf9, 0x60,
	0xfb, 0xab, 0x93, 0x6b, 0xb4, 0x4e, 0xac, 0x75, 0x38, 0xf0, 0xfe, 0x9f, 0x6f, 0xc3, 0xfd, 0x79,
	0x7f, 0xdd, 0x93, 0xc0, 0xc9, 0xe6, 0x30, 0x56, 0x46, 0x2e, 0x65, 0x5b, 0x4c, 0x8e, 0x93, 0x93,
	0xe9, 0xc3, 0x0f, 0xab, 0xdb, 0x17, 0x57, 0xdb, 0xa8, 0xea, 0x0c, 0xd1, 0xf0, 0x08, 0xf4, 0x14,
	0x56, 0x75, 0xa6, 0xc6, 0x22, 0x19, 0x4c, 0x11, 0x80, 0xec, 0x3b, 0x98, 0x2e, 0xd0, 0x3a, 0xd9,
	0x0a, 0x27, 0x55, 0x5b, 0x8c, 0x86, 0xf2, 0xdc, 0x44, 0xb3, 0xaf, 0x61, 0x62, 0xf0, 0x45, 0x87,
	0xd6, 0x15, 0x29, 0x11, 0x7d, 0xbc, 0x13, 0x11, 0x0f, 0x18, 0xde, 0x83, 0xd9, 0xb7, 0xb0, 0x6f,
	0xd0, 0x6a, 0xd5, 0x5a, 0x2c, 0x32, 0x22, 0xfa, 0x64, 0x47, 0xa2, 0x00, 0xe2, 0x1b, 0x78, 0xa4,
	0x0a, 0x45, 0xda, 0x1b, 0x46, 0x45, 0x20, 0xbe, 0x81, 0xb3, 0x53, 0x48, 0x85, 0x96, 0xc5, 0x98,
	0x58, 0x4e, 0x76, 0x62, 0x99, 0x6b, 0xc9, 0x3d, 0xa8, 0xfc, 0x27, 0x81, 0xcc, 0xd7, 0x8b, 0xbd,
	0x05, 0x23, 0xa9, 0xa9, 0x5d, 0x39, 0x1f, 0x49, 0xcd, 0x18, 0x64, 0x5a, 0x19, 0x47, 0x85, 0x4f,
	0x39, 0xd9, 0xec, 0x7b, 0x18, 0x37, 0xe2, 0x02, 0x1b, 0x5b, 0x8c, 0x8f, 0xd3, 0x93, 0xe9, 0xc3,
	0xcf, 0x76, 0x6e, 0x47, 0xf5, 0x94, 0x70, 0x5f, 0xb5, 0xce, 0x5c, 0xf1, 0x48, 0xc2, 0x8e, 0x20,
	0xd7, 0x46, 0xb6, 0xb5, 0xd4, 0xa2, 0x21, 0xad, 0xe5, 0xfc, 0x3a, 0xc0, 0x1e, 0xc0, 0xd4, 0xe0,
	0x52, 0xaa, 0xf6, 0xbc, 0x56, 0x0b, 0x2c, 0xf6, 0xe9, 0x3b, 0x84, 0xd0, 0x13, 0xb5, 0xc0, 0xf2,
	0x11, 0x4c, 0x6f, 0xb0, 0xb2, 0xfb, 0x90, 0xfe, 0x82, 0x57, 0x31, 0x03, 0x6f, 0xb2, 0x77, 0x60,
	0xef, 0x52, 0x34, 0x1d, 0x52, 0x0e, 0x39, 0x0f, 0xce, 0xe9, 0xe8, 0xf3, 0xa4, 0xb4, 0x90, 0xce,
	0xb5, 0x64, 0x05, 0x4c, 0x2c, 0x9a, 0x4b, 0x19, 0x75, 0x9a, 0xf3, 0xde, 0xf5, 0x4f, 0x53, 0x1a,
	0xcd, 0xb5, 0xf6, 0x72, 0x7e, 0x1d, 0x60, 0x25, 0xec, 0xd3, 0xfc, 0xd4, 0xaa, 0x21, 0x3d, 0xe5,
	0x7c, 0xe3, 0x7b, 0xce, 0x4b, 0x34, 0xd6, 0xe3, 0xb2, 0xc0, 0x19, 0xdd, 0xf2, 0x8f, 0x04, 0xb2,
	0x79, 0xe7, 0x56, 0x2f, 0xe7, 0x9d, 0x6c, 0xe7, 0x7d, 0x04, 0xb9, 0xe8, 0x16, 0x12, 0xdb, 0x1a,
	0x6d, 0x31, 0x3a, 0x4e, 0xfd, 0xd7, 0x4d, 0x20, 0x60, 0xd1, 0x62, 0xeb, 0xd0, 0xc4, 0xbb, 0xaf,
	0x03, 0x6c, 0x06, 0xe3, 0xba, 0x11, 0x72, 0x6d, 0xa3, 0x3a, 0xdf, 0xeb, 0x1b, 0xd4, 0x6f, 0x80,
	0xea, 0x19, 0xed, 0x07, 0x1e, 0x8f, 0xb1, 0x0f, 0xe0, 0x9e, 0xa8, 0x6b, 0xb4, 0xf6, 0xbc, 0xc1,
	0x4b, 0xdf, 0xd8, 0x3d, 0xba, 0xf0, 0x20, 0x04, 0x9f, 0x52, 0xac, 0xfc, 0x2b, 0x85, 0x49, 0x1c,
	0x05, 0x92, 0xc9, 0x62, 0x23, 0x93, 0x05, 0x3b, 0x84, 0xf1, 0x1a, 0xdd, 0x4a, 0x2d, 0x62, 0x95,
	0xa2, 0xc7, 0x9e, 0xc1, 0x64, 0x85, 0x62, 0x81, 0xc6, 0x16, 0x29, 0x69, 0xe5, 0xd1, 0x90, 0x89,
	0xab, 0xbe, 0x09, 0xd8, 0xa0, 0x97, 0x9e, 0x89, 0x34, 0x29, 0xdc, 0x2a, 0x16, 0x96, 0x6c, 0x1f,
	0x5b, 0x29, 0xeb, 0x68, 0x86, 0x72, 0x4e, 0xb6, 0x7f, 0x94, 0xad, 0x57, 0xb8, 0x46, 0x9a, 0x89,
	0x9c, 0x47, 0xcf, 0x0b, 0xe2, 0x45, 0x87, 0xe6, 0x2a, 0x8a, 0x2d, 0x38, 0xac, 0x82, 0xcc, 0xef,
	0xc5, 0x22, 0xa7, 0x92, 0x95, 0xb7, 0x4a, 0xf6, 0xbc, 0x5f, 0x9a, 0x9c, 0xce, 0xf9, 0x1b, 0xad,
	0xfc, 0x0d, 0x0b, 0x08, 0x93, 0xe1, 0xed, 0x97, 0x14, 0x31, 0xdd, 0x52, 0xc4, 0x21, 0x8c, 0x0d,
	0x0a, 0xab, 0xda, 0xe2, 0x20, 0xbc, 0x26, 0x78, 0xec, 0x4b, 0xc8, 0x44, 0xe7, 0x56, 0xc5, 0xbd,
	0x01, 0xab, 0xcd, 0xeb, 0x87, 0x13, 0xac, 0x3c, 0x85, 0x83, 0x9b, 0x55, 0x1a, 0xa4, 0xff, 0x7f,
	0x13, 0xd8, 0xef, 0x77, 0x92, 0xcf, 0x87, 0x26, 0x2c, 0x09, 0xf9, 0x78, 0x7b, 0x93, 0xe3, 0xe8,
	0x46, 0x8e, 0xcf, 0xb7, 0x5b, 0x7a, 0x3a, 0x68, 0xf7, 0xbd, 0xa6, 0xa7, 0x7d, 0xf5, 0xb3, 0xdd,
	0xaa, 0x7f, 0xa7, 0xb4, 0xff, 0x0e, 0x69, 0x87, 0xad, 0xf9, 0xfa, 0xe1, 0x67, 0x90, 0xb5, 0x62,
	0xdd, 0xe3, 0xc9, 0xf6, 0x31, 0x77, 0xa5, 0x31, 0x8e, 0x1c, 0xd9, 0xec, 0x87, 0xcd, 0x3a, 0xcc,
	0x06, 0x49, 0x3c, 0x3c, 0xe0, 0x55, 0x2b, 0xf1, 0x0e, 0x3b, 0xed, 0xf1, 0xef, 0x09, 0x1c, 0xd6,
	0x6a, 0xfd, 0x8a, 0x37, 0x3c, 0x7e, 0x77, 0xfb, 0x11, 0x67, 0xbe, 0xba, 0x67, 0xc9, 0x4f, 0x3f,
	0xc6, 0xc3, 0x4b, 0xd5, 0x88, 0x76, 0x59, 0x29, 0xb3, 0x9c, 0x2d, 0xb1, 0xa5, 0xda, 0xcf, 0xc2,
	0x27, 0xa1, 0xa5, 0x7d, 0xf3, 0xdf, 0xc9, 0x17, 0xb7, 0x22, 0xff, 0x25, 0xc9, 0xc5, 0x98, 0x48,
	0x3e, 0xfd, 0x3f, 0x00, 0x00, 0xff, 0xff, 0x6e, 0xd3, 0x88, 0xb9, 0xe1, 0x08, 0x00, 0x00,
}
