// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/tasks/v2/target.proto

package tasks

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The HTTP method used to deliver the task.
type HttpMethod int32

const (
	// HTTP method unspecified
	HttpMethod_HTTP_METHOD_UNSPECIFIED HttpMethod = 0
	// HTTP POST
	HttpMethod_POST HttpMethod = 1
	// HTTP GET
	HttpMethod_GET HttpMethod = 2
	// HTTP HEAD
	HttpMethod_HEAD HttpMethod = 3
	// HTTP PUT
	HttpMethod_PUT HttpMethod = 4
	// HTTP DELETE
	HttpMethod_DELETE HttpMethod = 5
	// HTTP PATCH
	HttpMethod_PATCH HttpMethod = 6
	// HTTP OPTIONS
	HttpMethod_OPTIONS HttpMethod = 7
)

var HttpMethod_name = map[int32]string{
	0: "HTTP_METHOD_UNSPECIFIED",
	1: "POST",
	2: "GET",
	3: "HEAD",
	4: "PUT",
	5: "DELETE",
	6: "PATCH",
	7: "OPTIONS",
}

var HttpMethod_value = map[string]int32{
	"HTTP_METHOD_UNSPECIFIED": 0,
	"POST":                    1,
	"GET":                     2,
	"HEAD":                    3,
	"PUT":                     4,
	"DELETE":                  5,
	"PATCH":                   6,
	"OPTIONS":                 7,
}

func (x HttpMethod) String() string {
	return proto.EnumName(HttpMethod_name, int32(x))
}

func (HttpMethod) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_9ccba55e885aeacf, []int{0}
}

// HTTP request.
//
// The task will be pushed to the worker as an HTTP request. If the worker
// or the redirected worker acknowledges the task by returning a successful HTTP
// response code ([`200` - `299`]), the task will be removed from the queue. If
// any other HTTP response code is returned or no response is received, the
// task will be retried according to the following:
//
// * User-specified throttling: [retry configuration][google.cloud.tasks.v2.Queue.retry_config],
//   [rate limits][google.cloud.tasks.v2.Queue.rate_limits], and the [queue's state][google.cloud.tasks.v2.Queue.state].
//
// * System throttling: To prevent the worker from overloading, Cloud Tasks may
//   temporarily reduce the queue's effective rate. User-specified settings
//   will not be changed.
//
//  System throttling happens because:
//
//   * Cloud Tasks backs off on all errors. Normally the backoff specified in
//     [rate limits][google.cloud.tasks.v2.Queue.rate_limits] will be used. But if the worker returns
//     `429` (Too Many Requests), `503` (Service Unavailable), or the rate of
//     errors is high, Cloud Tasks will use a higher backoff rate. The retry
//     specified in the `Retry-After` HTTP response header is considered.
//
//   * To prevent traffic spikes and to smooth sudden increases in traffic,
//     dispatches ramp up slowly when the queue is newly created or idle and
//     if large numbers of tasks suddenly become available to dispatch (due to
//     spikes in create task rates, the queue being unpaused, or many tasks
//     that are scheduled at the same time).
type HttpRequest struct {
	// Required. The full url path that the request will be sent to.
	//
	// This string must begin with either "http://" or "https://". Some examples
	// are: `http://acme.com` and `https://acme.com/sales:8080`. Cloud Tasks will
	// encode some characters for safety and compatibility. The maximum allowed
	// URL length is 2083 characters after encoding.
	//
	// The `Location` header response from a redirect response [`300` - `399`]
	// may be followed. The redirect is not counted as a separate attempt.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// The HTTP method to use for the request. The default is POST.
	HttpMethod HttpMethod `protobuf:"varint,2,opt,name=http_method,json=httpMethod,proto3,enum=google.cloud.tasks.v2.HttpMethod" json:"http_method,omitempty"`
	// HTTP request headers.
	//
	// This map contains the header field names and values.
	// Headers can be set when the
	// [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
	//
	// These headers represent a subset of the headers that will accompany the
	// task's HTTP request. Some HTTP request headers will be ignored or replaced.
	//
	// A partial list of headers that will be ignored or replaced is:
	//
	// * Host: This will be computed by Cloud Tasks and derived from
	//   [HttpRequest.url][google.cloud.tasks.v2.HttpRequest.url].
	// * Content-Length: This will be computed by Cloud Tasks.
	// * User-Agent: This will be set to `"Google-Cloud-Tasks"`.
	// * X-Google-*: Google use only.
	// * X-AppEngine-*: Google use only.
	//
	// `Content-Type` won't be set by Cloud Tasks. You can explicitly set
	// `Content-Type` to a media type when the
	//  [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
	//  For example, `Content-Type` can be set to `"application/octet-stream"` or
	//  `"application/json"`.
	//
	// Headers which can have multiple values (according to RFC2616) can be
	// specified using comma-separated values.
	//
	// The size of the headers must be less than 80KB.
	Headers map[string]string `protobuf:"bytes,3,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// HTTP request body.
	//
	// A request body is allowed only if the
	// [HTTP method][google.cloud.tasks.v2.HttpRequest.http_method] is POST, PUT, or PATCH. It is an
	// error to set body on a task with an incompatible [HttpMethod][google.cloud.tasks.v2.HttpMethod].
	Body []byte `protobuf:"bytes,4,opt,name=body,proto3" json:"body,omitempty"`
	// The mode for generating an `Authorization` header for HTTP requests.
	//
	// If specified, all `Authorization` headers in the [HttpRequest.headers][google.cloud.tasks.v2.HttpRequest.headers]
	// field will be overridden.
	//
	// Types that are valid to be assigned to AuthorizationHeader:
	//	*HttpRequest_OauthToken
	//	*HttpRequest_OidcToken
	AuthorizationHeader  isHttpRequest_AuthorizationHeader `protobuf_oneof:"authorization_header"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *HttpRequest) Reset()         { *m = HttpRequest{} }
func (m *HttpRequest) String() string { return proto.CompactTextString(m) }
func (*HttpRequest) ProtoMessage()    {}
func (*HttpRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ccba55e885aeacf, []int{0}
}

func (m *HttpRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HttpRequest.Unmarshal(m, b)
}
func (m *HttpRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HttpRequest.Marshal(b, m, deterministic)
}
func (m *HttpRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HttpRequest.Merge(m, src)
}
func (m *HttpRequest) XXX_Size() int {
	return xxx_messageInfo_HttpRequest.Size(m)
}
func (m *HttpRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_HttpRequest.DiscardUnknown(m)
}

var xxx_messageInfo_HttpRequest proto.InternalMessageInfo

func (m *HttpRequest) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *HttpRequest) GetHttpMethod() HttpMethod {
	if m != nil {
		return m.HttpMethod
	}
	return HttpMethod_HTTP_METHOD_UNSPECIFIED
}

func (m *HttpRequest) GetHeaders() map[string]string {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *HttpRequest) GetBody() []byte {
	if m != nil {
		return m.Body
	}
	return nil
}

type isHttpRequest_AuthorizationHeader interface {
	isHttpRequest_AuthorizationHeader()
}

type HttpRequest_OauthToken struct {
	OauthToken *OAuthToken `protobuf:"bytes,5,opt,name=oauth_token,json=oauthToken,proto3,oneof"`
}

type HttpRequest_OidcToken struct {
	OidcToken *OidcToken `protobuf:"bytes,6,opt,name=oidc_token,json=oidcToken,proto3,oneof"`
}

func (*HttpRequest_OauthToken) isHttpRequest_AuthorizationHeader() {}

func (*HttpRequest_OidcToken) isHttpRequest_AuthorizationHeader() {}

func (m *HttpRequest) GetAuthorizationHeader() isHttpRequest_AuthorizationHeader {
	if m != nil {
		return m.AuthorizationHeader
	}
	return nil
}

func (m *HttpRequest) GetOauthToken() *OAuthToken {
	if x, ok := m.GetAuthorizationHeader().(*HttpRequest_OauthToken); ok {
		return x.OauthToken
	}
	return nil
}

func (m *HttpRequest) GetOidcToken() *OidcToken {
	if x, ok := m.GetAuthorizationHeader().(*HttpRequest_OidcToken); ok {
		return x.OidcToken
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*HttpRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*HttpRequest_OauthToken)(nil),
		(*HttpRequest_OidcToken)(nil),
	}
}

// App Engine HTTP request.
//
// The message defines the HTTP request that is sent to an App Engine app when
// the task is dispatched.
//
// Using [AppEngineHttpRequest][google.cloud.tasks.v2.AppEngineHttpRequest] requires
// [`appengine.applications.get`](https://cloud.google.com/appengine/docs/admin-api/access-control)
// Google IAM permission for the project
// and the following scope:
//
// `https://www.googleapis.com/auth/cloud-platform`
//
// The task will be delivered to the App Engine app which belongs to the same
// project as the queue. For more information, see
// [How Requests are
// Routed](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed)
// and how routing is affected by
// [dispatch
// files](https://cloud.google.com/appengine/docs/python/config/dispatchref).
// Traffic is encrypted during transport and never leaves Google datacenters.
// Because this traffic is carried over a communication mechanism internal to
// Google, you cannot explicitly set the protocol (for example, HTTP or HTTPS).
// The request to the handler, however, will appear to have used the HTTP
// protocol.
//
// The [AppEngineRouting][google.cloud.tasks.v2.AppEngineRouting] used to construct the URL that the task is
// delivered to can be set at the queue-level or task-level:
//
// * If [app_engine_routing_override is set on the
//    queue][Queue.app_engine_routing_override], this value is used for all
//    tasks in the queue, no matter what the setting is for the [task-level
//    app_engine_routing][AppEngineHttpRequest.app_engine_routing].
//
//
// The `url` that the task will be sent to is:
//
// * `url =` [host][google.cloud.tasks.v2.AppEngineRouting.host] `+`
//   [relative_uri][google.cloud.tasks.v2.AppEngineHttpRequest.relative_uri]
//
// Tasks can be dispatched to secure app handlers, unsecure app handlers, and
// URIs restricted with
// [`login:
// admin`](https://cloud.google.com/appengine/docs/standard/python/config/appref).
// Because tasks are not run as any user, they cannot be dispatched to URIs
// restricted with
// [`login:
// required`](https://cloud.google.com/appengine/docs/standard/python/config/appref)
// Task dispatches also do not follow redirects.
//
// The task attempt has succeeded if the app's request handler returns an HTTP
// response code in the range [`200` - `299`]. The task attempt has failed if
// the app's handler returns a non-2xx response code or Cloud Tasks does
// not receive response before the [deadline][google.cloud.tasks.v2.Task.dispatch_deadline]. Failed
// tasks will be retried according to the
// [retry configuration][google.cloud.tasks.v2.Queue.retry_config]. `503` (Service Unavailable) is
// considered an App Engine system error instead of an application error and
// will cause Cloud Tasks' traffic congestion control to temporarily throttle
// the queue's dispatches. Unlike other types of task targets, a `429` (Too Many
// Requests) response from an app handler does not cause traffic congestion
// control to throttle the queue.
type AppEngineHttpRequest struct {
	// The HTTP method to use for the request. The default is POST.
	//
	// The app's request handler for the task's target URL must be able to handle
	// HTTP requests with this http_method, otherwise the task attempt will fail
	// with error code 405 (Method Not Allowed). See
	// [Writing a push task request
	// handler](https://cloud.google.com/appengine/docs/java/taskqueue/push/creating-handlers#writing_a_push_task_request_handler)
	// and the documentation for the request handlers in the language your app is
	// written in e.g.
	// [Python Request
	// Handler](https://cloud.google.com/appengine/docs/python/tools/webapp/requesthandlerclass).
	HttpMethod HttpMethod `protobuf:"varint,1,opt,name=http_method,json=httpMethod,proto3,enum=google.cloud.tasks.v2.HttpMethod" json:"http_method,omitempty"`
	// Task-level setting for App Engine routing.
	//
	// * If [app_engine_routing_override is set on the
	//    queue][Queue.app_engine_routing_override], this value is used for all
	//    tasks in the queue, no matter what the setting is for the [task-level
	//    app_engine_routing][AppEngineHttpRequest.app_engine_routing].
	AppEngineRouting *AppEngineRouting `protobuf:"bytes,2,opt,name=app_engine_routing,json=appEngineRouting,proto3" json:"app_engine_routing,omitempty"`
	// The relative URI.
	//
	// The relative URI must begin with "/" and must be a valid HTTP relative URI.
	// It can contain a path and query string arguments.
	// If the relative URI is empty, then the root path "/" will be used.
	// No spaces are allowed, and the maximum length allowed is 2083 characters.
	RelativeUri string `protobuf:"bytes,3,opt,name=relative_uri,json=relativeUri,proto3" json:"relative_uri,omitempty"`
	// HTTP request headers.
	//
	// This map contains the header field names and values.
	// Headers can be set when the
	// [task is created][google.cloud.tasks.v2.CloudTasks.CreateTask].
	// Repeated headers are not supported but a header value can contain commas.
	//
	// Cloud Tasks sets some headers to default values:
	//
	// * `User-Agent`: By default, this header is
	//   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
	//   This header can be modified, but Cloud Tasks will append
	//   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
	//   modified `User-Agent`.
	//
	// If the task has a [body][google.cloud.tasks.v2.AppEngineHttpRequest.body], Cloud
	// Tasks sets the following headers:
	//
	// * `Content-Type`: By default, the `Content-Type` header is set to
	//   `"application/octet-stream"`. The default can be overridden by explicitly
	//   setting `Content-Type` to a particular media type when the
	//   [task is created][google.cloud.tasks.v2.CloudTasks.CreateTask].
	//   For example, `Content-Type` can be set to `"application/json"`.
	// * `Content-Length`: This is computed by Cloud Tasks. This value is
	//   output only.   It cannot be changed.
	//
	// The headers below cannot be set or overridden:
	//
	// * `Host`
	// * `X-Google-*`
	// * `X-AppEngine-*`
	//
	// In addition, Cloud Tasks sets some headers when the task is dispatched,
	// such as headers containing information about the task; see
	// [request
	// headers](https://cloud.google.com/tasks/docs/creating-appengine-handlers#reading_request_headers).
	// These headers are set only when the task is dispatched, so they are not
	// visible when the task is returned in a Cloud Tasks response.
	//
	// Although there is no specific limit for the maximum number of headers or
	// the size, there is a limit on the maximum size of the [Task][google.cloud.tasks.v2.Task]. For more
	// information, see the [CreateTask][google.cloud.tasks.v2.CloudTasks.CreateTask] documentation.
	Headers map[string]string `protobuf:"bytes,4,rep,name=headers,proto3" json:"headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// HTTP request body.
	//
	// A request body is allowed only if the HTTP method is POST or PUT. It is
	// an error to set a body on a task with an incompatible [HttpMethod][google.cloud.tasks.v2.HttpMethod].
	Body                 []byte   `protobuf:"bytes,5,opt,name=body,proto3" json:"body,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AppEngineHttpRequest) Reset()         { *m = AppEngineHttpRequest{} }
func (m *AppEngineHttpRequest) String() string { return proto.CompactTextString(m) }
func (*AppEngineHttpRequest) ProtoMessage()    {}
func (*AppEngineHttpRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ccba55e885aeacf, []int{1}
}

func (m *AppEngineHttpRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AppEngineHttpRequest.Unmarshal(m, b)
}
func (m *AppEngineHttpRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AppEngineHttpRequest.Marshal(b, m, deterministic)
}
func (m *AppEngineHttpRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AppEngineHttpRequest.Merge(m, src)
}
func (m *AppEngineHttpRequest) XXX_Size() int {
	return xxx_messageInfo_AppEngineHttpRequest.Size(m)
}
func (m *AppEngineHttpRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AppEngineHttpRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AppEngineHttpRequest proto.InternalMessageInfo

func (m *AppEngineHttpRequest) GetHttpMethod() HttpMethod {
	if m != nil {
		return m.HttpMethod
	}
	return HttpMethod_HTTP_METHOD_UNSPECIFIED
}

func (m *AppEngineHttpRequest) GetAppEngineRouting() *AppEngineRouting {
	if m != nil {
		return m.AppEngineRouting
	}
	return nil
}

func (m *AppEngineHttpRequest) GetRelativeUri() string {
	if m != nil {
		return m.RelativeUri
	}
	return ""
}

func (m *AppEngineHttpRequest) GetHeaders() map[string]string {
	if m != nil {
		return m.Headers
	}
	return nil
}

func (m *AppEngineHttpRequest) GetBody() []byte {
	if m != nil {
		return m.Body
	}
	return nil
}

// App Engine Routing.
//
// Defines routing characteristics specific to App Engine - service, version,
// and instance.
//
// For more information about services, versions, and instances see
// [An Overview of App
// Engine](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine),
// [Microservices Architecture on Google App
// Engine](https://cloud.google.com/appengine/docs/python/microservices-on-app-engine),
// [App Engine Standard request
// routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed),
// and [App Engine Flex request
// routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
//
// Using [AppEngineRouting][google.cloud.tasks.v2.AppEngineRouting] requires
// [`appengine.applications.get`](https://cloud.google.com/appengine/docs/admin-api/access-control)
// Google IAM permission for the project
// and the following scope:
//
// `https://www.googleapis.com/auth/cloud-platform`
type AppEngineRouting struct {
	// App service.
	//
	// By default, the task is sent to the service which is the default
	// service when the task is attempted.
	//
	// For some queues or tasks which were created using the App Engine
	// Task Queue API, [host][google.cloud.tasks.v2.AppEngineRouting.host] is not parsable
	// into [service][google.cloud.tasks.v2.AppEngineRouting.service],
	// [version][google.cloud.tasks.v2.AppEngineRouting.version], and
	// [instance][google.cloud.tasks.v2.AppEngineRouting.instance]. For example, some tasks
	// which were created using the App Engine SDK use a custom domain
	// name; custom domains are not parsed by Cloud Tasks. If
	// [host][google.cloud.tasks.v2.AppEngineRouting.host] is not parsable, then
	// [service][google.cloud.tasks.v2.AppEngineRouting.service],
	// [version][google.cloud.tasks.v2.AppEngineRouting.version], and
	// [instance][google.cloud.tasks.v2.AppEngineRouting.instance] are the empty string.
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// App version.
	//
	// By default, the task is sent to the version which is the default
	// version when the task is attempted.
	//
	// For some queues or tasks which were created using the App Engine
	// Task Queue API, [host][google.cloud.tasks.v2.AppEngineRouting.host] is not parsable
	// into [service][google.cloud.tasks.v2.AppEngineRouting.service],
	// [version][google.cloud.tasks.v2.AppEngineRouting.version], and
	// [instance][google.cloud.tasks.v2.AppEngineRouting.instance]. For example, some tasks
	// which were created using the App Engine SDK use a custom domain
	// name; custom domains are not parsed by Cloud Tasks. If
	// [host][google.cloud.tasks.v2.AppEngineRouting.host] is not parsable, then
	// [service][google.cloud.tasks.v2.AppEngineRouting.service],
	// [version][google.cloud.tasks.v2.AppEngineRouting.version], and
	// [instance][google.cloud.tasks.v2.AppEngineRouting.instance] are the empty string.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// App instance.
	//
	// By default, the task is sent to an instance which is available when
	// the task is attempted.
	//
	// Requests can only be sent to a specific instance if
	// [manual scaling is used in App Engine
	// Standard](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine?hl=en_US#scaling_types_and_instance_classes).
	// App Engine Flex does not support instances. For more information, see
	// [App Engine Standard request
	// routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed)
	// and [App Engine Flex request
	// routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
	Instance string `protobuf:"bytes,3,opt,name=instance,proto3" json:"instance,omitempty"`
	// Output only. The host that the task is sent to.
	//
	// The host is constructed from the domain name of the app associated with
	// the queue's project ID (for example <app-id>.appspot.com), and the
	// [service][google.cloud.tasks.v2.AppEngineRouting.service], [version][google.cloud.tasks.v2.AppEngineRouting.version],
	// and [instance][google.cloud.tasks.v2.AppEngineRouting.instance]. Tasks which were created using
	// the App Engine SDK might have a custom domain name.
	//
	// For more information, see
	// [How Requests are
	// Routed](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed).
	Host                 string   `protobuf:"bytes,4,opt,name=host,proto3" json:"host,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AppEngineRouting) Reset()         { *m = AppEngineRouting{} }
func (m *AppEngineRouting) String() string { return proto.CompactTextString(m) }
func (*AppEngineRouting) ProtoMessage()    {}
func (*AppEngineRouting) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ccba55e885aeacf, []int{2}
}

func (m *AppEngineRouting) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AppEngineRouting.Unmarshal(m, b)
}
func (m *AppEngineRouting) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AppEngineRouting.Marshal(b, m, deterministic)
}
func (m *AppEngineRouting) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AppEngineRouting.Merge(m, src)
}
func (m *AppEngineRouting) XXX_Size() int {
	return xxx_messageInfo_AppEngineRouting.Size(m)
}
func (m *AppEngineRouting) XXX_DiscardUnknown() {
	xxx_messageInfo_AppEngineRouting.DiscardUnknown(m)
}

var xxx_messageInfo_AppEngineRouting proto.InternalMessageInfo

func (m *AppEngineRouting) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

func (m *AppEngineRouting) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *AppEngineRouting) GetInstance() string {
	if m != nil {
		return m.Instance
	}
	return ""
}

func (m *AppEngineRouting) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

// Contains information needed for generating an
// [OAuth token](https://developers.google.com/identity/protocols/OAuth2).
// This type of authorization should generally only be used when calling Google
// APIs hosted on *.googleapis.com.
type OAuthToken struct {
	// [Service account email](https://cloud.google.com/iam/docs/service-accounts)
	// to be used for generating OAuth token.
	// The service account must be within the same project as the queue. The
	// caller must have iam.serviceAccounts.actAs permission for the service
	// account.
	ServiceAccountEmail string `protobuf:"bytes,1,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// OAuth scope to be used for generating OAuth access token.
	// If not specified, "https://www.googleapis.com/auth/cloud-platform"
	// will be used.
	Scope                string   `protobuf:"bytes,2,opt,name=scope,proto3" json:"scope,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OAuthToken) Reset()         { *m = OAuthToken{} }
func (m *OAuthToken) String() string { return proto.CompactTextString(m) }
func (*OAuthToken) ProtoMessage()    {}
func (*OAuthToken) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ccba55e885aeacf, []int{3}
}

func (m *OAuthToken) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OAuthToken.Unmarshal(m, b)
}
func (m *OAuthToken) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OAuthToken.Marshal(b, m, deterministic)
}
func (m *OAuthToken) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OAuthToken.Merge(m, src)
}
func (m *OAuthToken) XXX_Size() int {
	return xxx_messageInfo_OAuthToken.Size(m)
}
func (m *OAuthToken) XXX_DiscardUnknown() {
	xxx_messageInfo_OAuthToken.DiscardUnknown(m)
}

var xxx_messageInfo_OAuthToken proto.InternalMessageInfo

func (m *OAuthToken) GetServiceAccountEmail() string {
	if m != nil {
		return m.ServiceAccountEmail
	}
	return ""
}

func (m *OAuthToken) GetScope() string {
	if m != nil {
		return m.Scope
	}
	return ""
}

// Contains information needed for generating an
// [OpenID Connect
// token](https://developers.google.com/identity/protocols/OpenIDConnect).
// This type of authorization can be used for many scenarios, including
// calling Cloud Run, or endpoints where you intend to validate the token
// yourself.
type OidcToken struct {
	// [Service account email](https://cloud.google.com/iam/docs/service-accounts)
	// to be used for generating OIDC token.
	// The service account must be within the same project as the queue. The
	// caller must have iam.serviceAccounts.actAs permission for the service
	// account.
	ServiceAccountEmail string `protobuf:"bytes,1,opt,name=service_account_email,json=serviceAccountEmail,proto3" json:"service_account_email,omitempty"`
	// Audience to be used when generating OIDC token. If not specified, the URI
	// specified in target will be used.
	Audience             string   `protobuf:"bytes,2,opt,name=audience,proto3" json:"audience,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OidcToken) Reset()         { *m = OidcToken{} }
func (m *OidcToken) String() string { return proto.CompactTextString(m) }
func (*OidcToken) ProtoMessage()    {}
func (*OidcToken) Descriptor() ([]byte, []int) {
	return fileDescriptor_9ccba55e885aeacf, []int{4}
}

func (m *OidcToken) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OidcToken.Unmarshal(m, b)
}
func (m *OidcToken) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OidcToken.Marshal(b, m, deterministic)
}
func (m *OidcToken) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OidcToken.Merge(m, src)
}
func (m *OidcToken) XXX_Size() int {
	return xxx_messageInfo_OidcToken.Size(m)
}
func (m *OidcToken) XXX_DiscardUnknown() {
	xxx_messageInfo_OidcToken.DiscardUnknown(m)
}

var xxx_messageInfo_OidcToken proto.InternalMessageInfo

func (m *OidcToken) GetServiceAccountEmail() string {
	if m != nil {
		return m.ServiceAccountEmail
	}
	return ""
}

func (m *OidcToken) GetAudience() string {
	if m != nil {
		return m.Audience
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.tasks.v2.HttpMethod", HttpMethod_name, HttpMethod_value)
	proto.RegisterType((*HttpRequest)(nil), "google.cloud.tasks.v2.HttpRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.tasks.v2.HttpRequest.HeadersEntry")
	proto.RegisterType((*AppEngineHttpRequest)(nil), "google.cloud.tasks.v2.AppEngineHttpRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.tasks.v2.AppEngineHttpRequest.HeadersEntry")
	proto.RegisterType((*AppEngineRouting)(nil), "google.cloud.tasks.v2.AppEngineRouting")
	proto.RegisterType((*OAuthToken)(nil), "google.cloud.tasks.v2.OAuthToken")
	proto.RegisterType((*OidcToken)(nil), "google.cloud.tasks.v2.OidcToken")
}

func init() { proto.RegisterFile("google/cloud/tasks/v2/target.proto", fileDescriptor_9ccba55e885aeacf) }

var fileDescriptor_9ccba55e885aeacf = []byte{
	// 685 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x54, 0x4d, 0x6f, 0x9b, 0x4a,
	0x14, 0x0d, 0xc6, 0x1f, 0xf1, 0x25, 0x7a, 0x42, 0xf3, 0x92, 0xf7, 0x5c, 0xb7, 0x52, 0x1d, 0x6f,
	0x6a, 0x75, 0x01, 0x92, 0xbb, 0x89, 0xd2, 0x95, 0x1d, 0xd3, 0xda, 0x52, 0x13, 0x23, 0x82, 0xbb,
	0x68, 0x17, 0x68, 0x02, 0x13, 0x18, 0x85, 0x30, 0x74, 0x18, 0x90, 0xd2, 0xdf, 0xd3, 0x1f, 0xd6,
	0x9f, 0xd1, 0x65, 0xc5, 0x80, 0xed, 0xc8, 0x4a, 0xda, 0x2a, 0xdd, 0xdd, 0x33, 0xf7, 0xdc, 0xc3,
	0xbd, 0x73, 0x0f, 0x03, 0xc3, 0x90, 0xb1, 0x30, 0x26, 0xa6, 0x1f, 0xb3, 0x3c, 0x30, 0x05, 0xce,
	0x6e, 0x32, 0xb3, 0x18, 0x9b, 0x02, 0xf3, 0x90, 0x08, 0x23, 0xe5, 0x4c, 0x30, 0x74, 0x54, 0x71,
	0x0c, 0xc9, 0x31, 0x24, 0xc7, 0x28, 0xc6, 0xfd, 0x97, 0x75, 0x29, 0x4e, 0xa9, 0x79, 0x4d, 0x49,
	0x1c, 0x78, 0x57, 0x24, 0xc2, 0x05, 0x65, 0xbc, 0xaa, 0xeb, 0xbf, 0xb8, 0x47, 0xc0, 0x49, 0xc2,
	0x04, 0x16, 0x94, 0x25, 0x59, 0x95, 0x1d, 0x7e, 0x53, 0x41, 0x9b, 0x0b, 0x91, 0x3a, 0xe4, 0x4b,
	0x4e, 0x32, 0x81, 0x8e, 0x40, 0xcd, 0x79, 0xdc, 0x53, 0x06, 0xca, 0xa8, 0x3b, 0x55, 0xbf, 0x4f,
	0x1a, 0x4e, 0x89, 0xd1, 0x14, 0xb4, 0x48, 0x88, 0xd4, 0xbb, 0x25, 0x22, 0x62, 0x41, 0xaf, 0x31,
	0x50, 0x46, 0xff, 0x8c, 0x8f, 0x8d, 0x07, 0x5b, 0x32, 0x4a, 0xbd, 0x73, 0x49, 0x74, 0x20, 0xda,
	0xc4, 0x68, 0x01, 0x9d, 0x88, 0xe0, 0x80, 0xf0, 0xac, 0xa7, 0x0e, 0xd4, 0x91, 0x36, 0x36, 0x7f,
	0x51, 0x5f, 0xf7, 0x63, 0xcc, 0xab, 0x0a, 0x2b, 0x11, 0xfc, 0xce, 0x59, 0xd7, 0x23, 0x04, 0xcd,
	0x2b, 0x16, 0xdc, 0xf5, 0x9a, 0x03, 0x65, 0x74, 0xe0, 0xc8, 0x18, 0xcd, 0x40, 0x63, 0x38, 0x17,
	0x91, 0x27, 0xd8, 0x0d, 0x49, 0x7a, 0xad, 0x81, 0x32, 0xd2, 0x1e, 0x6d, 0x71, 0x39, 0xc9, 0x45,
	0xe4, 0x96, 0xc4, 0xf9, 0x9e, 0x03, 0xb2, 0x4e, 0x22, 0x34, 0x01, 0x60, 0x34, 0xf0, 0x6b, 0x91,
	0xb6, 0x14, 0x19, 0x3c, 0x26, 0x42, 0x03, 0x7f, 0xad, 0xd1, 0x65, 0x6b, 0xd0, 0x3f, 0x85, 0x83,
	0xfb, 0x5d, 0x23, 0x1d, 0xd4, 0x1b, 0x72, 0x57, 0x5d, 0xa9, 0x53, 0x86, 0xe8, 0x10, 0x5a, 0x05,
	0x8e, 0x73, 0x22, 0xef, 0xb1, 0xeb, 0x54, 0xe0, 0xb4, 0x71, 0xa2, 0x4c, 0xff, 0x83, 0xc3, 0xb2,
	0x17, 0xc6, 0xe9, 0x57, 0xb9, 0x26, 0xaf, 0x9a, 0x78, 0xf8, 0xa3, 0x01, 0x87, 0x93, 0x34, 0xb5,
	0x92, 0x90, 0x26, 0xe4, 0xfe, 0xbe, 0x76, 0x16, 0xa3, 0x3c, 0x65, 0x31, 0x2b, 0x40, 0x38, 0x4d,
	0x3d, 0x22, 0xc5, 0x3d, 0xce, 0x72, 0x41, 0x93, 0x50, 0xf6, 0xa6, 0x8d, 0x5f, 0x3d, 0x22, 0xb5,
	0x69, 0xc6, 0xa9, 0xe8, 0x8e, 0x8e, 0x77, 0x4e, 0xd0, 0x31, 0x1c, 0x70, 0x12, 0x63, 0x41, 0x0b,
	0xe2, 0xe5, 0x9c, 0xf6, 0x54, 0x39, 0xac, 0xb6, 0x3e, 0x5b, 0x71, 0x8a, 0x9c, 0xad, 0x25, 0x9a,
	0xd2, 0x12, 0x27, 0xbf, 0xfb, 0xdc, 0x9f, 0x7b, 0xa3, 0xb5, 0xf5, 0xc6, 0xdf, 0xac, 0x64, 0x58,
	0x80, 0xbe, 0x3b, 0x2c, 0xea, 0x41, 0x27, 0x23, 0xbc, 0xa0, 0x3e, 0xa9, 0x35, 0xd6, 0xb0, 0xcc,
	0x14, 0x84, 0x67, 0x94, 0x25, 0xb5, 0xd2, 0x1a, 0xa2, 0x3e, 0xec, 0xd3, 0x24, 0x13, 0x38, 0xf1,
	0x49, 0x7d, 0x15, 0x1b, 0x5c, 0xf6, 0x1c, 0xb1, 0x4c, 0x48, 0x3f, 0x77, 0x1d, 0x19, 0x0f, 0x3f,
	0x02, 0x6c, 0x5d, 0x8a, 0xc6, 0x70, 0x54, 0x7f, 0xc2, 0xc3, 0xbe, 0xcf, 0xf2, 0x44, 0x78, 0xe4,
	0x16, 0xd3, 0xfa, 0x4f, 0x75, 0xfe, 0xad, 0x93, 0x93, 0x2a, 0x67, 0x95, 0xa9, 0x72, 0xa6, 0xcc,
	0x67, 0xe9, 0x66, 0x26, 0x09, 0x86, 0x9f, 0xa1, 0xbb, 0x31, 0xee, 0x93, 0x64, 0xfb, 0xb0, 0x8f,
	0xf3, 0x80, 0x92, 0x72, 0x90, 0x4a, 0x79, 0x83, 0x5f, 0x67, 0x00, 0x5b, 0x93, 0xa1, 0xe7, 0xf0,
	0xff, 0xdc, 0x75, 0x6d, 0xef, 0xdc, 0x72, 0xe7, 0xcb, 0x99, 0xb7, 0xba, 0xb8, 0xb4, 0xad, 0xb3,
	0xc5, 0xbb, 0x85, 0x35, 0xd3, 0xf7, 0xd0, 0x3e, 0x34, 0xed, 0xe5, 0xa5, 0xab, 0x2b, 0xa8, 0x03,
	0xea, 0x7b, 0xcb, 0xd5, 0x1b, 0xe5, 0xd1, 0xdc, 0x9a, 0xcc, 0x74, 0xb5, 0x3c, 0xb2, 0x57, 0xae,
	0xde, 0x44, 0x00, 0xed, 0x99, 0xf5, 0xc1, 0x72, 0x2d, 0xbd, 0x85, 0xba, 0xd0, 0xb2, 0x27, 0xee,
	0xd9, 0x5c, 0x6f, 0x23, 0x0d, 0x3a, 0x4b, 0xdb, 0x5d, 0x2c, 0x2f, 0x2e, 0xf5, 0xce, 0xf4, 0x1a,
	0x9e, 0xf9, 0xec, 0xf6, 0x61, 0xe7, 0x4c, 0x35, 0x57, 0x3e, 0xa2, 0x76, 0xf9, 0xda, 0xd9, 0xca,
	0xa7, 0xd3, 0x9a, 0x15, 0xb2, 0x18, 0x27, 0xa1, 0xc1, 0x78, 0x68, 0x86, 0x24, 0x91, 0x6f, 0xa1,
	0x59, 0xa5, 0x70, 0x4a, 0xb3, 0x9d, 0x87, 0xf8, 0xad, 0x0c, 0xae, 0xda, 0x92, 0xf6, 0xe6, 0x67,
	0x00, 0x00, 0x00, 0xff, 0xff, 0x75, 0x49, 0xba, 0x87, 0xae, 0x05, 0x00, 0x00,
}
