package azureadexternalidentities

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// B2CResourceSKUName enumerates the values for b2c resource sku name.
type B2CResourceSKUName string

const (
	// B2CResourceSKUNamePremiumP1 Azure AD B2C usage is billed to a linked Azure subscription and uses number
	// of authentications based billing.
	B2CResourceSKUNamePremiumP1 B2CResourceSKUName = "PremiumP1"
	// B2CResourceSKUNamePremiumP2 Azure AD B2C usage is billed to a linked Azure subscription and uses number
	// of authentications based billing.
	B2CResourceSKUNamePremiumP2 B2CResourceSKUName = "PremiumP2"
	// B2CResourceSKUNameStandard Azure AD B2C usage is billed to a linked Azure subscription and uses a
	// monthly active users (MAU) billing model.
	B2CResourceSKUNameStandard B2CResourceSKUName = "Standard"
)

// PossibleB2CResourceSKUNameValues returns an array of possible values for the B2CResourceSKUName const type.
func PossibleB2CResourceSKUNameValues() []B2CResourceSKUName {
	return []B2CResourceSKUName{B2CResourceSKUNamePremiumP1, B2CResourceSKUNamePremiumP2, B2CResourceSKUNameStandard}
}

// B2CResourceSKUTier enumerates the values for b2c resource sku tier.
type B2CResourceSKUTier string

const (
	// B2CResourceSKUTierA0 The SKU tier used for all Azure AD B2C tenants.
	B2CResourceSKUTierA0 B2CResourceSKUTier = "A0"
)

// PossibleB2CResourceSKUTierValues returns an array of possible values for the B2CResourceSKUTier const type.
func PossibleB2CResourceSKUTierValues() []B2CResourceSKUTier {
	return []B2CResourceSKUTier{B2CResourceSKUTierA0}
}

// BillingType enumerates the values for billing type.
type BillingType string

const (
	// BillingTypeAuths Azure AD B2C usage is billed to a linked Azure subscription and uses number of
	// authentications based billing.
	BillingTypeAuths BillingType = "Auths"
	// BillingTypeMAU Azure AD B2C usage is billed to a linked Azure subscription and uses a monthly active
	// users (MAU) billing model.
	BillingTypeMAU BillingType = "MAU"
)

// PossibleBillingTypeValues returns an array of possible values for the BillingType const type.
func PossibleBillingTypeValues() []BillingType {
	return []BillingType{BillingTypeAuths, BillingTypeMAU}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// NameAvailabilityReasonType enumerates the values for name availability reason type.
type NameAvailabilityReasonType string

const (
	// NameAvailabilityReasonTypeAlreadyExists The name is already in use and is therefore unavailable.
	NameAvailabilityReasonTypeAlreadyExists NameAvailabilityReasonType = "AlreadyExists"
	// NameAvailabilityReasonTypeInvalid The name provided does not match the resource provider’s naming
	// requirements (incorrect length, unsupported characters, etc.).
	NameAvailabilityReasonTypeInvalid NameAvailabilityReasonType = "Invalid"
)

// PossibleNameAvailabilityReasonTypeValues returns an array of possible values for the NameAvailabilityReasonType const type.
func PossibleNameAvailabilityReasonTypeValues() []NameAvailabilityReasonType {
	return []NameAvailabilityReasonType{NameAvailabilityReasonTypeAlreadyExists, NameAvailabilityReasonTypeInvalid}
}

// TypeValue enumerates the values for type value.
type TypeValue string

const (
	// TypeValueMicrosoftAzureActiveDirectoryb2cDirectories The resource type for Azure AD B2C tenant resource.
	TypeValueMicrosoftAzureActiveDirectoryb2cDirectories TypeValue = "Microsoft.AzureActiveDirectory/b2cDirectories"
)

// PossibleTypeValueValues returns an array of possible values for the TypeValue const type.
func PossibleTypeValueValues() []TypeValue {
	return []TypeValue{TypeValueMicrosoftAzureActiveDirectoryb2cDirectories}
}
