/*
hash.h/hash.cpp - Source Code for ElephantEye, Part V

ElephantEye - a Chinese Chess Program (UCCI Engine)
Designed by Morning Yellow, Version: 3.12, Last Modified: Dec. 2007
Copyright (C) 2004-2007 www.elephantbase.net

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <string.h>
#include "base.h"
#include "position.h"

#ifndef HASH_H
#define HASH_H

// û־ֻ"RecordHash()"
const int HASH_BETA = 1;
const int HASH_ALPHA = 2;
const int HASH_PV = HASH_ALPHA | HASH_BETA;

const int HASH_LAYERS = 2;   // ûĲ
const int NULL_DEPTH = 2;    // Ųü

// ûṹûϢZobristУм䣬Էֹȡͻ
struct HashStruct {
  uint32_t dwZobristLock0;           // ZobristУһ
  uint16_t wmv;                      // ŷ
  uint8_t ucAlphaDepth, ucBetaDepth; // (ϱ߽±߽)
  int16_t svlAlpha, svlBeta;         // ֵ(ϱ߽±߽)
  uint32_t dwZobristLock1;           // ZobristУڶ
}; // hsh

// ûϢ
extern int nHashMask;              // ûĴС
extern HashStruct *hshItems;       // ûָ룬ElephantEyeöû
#ifdef HASH_QUIESC
  extern HashStruct *hshItemsQ;
#endif

inline void ClearHash(void) {         // û
  memset(hshItems, 0, (nHashMask + 1) * sizeof(HashStruct));
#ifdef HASH_QUIESC
  memset(hshItemsQ, 0, (nHashMask + 1) * sizeof(HashStruct));
#endif
}

inline void NewHash(int nHashScale) { // ûС 2^nHashScale ֽ
  nHashMask = ((1 << nHashScale) / sizeof(HashStruct)) - 1;
  hshItems = new HashStruct[nHashMask + 1];
#ifdef HASH_QUIESC
  hshItemsQ = new HashStruct[nHashMask + 1];
#endif
  ClearHash();
}

inline void DelHash(void) {           // ͷû
  delete[] hshItems;
#ifdef HASH_QUIESC
  delete[] hshItemsQ;
#endif
}

// жûǷϾ(ZobristǷ)
inline bool HASH_POS_EQUAL(const HashStruct &hsh, const PositionStruct &pos) {
  return hsh.dwZobristLock0 == pos.zobr.dwLock0 && hsh.dwZobristLock1 == pos.zobr.dwLock1;
}

// Ͳȡû(һãԶ丳ֵ)
inline HashStruct &HASH_ITEM(const PositionStruct &pos, int nLayer) {
  return hshItems[(pos.zobr.dwKey + nLayer) & nHashMask];
}

// ûĹ
void RecordHash(const PositionStruct &pos, int nFlag, int vl, int nDepth, int mv);                    // 洢ûϢ
int ProbeHash(const PositionStruct &pos, int vlAlpha, int vlBeta, int nDepth, bool bNoNull, int &mv); // ȡûϢ
#ifdef HASH_QUIESC
  void RecordHashQ(const PositionStruct &pos, int vlBeta, int vlAlpha); // 洢ûϢ(̬)
  int ProbeHashQ(const PositionStruct &pos, int vlAlpha, int vlBeta);   // ȡûϢ(̬)
#endif

// UCCI֧ - HashеľϢ
bool PopHash(const PositionStruct &pos);

#endif
