# Contributing

## Bug Reports

Bug reports are the number one way you can contribute to *ghostwriter*.  Please include the following information when filing a bug report in GitHub:

* Your Operating System
* If on GNU/Linux, your desktop environment
* Steps that can be used to replicate the problem
* Any sample Markdown files that might be useful in replicating the problem

## New Feature Requests

At this present time, I do not have the bandwidth to work on new feature requests.  As such, new feature requests filed in GitHub will be closed.  This does not mean *ghostwriter* will cease to have new features.  On the contrary!  *ghostwriter* has quite the backlog of feature requests already filed in GitHub.  Also, I have a secret list of features I would like to work on that I think the community will very much enjoy.  I do appreciate the community's enthusiasm for *ghostwriter*.  Thank you for all your feedback!

## Pull Requests

Pull requests are presently only accepted for translations into different languages or documentation updates.  I will be closing all other pull requests.  This is simply because I do not have the time that contributors deserve to review the code, let alone the time required to thoroughly test it.

## Translations

As stated above, pull requests are still accepted for translations into different languages.  Being a Qt application, *ghostwriter* requires translators to use Qt Linguist to create translation files.

## Packaging

*ghostwriter* still needs to be packaged for different GNU/Linux distributions.  If you are a maintainer for a GNU/Linux distribution, or would like to volunteer to become one, please consider packaging *ghostwriter* for your distribution's repository.

Finally, I am also looking for someone to contribute a regular MacOS build, as well as a Windows build.  While I am maintaining the Windows build releases at present, I would like to hand that off to someone else in the long term.  If you are interested, please let me know by filing a new Issue, and we can work together to get you started in creating the Windows executables.

## Other

For a full list of ways you can contribute, please visit the project website's ["Get Involved" page](https://wereturtle.github.io/ghostwriter/contribute.html).
