/*
  Copyright (c) 2011-2012 Stefan Kurtz <kurtz@zbh.uni-hamburg.de>
  Copyright (c) 2011-2012 Center for Bioinformatics, University of Hamburg

  Permission to use, copy, modify, and distribute this software for any
  purpose with or without fee is hereby granted, provided that the above
  copyright notice and this permission notice appear in all copies.

  THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
  WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
  ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
  ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/

/*
  THIS FILE IS GENERATED by
  scripts/gen-esa-bottomup.rb
  --key shulen
  --gtlcpvaluetypeset
  --absolute
  --no_process_lastvalue
  --no_process_lcpinterval
  --withlastfrompreviousbucket
  --additionaluint32bucket
  --no_declarations.
  DO NOT EDIT.
*/

#include <limits.h>
#include "core/ma.h"
#include "esa-seqread.h"
/* no include for seqnumrelpos.h */

static int gt_esa_bottomup_RAM_previousfromlast_shulen(
                        unsigned long previoussuffix,
                        unsigned long lcpvalue,
                        GtArrayGtBUItvinfo_shulen *stack,
                        GtBUstate_shulen *bustate,
                        /* no parameter snrp */
                        GtError *err)
{
  const unsigned long incrementstacksize = 32UL;
  unsigned long idx = 0;
  GtBUItvinfo_shulen *lastinterval = NULL;
  bool haserr = false, firstedge,
       firstedgefromroot = bustate->firstedgefromroot;

    gt_assert(stack->nextfreeGtBUItvinfo > 0);
    if (lcpvalue <= TOP_ESA_BOTTOMUP_shulen.lcp)
    {
      if (TOP_ESA_BOTTOMUP_shulen.lcp > 0 || !firstedgefromroot)
      {
        firstedge = false;
      } else
      {
        firstedge = true;
        firstedgefromroot = false;
      }
      if (processleafedge_shulen(firstedge,
                          TOP_ESA_BOTTOMUP_shulen.lcp,
                          &TOP_ESA_BOTTOMUP_shulen.info,
                          previoussuffix,
                          bustate,
                          err) != 0)
      {
        haserr = true;
      }
    }
    gt_assert(lastinterval == NULL);
    while (!haserr && lcpvalue < TOP_ESA_BOTTOMUP_shulen.lcp)
    {
      lastinterval = POP_ESA_BOTTOMUP_shulen;
      lastinterval->rb = idx + bustate->idxoffset;
      /* no call to processlcpinterval_shulen */
      if (lcpvalue <= TOP_ESA_BOTTOMUP_shulen.lcp)
      {
        if (TOP_ESA_BOTTOMUP_shulen.lcp > 0 || !firstedgefromroot)
        {
          firstedge = false;
        } else
        {
          firstedge = true;
          firstedgefromroot = false;
        }
        if (processbranchingedge_shulen(firstedge,
                   TOP_ESA_BOTTOMUP_shulen.lcp,
                   &TOP_ESA_BOTTOMUP_shulen.info,
                   lastinterval->lcp,
                   lastinterval->rb - lastinterval->lb + 1,
                   &lastinterval->info,
                   bustate,
                   err) != 0)
        {
          haserr = true;
        }
        lastinterval = NULL;
      }
    }
    if (!haserr && lcpvalue > TOP_ESA_BOTTOMUP_shulen.lcp)
    {
      if (lastinterval != NULL)
      {
        unsigned long lastintervallb = lastinterval->lb;
        unsigned long lastintervallcp = lastinterval->lcp,
              lastintervalrb = lastinterval->rb;
        PUSH_ESA_BOTTOMUP_shulen(lcpvalue,lastintervallb);
        if (processbranchingedge_shulen(true,
                       TOP_ESA_BOTTOMUP_shulen.lcp,
                       &TOP_ESA_BOTTOMUP_shulen.info,
                       lastintervallcp,
                       lastintervalrb - lastintervallb + 1,
                       NULL,
                       bustate,
                       err) != 0)
        {
          haserr = true;
        }
        lastinterval = NULL;
      } else
      {
        PUSH_ESA_BOTTOMUP_shulen(lcpvalue,idx + bustate->idxoffset);
        if (processleafedge_shulen(true,
                            TOP_ESA_BOTTOMUP_shulen.lcp,
                            &TOP_ESA_BOTTOMUP_shulen.info,
                            previoussuffix,
                            bustate,
                            err) != 0)
        {
          haserr = true;
        }
      }
    }
  if (!haserr)
  {
    bustate->firstedgefromroot = firstedgefromroot;
  }
  return haserr ? -1 : 0;
}

static int gt_esa_bottomup_RAM_shulen(const unsigned long *bucketofsuffixes,
                        const uint32_t *bucketofsuffixes_uint32,
                        const GtLcpvaluetype *lcptab_bucket,
                        unsigned long numberofsuffixes,
                        GtArrayGtBUItvinfo_shulen *stack,
                        GtBUstate_shulen *bustate,
                        /* no parameter snrp */
                        GtError *err)
{
  const unsigned long incrementstacksize = 32UL;
  unsigned long lcpvalue,
                previoussuffix,
                idx;
  GtBUItvinfo_shulen *lastinterval = NULL;
  bool haserr = false, firstedge, firstedgefromroot;

  if (bustate->previousbucketlastsuffix == ULONG_MAX)
  {
    PUSH_ESA_BOTTOMUP_shulen(0,0);
    firstedgefromroot = true;
  } else
  {
    firstedgefromroot = bustate->firstedgefromroot;
  }
  gt_assert (numberofsuffixes > 0);
  for (idx = 0; !haserr && idx < numberofsuffixes-1; idx++)
  {
    lcpvalue = (unsigned long) lcptab_bucket[idx+1];
    previoussuffix = bucketofsuffixes != NULL ? bucketofsuffixes[idx]
                                 : (unsigned long)
                                   bucketofsuffixes_uint32[idx];
    gt_assert(stack->nextfreeGtBUItvinfo > 0);
    if (lcpvalue <= TOP_ESA_BOTTOMUP_shulen.lcp)
    {
      if (TOP_ESA_BOTTOMUP_shulen.lcp > 0 || !firstedgefromroot)
      {
        firstedge = false;
      } else
      {
        firstedge = true;
        firstedgefromroot = false;
      }
      if (processleafedge_shulen(firstedge,
                          TOP_ESA_BOTTOMUP_shulen.lcp,
                          &TOP_ESA_BOTTOMUP_shulen.info,
                          previoussuffix,
                          bustate,
                          err) != 0)
      {
        haserr = true;
      }
    }
    gt_assert(lastinterval == NULL);
    while (!haserr && lcpvalue < TOP_ESA_BOTTOMUP_shulen.lcp)
    {
      lastinterval = POP_ESA_BOTTOMUP_shulen;
      lastinterval->rb = idx + bustate->idxoffset;
      /* no call to processlcpinterval_shulen */
      if (lcpvalue <= TOP_ESA_BOTTOMUP_shulen.lcp)
      {
        if (TOP_ESA_BOTTOMUP_shulen.lcp > 0 || !firstedgefromroot)
        {
          firstedge = false;
        } else
        {
          firstedge = true;
          firstedgefromroot = false;
        }
        if (processbranchingedge_shulen(firstedge,
                   TOP_ESA_BOTTOMUP_shulen.lcp,
                   &TOP_ESA_BOTTOMUP_shulen.info,
                   lastinterval->lcp,
                   lastinterval->rb - lastinterval->lb + 1,
                   &lastinterval->info,
                   bustate,
                   err) != 0)
        {
          haserr = true;
        }
        lastinterval = NULL;
      }
    }
    if (!haserr && lcpvalue > TOP_ESA_BOTTOMUP_shulen.lcp)
    {
      if (lastinterval != NULL)
      {
        unsigned long lastintervallb = lastinterval->lb;
        unsigned long lastintervallcp = lastinterval->lcp,
              lastintervalrb = lastinterval->rb;
        PUSH_ESA_BOTTOMUP_shulen(lcpvalue,lastintervallb);
        if (processbranchingedge_shulen(true,
                       TOP_ESA_BOTTOMUP_shulen.lcp,
                       &TOP_ESA_BOTTOMUP_shulen.info,
                       lastintervallcp,
                       lastintervalrb - lastintervallb + 1,
                       NULL,
                       bustate,
                       err) != 0)
        {
          haserr = true;
        }
        lastinterval = NULL;
      } else
      {
        PUSH_ESA_BOTTOMUP_shulen(lcpvalue,idx + bustate->idxoffset);
        if (processleafedge_shulen(true,
                            TOP_ESA_BOTTOMUP_shulen.lcp,
                            &TOP_ESA_BOTTOMUP_shulen.info,
                            previoussuffix,
                            bustate,
                            err) != 0)
        {
          haserr = true;
        }
      }
    }
  }
  if (!haserr)
  {
    bustate->previousbucketlastsuffix
      = bucketofsuffixes != NULL ? bucketofsuffixes[numberofsuffixes-1]
                                 : (unsigned long)
                                   bucketofsuffixes_uint32[numberofsuffixes-1];
    bustate->firstedgefromroot = firstedgefromroot;
  }
  return haserr ? -1 : 0;
}
