/**
 * @file check_subscription.c
 * @brief Unit tests for GEIS v1 subscriptions
 *
 * Copyright 2011 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of version 3 of the GNU Lesser General Public License as published
 * by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */
#include <check.h>

#include <geis/geis.h>
#include <string.h>


#define GEIS_TEST_WINDOW geis_win_type_str(Test)

static const char* s_gestures[] = {
  GEIS_GESTURE_TYPE_DRAG2, GEIS_GESTURE_TYPE_DRAG3,
  GEIS_GESTURE_TYPE_PINCH2, GEIS_GESTURE_TYPE_PINCH3,
  GEIS_GESTURE_TYPE_ROTATE2, GEIS_GESTURE_TYPE_ROTATE3,
  GEIS_GESTURE_TYPE_TAP2, GEIS_GESTURE_TYPE_TAP3, GEIS_GESTURE_TYPE_TAP4,
  NULL
};

static void
gesture_added(void            *cookie CK_ATTRIBUTE_UNUSED,
              GeisGestureType  gesture_type CK_ATTRIBUTE_UNUSED,
              GeisGestureId    gesture_id CK_ATTRIBUTE_UNUSED,
              GeisSize         attr_count CK_ATTRIBUTE_UNUSED,
              GeisGestureAttr *attrs CK_ATTRIBUTE_UNUSED)
{
}

static void
gesture_removed(void              *cookie CK_ATTRIBUTE_UNUSED,
                GeisGestureType    gesture_type CK_ATTRIBUTE_UNUSED,
                GeisGestureId      gesture_id CK_ATTRIBUTE_UNUSED,
                GeisSize           attr_count CK_ATTRIBUTE_UNUSED,
                GeisGestureAttr   *attrs CK_ATTRIBUTE_UNUSED)
{
}

/*
 * Checks for special values generated by the mock back end.
 */
static void
gesture_start(void              *cookie CK_ATTRIBUTE_UNUSED,
              GeisGestureType    gesture_type CK_ATTRIBUTE_UNUSED,
              GeisGestureId      gesture_id CK_ATTRIBUTE_UNUSED,
              GeisSize           attr_count CK_ATTRIBUTE_UNUSED,
              GeisGestureAttr   *attrs CK_ATTRIBUTE_UNUSED)
{
}

static void
gesture_update(void              *cookie CK_ATTRIBUTE_UNUSED,
               GeisGestureType    gesture_type CK_ATTRIBUTE_UNUSED,
               GeisGestureId      gesture_id CK_ATTRIBUTE_UNUSED,
               GeisSize           attr_count CK_ATTRIBUTE_UNUSED,
               GeisGestureAttr   *attrs CK_ATTRIBUTE_UNUSED)
{
}

static void
gesture_finish(void              *cookie CK_ATTRIBUTE_UNUSED,
               GeisGestureType    gesture_type CK_ATTRIBUTE_UNUSED,
               GeisGestureId      gesture_id CK_ATTRIBUTE_UNUSED,
               GeisSize           attr_count CK_ATTRIBUTE_UNUSED,
               GeisGestureAttr   *attrs CK_ATTRIBUTE_UNUSED)
{
}


/* fixtures */
static GeisInstance g_instance;

/* fixture setup */
static void
construct_instance()
{
  GeisStatus   status;
  GeisXcbWinInfo x_win_info = {
    .display_name  = NULL,
    .screenp       = NULL,
    .window_id     = 1
  };
  GeisWinInfo  win_info = { GEIS_TEST_WINDOW, &x_win_info };

  status = geis_init(&win_info, &g_instance);
}

/* fixture teardown */
static void
destroy_instance()
{
  geis_finish(g_instance);
}


static void
construct_subscription()
{
  GeisStatus status;
  GeisGestureFuncs gesture_funcs;

  gesture_funcs.added   = gesture_added;
  gesture_funcs.removed = gesture_removed;
  gesture_funcs.start   = gesture_start;
  gesture_funcs.update  = gesture_update;
  gesture_funcs.finish  = gesture_finish;
  status = geis_subscribe(g_instance,
                          GEIS_ALL_INPUT_DEVICES,
                          s_gestures,
                          &gesture_funcs,
                          &gesture_funcs);
}


static void
dispatch_events()
{
  GeisGestureFuncs gesture_funcs;
  memset(&gesture_funcs, 0, sizeof(GeisGestureFuncs));
  geis_event_dispatch(g_instance);
}


/* regression test for LP: #754135 */
START_TEST(check_persistence)
{
  construct_subscription();
  dispatch_events();
}
END_TEST


Suite *
geis1_subscription_new()
{
  Suite *s = suite_create("geis1_subscription");
  TCase *test;

  test = tcase_create("lp754135");
  tcase_add_checked_fixture(test, construct_instance, destroy_instance);
  tcase_add_test(test, check_persistence);
  suite_add_tcase(s, test);

  return s;
}

