#!/bin/sh

# use the test config file, and just echo the arguments, for the tests.
export __GCC_OPT_CONFIG_FILE=test.conf
export __GCC_OPT_COMPILER_EXEC=/bin/echo

typeset -i num=0
typeset -i pass=0
typeset -i fail=0

dotest() {
  pkg="$1"
  name="$2"
  args="$3"
  ret="$4"

  num=num+1
  out=$(__GCC_OPT_PACKAGE=$pkg __GCC_OPT_COMPILER_NAME=$name ./gcc-3.3 $args)
  if [ "X$out" = "X$ret" ]; then
    pass=$pass+1
  else
    echo test $num:
    echo " " \"$out\" !=
    echo " " \"$ret\"
    echo
    fail=$fail+1
  fi
}

[ -x gcc-3.3 ] || make gcc-3.3

dotest "" test "" "-march=i386 -fda=1 -fdb -mcpu=pentium4 -ffa=1 -ffb" 
dotest "" test "-march=i486 -fda=76 -fca=7 -ffa=76" "-fdb -mcpu=pentium4 -ffa=1 -ffb -march=i486 -fda=76"

dotest memtest test "-march=i486" "-fda=1 -fdb -march=i486"
dotest prefix test "" "/bin/echo -march=i386 -fda=1 -fdb -mcpu=pentium4 -ffa=1 -ffb"

dotest "" optdefault "" "-O2"
dotest "" optdefault "-O0" "-O2"
dotest "" optdefault "-O1" "-O1"
dotest "" optdefault "-O7" "-O2"
dotest O6 optdefault "-O6" "-O6"
dotest ONONE optdefault "" ""

dotest nopref ONONE "" ""
echo $num tests: $pass pass, $fail fail
