/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc;

import java.io.IOException;
import java.util.Date;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.apache.xmlrpc.XmlRpcException;

public class Benchmark
implements Runnable {
    XmlRpcClient client = new XmlRpcClientLite(url);
    static String url;
    static int clients;
    static int loops;
    long start;
    int gCalls = 0;
    int gErrors = 0;
    Date date;

    public Benchmark() throws Exception {
        Vector<Integer> vector = new Vector<Integer>();
        vector.addElement(new Integer(123));
        this.client.execute("math.abs", vector);
        this.date = new Date();
        this.date = new Date(this.date.getTime() / 1000L * 1000L);
        this.start = System.currentTimeMillis();
        int n = clients;
        int n2 = 0;
        while (n2 < n) {
            new Thread(this).start();
            ++n2;
        }
    }

    public void run() {
        int n;
        int n2 = 0;
        int n3 = 0;
        try {
            n = (int)(-100.0 * Math.random());
            Vector<Integer> vector = new Vector<Integer>();
            vector.addElement(new Integer(n));
            int n4 = 0;
            while (n4 < loops) {
                Integer n5 = (Integer)this.client.execute("math.abs", vector);
                if (n5 != Math.abs(n)) {
                    ++n2;
                }
                ++n3;
                ++n4;
            }
        }
        catch (IOException iOException) {
            System.err.println("Exception in client: " + iOException);
            iOException.printStackTrace();
        }
        catch (XmlRpcException xmlRpcException) {
            System.err.println("Server reported error: " + xmlRpcException);
        }
        catch (Exception exception) {
            System.err.println("Exception in Benchmark client: " + exception);
        }
        n = (int)(System.currentTimeMillis() - this.start);
        this.checkout(n3, n2, n);
    }

    private synchronized void checkout(int n, int n2, int n3) {
        this.gCalls += n;
        this.gErrors += n2;
        System.err.println("Benchmark thread finished: " + n + " calls, " + n2 + " errors in " + n3 + " milliseconds.");
        if (--clients == 0) {
            System.err.println("");
            System.err.println("Benchmark result: " + 1000 * this.gCalls / n3 + " calls per second.");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0 && stringArray.length < 3) {
            url = stringArray[0];
            XmlRpc.setKeepAlive(true);
            if (stringArray.length == 2) {
                XmlRpc.setDriver(stringArray[1]);
            }
            new Benchmark();
        } else {
            System.err.println("Usage: java org.apache.xmlrpc.Benchmark URL [SAXDriver]");
        }
    }

    static {
        clients = 16;
        loops = 100;
    }
}

