# General Instrument AY-3-8910

this chip was used in many home computers (ZX Spectrum, MSX, Amstrad CPC, Atari ST, etc.), video game consoles (Intellivision and Vectrex), arcade boards and even slot machines!

it is a 3-channel square/noise/envelope sound generator. the chip's powerful sound comes from the envelope...

the AY-3-8914 variant was used in Intellivision, which is pretty much an AY with 4 level envelope volume per channel and different register format.

Furnace is capable of doing software sample playback on AY-3-8910, where all 3 channels can play 4-bit PCM samples (at the cost of a very high CPU usage) and utilize CPU timer effects, providing all kinds of modulation (PWM and envelope distortion) effects, again at the cost of a higher CPU usage. Songs utilizing timer effects may not sound as intended after VGM export.

## effects

- `20xx`: **set channel mode.**
  - `0`: square
  - `1`: noise
  - `2`: square and noise
  - `3`: envelope
  - `4`: envelope and square
  - `5`: envelope and noise
  - `6`: envelope and square and noise
  - `7`: nothing
- `21xx`: **set noise frequency.** range is `0` to `1F`.
- `22xy`: **set envelope mode.**
  - `x` sets the envelope shape:
    - `0`: `\___` decay
    - `4`: `/___` attack once
    - `8`: `\\\\` saw
    - `9`: `\___` decay
    - `A`: `\/\/` inverse obelisco
    - `B`: `\¯¯¯` decay once
    - `C`: `////` inverse saw
    - `D`: `/¯¯¯` attack
    - `E`: `/\/\` obelisco
    - `F`: `/___` attack once
  - if `y` is 1 then the envelope will affect this channel.
- `23xx`: **set envelope period low byte.**
- `24xx`: **set envelope period high byte.**
- `25xx`: **slide envelope period up.**
- `26xx`: **slide envelope period down.**
- `29xy`: **enable auto-envelope mode.**
  - in this mode the envelope period is set to the channel's notes, multiplied by a fraction.
  - `x` is the numerator.
  - `y` is the denominator.
  - if `x` or `y` are 0 this will disable auto-envelope mode.
- `2Cxx`: **set timer period offset.**
  - bit 7 is the sign.
- `2Exx`: **write to I/O port A.**
  - this changes the port's mode to "write". make sure you have connected something to it.
- `2Fxx`: **write to I/O port B.**
  - this changes the port's mode to "write". make sure you have connected something to it.

## what is obelisco

it's a name I use for a spiky waveform that starts low.

its origin is a wavetable that comes in DefleMask that happens to be called Obelisco.

## AY derivative modes

AY-3-810 was an absurdly popular chip that was blessed with many third-party clones, licensed or not.

- the AY-3-8914 variant was used in Intellivision, which is pretty much an 8910 with 4 level envelope volume per channel and different register format.
- Yamaha YM2149 was an AY-3-8910 clone released in 1983. it's almost identical to AY with minor differences being: higher hardware envelope step resolution (16 vs 32), half-clock mode when voltage level is low, much stronger DC offset and cleaner, but softer output.
- Sunsoft 5B is YM2149 clone with half-clock mode forced on.

## info

this chip uses the [AY-3-8910](../4-instrument/ay8910.md) instrument editor.

## chip config

the following options are available in the Chip Manager window:

- **Clock rate**: sets the rate at which the chip will run.
- **Chip type**: changes the chip model.
  - AY-3-8910: the original model.
  - YM2149(F): Yamaha clone with higher envelope resolution and a different volume curve.
  - Sunsoft 5B: a special model found in one of Sunsoft's Famicom cartridges.
  - AY-3-8914: scrambled registers. has envelope volume control.
- **Stereo**: enable stereo output. channel 1 is output left, channel 2 is output center and channel 3 is output right.
  - **Separation**: allows you to set left/right separation.
- **Half Clock divider**: pulls the half clock pin, running the chip at half the speed.
  - only available in YM2149.
