/* Unsorted.vala
 *
 * Copyright (C) 2009 - 2019 Jerry Casiano
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.
 *
 * If not, see <http://www.gnu.org/licenses/gpl-3.0.txt>.
*/

namespace FontManager {

    public class Unsorted : Category {

        public Unsorted () {
            base(_("Unsorted"), _("Fonts not present in any collection"), "dialog-question", "%s;".printf(SELECT_FROM_FONTS));
        }

        public new async void update (StringHashset sorted) {
            SourceFunc callback = update.callback;
            base.update.begin((obj, res) => {
                base.update.end(res);
                families.remove_all(sorted.list());
                Idle.add((owned) callback);
            });
            yield;
            return;
        }

        public new bool visible_func (Gtk.TreeModel model, Gtk.TreeIter iter) {
            Value val;
            bool visible = false;
            model.get_value(iter, FontModelColumn.OBJECT, out val);
            string? family = ((Json.Object) val).get_string_member("family");
            visible = (family in families);
            val.unset();
            return visible;
        }

    }

}
