/*
 * Decompiled with CFR 0.152.
 */
package friendless.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public final class VCodeLayout
implements LayoutManager {
    private int vgap;
    private String usual;
    private Hashtable codes;
    private boolean debug;

    public VCodeLayout() {
        this("", 4, false);
    }

    public VCodeLayout(String string, int n) {
        this(string, n, false);
    }

    public VCodeLayout(String string, int n, boolean bl) {
        if (string == null) {
            string = "";
        }
        this.usual = string;
        this.vgap = n;
        this.codes = new Hashtable();
        this.debug = bl;
    }

    public void addLayoutComponent(String string, Component component) {
        this.codes.put(component, string);
    }

    private boolean hasCode(StringBuffer stringBuffer, char c) {
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == c) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private int getExpansion(StringBuffer stringBuffer) {
        int n = 0;
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            if (stringBuffer.charAt(n2) == 'x') {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private StringBuffer getCode(Component component) {
        String string = (String)this.codes.get(component);
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer(this.usual + string);
        Vector<Character> vector = new Vector<Character>();
        boolean bl = false;
        int n = 0;
        while (n < stringBuffer.length()) {
            char c = stringBuffer.charAt(n);
            if (c == '-') {
                bl = true;
            } else if (c == '+') {
                bl = false;
            } else {
                Character c2 = new Character(c);
                if (bl) {
                    vector.removeElement(c2);
                } else {
                    vector.addElement(c2);
                }
            }
            ++n;
        }
        StringBuffer stringBuffer2 = new StringBuffer(vector.size());
        int n2 = 0;
        while (n2 < vector.size()) {
            Character c = (Character)vector.elementAt(n2);
            stringBuffer2.append(c.charValue());
            ++n2;
        }
        return stringBuffer2;
    }

    public void layoutContainer(Container container) {
        int n;
        int n2;
        boolean bl;
        Serializable serializable;
        Rectangle rectangle = container.getBounds();
        Insets insets = container.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        if (this.debug) {
            System.out.println("VCodeLayout: Bounds: " + rectangle);
            System.out.println("VCodeLayout: Insets: " + insets);
        }
        int n3 = rectangle.height - insets.top - insets.bottom;
        int n4 = rectangle.width - insets.left - insets.right;
        boolean bl2 = false;
        int n5 = 0;
        Component[] componentArray = container.getComponents();
        int n6 = 0;
        int n7 = 0;
        while (n7 < componentArray.length) {
            Dimension dimension = componentArray[n7].getPreferredSize();
            serializable = this.getCode(componentArray[n7]);
            int n8 = this.getExpansion((StringBuffer)serializable);
            if (n8 > 0) {
                n5 += n8;
            } else {
                n6 += dimension.height;
            }
            n6 += this.vgap;
            ++n7;
        }
        if ((n6 -= this.vgap) >= n3) {
            bl = true;
            n6 = 0;
            int n9 = 0;
            while (n9 < componentArray.length) {
                serializable = componentArray[n9].getMinimumSize();
                StringBuffer stringBuffer = this.getCode(componentArray[n9]);
                n2 = this.getExpansion(stringBuffer);
                if (n2 > 0) {
                    n5 += n2;
                } else {
                    n6 += ((Dimension)serializable).height;
                }
                n6 += this.vgap;
                ++n9;
            }
            n = 0;
            if (n5 != 0 && (n6 -= this.vgap) < n3) {
                n = (n3 - n6) / n5;
            }
        } else if (n5 == 0) {
            bl = false;
            n = 0;
        } else {
            bl = false;
            n = (n3 - n6) / n5;
        }
        n6 = insets.top;
        int n10 = 0;
        while (n10 < componentArray.length) {
            int n11;
            serializable = this.getCode(componentArray[n10]);
            Dimension dimension = null;
            n2 = 0;
            dimension = bl ? componentArray[n10].getMinimumSize() : componentArray[n10].getPreferredSize();
            int n12 = this.getExpansion((StringBuffer)serializable);
            if (n12 > 0) {
                n11 = n * n12;
                n2 = 0;
            } else {
                n11 = dimension.height;
                n2 = dimension.width;
            }
            int n13 = 0;
            if (this.hasCode((StringBuffer)serializable, 'f')) {
                n2 = n4;
            } else if (n2 == 0 || n2 > n4) {
                n2 = n4;
            }
            n13 = this.hasCode((StringBuffer)serializable, 'l') ? insets.left : (this.hasCode((StringBuffer)serializable, 'r') ? n4 + insets.left - n2 : insets.left + (n4 - n2) / 2);
            componentArray[n10].setBounds(n13, n6, n2, n11);
            n6 += n11;
            n6 += this.vgap;
            ++n10;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension;
        int n = 0;
        int n2 = 0;
        Component[] componentArray = container.getComponents();
        int n3 = 0;
        while (n3 < componentArray.length) {
            dimension = componentArray[n3].getMinimumSize();
            n += dimension.height;
            n += this.vgap;
            if (dimension.width > n2) {
                n2 = dimension.width;
            }
            ++n3;
        }
        dimension = new Dimension(n2, n - this.vgap);
        Insets insets = container.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension;
        int n = 0;
        int n2 = 0;
        Component[] componentArray = container.getComponents();
        int n3 = 0;
        while (n3 < componentArray.length) {
            dimension = componentArray[n3].getPreferredSize();
            n += dimension.height;
            n += this.vgap;
            if (dimension.width > n2) {
                n2 = dimension.width;
            }
            ++n3;
        }
        dimension = new Dimension(n2, n - this.vgap);
        Insets insets = container.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public void removeLayoutComponent(Component component) {
        this.codes.remove(component);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

