/*******************************************************************
 * Fritz Fun                                                       *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file pwd_kdemain.cpp
 * \brief KDE Wallet (KDE4) main functions
 */

#include <qstring.h>
#include <kaboutdata.h>
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <kwallet.h>
#include <stdio.h>

#include <config.h>

#define FOLDER	"ffgtk"

//#define KERN_DEBUG 3

/*#define Debug( x, y... ) do {\
	Debug2( x, __FUNCTION__, y );\
} while ( 0 );*/

//extern "C" int Debug2( int, const char *, const char *,... );

static KApplication *App = NULL;
static KWallet::Wallet *Wallet = NULL;

/**
 * \brief Initialize wallet
 */
extern "C" void InitWallet( void ) {
	QString qLocalWallet;

	if ( App == NULL ) {
		KAboutData aboutData( "ffgtk", 0, ki18n( "ffgtk" ), "" );
		KCmdLineArgs::init( &aboutData );
		App = new KApplication( false );
	}
	if ( Wallet == NULL ) {
		qLocalWallet = KWallet::Wallet::LocalWallet();
		Wallet = KWallet::Wallet::openWallet( qLocalWallet, 0 );
	}
}

/**
 * \brief Read password
 * \param pnName entry name
 * \param ppnPassword pointer to store data to
 * \return error code
 */
extern "C" int kdeReadPassword( const char *pnName, char **ppnPassword ) {
	QString qEntry, qPassword;
	int nError = -1;

	if ( !Wallet ) {
		return -2;
	}

	if ( !Wallet -> hasFolder( FOLDER ) ) {
		nError = -3;
		goto out;
	}

	if ( !Wallet -> setFolder( FOLDER ) ) {
		nError = -4;
		goto out;;
	}

	qEntry = QString::fromUtf8( pnName );

	if ( !Wallet -> hasEntry( qEntry ) ) {
		nError = -5;
		goto out;
	}

	qPassword = "";
	//Debug( KERN_DEBUG, "Want to read password!\n" );
	if ( Wallet -> readPassword( qEntry, qPassword ) == 0 ) {
		//Debug( KERN_DEBUG, "Got password: '%s'\n", ( char * ) qPassword.toUtf8().data() );
		*ppnPassword = strdup( ( char * ) qPassword.toUtf8().data() );
		nError = 0;
	}

out:

	return nError;
}

/**
 * \brief Write password
 * \param pnName entry name
 * \param pnPassword password
 * \return error code
 */
extern "C" int kdeWritePassword( const char *pnName, const char *pnPassword ) {
	QString qEntry, qPassword;
	int nError = -1;

	if ( !Wallet ) {
		return -2;
	}

	if ( !Wallet -> hasFolder( FOLDER ) ) {
		Wallet -> createFolder( FOLDER );
	}

	if ( !Wallet -> setFolder( FOLDER ) ) {
		nError = -4;
		goto out;;
	}

	qEntry = QString::fromUtf8( pnName );
	qPassword = QString::fromUtf8( pnPassword );

	if ( Wallet -> writePassword( qEntry, qPassword ) ) {
		nError = -5;
	} else {
		nError = 0;
	}

out:

	return nError;
}
