/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.springframework.core.Constants;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.JmsException;
import org.springframework.jms.listener.AbstractJmsListeningContainer;
import org.springframework.jms.listener.AbstractPollingMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.destination.CachingDestinationResolver;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.scheduling.SchedulingAwareRunnable;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class DefaultMessageListenerContainer
extends AbstractPollingMessageListenerContainer {
    public static final String DEFAULT_THREAD_NAME_PREFIX = ClassUtils.getShortName(DefaultMessageListenerContainer.class) + "-";
    public static final long DEFAULT_RECOVERY_INTERVAL = 5000L;
    public static final int CACHE_NONE = 0;
    public static final int CACHE_CONNECTION = 1;
    public static final int CACHE_SESSION = 2;
    public static final int CACHE_CONSUMER = 3;
    public static final int CACHE_AUTO = 4;
    private static final Constants constants = new Constants(DefaultMessageListenerContainer.class);
    private TaskExecutor taskExecutor;
    private long recoveryInterval = 5000L;
    private int cacheLevel = 4;
    private int concurrentConsumers = 1;
    private int maxConcurrentConsumers = 1;
    private int maxMessagesPerTask = Integer.MIN_VALUE;
    private int idleTaskExecutionLimit = 1;
    private final Set scheduledInvokers = new HashSet();
    private int activeInvokerCount = 0;
    private Runnable stopCallback;
    private final Object activeInvokerMonitor = new Object();
    private Object currentRecoveryMarker = new Object();
    private final Object recoveryMonitor = new Object();

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public void setCacheLevelName(String constantName) throws IllegalArgumentException {
        if (constantName == null || !constantName.startsWith("CACHE_")) {
            throw new IllegalArgumentException("Only cache constants allowed");
        }
        this.setCacheLevel(constants.asNumber(constantName).intValue());
    }

    public void setCacheLevel(int cacheLevel) {
        this.cacheLevel = cacheLevel;
    }

    public int getCacheLevel() {
        return this.cacheLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConcurrentConsumers(int concurrentConsumers) {
        Assert.isTrue(concurrentConsumers > 0, "'concurrentConsumers' value must be at least 1 (one)");
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            this.concurrentConsumers = concurrentConsumers;
            if (this.maxConcurrentConsumers < concurrentConsumers) {
                this.maxConcurrentConsumers = concurrentConsumers;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getConcurrentConsumers() {
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            return this.concurrentConsumers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        Assert.isTrue(maxConcurrentConsumers > 0, "'maxConcurrentConsumers' value must be at least 1 (one)");
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            this.maxConcurrentConsumers = maxConcurrentConsumers > this.concurrentConsumers ? maxConcurrentConsumers : this.concurrentConsumers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getMaxConcurrentConsumers() {
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            return this.maxConcurrentConsumers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxMessagesPerTask(int maxMessagesPerTask) {
        Assert.isTrue(maxMessagesPerTask != 0, "'maxMessagesPerTask' must not be 0");
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            this.maxMessagesPerTask = maxMessagesPerTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxMessagesPerTask() {
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            return this.maxMessagesPerTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdleTaskExecutionLimit(int idleTaskExecutionLimit) {
        Assert.isTrue(idleTaskExecutionLimit > 0, "'idleTaskExecutionLimit' must be 1 or higher");
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            this.idleTaskExecutionLimit = idleTaskExecutionLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdleTaskExecutionLimit() {
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            return this.idleTaskExecutionLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateConfiguration() {
        super.validateConfiguration();
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            if (this.isSubscriptionDurable() && this.concurrentConsumers != 1) {
                throw new IllegalArgumentException("Only 1 concurrent consumer supported for durable subscription");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        if (this.cacheLevel == 4) {
            this.cacheLevel = this.getTransactionManager() != null ? 0 : 3;
        }
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            if (this.taskExecutor == null) {
                this.taskExecutor = this.createDefaultTaskExecutor();
            } else if (this.taskExecutor instanceof SchedulingTaskExecutor && ((SchedulingTaskExecutor)this.taskExecutor).prefersShortLivedTasks() && this.maxMessagesPerTask == Integer.MIN_VALUE) {
                this.maxMessagesPerTask = 10;
            }
        }
        super.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInitialize() throws JMSException {
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            for (int i = 0; i < this.concurrentConsumers; ++i) {
                this.scheduleNewInvoker();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doShutdown() throws JMSException {
        this.logger.debug("Waiting for shutdown of message listener invokers");
        try {
            Object object = this.activeInvokerMonitor;
            synchronized (object) {
                while (this.activeInvokerCount > 0) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Still waiting for shutdown of " + this.activeInvokerCount + " message listener invokers");
                    }
                    this.activeInvokerMonitor.wait();
                }
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JmsException {
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            this.stopCallback = null;
        }
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Runnable callback) throws JmsException {
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            this.stopCallback = callback;
        }
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getScheduledConsumerCount() {
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            return this.scheduledInvokers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getActiveConsumerCount() {
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            return this.activeInvokerCount;
        }
    }

    protected TaskExecutor createDefaultTaskExecutor() {
        String beanName = this.getBeanName();
        String threadNamePrefix = beanName != null ? beanName + "-" : DEFAULT_THREAD_NAME_PREFIX;
        return new SimpleAsyncTaskExecutor(threadNamePrefix);
    }

    private void scheduleNewInvoker() {
        AsyncMessageListenerInvoker invoker = new AsyncMessageListenerInvoker();
        if (this.rescheduleTaskIfNecessary(invoker)) {
            this.scheduledInvokers.add(invoker);
        }
    }

    protected final boolean sharedConnectionEnabled() {
        return this.getCacheLevel() >= 1;
    }

    protected void doRescheduleTask(Object task) {
        this.taskExecutor.execute((Runnable)task);
    }

    protected void messageReceived(Object invoker, Session session) {
        ((AsyncMessageListenerInvoker)invoker).setIdle(false);
        this.scheduleNewInvokerIfAppropriate();
    }

    protected void noMessageReceived(Object invoker, Session session) {
        ((AsyncMessageListenerInvoker)invoker).setIdle(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleNewInvokerIfAppropriate() {
        if (this.isRunning()) {
            this.resumePausedTasks();
            Object object = this.activeInvokerMonitor;
            synchronized (object) {
                if (this.scheduledInvokers.size() < this.maxConcurrentConsumers && this.getIdleInvokerCount() == 0) {
                    this.scheduleNewInvoker();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Raised scheduled invoker count: " + this.scheduledInvokers.size());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldRescheduleInvoker(int idleTaskExecutionCount) {
        Object object = this.activeInvokerMonitor;
        synchronized (object) {
            boolean superfluous = idleTaskExecutionCount >= this.idleTaskExecutionLimit && this.getIdleInvokerCount() > 1;
            return this.scheduledInvokers.size() <= (superfluous ? this.concurrentConsumers : this.maxConcurrentConsumers);
        }
    }

    private int getIdleInvokerCount() {
        int count = 0;
        Iterator it = this.scheduledInvokers.iterator();
        while (it.hasNext()) {
            AsyncMessageListenerInvoker invoker = (AsyncMessageListenerInvoker)it.next();
            if (!invoker.isIdle()) continue;
            ++count;
        }
        return count;
    }

    protected void establishSharedConnection() {
        try {
            super.establishSharedConnection();
        }
        catch (JMSException ex) {
            this.logger.debug("Could not establish shared JMS Connection - leaving it up to asynchronous invokers to establish a Connection as soon as possible", ex);
        }
    }

    protected void startSharedConnection() {
        try {
            super.startSharedConnection();
        }
        catch (JMSException ex) {
            this.logger.debug("Connection start failed - relying on listeners to perform recovery", ex);
        }
    }

    protected void stopSharedConnection() {
        try {
            super.stopSharedConnection();
        }
        catch (JMSException ex) {
            this.logger.debug("Connection stop failed - relying on listeners to perform recovery after restart", ex);
        }
    }

    protected void handleListenerSetupFailure(Throwable ex, boolean alreadyRecovered) {
        if (ex instanceof JMSException) {
            this.invokeExceptionListener((JMSException)ex);
        }
        if (ex instanceof AbstractJmsListeningContainer.SharedConnectionNotInitializedException) {
            if (!alreadyRecovered) {
                this.logger.debug("JMS message listener invoker needs to establish shared Connection");
            }
        } else if (alreadyRecovered) {
            this.logger.debug("Setup of JMS message listener invoker failed - already recovered by other invoker", ex);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.info("Setup of JMS message listener invoker failed - trying to recover", ex);
        } else {
            this.logger.info("Setup of JMS message listener invoker failed - trying to recover: " + ex);
        }
    }

    protected void recoverAfterListenerSetupFailure() {
        this.refreshConnectionUntilSuccessful();
        this.refreshDestination();
    }

    protected void refreshConnectionUntilSuccessful() {
        while (this.isRunning()) {
            try {
                if (this.sharedConnectionEnabled()) {
                    this.refreshSharedConnection();
                } else {
                    Connection con = this.createConnection();
                    JmsUtils.closeConnection(con);
                }
                this.logger.info("Successfully refreshed JMS Connection");
                break;
            }
            catch (Exception ex) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Could not refresh JMS Connection - retrying in " + this.recoveryInterval + " ms", ex);
                }
                this.sleepInbetweenRecoveryAttempts();
            }
        }
    }

    protected void refreshDestination() {
        DestinationResolver destResolver;
        String destName = this.getDestinationName();
        if (destName != null && (destResolver = this.getDestinationResolver()) instanceof CachingDestinationResolver) {
            ((CachingDestinationResolver)destResolver).removeFromCache(destName);
        }
    }

    protected void sleepInbetweenRecoveryAttempts() {
        if (this.recoveryInterval > 0L) {
            try {
                Thread.sleep(this.recoveryInterval);
            }
            catch (InterruptedException interEx) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class AsyncMessageListenerInvoker
    implements SchedulingAwareRunnable {
        private Session session;
        private MessageConsumer consumer;
        private Object lastRecoveryMarker;
        private boolean lastMessageSucceeded;
        private int idleTaskExecutionCount = 0;
        private volatile boolean idle = true;

        private AsyncMessageListenerInvoker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean messageReceived;
            block29: {
                Object object = DefaultMessageListenerContainer.this.activeInvokerMonitor;
                synchronized (object) {
                    DefaultMessageListenerContainer.this.activeInvokerCount++;
                    DefaultMessageListenerContainer.this.activeInvokerMonitor.notifyAll();
                }
                messageReceived = false;
                try {
                    if (DefaultMessageListenerContainer.this.maxMessagesPerTask < 0) {
                        while (DefaultMessageListenerContainer.this.isActive()) {
                            DefaultMessageListenerContainer.this.waitWhileNotRunning();
                            if (!DefaultMessageListenerContainer.this.isActive()) continue;
                            messageReceived = this.invokeListener();
                        }
                    } else {
                        for (int messageCount = 0; DefaultMessageListenerContainer.this.isRunning() && messageCount < DefaultMessageListenerContainer.this.maxMessagesPerTask; ++messageCount) {
                            messageReceived = this.invokeListener() || messageReceived;
                        }
                    }
                }
                catch (Throwable ex) {
                    this.clearResources();
                    if (!this.lastMessageSucceeded) {
                        DefaultMessageListenerContainer.this.sleepInbetweenRecoveryAttempts();
                    }
                    this.lastMessageSucceeded = false;
                    boolean alreadyRecovered = false;
                    Object object2 = DefaultMessageListenerContainer.this.recoveryMonitor;
                    synchronized (object2) {
                        if (this.lastRecoveryMarker == DefaultMessageListenerContainer.this.currentRecoveryMarker) {
                            DefaultMessageListenerContainer.this.handleListenerSetupFailure(ex, false);
                            DefaultMessageListenerContainer.this.recoverAfterListenerSetupFailure();
                            DefaultMessageListenerContainer.this.currentRecoveryMarker = new Object();
                        } else {
                            alreadyRecovered = true;
                        }
                    }
                    if (!alreadyRecovered) break block29;
                    DefaultMessageListenerContainer.this.handleListenerSetupFailure(ex, true);
                }
            }
            Object ex = DefaultMessageListenerContainer.this.activeInvokerMonitor;
            synchronized (ex) {
                DefaultMessageListenerContainer.this.activeInvokerCount--;
                if (DefaultMessageListenerContainer.this.stopCallback != null && DefaultMessageListenerContainer.this.activeInvokerCount == 0) {
                    DefaultMessageListenerContainer.this.stopCallback.run();
                    DefaultMessageListenerContainer.this.stopCallback = null;
                }
                DefaultMessageListenerContainer.this.activeInvokerMonitor.notifyAll();
            }
            this.idleTaskExecutionCount = !messageReceived ? ++this.idleTaskExecutionCount : 0;
            if (!DefaultMessageListenerContainer.this.shouldRescheduleInvoker(this.idleTaskExecutionCount) || !DefaultMessageListenerContainer.this.rescheduleTaskIfNecessary(this)) {
                ex = DefaultMessageListenerContainer.this.activeInvokerMonitor;
                synchronized (ex) {
                    DefaultMessageListenerContainer.this.scheduledInvokers.remove(this);
                    if (DefaultMessageListenerContainer.this.logger.isDebugEnabled()) {
                        DefaultMessageListenerContainer.this.logger.debug("Lowered scheduled invoker count: " + DefaultMessageListenerContainer.this.scheduledInvokers.size());
                    }
                    DefaultMessageListenerContainer.this.activeInvokerMonitor.notifyAll();
                }
                this.clearResources();
            } else if (DefaultMessageListenerContainer.this.isRunning()) {
                int nonPausedConsumers = DefaultMessageListenerContainer.this.getScheduledConsumerCount() - DefaultMessageListenerContainer.this.getPausedTaskCount();
                if (nonPausedConsumers < 1) {
                    DefaultMessageListenerContainer.this.logger.error("All scheduled consumers have been paused, probably due to tasks having been rejected. Check your thread pool configuration! Manual recovery necessary through a start() call.");
                } else if (nonPausedConsumers < DefaultMessageListenerContainer.this.getConcurrentConsumers()) {
                    DefaultMessageListenerContainer.this.logger.warn("Number of scheduled consumers has dropped below concurrentConsumers limit, probably due to tasks having been rejected. Check your thread pool configuration! Automatic recovery to be triggered by remaining consumers.");
                }
            }
        }

        private boolean invokeListener() throws JMSException {
            this.initResourcesIfNecessary();
            boolean messageReceived = DefaultMessageListenerContainer.this.receiveAndExecute(this, this.session, this.consumer);
            this.lastMessageSucceeded = true;
            return messageReceived;
        }

        private void initResourcesIfNecessary() throws JMSException {
            if (DefaultMessageListenerContainer.this.getCacheLevel() <= 1) {
                this.updateRecoveryMarker();
            } else {
                if (this.session == null && DefaultMessageListenerContainer.this.getCacheLevel() >= 2) {
                    this.updateRecoveryMarker();
                    this.session = DefaultMessageListenerContainer.this.createSession(DefaultMessageListenerContainer.this.getSharedConnection());
                }
                if (this.consumer == null && DefaultMessageListenerContainer.this.getCacheLevel() >= 3) {
                    this.consumer = DefaultMessageListenerContainer.this.createListenerConsumer(this.session);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateRecoveryMarker() {
            Object object = DefaultMessageListenerContainer.this.recoveryMonitor;
            synchronized (object) {
                this.lastRecoveryMarker = DefaultMessageListenerContainer.this.currentRecoveryMarker;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearResources() {
            if (DefaultMessageListenerContainer.this.sharedConnectionEnabled()) {
                Object object = DefaultMessageListenerContainer.this.sharedConnectionMonitor;
                synchronized (object) {
                    JmsUtils.closeMessageConsumer(this.consumer);
                    JmsUtils.closeSession(this.session);
                }
            } else {
                JmsUtils.closeMessageConsumer(this.consumer);
                JmsUtils.closeSession(this.session);
            }
            this.consumer = null;
            this.session = null;
        }

        public boolean isLongLived() {
            return DefaultMessageListenerContainer.this.maxMessagesPerTask < 0;
        }

        public void setIdle(boolean idle) {
            this.idle = idle;
        }

        public boolean isIdle() {
            return this.idle;
        }
    }
}

