-- $Id: generic5.vhdl 4536 2009-06-11 14:36:31Z potyra $

-- test if generics work, test generic map (composite types)

-- Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.


ENTITY fwg IS
	GENERIC (
		g1 : string := "hallo welt"
	);
END ENTITY fwg;

ARCHITECTURE fwg_impl of fwg IS
BEGIN
	test_fwg : process
	begin
		assert false report g1 severity note;
		wait;
	end process;

END fwg_impl;

ENTITY ewg IS
	GENERIC (
		g1 : string := "hallo welt"
	);
END ENTITY ewg;

ARCHITECTURE ewg_impl of ewg IS
BEGIN
	U : fwg generic map (g1 => g1);
	-- formal g1: unconstraint
	-- actual g1: unconstraint
END ewg_impl;

ENTITY test_bench IS
END ENTITY test_bench;

ARCHITECTURE test_bench_impl of test_bench IS
begin
	-- generic must be set to default value
	test_ewg : ewg
		generic map ( g1 => "simulation finished" );
		-- hidden storage: "simulation finished"
		-- g1: unconstraint array will pass 
		-- base pointer to hidden storage instead
		-- if no actual is given, use ewg initializer
		-- as hidden storage.

end test_bench_impl;
