/* $Id: NullVisitor.hpp 4555 2009-08-21 11:01:35Z potyra $ 
 * NullVisitor: base class for visitors that don't want any default traversal.
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __NULL_VISITOR_HPP_INCLUDED
#define __NULL_VISITOR_HPP_INCLUDED

#include "frontend/visitor/Visitor.hpp"
namespace ast {

//! Visitor, that doesn't traverse.
/** This visitor doesn't traverse in any way. It only calls the 
 *  appropriate process methods.
 */
class NullVisitor : public Visitor {
public:
	/** dummy d'tor */
	virtual ~NullVisitor() {}

	/** visit a ElementAssociation
         *  @param node node that get's visited.
         */
	virtual void visit(ElementAssociation &node);

	/** visit a ConstReal
         *  @param node node that get's visited.
         */
	virtual void visit(ConstReal &node);

	/** visit a SimpleName
         *  @param node node that get's visited.
         */
	virtual void visit(SimpleName &node);

	/** visit a TemporaryName
         *  @param node node that get's visited.
         */
	virtual void visit(TemporaryName &node);

	/** visit a SelectedName
         *  @param node node that get's visited.
         */
	virtual void visit(SelectedName &node);

	/** visit a AttributeName
         *  @param node node that get's visited.
         */
	virtual void visit(AttributeName &node);

	/** Visit an Entity declaration.
	 *  @param node Entity Declaration node that get's visited.
	 */
	virtual void visit(Entity &node);

	/** Visit an Signal declaration.
	 *  @param node SignalDeclaration node that get's visited.
	 */
	virtual void visit(SignalDeclaration &node);

	/** Visit an Constant declaration.
	 *  @param node ConstantDeclaration node that get's visited.
	 */
	virtual void visit(ConstantDeclaration &node);

	/** Visit an FunctionCall.
	 *  @param node FunctionCall node that get's visited.
	 */
	virtual void visit(FunctionCall &node);

	/** Visit an IfStat.
	 *  @param node IfStat node that get's visited.
	 */
	virtual void visit(IfStat &node);

	/** Visit an NullStat.
	 *  @param node IfStat node that get's visited.
	 */
	virtual void visit(NullStat &node);

	/** Visit a ForLoopStat
	 *  @param node ForLoopStat node that get's visited.
	 */
	virtual void visit(ForLoopStat &node);

	/** Visit a WhileLoopStat
	 *  @param node WhileLoopStat node that get's visited.
	 */
	virtual void visit(WhileLoopStat &node);

	/** Visit a NextStat
	 *  @param node NextStat node that get's visited.
	 */
	virtual void visit(NextStat &node);

	/** Visit a VarAssignStat
	 *  @param node VarAssignStat node that get's visited.
	 */
	virtual void visit(VarAssignStat &node);

	/** Visit a WaitStat
	 *  @param node WaitStat node that get's visited.
	 */
	virtual void visit(WaitStat &node);

	/** Visit a ExitStat
	 *  @param node ExitStat node that get's visited.
	 */
	virtual void visit(ExitStat &node);

	/** Visit a SigAssignStat
	 *  @param node SigAssignStat node that get's visited.
	 */
	virtual void visit(SigAssignStat &node);

	/** Visit a WaveFormElem
	 *  @param node WaveFormElem node that get's visited.
	 */
	virtual void visit(WaveFormElem &node);

	/** Visit a ReturnStat
	 *  @param node ReturnStat node that get's visited.
	 */
	virtual void visit(ReturnStat &node);

	/** Visit a ProcCallStat
	 *  @param node ReturnStat node that get's visited.
	 */
	virtual void visit(ProcCallStat &node);

	/** Visit a AssertStat
	 *  @param node AssertStat node that get's visited.
	 */
	virtual void visit(AssertStat &node);

	/** Visit a VarDeclaration
	 *  @param node VarDeclaration node that get's visited.
	 */
	virtual void visit(VarDeclaration &node);

	/** Visit a DiscreteRange
	 *  @param node DiscreteRange node that get's visited.
	 */
	virtual void visit(DiscreteRange &node);

	/** Visit a CaseStat
	 *  @param node CaseStat node that get's visited.
	 */
	virtual void visit(CaseStat &node);

	/** Visit a CaseAlternative
	 *  @param node CaseAlternative node that get's visited.
	 */
	virtual void visit(CaseAlternative &node);

	/** Visit an Others node.
	 *  @param node Others node that get's visited.
	 */
	virtual void visit(Others &node);

	/** Visit a Architecture node.
	 *  @param node Architecture node that get's visited.
	 */
	virtual void visit(Architecture &node);

	/** Visit a AssociationElement node.
	 *  @param node AssociationElement node that get's visited.
	 */
	virtual void visit(AssociationElement &node);

	/** Visit a FunctionDeclaration node.
	 *  @param node FunctionDeclaration node that get's visited.
	 */
	virtual void visit(FunctionDeclaration &node);

	/** Visit a ProcedureDeclaration node.
	 *  @param node ProcedureDeclaration node that get's visited.
	 */
	virtual void visit(ProcedureDeclaration &node);

	/** Visit a CompInstStat node.
	 *  @param node CompInstStat node that get's visited.
	 */
	virtual void visit(CompInstStat &node);

	/** Visit a Package node.
	 *  @param node Package node that get's visited.
	 */
	virtual void visit(Package &node);

	/** Visit a PackageBody node.
	 *  @param node PackageBody node that get's visited.
	 */
	virtual void visit(PackageBody &node);

	/** Visit a Process node.
	 *  @param node Process node that get's visited.
	 */
	virtual void visit(Process &node);

	/** Visit a SubprogBody node.
	 *  @param node SubprogBody node that get's visited.
	 */
	virtual void visit(SubprogBody &node);

	/** Visit a CondalSigAssign node.
	 *  @param node CondalSigAssign node that get's visited.
	 */
	virtual void visit(CondalSigAssign &node);

	/** Visit an EnumerationType node.
	 *  @param node EnumerationType node that get's visited.
	 */
	virtual void visit(EnumerationType &node);

	/** Visit an PhysicalType node.
	 *  @param node PhysicalType node that get's visited.
	 */
	virtual void visit(PhysicalType &node);

	/** Visit an PhysicalTypeUnit node.
	 *  @param node PhysicalTypeUnit node that get's visited.
	 */
	virtual void visit(PhysicalTypeUnit &node);

	/** Visit an RangeConstraintType node.
	 *  @param node RangeConstraintType node that get's visited.
	 */
	virtual void visit(RangeConstraintType &node);

	/** Visit an UnconstrainedArrayType node.
	 *  @param node UnconstrainedArrayType node that get's visited.
	 */
	virtual void visit(UnconstrainedArrayType &node);

	/** Visit an RecordType node.
	 *  @param node RecordType node that get's visited.
	 */
	virtual void visit(RecordType &node);

	/** Visit an RecordTypeElement node.
	 *  @param node RecordTypeElement node that get's visited.
	 */
	virtual void visit(RecordTypeElement &node);

	/** Visit an Aggregate node.
	 *  @param node Aggregate node that get's visited.
	 */
	virtual void visit(Aggregate &node);

	/** Visit a SubtypeIndication node.
	 *  @param node SubtypeIndication node that get's visited.
	 */
	virtual void visit(SubtypeIndication &node);

	/** Visit a Library node.
	 *  @param node Library node that get's visited.
	 */
	virtual void visit(Library &node);

	/** Visit a LibraryList node.
	 *  @param node LibraryList node that get's visited.
	 */
	virtual void visit(LibraryList &node);

	/** Visit a Slice node.
	 *  @param node Slice node that get's visited.
	 */
	virtual void visit(Slice &node);

	/** Visit a ConstInteger node.
	 *  @param node ConstInteger node that get's visited.
	 */
	virtual void visit(ConstInteger &node);

	/** Visit a ConstArray node.
	 *  @param node ConstArray node that get's visited.
	 */
	virtual void visit(ConstArray &node);

	/** Visit a Subscript node.
	 *  @param node Subscript node that get's visited.
	 */
	virtual void visit(Subscript &node);

	/** Visit a TypeConversion node.
	 *  @param node TypeConversion node that get's visited.
	 */
	virtual void visit(TypeConversion &node);

	/** Visit an AttributeDeclaration node.
	 *  @param node AttributeDeclaration node that gets visited.
	 */
	virtual void visit(AttributeDeclaration &node);

	/** Visit an AttributeSpecification node.
	 *  @param node AttributeSpecification node that gets visited.
	 */
	virtual void visit(AttributeSpecification &node);

protected:
using Visitor::process;
	//! Process a generic ValDeclaration.
        /** This function will get called for each ValDeclaration (or class 
         *  derived from ValDeclaration) that get's visited.
         *
         *  @param node ValDeclaration instance.
         */
	virtual void process(ValDeclaration &node);

	//! Process a generic SymbolDeclaration.
        /** This function will get called for each SymbolDeclaration (or class
         *  derived from SymbolDeclaration) that get's visited.
         *
         *  @param node SymbolDeclaration instance.
         */
	virtual void process(SymbolDeclaration &node);

	//! Process a generic Expression.
        /** This function will get called for each Expression (or class
         *  derived from Expression) that get's visited.
         *
         *  @param node Expression instance.
         */
	virtual void process(Expression &node);

	//! Process a generic SeqStat.
        /** This function will get called for each SeqStat (or class
         *  derived from SeqStat) that get's visited.
         *
         *  @param node SeqStat instance.
         */
	virtual void process(SeqStat& node);

	//! Process a generic LoopStat.
        /** This function will get called for each LoopStat (or class
         *  derived from LoopStat) that get's visited.
         *
         *  @param node LoopStat instance.
         */
	virtual void process(LoopStat& node);

	//! Process a generic ConditionedStat.
        /** This function will get called for each ConditionedStat (or class
         *  derived from ConditionedStat) that get's visited.
         *
         *  @param node ConditionedStat instance.
         */
	virtual void process(ConditionedStat& node);

	//! Process a generic Callable.
        /** This function will get called for each Callable (or class
         *  derived from Callable) that get's visited.
         *
         *  @param node Callable instance.
         */
	virtual void process(Callable& node);

	//! Process a generic LibUnit.
        /** This function will get called for each LibUnit (or class
         *  derived from LibUnit) that get's visited.
         *
         *  @param node LibUnit instance.
         */
	virtual void process(LibUnit& node);

	//! Process a generic TypeDeclaration.
        /** This function will get called for each TypeDeclaration (or class
         *  derived from TypeDeclaration) that get's visited.
         *
         *  @param node TypeDeclaration instance.
         */
	virtual void process(TypeDeclaration &node);

	//! Process a generic PrefixedName.
        /** This function will get called for each PrefixedName (or class
         *  derived from PrefixedName) that get's visited.
         *
         *  @param node PrefixedName instance.
         */
	virtual void process(PrefixedName &node);

	//! Process a generic Name.
        /** This function will get called for each Name (or class
         *  derived from Name) that get's visited.
         *
         *  @param node Name instance.
         */
	virtual void process(Name &node);

	//! Process a AttributableDeclaration.
        /** This function will get called for each AttributableDeclaration 
	 *  (or class derived from it) that gets visited.
         *
         *  @param node AttributableDeclaration instance.
         */
	virtual void process(AttributableDeclaration &node);
};

}; /* namespace ast */

#endif /* __NULL_VISITOR_HPP_INCLUDED */
