/* $Id: Others.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __OTHERS_HPP_INCLUDED
#define __OTHERS_HPP_INCLUDED

#include "frontend/ast/Expression.hpp"

namespace ast {

//! VHDL others expression.
/** a VHDL others expression.
 */
class Others : public Expression {
public:
	//! c'tor
	/** @param loc location of the Others expression. */
	Others(Location loc) : Expression(loc) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		stream << "OTHERS";
	}

};

}; /* namespace ast */

#endif /* __OTHERS_HPP_INCLUDED */
