/* $Id: Expression.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __EXPRESSION_HPP_INCLUDED
#define __EXPRESSION_HPP_INCLUDED

#include "frontend/ast/AstNode.hpp"
#include "frontend/ast/Types.hpp"

namespace ast {

//! Generic class for an expression.
/** This class is a generic class for any VHDL expressions.
 */
class Expression : public AstNode {
public:
	//! c'tor
	/** @param loc location of the Expression.
	 */
	Expression(Location loc) : 	AstNode(loc), 
					baseType(BASE_TYPE_UNSET), 
					type(NULL) {}

	//! alternate c'tor
	/** @param loc Location of the expression.
	 *  @param baseT baseType of the expression.
	 */
	Expression(
		enum BaseType baseT,
		Location loc
		) :	AstNode(loc), baseType(baseT), type(NULL) {}

	/** base type of the expresion. */
	enum BaseType baseType;

	/** type of the expression, will get set by ResolveTypes. */
	TypeDeclaration *type;
protected:
	/** Destructor */
	virtual ~Expression();
};

}; /* namespace ast */

#endif /* __EXPRESSION_HPP_INCLUDED */
