//
// File: PanelCadres.cc
// Created by: Éric Laly <elaly@free.fr>
// Created on: Thu Oct 19 10:09:09 2006
//

#include "PanelCadres.h"
#include <exception>
using std::exception;

PanelCadres::PanelCadres(int nombrecadres,wxWindow* parent,int id):wxPanel(parent,id)
{
    mon_parent=parent;
    
    //on crée le sizer qui contient les contrôles gérant le nombre de cadres
    NombreCadres=nombrecadres;
    label_nombre_cadres = new wxStaticText(this, -1, wxT("Nombre de cadres: "));
    wxString temp(wxT(""));temp<<NombreCadres;
    text_ctrl_nombre_cadres= new wxTextCtrl(this, -1, temp, wxDefaultPosition, wxDefaultSize, wxTE_READONLY);
    spin_button_nombre_cadres= new wxSpinButton(this, -1, wxDefaultPosition, wxDefaultSize,
        wxSP_VERTICAL| wxSP_ARROW_KEYS|wxSP_WRAP);
    wxBoxSizer* sizer_nombre_cadres = new wxBoxSizer(wxHORIZONTAL);
    sizer_nombre_cadres->Add(label_nombre_cadres, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    sizer_nombre_cadres->Add(text_ctrl_nombre_cadres, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    sizer_nombre_cadres->Add(spin_button_nombre_cadres, 0, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL|wxADJUST_MINSIZE, 2);
    
    // on crée une ligne de séparation (permet aussi de donner une largeur minimum...)
    static_line_sep = new wxStaticLine(this, -1);
    static_line_sep->SetMinSize(wxSize(700, 2));
 
    // on crée un panel scrollable qui va contenir les panels de paramétrage des cadres
    sw_cadres=new wxScrolledWindow(this,-1);
    sw_cadres->SetScrollRate(10,10);
    sizer_cadres = new wxBoxSizer(wxVERTICAL);
    sw_cadres->SetSizer(sizer_cadres);
    //on crée le nombre de PanelSaisieParametresCadre demandés et on les ajoute au sizer
    panels_cadre.resize(nombrecadres);
    for (int i=0; i<nombrecadres;i++)
    {    
        wxString temp(wxT("Cadre "));temp<<i+1;
        panels_cadre[i]=new PanelSaisieParametresCadre(sw_cadres,-1,temp,wxColour(0, 0, 0));
        sizer_cadres->Add(panels_cadre[i], 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 2);
    }
    sizer_cadres->Fit(sw_cadres); //on met le sizer à la taille du panel scrollable pour qu'il contienne le nombre de cadre par défaut
    // on ajoute les élements que l'on vient de créer au sizer principal
    sizer_parametres_cadres = new wxBoxSizer(wxVERTICAL);
    sizer_parametres_cadres->Add(sizer_nombre_cadres, 0, wxALL|wxALIGN_RIGHT|wxALIGN_CENTER_HORIZONTAL, 2);
    sizer_parametres_cadres->Add(static_line_sep, 0, wxEXPAND, 0);
    sizer_parametres_cadres->Add(sw_cadres, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 2);
    
    SetSizer(sizer_parametres_cadres);// on affecte le sizer principal au panel principal

    AfficheNombreCadres();
    
    sizer_parametres_cadres->Fit(this);// on met le sizer à la taille du panel

    // on connecte les évènements
    Connect(spin_button_nombre_cadres->GetId( ), wxEVT_SCROLL_LINEUP,(wxObjectEventFunction) &PanelCadres::OnSpinButtonUpNombreCadres);
    Connect(spin_button_nombre_cadres->GetId( ), wxEVT_SCROLL_LINEDOWN,(wxObjectEventFunction) &PanelCadres::OnSpinButtonDownNombreCadres);
}

PanelCadres::~PanelCadres()
{
}

void PanelCadres::AfficheNombreCadres()
{
	wxString stemp(wxT(""));stemp<<NombreCadres;
    
	// on recherche la taille du text_ctrl pour contenir la valeur
	int x,y;
	wxTextCtrl* temp = new wxTextCtrl(this, -1, wxT(""));
	temp->GetTextExtent(stemp+wxT("  "), &x, &y);
	delete temp;

	// on affiche la valeur correspondant à la position du slider
	text_ctrl_nombre_cadres->SetMinSize(wxSize(x+2, y+5));
	text_ctrl_nombre_cadres->SetValue(stemp);
    sizer_parametres_cadres->Layout();// on retrace le panel pour mettre à jour la taille du textctrl
}

void  PanelCadres::OnSpinButtonUpNombreCadres(wxCommandEvent& event)
{
    try
    {
        NombreCadres++;
        AfficheNombreCadres();
        panels_cadre.resize(NombreCadres);
        wxString temp(wxT("Cadre "));temp<<NombreCadres;
        panels_cadre[NombreCadres-1]=new PanelSaisieParametresCadre(sw_cadres,-1,temp,wxColour(0, 0, 0));
        sizer_cadres->Add(panels_cadre[NombreCadres-1], 0, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 2);
        sizer_cadres->Layout();
    }
    catch (exception& e)
    {
        wxLogError(wxT("On ne peut plus créer un nouveau cadre: %s"),e.what());
    }  
}    

void  PanelCadres::OnSpinButtonDownNombreCadres(wxCommandEvent& event)
{
    if (NombreCadres>=1) 
    {
        delete panels_cadre[NombreCadres-1];
        panels_cadre.resize(NombreCadres-1);
        NombreCadres--;
        AfficheNombreCadres();
        sizer_cadres->Layout();
    }   
}    


vector <double> PanelCadres::GetPourcentages()
{
    PourcentagesCadres.clear();
    for (unsigned int i=0;i<panels_cadre.size();i++) 
    {   
        PourcentagesCadres.push_back(panels_cadre[i]->GetPourcentage());
    }   
    return PourcentagesCadres;
} 

vector <wxColor> PanelCadres::GetCouleurs()
{
    CouleursCadres.clear();
    for (unsigned int i=0;i<panels_cadre.size();i++) CouleursCadres.push_back(panels_cadre[i]->GetCouleur());
    return CouleursCadres;
}

vector <bool> PanelCadres::GetCouleursAuto()
{
    CouleursCadresAuto.clear();
    for (unsigned int i=0;i<panels_cadre.size();i++) CouleursCadresAuto.push_back(panels_cadre[i]->GetCouleurAuto());
    return CouleursCadresAuto;
}
