/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

public class Sequence {
    private String name;
    protected String seq;
    protected int length;
    private float wt;
    private String id;
    private boolean protein;

    public Sequence(String name, String seq, int length, float wt) {
        this.name = name;
        this.seq = seq;
        this.length = length;
        this.wt = wt;
        int index = name.indexOf(" ");
        this.id = index > 0 ? name.substring(0, index) : name;
    }

    public Sequence(String name, String seq, int length) {
        this(name, seq, length, 1.0f);
    }

    public Sequence(String name, String seq) {
        this(name, seq, seq.length());
    }

    public Sequence(String seq) {
        this(new String(""), seq);
    }

    public Sequence(String seq, float wt) {
        this(new String(""), seq, seq.length(), wt);
    }

    public String getName() {
        return this.name;
    }

    public String getID() {
        return this.id;
    }

    public String getSequence() {
        return this.seq;
    }

    public String getResidueAt(int p) {
        return this.seq.substring(p, p + 1);
    }

    public int getLength() {
        return this.length;
    }

    public float getWeight() {
        return this.wt;
    }

    public String getResidue(int pos) {
        return this.seq.substring(pos, pos + 1);
    }

    public void insertResidue(String s, int pos) {
        this.seq = this.seq.substring(0, pos) + s + this.seq.substring(pos);
        ++this.length;
    }

    public void deleteResidue(int pos) {
        this.seq = this.seq.substring(0, pos) + this.seq.substring(pos + 1);
        --this.length;
    }

    public void trim(int start, int end) {
        this.seq = this.seq.substring(start - 1, end);
        this.length = end - start + 1;
    }

    public void appendToSequence(String s) {
        this.seq = this.seq + s;
        this.length += s.length();
    }

    public void reverseSequence() {
        char[] tmpChar = new char[this.length];
        for (int i = 0; i < this.length; ++i) {
            tmpChar[i] = this.seq.charAt(this.length - i - 1);
        }
        this.seq = new String(tmpChar);
    }

    public void reverseComplementSequence() {
        char[] tmpChar = new char[this.length];
        for (int i = 0; i < this.length; ++i) {
            tmpChar[i] = this.complement(this.seq.charAt(this.length - i - 1));
        }
        this.seq = new String(tmpChar);
    }

    public void setType(boolean protein) {
        this.protein = protein;
    }

    public void setWeight(float wt) {
        this.wt = wt;
    }

    public boolean isProtein() {
        return this.protein;
    }

    public void complementSequence() {
        char[] tmpChar = new char[this.length];
        for (int i = 0; i < this.length; ++i) {
            tmpChar[i] = this.complement(this.seq.charAt(i));
        }
        this.seq = new String(tmpChar);
    }

    private char complement(char c) {
        if (c == 't') {
            return 'a';
        }
        if (c == 'T') {
            return 'A';
        }
        if (c == 'a') {
            return 't';
        }
        if (c == 'A') {
            return 'T';
        }
        if (c == 'g') {
            return 'c';
        }
        if (c == 'G') {
            return 'C';
        }
        if (c == 'c') {
            return 'g';
        }
        if (c == 'C') {
            return 'G';
        }
        return c;
    }

    public static void main(String[] args) {
        new Sequence("Seq", "ACTATACAG", 9);
    }
}

