/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.emboss.jemboss.draw.DNADraw;
import org.emboss.jemboss.gui.form.TextFieldInt;

public class Block
extends JPanel
implements Transferable {
    private DNADraw current_dna;
    private Vector marker;
    private double angStart;
    private double angEnd;
    private double fracRadii = 1.0;
    private Rectangle rect = new Rectangle();
    public static final DataFlavor BLOCK = new DataFlavor(Block.class, "Block");
    static DataFlavor[] blockFlavors = new DataFlavor[]{BLOCK};

    public Block(Vector marker) {
        this.setOpaque(false);
        this.marker = marker;
    }

    public Block(Vector marker, DNADraw current_dna) {
        this(marker);
        this.current_dna = current_dna;
        this.setPreferredSize(current_dna.getPreferredSize());
    }

    public Vector getMarker() {
        return this.marker;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.draw(g2);
    }

    protected void draw(Graphics2D g2) {
        if (this.current_dna.isCircular()) {
            this.drawCircular(g2);
        } else {
            this.drawLinear(g2);
        }
    }

    protected String getLabel() {
        return (String)this.marker.elementAt(0);
    }

    protected int getStart() {
        return (Integer)this.marker.elementAt(1);
    }

    protected int getEnd() {
        return (Integer)this.marker.elementAt(2);
    }

    protected void showProperties(final JFrame f, final DNADraw draw, JButton delete) {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        menuBar.add(fileMenu);
        JMenuItem closeMenu = new JMenuItem("Close");
        closeMenu.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        closeMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                f.dispose();
            }
        });
        fileMenu.add(closeMenu);
        f.setJMenuBar(menuBar);
        JPanel pane = (JPanel)f.getContentPane();
        String markerLabel = (String)this.marker.elementAt(0);
        int bstart = (Integer)this.marker.elementAt(1);
        int bend = (Integer)this.marker.elementAt(2);
        Color colour = (Color)this.marker.elementAt(3);
        float strokeSize = ((Float)this.marker.elementAt(4)).floatValue();
        boolean arrowHead = (Boolean)this.marker.elementAt(5);
        boolean arrowTail = (Boolean)this.marker.elementAt(6);
        Box bdown = Box.createVerticalBox();
        pane.add(bdown);
        bdown.add(Box.createVerticalStrut(4));
        Dimension d = new Dimension(200, 30);
        Box bacross = Box.createHorizontalBox();
        final JTextField annotation = new JTextField();
        annotation.setPreferredSize(d);
        annotation.setMaximumSize(d);
        annotation.setText(markerLabel);
        annotation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Block.this.marker.setElementAt(annotation.getText(), 0);
                if (draw != null) {
                    draw.repaint();
                }
            }
        });
        bacross.add(annotation);
        bacross.add(new JLabel(" Label"));
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        d = new Dimension(65, 30);
        bacross = Box.createHorizontalBox();
        final TextFieldInt start = new TextFieldInt();
        start.setPreferredSize(d);
        start.setMaximumSize(d);
        start.setValue(bstart);
        start.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Block.this.marker.setElementAt(new Integer(start.getValue()), 1);
                if (draw != null) {
                    draw.repaint();
                }
            }
        });
        bacross.add(start);
        bacross.add(new JLabel(" Start"));
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        bacross = Box.createHorizontalBox();
        final TextFieldInt end = new TextFieldInt();
        end.setPreferredSize(d);
        end.setMaximumSize(d);
        end.setValue(bend);
        end.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Block.this.marker.setElementAt(new Integer(end.getValue()), 2);
                if (draw != null) {
                    draw.repaint();
                }
            }
        });
        bacross.add(end);
        bacross.add(new JLabel(" End"));
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        final JButton button = new JButton("");
        button.setBackground(colour);
        final JColorChooser colorChooser = new JColorChooser();
        ActionListener okListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Block.this.marker.setElementAt(colorChooser.getColor(), 3);
                button.setBackground(colorChooser.getColor());
                if (draw != null) {
                    draw.repaint();
                }
            }
        };
        final JDialog dialog = JColorChooser.createDialog(button, "Pick a Color", true, colorChooser, okListener, null);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.show();
            }
        });
        bacross = Box.createHorizontalBox();
        bacross.add(button);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        bacross = Box.createHorizontalBox();
        final JSlider slider = new JSlider(1, 25, (int)strokeSize);
        bacross.add(slider);
        bacross.add(new JLabel(" Line width"));
        bacross.add(Box.createHorizontalGlue());
        slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Block.this.marker.setElementAt(new Float(slider.getValue()), 4);
                if (draw != null) {
                    draw.repaint();
                }
            }
        });
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        bacross = Box.createHorizontalBox();
        bacross.add(new JLabel("Arrow :"));
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        bacross = Box.createHorizontalBox();
        final JRadioButton head = new JRadioButton("Head");
        final JRadioButton tail = new JRadioButton("Tail");
        final JRadioButton none = new JRadioButton("None");
        head.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (head.isSelected()) {
                    Block.this.marker.setElementAt(new Boolean(true), 5);
                    Block.this.marker.setElementAt(new Boolean(false), 6);
                } else {
                    Block.this.marker.setElementAt(new Boolean(false), 5);
                    Block.this.marker.setElementAt(new Boolean(true), 6);
                }
                if (draw != null) {
                    draw.repaint();
                }
            }
        });
        bacross.add(head);
        tail.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (tail.isSelected()) {
                    Block.this.marker.setElementAt(new Boolean(true), 6);
                    Block.this.marker.setElementAt(new Boolean(false), 5);
                } else {
                    Block.this.marker.setElementAt(new Boolean(false), 6);
                    Block.this.marker.setElementAt(new Boolean(true), 5);
                }
                if (draw != null) {
                    draw.repaint();
                }
            }
        });
        bacross.add(tail);
        none.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (none.isSelected()) {
                    Block.this.marker.setElementAt(new Boolean(false), 6);
                    Block.this.marker.setElementAt(new Boolean(false), 5);
                }
                if (draw != null) {
                    draw.repaint();
                }
            }
        });
        bacross.add(none);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        bacross = Box.createHorizontalBox();
        bacross.add(delete);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        ButtonGroup group = new ButtonGroup();
        group.add(head);
        group.add(tail);
        group.add(none);
        if (arrowHead) {
            head.setSelected(true);
        } else if (arrowTail) {
            tail.setSelected(true);
        }
        f.pack();
        f.setVisible(true);
    }

    protected void drawLinear(Graphics2D g2) {
        int[] xPoints;
        String markerLabel = (String)this.marker.elementAt(0);
        int bstart = (Integer)this.marker.elementAt(1);
        int bend = (Integer)this.marker.elementAt(2);
        Color colour = (Color)this.marker.elementAt(3);
        float strokeSize = ((Float)this.marker.elementAt(4)).floatValue();
        float strokeSize2 = strokeSize / 2.0f;
        boolean arrowHead = (Boolean)this.marker.elementAt(5);
        boolean arrowTail = (Boolean)this.marker.elementAt(6);
        FontMetrics fm = g2.getFontMetrics();
        g2.setColor(colour);
        double ddiameter = this.current_dna.getDiameter();
        double heightPanel = this.current_dna.getHeight();
        Point location = this.current_dna.getLocationPoint();
        int ymid = (int)(heightPanel / 2.0);
        int shift = (int)this.fracRadii;
        if (shift > 1 && shift < (int)heightPanel) {
            ymid = shift;
        }
        int start = this.current_dna.getStart();
        int end = this.current_dna.getEnd();
        g2.setStroke(new BasicStroke(strokeSize));
        int xend = ((int)ddiameter - location.x) * (bend - start) / (end - start) + location.x - (int)strokeSize2;
        int xstart = ((int)ddiameter - location.x) * (bstart - start) / (end - start) + location.x + (int)strokeSize2;
        if (arrowHead) {
            xend = (int)((float)xend - strokeSize2);
            xPoints = new int[]{xend, xend, xend + (int)strokeSize};
            int[] yPoints = new int[]{ymid + (int)strokeSize, ymid - (int)strokeSize, ymid};
            g2.fillPolygon(xPoints, yPoints, 3);
            g2.drawLine(xstart, ymid, xend, ymid);
        } else if (arrowTail) {
            xstart = (int)((float)xstart + strokeSize2);
            xPoints = new int[]{xstart, xstart, xstart - (int)strokeSize};
            int[] yPoints = new int[]{ymid + (int)strokeSize, ymid - (int)strokeSize, ymid};
            g2.fillPolygon(xPoints, yPoints, 3);
            g2.drawLine(xstart, ymid, xend, ymid);
        } else {
            g2.drawLine(xstart, ymid, xend, ymid);
        }
        this.rect.setLocation(xstart, ymid - (int)strokeSize2);
        this.rect.setSize(xend - xstart, (int)strokeSize);
        int xmid = xstart + (int)((double)(xend - xstart) / 2.0 - (double)fm.stringWidth(markerLabel) / 2.0);
        g2.drawString(markerLabel, (float)xmid, (float)ymid - strokeSize);
    }

    protected void drawCircular(Graphics2D g2) {
        int[] xPoints;
        int ymid;
        int xmid;
        String markerLabel = (String)this.marker.elementAt(0);
        int bstart = (Integer)this.marker.elementAt(1);
        int bend = (Integer)this.marker.elementAt(2);
        Color colour = (Color)this.marker.elementAt(3);
        float strokeSize = ((Float)this.marker.elementAt(4)).floatValue();
        boolean arrowHead = (Boolean)this.marker.elementAt(5);
        boolean arrowTail = (Boolean)this.marker.elementAt(6);
        FontMetrics fm = g2.getFontMetrics();
        double hgt = fm.getAscent();
        g2.setColor(colour);
        double ddiameter = this.current_dna.getDiameter();
        double widthPanel = this.current_dna.getWidth();
        double heightPanel = this.current_dna.getHeight();
        double dradii = ddiameter / 2.0;
        double rad = 360.0;
        Point location = this.current_dna.getLocationPoint();
        AffineTransform origin = g2.getTransform();
        AffineTransform newOrig = (AffineTransform)origin.clone();
        double stroke = Math.toDegrees(Math.asin((double)strokeSize / dradii));
        double stroke2 = stroke / 2.0;
        this.angStart = this.current_dna.getAngleFromPosition(bstart, rad) - stroke2;
        this.angEnd = this.current_dna.getAngleFromPosition(bend, rad) + stroke2 - this.angStart;
        int shift = (int)(dradii * (1.0 - this.fracRadii));
        double bdiameter = ddiameter * this.fracRadii;
        if (arrowHead) {
            this.angEnd += stroke2;
            newOrig.rotate(Math.toRadians(-this.angStart - this.angEnd), widthPanel / 2.0, heightPanel / 2.0);
            this.angEnd += stroke2 / 3.0;
            xmid = location.x + (int)(ddiameter - (double)shift);
            ymid = location.y + (int)dradii;
            xPoints = new int[]{xmid - (int)strokeSize, xmid + (int)strokeSize, xmid};
            int[] yPoints = new int[]{ymid, ymid, ymid + (int)strokeSize};
            g2.setTransform(newOrig);
            g2.fillPolygon(xPoints, yPoints, 3);
        } else if (arrowTail) {
            this.angStart += stroke2;
            newOrig.rotate(Math.toRadians(-this.angStart), widthPanel / 2.0, heightPanel / 2.0);
            this.angStart -= stroke;
            this.angEnd += stroke2;
            xmid = location.x + (int)(ddiameter - (double)shift);
            ymid = location.y + (int)dradii;
            xPoints = new int[]{xmid - (int)strokeSize, xmid + (int)strokeSize, xmid};
            int[] yPoints = new int[]{ymid + (int)strokeSize, ymid + (int)strokeSize, ymid};
            g2.setTransform(newOrig);
            g2.fillPolygon(xPoints, yPoints, 3);
        }
        g2.setStroke(new BasicStroke(strokeSize));
        g2.setTransform(origin);
        g2.drawArc(location.x + shift, location.y + shift, (int)bdiameter, (int)bdiameter, Math.round(Math.round(this.angStart)), Math.round(Math.round(this.angEnd)));
        newOrig = (AffineTransform)origin.clone();
        newOrig.rotate(Math.toRadians(-this.angStart - this.angEnd / 2.0), widthPanel / 2.0, heightPanel / 2.0);
        int xblock = 0;
        int yblock = 0;
        int widMarker = fm.stringWidth(markerLabel) / 2;
        xblock = (int)(dradii - (double)shift / 2.0 + newOrig.getScaleX() * (dradii - 3.0 - (double)widMarker - (double)((float)shift + strokeSize) / 2.0) - (double)widMarker);
        xblock = (int)(dradii + newOrig.getScaleX() * (dradii - (double)shift - 3.0 - (double)widMarker - (double)strokeSize / 2.0) - (double)widMarker);
        yblock = (int)(dradii + newOrig.getShearY() * (dradii - (double)shift - 3.0 - ((double)strokeSize + hgt) / 2.0) + hgt / 2.0);
        g2.drawString(markerLabel, location.x + xblock, location.y + yblock);
    }

    public void setBlockLocation(int x, int y) {
        if (this.current_dna.isCircular()) {
            double dradii = this.current_dna.getDiameter() / 2.0;
            Point location = this.current_dna.getLocationPoint();
            double x_origin = (double)location.x + dradii;
            double y_origin = (double)location.y + dradii;
            double len = Math.sqrt(Math.pow(y_origin - (double)y, 2.0) + Math.pow(x_origin - (double)x, 2.0));
            this.fracRadii = len / dradii;
        } else {
            this.fracRadii = y;
        }
        this.repaint();
    }

    public boolean isOverMe(int x, int y) {
        if (this.current_dna.isCircular()) {
            double len;
            double rat;
            double dradii = this.current_dna.getDiameter() / 2.0;
            Point location = this.current_dna.getLocationPoint();
            double x_origin = (double)location.x + dradii;
            double y_origin = (double)location.y + dradii;
            double ttheta = (y_origin - (double)y) / (x_origin - (double)x);
            double ang = 180.0 - Math.toDegrees(Math.atan(ttheta));
            if ((double)x > x_origin) {
                ang += 180.0;
            }
            if (ang > 360.0) {
                ang -= 360.0;
            }
            return ang < 360.0 + this.angStart && ang > 360.0 + this.angStart + this.angEnd && (rat = (len = Math.sqrt(Math.pow(y_origin - (double)y, 2.0) + Math.pow(x_origin - (double)x, 2.0))) / dradii / this.fracRadii) < 1.1 && rat > 0.9;
        }
        return this.rect.contains(x, y);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return blockFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor f) {
        return f.equals(BLOCK);
    }

    public Object getTransferData(DataFlavor d) throws UnsupportedFlavorException, IOException {
        if (d.equals(BLOCK)) {
            return this;
        }
        throw new UnsupportedFlavorException(d);
    }
}

