/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JembossJarUtil {
    private Hashtable jarStore = new Hashtable();

    public JembossJarUtil(String jarFile) throws Exception {
        int rb;
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream is = cl.getResourceAsStream(jarFile);
        if (is == null) {
            throw new Exception("Jemboss not able to use resource " + jarFile);
        }
        ZipInputStream zis = new ZipInputStream(is);
        ZipEntry ze = null;
        Hashtable<String, Integer> htSizes = new Hashtable<String, Integer>();
        while ((ze = zis.getNextEntry()) != null) {
            int ret = 0;
            int cnt = 0;
            rb = 0;
            while (ret != -1) {
                byte[] b1 = new byte[1];
                ret = zis.read(b1, rb, 1);
                ++cnt;
            }
            htSizes.put(ze.getName(), new Integer(cnt));
        }
        zis.close();
        zis = new ZipInputStream(cl.getResourceAsStream(jarFile));
        ze = null;
        while ((ze = zis.getNextEntry()) != null) {
            if (ze.isDirectory()) continue;
            int size = (int)ze.getSize();
            if (size == -1) {
                size = (Integer)htSizes.get(ze.getName());
            }
            byte[] b = new byte[size];
            rb = 0;
            int chunk = 0;
            while (size - rb > 0 && (chunk = zis.read(b, rb, size - rb)) != -1) {
                rb += chunk;
            }
            this.jarStore.put(ze.getName(), b);
        }
        zis.close();
    }

    public Hashtable getHash() {
        return this.jarStore;
    }

    public Object getElement(String el) {
        return this.jarStore.get(el);
    }

    public boolean writeByteFile(String el, String f) {
        try {
            FileOutputStream out = new FileOutputStream(f);
            out.write((byte[])this.jarStore.get(el));
            out.close();
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }
}

