/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import com.stevesoft.pat.Regex;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SearchResults;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceGroup;
import jalview.util.Comparison;
import java.util.Vector;

public class Finder {
    SearchResults searchResults;
    AlignmentI alignment;
    SequenceGroup selection = null;
    Vector idMatch = null;
    boolean caseSensitive = false;
    boolean findAll = false;
    Regex regex = null;
    int seqIndex = 0;
    int resIndex = 0;

    public Finder(AlignmentI alignment, SequenceGroup selection) {
        this.alignment = alignment;
        this.selection = selection;
    }

    public Finder(AlignmentI alignment, SequenceGroup selectionGroup, int seqIndex, int resIndex) {
        this(alignment, selectionGroup);
        this.seqIndex = seqIndex;
        this.resIndex = resIndex;
    }

    public boolean find(String searchString) {
        Sequence seq;
        boolean hasResults = false;
        if (!this.caseSensitive) {
            searchString = searchString.toUpperCase();
        }
        this.regex = new Regex(searchString);
        this.searchResults = new SearchResults();
        this.idMatch = new Vector();
        String item = null;
        boolean found = false;
        try {
            int res = Integer.parseInt(searchString);
            found = true;
            seq = this.selection == null || this.selection.getSize() < 1 ? (Sequence)this.alignment.getSequenceAt(0) : (Sequence)this.selection.getSequenceAt(0);
            this.searchResults.addResult(seq, res, res);
            hasResults = true;
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        int end = this.alignment.getHeight();
        if (this.selection != null && (this.selection.getSize() < 1 || this.selection.getEndRes() - this.selection.getStartRes() < 2)) {
            this.selection = null;
        }
        while (!found && this.seqIndex < end) {
            seq = (Sequence)this.alignment.getSequenceAt(this.seqIndex);
            if (this.selection != null && !this.selection.getSequences(null).contains(seq)) {
                ++this.seqIndex;
                this.resIndex = 0;
                continue;
            }
            item = seq.getSequenceAsString();
            if (!this.caseSensitive) {
                item = item.toUpperCase();
            }
            if (this.selection != null && this.selection.getEndRes() < this.alignment.getWidth() - 1) {
                item = item.substring(0, this.selection.getEndRes() + 1);
            }
            StringBuffer noGapsSB = new StringBuffer();
            int insertCount = 0;
            Vector<Integer> spaces = new Vector<Integer>();
            for (int j = 0; j < item.length(); ++j) {
                if (!Comparison.isGap(item.charAt(j))) {
                    noGapsSB.append(item.charAt(j));
                    spaces.addElement(new Integer(insertCount));
                    continue;
                }
                ++insertCount;
            }
            String noGaps = noGapsSB.toString();
            for (int r = this.resIndex; r < noGaps.length() && this.regex.searchFrom(noGaps, r); ++r) {
                this.resIndex = this.regex.matchedFrom();
                if (this.selection != null && this.resIndex + Integer.parseInt(spaces.elementAt(this.resIndex).toString()) < this.selection.getStartRes()) continue;
                int sres = seq.findPosition(this.resIndex + Integer.parseInt(spaces.elementAt(this.resIndex).toString()));
                int eres = seq.findPosition(this.regex.matchedTo() - 1 + Integer.parseInt(spaces.elementAt(this.regex.matchedTo() - 1).toString()));
                this.searchResults.addResult(seq, sres, eres);
                hasResults = true;
                if (!this.findAll) {
                    found = true;
                    ++this.resIndex;
                    break;
                }
                r = this.resIndex;
            }
            if (found) continue;
            ++this.seqIndex;
            this.resIndex = 0;
        }
        for (int id = 0; id < this.alignment.getHeight(); ++id) {
            if (!this.regex.search(this.alignment.getSequenceAt(id).getName())) continue;
            this.idMatch.addElement(this.alignment.getSequenceAt(id));
            hasResults = true;
        }
        return hasResults;
    }

    public AlignmentI getAlignment() {
        return this.alignment;
    }

    public void setAlignment(AlignmentI alignment) {
        this.alignment = alignment;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isFindAll() {
        return this.findAll;
    }

    public void setFindAll(boolean findAll) {
        this.findAll = findAll;
    }

    public SequenceGroup getSelection() {
        return this.selection;
    }

    public void setSelection(SequenceGroup selection) {
        this.selection = selection;
    }

    public Vector getIdMatch() {
        return this.idMatch;
    }

    public Regex getRegex() {
        return this.regex;
    }

    public SearchResults getSearchResults() {
        return this.searchResults;
    }

    public int getResIndex() {
        return this.resIndex;
    }

    public void setResIndex(int resIndex) {
        this.resIndex = resIndex;
    }

    public int getSeqIndex() {
        return this.seqIndex;
    }

    public void setSeqIndex(int seqIndex) {
        this.seqIndex = seqIndex;
    }
}

