/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import com.stevesoft.pat.Regex;
import java.util.Vector;

public class UrlLink {
    private String url_suffix;
    private String url_prefix;
    private String target;
    private String label;
    private String regexReplace;
    private boolean dynamic = false;
    private String invalidMessage = null;

    public UrlLink(String link) {
        int sep = link.indexOf("|");
        int psqid = link.indexOf("$SEQUENCE_ID");
        if (psqid > -1) {
            this.dynamic = true;
            int p = sep;
            while ((p = link.indexOf("|", (sep = p) + 1)) > sep && p < psqid) {
            }
            this.label = link.substring(0, sep);
            this.target = this.label.indexOf("|") > -1 ? this.label.substring(0, this.label.indexOf("|")) : (this.label.indexOf(" ") > 2 ? this.label.substring(0, this.label.indexOf(" ")) : this.label);
            this.url_prefix = link.substring(sep + 1, psqid);
            if (link.indexOf("$SEQUENCE_ID=/") == psqid && (p = link.indexOf("/=$", psqid + 14)) > psqid + 14) {
                this.url_suffix = link.substring(p + 3);
                this.regexReplace = link.substring(psqid + 14, p);
                try {
                    Regex rg = Regex.perlCode("/" + this.regexReplace + "/");
                    if (rg == null) {
                        this.invalidMessage = "Invalid Regular Expression : '" + this.regexReplace + "'\n";
                    }
                }
                catch (Exception e) {
                    this.invalidMessage = "Invalid Regular Expression : '" + this.regexReplace + "'\n";
                }
            } else {
                this.regexReplace = null;
                if (link.indexOf("$SEQUENCE_ID$") == psqid) {
                    this.url_suffix = link.substring(psqid + 13);
                    this.regexReplace = null;
                } else {
                    this.invalidMessage = "Warning: invalid regex structure for URL link : " + link;
                }
            }
        } else {
            this.target = link.substring(0, sep);
            sep = link.lastIndexOf("|");
            this.label = link.substring(0, sep);
            this.url_prefix = link.substring(sep + 1);
            this.regexReplace = null;
            this.url_suffix = null;
        }
    }

    public String getUrl_suffix() {
        return this.url_suffix;
    }

    public String getUrl_prefix() {
        return this.url_prefix;
    }

    public String getTarget() {
        return this.target;
    }

    public String getLabel() {
        return this.label;
    }

    public String getRegexReplace() {
        return this.regexReplace;
    }

    public String getInvalidMessage() {
        return this.invalidMessage;
    }

    public boolean isValid() {
        return this.invalidMessage == null;
    }

    public String[] makeUrls(String idstring, boolean onlyIfMatches) {
        if (this.dynamic) {
            if (this.regexReplace != null) {
                Regex rg = Regex.perlCode("/" + this.regexReplace + "/");
                if (rg.search(idstring)) {
                    int ns = rg.numSubs();
                    if (ns == 0) {
                        return new String[]{rg.stringMatched(), this.url_prefix + rg.stringMatched() + this.url_suffix};
                    }
                    for (int s = 0; s <= rg.numSubs(); ++s) {
                        System.err.println("Sub " + s + " : " + rg.matchedFrom(s) + " : " + rg.matchedTo(s) + " : '" + rg.stringMatched(s) + "'");
                    }
                    Vector<String> subs = new Vector<String>();
                    int s = 0;
                    while (s <= ns) {
                        if (s + 1 <= ns && rg.matchedTo(s) > -1 && rg.matchedTo(s + 1) > -1 && rg.matchedTo(s + 1) < rg.matchedTo(s)) {
                            int r;
                            String mtch = "";
                            for (r = s + 1; r <= ns && rg.matchedTo(r) <= rg.matchedTo(s); ++r) {
                                if (rg.matchedFrom(r) <= -1) continue;
                                mtch = mtch + rg.stringMatched(r);
                            }
                            if (mtch.length() > 0) {
                                subs.addElement(mtch);
                                subs.addElement(this.url_prefix + mtch + this.url_suffix);
                            }
                            s = r;
                            continue;
                        }
                        if (rg.matchedFrom(s) > -1) {
                            subs.addElement(rg.stringMatched(s));
                            subs.addElement(this.url_prefix + rg.stringMatched(s) + this.url_suffix);
                        }
                        ++s;
                    }
                    String[] res = new String[subs.size()];
                    int rs = subs.size();
                    for (int r = 0; r < rs; ++r) {
                        res[r] = (String)subs.elementAt(r);
                    }
                    subs.removeAllElements();
                    return res;
                }
                if (onlyIfMatches) {
                    return null;
                }
            }
            if (idstring.indexOf("|") > -1) {
                idstring = idstring.substring(idstring.lastIndexOf("|") + 1);
            }
            return new String[]{idstring, this.url_prefix + idstring + this.url_suffix};
        }
        return new String[]{"", this.url_prefix};
    }

    public String toString() {
        return this.label + "|" + this.url_prefix + (this.dynamic ? "$SEQUENCE_ID" + (this.regexReplace != null ? "=" + this.regexReplace + "=$" : "$") : "") + (this.url_suffix == null ? "" : this.url_suffix);
    }

    private static void testUrls(UrlLink ul, String idstring, String[] urls) {
        if (urls == null) {
            System.out.println("Created NO urls.");
        } else {
            System.out.println("Created " + urls.length / 2 + " Urls.");
            for (int uls = 0; uls < urls.length; uls += 2) {
                System.out.println("URL Replacement text : " + urls[uls] + " : URL : " + urls[uls + 1]);
            }
        }
    }

    public static void main(String[] argv) {
        String[] links = new String[]{"NESTED|http://nested/$SEQUENCE_ID=/^(?:Label:)?(?:(?:gi\\|(\\d+))|([^:]+))/=$/nested"};
        String[] idstrings = new String[]{"Label:gi|9234|pdb|102L|A"};
        for (int i = 0; i < links.length; ++i) {
            UrlLink ul = new UrlLink(links[i]);
            if (ul.isValid()) {
                System.out.println("\n\n\n");
                System.out.println("Link " + i + " " + links[i] + " : " + ul.toString());
                System.out.println(" pref : " + ul.getUrl_prefix() + "\n suf : " + ul.getUrl_suffix() + "\n : " + (ul.getRegexReplace() != null ? ul.getRegexReplace() : ""));
                for (int ids = 0; ids < idstrings.length; ++ids) {
                    System.out.println("ID String : " + idstrings[ids] + "\nWithout onlyIfMatches:");
                    String[] urls = ul.makeUrls(idstrings[ids], false);
                    UrlLink.testUrls(ul, idstrings[ids], urls);
                    System.out.println("With onlyIfMatches set.");
                    urls = ul.makeUrls(idstrings[ids], true);
                    UrlLink.testUrls(ul, idstrings[ids], urls);
                }
                continue;
            }
            System.err.println("Invalid URLLink : " + links[i] + " : " + ul.getInvalidMessage());
        }
    }

    public boolean isDynamic() {
        return this.dynamic;
    }
}

