/**
 * Copyright (c) 2005-2011 by Appcelerator, Inc. All Rights Reserved.
 * Licensed under the terms of the Eclipse Public License (EPL).
 * Please see the license.txt included with this distribution for details.
 * Any modifications to this file must keep this entire header intact.
 */
package org.python.pydev.navigator.decorator;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;

/**
 * This is a special <code>LabelProviderChangedEvent</code> carrying additional
 * information whether the event origins from a maker change.
 * <p>
 * <code>ProblemsLabelChangedEvent</code>s are only generated by <code>
 * ProblemsLabelDecorator</code>s.
 * </p>
 * 
 * Based on: org.eclipse.jdt.ui.ProblemsLabelDecorator.ProblemsLabelChangedEvent
 */
public class ProblemsLabelChangedEvent extends LabelProviderChangedEvent {

    private static final long serialVersionUID = 1L;

    private boolean fMarkerChange;

    /**
     * @param eventSource the base label provider
     * @param changedResource the changed resources
     * @param isMarkerChange <code>true</code> if the change is a marker change; otherwise
     *  <code>false</code>
     */
    public ProblemsLabelChangedEvent(IBaseLabelProvider eventSource, IResource[] changedResource, boolean isMarkerChange) {
        super(eventSource, changedResource);
        fMarkerChange = isMarkerChange;
    }

    /**
     * Returns whether this event origins from marker changes. If <code>false</code> an annotation
     * model change is the origin. In this case viewers not displaying working copies can ignore these
     * events.
     *
     * @return if this event origins from a marker change.
     */
    public boolean isMarkerChange() {
        return fMarkerChange;
    }

}
