/**
 * Copyright (c) 2004-2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 * Contributors: 
 *   IBM - Initial API and implementation
 */

  // line comment1 

/**
 * A javadoc
 */

  
package org.eclipse.emf.test.examples;

import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.eclipse.emf.common.*;
import org.eclipse.emf.common.notify.Notification;
// This is importing the EObjectImpl
import org.eclipse.emf.ecore.impl.EObjectImpl;

class AnotherClass<T>
{
  
}

/**
 * This is an example of a fairly complete Java file.
 * Its content is not really important
 * 
 * @author EMF team
 * @generated
 * @generated NOT
 */
public class Example1 extends EObjectImpl
{
	// A public inner class.  It is indented with TABs
	public abstract class InnerClass<K extends Number> 
    implements Notification, org.eclipse.emf.common.notify.Notifier
	{
	
	}
  
	// An initializer.  It is indented with TABs
	{
	System.out.println("A initializer with Comments");
	}
  
  /**
   * public String constant.
   */
  public static final String STR_CONST = "something is ; different \"//; /*;*/" /*inte;res;ting*/ + " !!;;" ;  // = "original text";
    
  /*
   * A private static inner interface
   */
  private static interface InnerInterface<N> extends Notification,  List<List<Number>>
  {
    
  }
  
  /**
   * protected static long field.
   * This is a multiline comment.
   */
  protected static long longStatic=1l; //A field
  
  /*
   * package protected boolean field.
   */
  Boolean booleanInstance;
  
  private Map.Entry<String, Object> myEntry;
      
  /**
   * An static initializer
   */
  static
  {
    System.out.println("A initializer with JavaDoc - line1");
    System.out.println("A initializer with JavaDoc - line2");
  }

  /**
   * This is a contructor
   */
  public Example1()
  {
    super();
  }
  
  private Example1(String aString, boolean bol)
  {
    super();
  }

  /**
   * Sets the boolean instance.
   * @param b
   * @generated
   */
  public <X extends Exception> void setBooleanInstance(Boolean b) throws X
  {
    if (b != null)
    {
      booleanInstance = b;
    }
    else
    {
      booleanInstance = Boolean.FALSE;
    }
  }

  @Deprecated
  void setBooleanInstance(int a)
  {
    setBooleanInstance(a > 0 ? Boolean.TRUE : Boolean.FALSE);
  }
  
  private int[][] myMatrix =new int[4][5];

  /**
   * Gets the boolean instance.  Now I will ask you to see 
   * something {@link EObjectImpl#eAdapters()}.  
   * @param b
   * @generated NOT
   */
  public <K> Boolean getBooleanInstance(Class<K> aClass) throws Exception
  {
    return booleanInstance == null ? Boolean.FALSE : booleanInstance;
  }
  
  /*
   * This method returns an empty list.
   */
  protected List<?> aMethodWithComments() throws RuntimeException, IllegalAccessError, java.lang.NullPointerException
  {
    return Collections.EMPTY_LIST;
  }
  // This is a simple comment

  //This is another simple comment
  private static long[][] aMethodWithNoComments(int[] a)
  {
     System.out.println("I don't do anything");
     return null;
  }
  
  /**
   * Another initializer with 2 lines
   * of javadoc.
   */
  {
    System.out.println("Another initializer with JavaDoc");
  }  

  public int a = 1, b = 2, c = 3;
  float[][] floatArray[][];
}
