/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.cmi;

import java.io.Serializable;
import org.adl.datamodels.Element;
import org.adl.datamodels.cmi.CMICategory;
import org.adl.datamodels.cmi.CMIRequest;
import org.adl.datamodels.cmi.DMErrorManager;
import org.adl.util.debug.DebugIndicator;

public class CMIScore
extends CMICategory
implements Serializable {
    public Element raw = new Element("", "checkScoreDecimal", "NULL", true, true, true);
    public Element min = new Element("", "checkScoreDecimal", "NULL", true, true, true);
    public Element max = new Element("", "checkScoreDecimal", "NULL", true, true, true);

    public CMIScore() {
        super(true);
    }

    public Element getRaw() {
        return this.raw;
    }

    public Element getMin() {
        return this.min;
    }

    public Element getMax() {
        return this.max;
    }

    public void setRaw(String inRaw) {
        this.raw.setValue(inRaw);
    }

    public void setMin(String inMin) {
        this.min.setValue(inMin);
    }

    public void setMax(String inMax) {
        this.max.setValue(inMax);
    }

    public boolean isInitialized() {
        boolean flag = false;
        if (this.raw.isInitialized() || this.min.isInitialized() || this.max.isInitialized()) {
            flag = true;
        }
        return flag;
    }

    public boolean isValidRequest(CMIRequest theRequest) {
        boolean flag = false;
        String token = theRequest.getNextToken();
        if (token.equals("_children")) {
            flag = true;
        } else if (token.equals("raw") || token.equals("min") || token.equals("max")) {
            flag = true;
            if (theRequest.hasMoreTokensToProcess()) {
                flag = theRequest.isAChildrenRequest();
            }
        }
        return flag;
    }

    public String performGet(CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        String result = new String("");
        String token = theRequest.getNextToken();
        if (theRequest.hasMoreTokensToProcess()) {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Element being processed: " + token + "is not a valid element of the CMI Score\n" + "Data Model Category");
            }
            if (theRequest.isAKeywordRequest()) {
                dmErrorMgr.recGetKeyWordError(theRequest.getElement());
            } else {
                dmErrorMgr.recNotImplementedError(theRequest);
            }
        } else if (theRequest.isAChildrenRequest()) {
            result = this.getChildren();
            dmErrorMgr.SetCurrentErrorCode("0");
        } else {
            result = this.determineElementValue(this, token, dmErrorMgr);
        }
        return result;
    }

    public String getChildren() {
        String children = "raw,min,max";
        return children;
    }

    public void performSet(CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        String token = theRequest.getNextToken();
        if (theRequest.hasMoreTokensToProcess()) {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Element being processed: " + token + "is not a valid element of the CMI Score\n" + "Data Model Category");
            }
            dmErrorMgr.recNotImplementedError(theRequest);
        } else {
            String value = theRequest.getValue();
            if (!theRequest.isAKeywordRequest()) {
                this.doSet(this, token, value, dmErrorMgr);
            } else {
                if (DebugIndicator.ON) {
                    System.out.println("Error - Cannot Set Data Model Element");
                    System.out.println("Element being processed: " + token + "cannot be set\n");
                }
                dmErrorMgr.recKeyWordError(token);
            }
        }
    }
}

