/*
 * Decompiled with CFR 0.152.
 */
package org.adl.samplerte.client;

import java.applet.Applet;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.adl.datamodels.DataModelInterface;
import org.adl.datamodels.SCODataManager;
import org.adl.datamodels.cmi.CMICore;
import org.adl.datamodels.cmi.CMIRequest;
import org.adl.datamodels.cmi.CMITime;
import org.adl.datamodels.cmi.DMErrorManager;
import org.adl.samplerte.client.LMSErrorManager;
import org.adl.samplerte.client.ServletProxy;
import org.adl.util.debug.DebugIndicator;

public class APIAdapterApplet
extends Applet {
    private static boolean _Debug = DebugIndicator.ON;
    private static LMSErrorManager lmsErrorManager;
    private static SCODataManager theSCOData;
    private DMErrorManager dmErrorManager;
    private static boolean isLMSInitialized;
    public static boolean areweloading;
    public static boolean arewefinishing;
    private String Debug;
    private String DOjs;
    public static String cookie;
    public String LastServerError;
    private static String cmiBooleanFalse;
    private static String cmiBooleanTrue;
    private static URL servletURL;

    public void start() {
        System.out.println("start() applet\n");
        this.DOjs = this.getParameter("JS");
        this.Debug = this.getParameter("debug");
        System.out.println("Debug is =" + this.Debug);
        String cookieName = "ad_session_id";
        cookie = this.getParameter("cookie");
        if (this.Debug.equals("false")) {
            _Debug = false;
            DebugIndicator.ON = false;
            System.out.println("debug is (false) " + _Debug);
        } else {
            _Debug = true;
            System.out.println("debug is (true) " + _Debug);
        }
        if (_Debug) {
            System.out.println("Cookies found =" + cookie);
        }
        if (cookie != null) {
            cookie = "ad_session_id=" + cookie;
        }
        System.out.println("cookie is (ending start):" + cookie);
        System.out.println("ending start\n");
    }

    public void init() {
        System.out.println("Version 10 init () in applet\n");
        if (_Debug) {
            System.out.println("Before setting interface)");
        }
        cmiBooleanFalse = new String("false");
        cmiBooleanTrue = new String("true");
        lmsErrorManager = new LMSErrorManager();
        this.dmErrorManager = new DMErrorManager();
        isLMSInitialized = false;
        URL codebase = this.getCodeBase();
        String host = codebase.getHost();
        String protocol = codebase.getProtocol();
        int port = codebase.getPort();
        String path = codebase.getPath();
        if (_Debug) {
            System.out.println("codebase url is " + codebase.toString());
        }
        try {
            while (!path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            path = path + "servlet";
            servletURL = port > 0 ? new URL(protocol + "://" + host + ":" + port + path) : new URL(protocol + "://" + host + path);
            System.out.println("servlet url is " + servletURL.toString());
            if (_Debug) {
                System.out.println("servlet host " + host.toString());
                System.out.println("servlet port " + port);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.stop();
        }
    }

    public String getAppletInfo() {
        return "RTE API Implementation. Michele Slocovich for SII and .LRN community. Based on:\nSample RTE API Implementation \nAuthor: R. Ball, CTC \nExample of one possible LMS API Implementation.";
    }

    public void destroy() {
        if (_Debug) {
            // empty if block
        }
        System.out.println("begin destroy");
        theSCOData = null;
        System.out.println("within destroy");
    }

    public void finalize() {
        System.out.println("begin finalize");
        System.out.println("within finalize");
    }

    public void stop() {
        System.out.println("begin stop");
        System.out.println("within stop");
    }

    public String[][] getParameterInfo() {
        String[][] info = new String[][]{{"None", "", "This applet requires no parameters."}};
        return info;
    }

    private boolean CheckInitialization() {
        if (!isLMSInitialized) {
            lmsErrorManager.SetCurrentErrorCode("301");
        }
        return isLMSInitialized;
    }

    public String LMSInitialize(String param) {
        if (_Debug) {
            System.out.println("*********************");
            System.out.println("In API::LMSInitialize");
            System.out.println("*********************");
            System.out.println("");
        }
        String result = cmiBooleanFalse;
        String tempParm = String.valueOf(param);
        if (!(tempParm.equals("null") || tempParm.equals(""))) {
            lmsErrorManager.SetCurrentErrorCode("201");
            return result;
        }
        if (isLMSInitialized) {
            if (_Debug) {
                System.out.println("********************************************");
                System.out.println("LMS seems have been already INITIALIZED");
                System.out.println("********************************************");
            }
            lmsErrorManager.SetCurrentErrorCode("101");
            result = cmiBooleanFalse;
        } else {
            ServletProxy servletProxy;
            String DataFromServer;
            if (_Debug) {
                System.out.println("Trying to get SCO Data from servlet...");
            }
            if ((DataFromServer = (servletProxy = new ServletProxy(servletURL, cookie)).GetSCOData()).startsWith("ERROR")) {
                isLMSInitialized = false;
                lmsErrorManager.SetCurrentErrorCode("201");
                System.out.println("Error on server on during communication");
                this.LastServerError = DataFromServer;
                result = cmiBooleanFalse;
                return result;
            }
            if (_Debug) {
                System.out.println("In LMSInitialize : Data obtained from server --> " + DataFromServer);
            }
            try {
                SCODataManager SCOData;
                theSCOData = SCOData = new SCODataManager();
                System.out.println("In LMSInitialize : CREATED EMPTY DATA");
                isLMSInitialized = true;
                System.out.println("In LMSInitialize : now parsing server data");
                Pattern p = Pattern.compile("^([^=]+)=(.*)$");
                DataFromServer = "," + DataFromServer;
                String[] couples = DataFromServer.split(",cmi\\.");
                int howmany = couples.length;
                System.out.println("In LMSInitialize, we have : " + howmany + " couples ");
                for (int z = 1; z < howmany; ++z) {
                    String Element2 = "";
                    String Value = "";
                    Matcher m = p.matcher(couples[z]);
                    if (m.find()) {
                        Element2 = m.group(1);
                        Value = m.group(2);
                    } else {
                        System.out.println("PARSE ERROR WITHIN:");
                        System.out.println("Couple is " + couples[z]);
                    }
                    if (z > 0) {
                        Element2 = "cmi." + Element2;
                    }
                    if (_Debug) {
                        System.out.println("Couple is " + couples[z]);
                        System.out.println("setting element " + Element2);
                        System.out.println("to value " + Value);
                    }
                    if (Value.length() > 0) {
                        areweloading = true;
                        if (_Debug) {
                            System.out.println("LMSSetValue returns " + this.LMSSetValue(Element2, Value));
                        } else {
                            this.LMSSetValue(Element2, Value);
                        }
                        areweloading = false;
                        continue;
                    }
                    System.out.println("Received a null value from server: not setting" + Element2);
                }
            }
            catch (Exception parsing) {
                isLMSInitialized = false;
                lmsErrorManager.SetCurrentErrorCode("201");
                if (_Debug) {
                    System.out.println("Error while parsing from server");
                    parsing.printStackTrace();
                }
                result = cmiBooleanFalse;
                return result;
            }
            System.out.println("In LMSInitialize : server data parsed");
            if (_Debug) {
                System.out.println("The Core Data for the current SCO contains the following:");
                theSCOData.getCore().showData();
            }
            lmsErrorManager.ClearCurrentErrorCode();
            result = cmiBooleanTrue;
        }
        if (_Debug) {
            System.out.println("");
            System.out.println("********************************************");
            System.out.println("Done Processing LMSInitialize() WITH SUCCESS");
            System.out.println("********************************************");
            System.out.println(" returning " + result);
        }
        return result;
    }

    public String getCookie(String cookieName) {
        String cookie = null;
        System.out.println("within getcookie function");
        return cookie;
    }

    public String LMSFinish(String param) {
        if (_Debug) {
            System.out.println("*****************");
            System.out.println("In API::LMSFinish");
            System.out.println("*****************");
            System.out.println("");
        }
        String result = cmiBooleanFalse;
        String tempParm = String.valueOf(param);
        if (tempParm.equals("null") || tempParm.equals("")) {
            if (this.CheckInitialization()) {
                CMICore lmsCore = theSCOData.getCore();
                CMITime totalTime = new CMITime(lmsCore.getTotalTime().getValue());
                if (_Debug) {
                    System.out.println("\tTotal time: " + totalTime.toString());
                }
                CMITime sessionTime = new CMITime(lmsCore.getSessionTime().getValue());
                if (_Debug) {
                    System.out.println("\tSession time: " + sessionTime.toString());
                }
                totalTime.add(sessionTime);
                lmsCore.setTotalTime(totalTime.toString());
                if (_Debug) {
                    System.out.println("\t\tTotal time: " + totalTime.toString());
                }
                if (lmsCore.getExit().getValue().equalsIgnoreCase("suspend")) {
                    lmsCore.setEntry("resume");
                } else {
                    lmsCore.setEntry("");
                }
                if (lmsCore.getLessonStatus().getValue().equalsIgnoreCase("not attempted")) {
                    lmsCore.setLessonStatus("incomplete");
                }
                theSCOData.setCore(lmsCore);
                arewefinishing = true;
                System.out.println("About calling LMSCommit from within LMSFinish with finalizing modifier\n");
                result = this.LMSCommit("");
                arewefinishing = false;
                if (result != cmiBooleanTrue) {
                    if (_Debug) {
                        System.out.println("LMSCommit failed causing LMSFinish to fail.");
                    }
                } else {
                    isLMSInitialized = false;
                    result = cmiBooleanTrue;
                }
            }
        } else {
            lmsErrorManager.SetCurrentErrorCode("201");
        }
        if (_Debug) {
            System.out.println("");
            System.out.println("***************************");
            System.out.println("Done Processing LMSFinish()");
            System.out.println("***************************");
            System.out.println(" returning " + result);
        }
        if (result == cmiBooleanTrue) {
            isLMSInitialized = false;
        }
        return result;
    }

    public String KeepAlive() {
        if (_Debug) {
            System.out.println("*****************");
            System.out.println("In API::KeepAlive");
            System.out.println("*****************");
        }
        String result = cmiBooleanFalse;
        ServletProxy servletProxy = new ServletProxy(servletURL, cookie);
        String calltoserver = servletProxy.KeepAlive();
        if (calltoserver.startsWith("OK")) {
            result = cmiBooleanTrue;
        } else {
            this.LastServerError = calltoserver;
        }
        if (_Debug) {
            System.out.println("***************************");
            System.out.println("Done Processing KeepAlive()");
            System.out.println("***************************");
            System.out.println("RESULT is:" + result);
        }
        return result;
    }

    public String LMSGetValue(String element) {
        if (_Debug) {
            System.out.println("*******************");
            System.out.println("In API::LMSGetValue");
            System.out.println("*******************");
            System.out.println("");
        }
        if (!this.CheckInitialization()) {
            if (_Debug) {
                System.out.println("LMS Not Initialized");
            }
            String emptyString = new String("");
            return emptyString;
        }
        if (_Debug) {
            System.out.println("Request being processed: LMSGetValue(" + element + ")");
        }
        CMIRequest request = new CMIRequest(element, true);
        if (_Debug) {
            System.out.println("Looking for the element " + request.getRequest());
        }
        lmsErrorManager.ClearCurrentErrorCode();
        this.dmErrorManager.ClearCurrentErrorCode();
        String rtnVal = null;
        DataModelInterface dmInterface = new DataModelInterface();
        rtnVal = dmInterface.processGet(element, theSCOData, this.dmErrorManager);
        lmsErrorManager.SetCurrentErrorCode(this.dmErrorManager.GetCurrentErrorCode());
        if (rtnVal != null) {
            if (_Debug) {
                System.out.println("LMSGetValue() found!");
                System.out.println("Returning: " + rtnVal);
            }
        } else {
            if (_Debug) {
                System.out.println("Found the element, but the value was null");
            }
            rtnVal = new String("");
        }
        if (_Debug) {
            System.out.println("");
            System.out.println("************************************");
            System.out.println("Processing done for API::LMSGetValue");
            System.out.println("************************************");
            System.out.println(" returning " + rtnVal);
        }
        return rtnVal;
    }

    public String LMSSetValue(String element, String value) {
        String result = cmiBooleanFalse;
        if (_Debug) {
            System.out.println("*******************");
            System.out.println("In API::LMSSetValue");
            System.out.println("*******************");
            System.out.println("");
        }
        lmsErrorManager.ClearCurrentErrorCode();
        this.dmErrorManager.ClearCurrentErrorCode();
        if (!this.CheckInitialization()) {
            System.out.println("**********************************************************************");
            System.out.println("In API::LMSSetValue ---> LMS IS NOT INITIALIZED ---> NOT SETTING VALUE");
            System.out.println("**********************************************************************");
            System.out.println("The request was: LMSSetValue (element=" + element + ", value=" + value);
            return result;
        }
        String tempValue = String.valueOf(value);
        String setValue = tempValue.equals("null") ? new String("") : tempValue;
        String theRequest = element + "," + setValue;
        if (_Debug) {
            System.out.println("Request being processed: LMSSetValue(" + theRequest + ")");
            System.out.println("Looking for the element " + element);
        }
        DataModelInterface dmInterface = new DataModelInterface();
        dmInterface.processSet(theRequest, theSCOData, this.dmErrorManager);
        lmsErrorManager.SetCurrentErrorCode(this.dmErrorManager.GetCurrentErrorCode());
        if (lmsErrorManager.GetCurrentErrorCode() == "0") {
            result = cmiBooleanTrue;
        }
        if (_Debug) {
            System.out.println("");
            System.out.println("************************************");
            System.out.println("Processing done for API::LMSSetValue");
            System.out.println("************************************");
            System.out.println(" returning " + result);
        }
        return result;
    }

    public String LMSCommit(String param) {
        if (_Debug) {
            System.out.println("*************************");
            System.out.println("Processing API::LMSCommit");
            System.out.println("*************************");
        }
        String result = cmiBooleanFalse;
        String tempParm = String.valueOf(param);
        if (tempParm.equals("null") || tempParm.equals("")) {
            if (!this.CheckInitialization()) {
                this.LastServerError = "LMSFinish without LMSInitialize";
                return result;
            }
            if (_Debug) {
                System.out.println("The SCO Data Manager for the current SCO contains The following:");
                theSCOData.getCore().showData();
            }
            ServletProxy servletProxy = new ServletProxy(servletURL, cookie);
            String servletResult = servletProxy.PutSCOData(theSCOData);
            if (!servletResult.equals("OK")) {
                lmsErrorManager.SetCurrentErrorCode("101");
                if (_Debug) {
                    System.out.println("Put to Server was NOT successful!");
                }
                this.LastServerError = servletResult;
            } else {
                lmsErrorManager.ClearCurrentErrorCode();
                result = cmiBooleanTrue;
                if (_Debug) {
                    System.out.println("Put to Server succeeded!");
                }
            }
        } else {
            lmsErrorManager.SetCurrentErrorCode("201");
        }
        if (_Debug) {
            System.out.println("");
            System.out.println("**********************************");
            System.out.println("Processing done for API::LMSCommit");
            System.out.println("**********************************");
            System.out.println(" returning " + result);
        }
        return result;
    }

    public String LMSGetLastError() {
        if (_Debug) {
            System.out.println("In API::LMSGetLastError()");
        }
        return lmsErrorManager.GetCurrentErrorCode();
    }

    public String LMSGetErrorString(String errorCode) {
        if (_Debug) {
            System.out.println("In API::LMSGetErrorString()");
        }
        return lmsErrorManager.GetErrorDescription(errorCode);
    }

    public String LMSGetDiagnostic(String errorCode) {
        if (_Debug) {
            System.out.println("In API::LMSGetDiagnostic()");
        }
        return lmsErrorManager.GetErrorDiagnostic(errorCode);
    }

    static {
        arewefinishing = false;
    }
}

