#!/usr/bin/env python

# Copyright (C) 2013 Johannes Ring
#
# This file is part of DOLFIN.
#
# DOLFIN is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# DOLFIN is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.

template = """#!/bin/bash
%(sbatch)s

%(paths)s

%(setup)s

%(job)s
"""

def job_script(job, jobname, nodes, ppn, walltime, mem, vmem, workdir, \
               email, paths, setup, keep_environment, queue, parallel_environment):
    """
    Generate a slurm specific job script.
    """

    sbatch = "#SBATCH --job-name=" + jobname
    sbatch += " --time=%d:00:00" % walltime
    sbatch += " --ntasks=" + str(nodes)
    sbatch += " --cpus-per-task=" + str(ppn)

    if mem:
        sbatch += " --mem-per-cpu=" + mem
    if email:
        sbatch += " --mail-user=" + email
    if keep_environment:
        sbatch += " --get-user-env"

    # Issue warnings on not supported arguments
    if vmem:
        print "Warning: 'vmem' is not supported for the 'slurm' backend"
    if queue:
        print "Warning: 'queue' is not supported for the 'slurm' backend"
    if parallel_environment:
        print "Warning: 'parallel_environment' is not supported for the 'slurm' backend"

    args = dict(sbatch=sbatch,
                workdir=workdir,
                paths=paths,
                setup=setup,
                job=job)

    return template % args
