// Auto generated SWIG file for Python interface of DOLFIN
//
// Copyright (C) 2012 Kristian B. Oelgaard
//
// This file is part of DOLFIN.
//
// DOLFIN is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// DOLFIN is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.
//

// Autogenerated docstrings file, extracted from the DOLFIN source C++ files.

// Documentation extracted from: (module=ale, header=ALE.h)
%feature("docstring")  dolfin::ALE "
This class provides functionality useful for implementation of
ALE (Arbitrary Lagrangian-Eulerian) methods, in particular
moving the boundary vertices of a mesh and then interpolating
the new coordinates for the interior vertices accordingly.
";

%feature("docstring")  dolfin::ALE::move "
**Overloaded versions**

* move\ (mesh, new_boundary)

  Move coordinates of mesh according to new boundary coordinates.
  Returns displacement (encapsulated in Expression subclass MeshDisplacement)

* move\ (mesh0, mesh1)

  Move coordinates of mesh0 according to mesh1 with common global vertices.
  Returns displacement (encapsulated in Expression subclass MeshDisplacement)

* move\ (mesh, displacement)

  Move coordinates of mesh according to displacement function
";

// Documentation extracted from: (module=ale, header=MeshDisplacement.h)
%feature("docstring")  dolfin::MeshDisplacement "
This class encapsulates the CG1 representation of the
displacement of a mesh as an Expression. This is particularly
useful for the displacement returned by mesh smoothers which can
subsequently be used in evaluating forms. The value rank is 1
and the value shape is equal to the geometric dimension of the
mesh.
";

%feature("docstring")  dolfin::MeshDisplacement::MeshDisplacement "
**Overloaded versions**

* MeshDisplacement\ (mesh)

  Create MeshDisplacement of given mesh
  
  *Arguments*
      mesh (:py:class:`Mesh`)
          Mesh to be displacement defined on.

* MeshDisplacement\ (mesh_displacement)

  Copy constructor
  
  *Arguments*
      mesh_displacement (:py:class:`MeshDisplacement`)
          Object to be copied.
";

%feature("docstring")  dolfin::MeshDisplacement::operator[] "
**Overloaded versions**

* operator[]\ (i)

  Extract subfunction
  In python available as MeshDisplacement.sub(i)
  
  *Arguments*
      i (int)
          Index of subfunction.

* operator[]\ (i)

  Extract subfunction. Const version
  
  *Arguments*
      i (int)
          Index of subfunction.
";

%feature("docstring")  dolfin::MeshDisplacement::eval "
Evaluate at given point in given cell.

*Arguments*
    values (numpy.array(float))
        The values at the point.
    x (numpy.array(float))
        The coordinates of the point.
    cell (ufc::cell)
        The cell which contains the given point.
";

%feature("docstring")  dolfin::MeshDisplacement::compute_vertex_values "
Compute values at all mesh vertices.

*Arguments*
    vertex_values (numpy.array(float))
        The values at all vertices.
    mesh (:py:class:`Mesh`)
        The mesh.
";

