.. This (-*- rst -*-) format file contains commonly used link targets
   and name substitutions.  It may be included in many files,
   therefore it should only contain link targets and name
   substitutions.  Try grepping for "^\.\. _" to find plausible
   candidates for this list.

.. NOTE: reST targets are
   __not_case_sensitive__, so only one target definition is needed for
   nipy, NIPY, Nipy, etc...

.. _nipy: https://nipy.org
.. _`Brain Imaging Center`: https://bic.berkeley.edu/
.. _dipy: https://dipy.org
.. _`dipy github`: https://github.com/dipy/dipy
.. _`dipy pypi`: https://pypi.python.org/pypi/dipy
.. _`nipy issues`: https://github.com/nipy/nipy/issues
.. _`dipy issues`: https://github.com/dipy/dipy/issues
.. _`dipy discussions`: https://github.com/dipy/dipy/discussions
.. _`dipy github actions`: https://github.com/dipy/dipy/actions
.. _`dipy paper`: https://www.frontiersin.org/Neuroinformatics/10.3389/fninf.2014.00008/abstract
.. _journal paper: https://www.frontiersin.org/Neuroinformatics/10.3389/fninf.2014.00008/abstract
.. _nibabel: https://nipy.org/nibabel
.. _nibabel pypi: https://pypi.python.org/pypi/nibabel
.. _nipy development guidelines: https://nipy.org/nipy/devel/guidelines/index.html
.. _buildbots: https://nipy.bic.berkeley.edu/builders
.. _`dipy gitter`: https://gitter.im/dipy/dipy
.. _neurostars: https://neurostars.org/
.. _h5py: https://www.h5py.org/
.. _cvxpy: https://www.cvxpy.org/

.. Packaging
.. _neurodebian: https://neuro.debian.net
.. _neurodebian how to: https://neuro.debian.net/#how-to-use-this-repository
.. _pip: https://www.pip-installer.org/en/latest/
.. _easy_install: https://pypi.python.org/pypi/setuptools
.. _homebrew: https://brew.sh/

.. Documentation tools
.. _graphviz: https://www.graphviz.org/
.. _`Sphinx reST`: https://sphinx.pocoo.org/rest.html
.. _reST: https://docutils.sourceforge.net/rst.html
.. _docutils: https://docutils.sourceforge.net

.. Licenses
.. _GPL: https://www.gnu.org/licenses/gpl.html
.. _BSD: https://www.opensource.org/licenses/bsd-license.php
.. _LGPL: https://www.gnu.org/copyleft/lesser.html

.. Working process
.. _pynifti: https://niftilib.sourceforge.net/pynifti/
.. _nifticlibs: https://nifti.nimh.nih.gov
.. _nifti: https://nifti.nimh.nih.gov
.. _`nipy launchpad`: https://launchpad.net/nipy
.. _launchpad: https://launchpad.net/
.. _`nipy trunk`: https://code.launchpad.net/~nipy-developers/nipy/trunk
.. _`nipy mailing list`: https://mail.python.org/mailman/listinfo/neuroimaging
.. _`dipy mailing list`: https://mail.python.org/mailman3/lists/dipy.python.org/
.. _`nipy bugs`: https://bugs.launchpad.net/nipy
.. _pep8: https://www.python.org/dev/peps/pep-0008/
.. _`numpy coding style`: https://github.com/numpy/numpy/blob/master/doc/HOWTO_DOCUMENT.rst.txt
.. _`python module path`: https://docs.python.org/tutorial/modules.html#the-module-search-path

.. Code support stuff
.. _pychecker: https://pychecker.sourceforge.net/
.. _pylint: https://www.logilab.org/project/pylint
.. _pyflakes: https://divmod.org/trac/wiki/DivmodPyflakes
.. _virtualenv: https://pypi.python.org/pypi/virtualenv
.. _git: https://git.or.cz/
.. _github: https://github.com
.. _flymake: https://flymake.sourceforge.net/
.. _rope: https://rope.sourceforge.net/
.. _pymacs: https://pymacs.progiciels-bpi.ca/pymacs.html
.. _ropemacs: https://rope.sourceforge.net/ropemacs.html
.. _ECB: https://ecb.sourceforge.net/
.. _emacs_python_mode: https://www.emacswiki.org/cgi-bin/wiki/PythonMode
.. _doctest-mode: https://www.cis.upenn.edu/~edloper/projects/doctestmode/
.. _bazaar: https://bazaar-vcs.org/
.. _nose: https://somethingaboutorange.com/mrl/projects/nose
.. _pytest: https://docs.pytest.org
.. _`python coverage tester`: https://nedbatchelder.com/code/modules/coverage.html
.. _cython: https://cython.org
.. _travis-ci: https://travis-ci.com/

.. Other python projects
.. _numpy: https://numpy.org
.. _scipy: https://www.scipy.org
.. _IPython: https://www.ipython.org/
.. _`ipython manual`: https://ipython.scipy.org/doc/manual/html
.. _matplotlib: https://matplotlib.sourceforge.net
.. _pythonxy: https://www.pythonxy.com
.. _ETS: https://code.enthought.com/projects/tool-suite.php
.. _`Enthought Tool Suite`: https://code.enthought.com/projects/tool-suite.php
.. _canopy: https://assets.enthought.com/downloads/
.. _anaconda: https://www.anaconda.com/download
.. _python: https://www.python.org
.. _mayavi: https://mayavi.sourceforge.net/
.. _sympy: https://code.google.com/p/sympy/
.. _networkx: https://networkx.lanl.gov/
.. _setuptools: https://pypi.python.org/pypi/setuptools
.. _distribute: https://packages.python.org/distribute
.. _datapkg: https://okfn.org/projects/datapkg
.. _pytables: https://www.pytables.org
.. _python-vtk: https://www.vtk.org
.. _pypi: https://pypi.python.org/pypi
.. _FURY: https://fury.gl
.. _scikit-learn: https://scikit-learn.org
.. _statsmodels: https://www.statsmodels.org
.. _pandas: https://pandas.pydata.org
.. _pytables: https://www.pytables.org

.. Python imaging projects
.. _PyMVPA: https://www.pymvpa.org
.. _BrainVISA: https://brainvisa.info
.. _anatomist: https://brainvisa.info
.. _pydicom: https://code.google.com/p/pydicom/

.. Not so python imaging projects
.. _matlab: https://www.mathworks.com
.. _spm: https://www.fil.ion.ucl.ac.uk/spm
.. _spm8: https://www.fil.ion.ucl.ac.uk/spm/software/spm8
.. _eeglab: https://sccn.ucsd.edu/eeglab
.. _AFNI: https://afni.nimh.nih.gov/afni
.. _FSL: https://www.fmrib.ox.ac.uk/fsl
.. _FreeSurfer: https://surfer.nmr.mgh.harvard.edu
.. _voxbo: https://www.voxbo.org
.. _mricron: https://www.mccauslandcenter.sc.edu/mricro/mricron/index.html
.. _slicer: https://www.slicer.org/
.. _fibernavigator: https://github.com/scilus/fibernavigator

.. File formats
.. _DICOM: https://medical.nema.org/
.. _`wikipedia DICOM`: https://en.wikipedia.org/wiki/Digital_Imaging_and_Communications_in_Medicine
.. _GDCM: https://sourceforge.net/apps/mediawiki/gdcm
.. _`DICOM specs`: ftp://medical.nema.org/medical/dicom/2009/
.. _`DICOM object definitions`: ftp://medical.nema.org/medical/dicom/2009/09_03pu3.pdf
.. _dcm2nii: https://www.cabiatl.com/mricro/mricron/dcm2nii.html
.. _`mricron install`: https://www.cabiatl.com/mricro/mricron/install.html
.. _dicom2nrrd: https://www.slicer.org/slicerWiki/index.php/Modules:DicomToNRRD-3.4
.. _Nrrd: https://teem.sourceforge.net/nrrd/format.html

.. General software
.. _gcc: https://gcc.gnu.org
.. _xcode: https://developer.apple.com/xcode/resources/
.. _mingw: https://www.mingw.org/wiki/Getting_Started
.. _mingw distutils bug: https://bugs.python.org/issue2698
.. _cygwin: https://cygwin.com
.. _macports: https://www.macports.org/
.. _VTK: https://www.vtk.org/
.. _ITK: https://www.itk.org/
.. _swig: https://www.swig.org
.. _openmp: https://www.openmp.org/

.. Windows development
.. _mingw: https://www.mingw.org/wiki/Getting_Started
.. _msys: https://www.mingw.org/wiki/MSYS
.. _powershell: https://www.microsoft.com/powershell
.. _msysgit: https://code.google.com/p/msysgit
.. _putty: https://www.chiark.greenend.org.uk/~sgtatham/putty
.. _visualstudiobuildtools: https://landinghub.visualstudio.com/visual-cpp-build-tools

.. Functional imaging labs
.. _`functional imaging laboratory`: https://www.fil.ion.ucl.ac.uk
.. _FMRIB: https://www.fmrib.ox.ac.uk

.. Other organizations
.. _enthought: https://www.enthought.com
.. _kitware: https://www.kitware.com
.. _nitrc: https://www.nitrc.org

.. General information links
.. _`wikipedia FMRI`: https://en.wikipedia.org/wiki/Functional_magnetic_resonance_imaging
.. _`wikipedia PET`: https://en.wikipedia.org/wiki/Positron_emission_tomography

.. Mathematical methods
.. _`wikipedia ICA`: https://en.wikipedia.org/wiki/Independent_component_analysis
.. _`wikipedia PCA`: https://en.wikipedia.org/wiki/Principal_component_analysis

.. Mathematical ideas
.. _`wikipedia spherical coordinate system`: https://en.wikipedia.org/wiki/Spherical_coordinate_system
.. _`mathworld spherical coordinate system`: https://mathworld.wolfram.com/SphericalCoordinates.html
.. _`wikipedia affine`: https://en.wikipedia.org/wiki/Affine_transformation
.. _`wikipedia linear transform`: https://en.wikipedia.org/wiki/Linear_transformation
.. _`wikipedia rotation matrix`: https://en.wikipedia.org/wiki/Rotation_matrix
.. _`wikipedia homogeneous coordinates`: https://en.wikipedia.org/wiki/Homogeneous_coordinates
.. _`wikipedia axis angle`: https://en.wikipedia.org/wiki/Axis_angle
.. _`wikipedia Euler angles`: https://en.wikipedia.org/wiki/Euler_angles
.. _`Mathworld Euler angles`: https://mathworld.wolfram.com/EulerAngles.html
.. _`wikipedia quaternion`: https://en.wikipedia.org/wiki/Quaternion
.. _`wikipedia shear matrix`: https://en.wikipedia.org/wiki/Shear_matrix
.. _`wikipedia reflection`: https://en.wikipedia.org/wiki/Reflection_(mathematics)
.. _`wikipedia direction cosine`: https://en.wikipedia.org/wiki/Direction_cosine

.. vim:syntax=rst
