/* ============================================================
 *
 * This file is a part of digiKam
 *
 * Date        : 2017-08-08
 * Description : Base functions for dnn module, can be used for face recognition, 
 *               all codes are ported from dlib library (http://dlib.net/)
 *
 * Copyright (C) 2006-2016 by Davis E. King <davis at dlib dot net>
 * Copyright (C) 2017      by Yingjie Liu <yingjiewudi at gmail dot com>
 * Copyright (C) 2017-2019 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef DLIB_NUMERIC_CONSTANTs_H_
#define DLIB_NUMERIC_CONSTANTs_H_


// pi -- Pi
const double pi = 3.1415926535897932385;

// e  -- Euler's Constant
const double e = 2.7182818284590452354;

// sqrt_2 -- The square root of 2
const double sqrt_2 = 1.4142135623730950488;

// sqrt_3 -- The square root of 3
const double sqrt_3 = 1.7320508075688772935;

// log10_2 -- The logarithm base 10 of two
const double log10_2 = 0.30102999566398119521;

// light_spd -- The speed of light in vacuum in meters per second
const double light_spd = 2.99792458e8;

// newton_G  -- Newton's gravitational constant (in metric units of m^3/(kg*s^2))
const double newton_G = 6.67384e-11;

// planck_cst -- Planck's constant (in units of Joules * seconds) 
const double planck_cst = 6.62606957e-34;

// golden_ratio -- The Golden Ratio
const double golden_ratio = 1.6180339887498948482;

// euler_gamma -- The Euler Mascheroni Constant 
const double euler_gamma = 0.5772156649015328606065;

// catalan -- Catalan's Constant
const double catalan = 0.91596559417721901505; 

// glaisher -- Glaisher Kinkelin constant
const double glaisher = 1.2824271291006226369;

// khinchin -- Khinchin's constant
const double khinchin = 2.6854520010653064453;

// apery -- Apery's constant
const double apery = 1.2020569031595942854;

#endif //DLIB_NUMERIC_CONSTANTs_H_

