## diffview.el
*View diffs in side-by-side format*

---
[![License GPLv3](https://img.shields.io/badge/license-GPL_v3-green.svg)](http://www.gnu.org/licenses/gpl-3.0.html)
[![MELPA](http://melpa.org/packages/diffview-badge.svg)](http://melpa.org/#/diffview)

Render a unified diff (top/bottom) in an easy-to-comprehend side-by-side
format.  This comes in handy for reading patches from mailing lists (or
from whencever you might acquire them).

### Installation


    M-x package-install diffview

### Usage


The following functions are provided for launching a side-by-side diff:

* `diffview-current` : View the current diff buffer side-by-side
* `diffview-region` : View the current diff region side-by-side
* `diffview-message` : View the current email message (which presumably
   contains a patch) side-by-side


### Screenshots


Before:<br>
<img src="https://raw.github.com/mgalgs/diffview-mode/master/screenshots/diffview-before.png"><br>
After:<br>
<img src="https://raw.github.com/mgalgs/diffview-mode/master/screenshots/diffview-after.png"><br>

### Function Documentation


#### `(diffview-current)`

Show current diff buffer in a side-by-side view.

#### `(diffview-region)`

Show current diff region in a side-by-side view.

#### `(diffview-message)`

Show `message-mode` buffer in a side-by-side view.

This is useful for reading patches from mailing lists.

-----
<div style="padding-top:15px;color: #d0d0d0;">
Markdown README file generated by
<a href="https://github.com/mgalgs/make-readme-markdown">make-readme-markdown.el</a>
</div>
