#ifndef TRANSFER_LIST_MODEL_H__
#define TRANSFER_LIST_MODEL_H__


#include "global.h"
#include "filetransfer.h"

#include <QAbstractTableModel>
#include <QList>


class TransferListModel : public QAbstractTableModel
{
Q_OBJECT
public:
	//!< Column indexes
	enum eTransferColumnHeader {
		COL_USER = 0,     //!< User nick
		COL_FILE_NAME,    //!< stripped path filename
		COL_PROGRESS_BAR, //!< data() for this column returns QVariant( QList<QVariant> )
		COL_SIZE_LEFT,
		COL_SIZE_TOTAL,
		COL_AVG_SPEED,
		COL_STATUS,
		NUM_COLUMNS
	};

	//! Index into QList<QVariant> returned by data() for COL_PROGRESS_BAR
	enum eProgressData {
		PDATA_IS_DOWNLOAD,  //!< bool, true if this transfer is a download
		PDATA_START_POS,    //!< qlonglong, start position
		PDATA_POS,          //!< qlonglong, write position in file
		PDATA_ACTUAL,       //!< qlonglong, bytes transferred this sessions
		PDATA_SIZE,         //!< qlonglong, target size
		PDATA_SECONDS_LEFT, //!< int, estimated time left, in seconds
		PDATA_MAX_INDEX
	};

	TransferListModel() {}
	virtual ~TransferListModel() {}

    int rowCount ( const QModelIndex& ) const {return transfers.size();}
    int columnCount ( const QModelIndex& ) const {return NUM_COLUMNS;}
    QVariant data ( const QModelIndex & index, int role = Qt::DisplayRole ) const;
    QVariant headerData ( int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const;
	FileTransfer data(int row) {Q_ASSERT(row>=0 && row < transfers.size());return transfers[row];}

	
public slots:
    void onTransferStart( const FileTransfer& );
    void onTransferTick( const QList<FileTransfer>& );
    void onTransferComplete( const FileTransfer& );
    void onTransferFailed( const FileTransfer&,const QString& );

private:
    QList<FileTransfer> transfers;
};

#endif

