

#ifndef RPC_TYPES_H_
#define RPC_TYPES_H_

#include <string>
#include <list>
#include <rpcdriver/types.h>

using std::string;
using std::list;

namespace rpc_types {


class FavouriteHub
{
public:
	string nick;
	string userDescription;
	string name;
	string server;
	string description;
	string password;
	bool autoConnect;
	
	bool operator==(const FavouriteHub& rhs) {
		return rhs.server==server;
	}
};
	
class Share
{
public:
	string virtualName;
	string realName;
	int64 bytesShared;
};

class HubEntry
{
public:
	string name;
	string server;
	string description;
	string country;
	string rating;
	int reliability;
	int64 shared;
	int64 minShare;
	int users;
	int minSlots;
	int maxHubs;
	int maxUsers;
	
	/// The amount of elements a hub entry should contain
	static const unsigned short HUB_ENTRY_SIZE = 12;
};

class User
{
public:
	string nick;
	int flags;
	string email;
	string description;
	string connection;
	string tag;
	int64 shared; 	
	int hubslots;
	int userid;
};

class SessionInfo
{
public:
	int id;
	string hubname;
	string url;
	list<User> users;
};

}

#endif
