/*
Copyright (c) 2013, Regents of the University of Alaska

All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
    * Neither the name of the Geographic Information Network of Alaska nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This code was developed by Dan Stahlke for the Geographic Information Network of Alaska.
*/



#ifndef DANGDAL_DP_H
#define DANGDAL_DP_H

#include <vector>

#include "polygon.h"

namespace dangdal {

struct segment_t {
	segment_t() : begin(0), end(0) { }
	segment_t(size_t _begin, size_t _end) : begin(_begin), end(_end) { }

	Bbox get_bbox(const Ring &ring) const {
		Bbox bbox;
		bbox.expand(ring.pts[begin]);
		bbox.expand(ring.pts[end]);
		return bbox;
	}

	size_t begin;
	size_t end;
};

struct ReducedRing {
	std::vector<segment_t> segs;
};

Mpoly compute_reduced_pointset(const Mpoly &in_mpoly, double tolerance);
ReducedRing compute_reduced_ring(const Ring &orig_string, double res);
void fix_topology(const Mpoly &mpoly, std::vector<ReducedRing> &reduced_rings);
Mpoly reduction_to_mpoly(const Mpoly &in_mpoly, const std::vector<ReducedRing> &reduced_rings);

} // namespace dangdal

#endif // ifndef DANGDAL_DP_H
