/******************************************************************************
 * Top contributors (to current version):
 *   Andrew Reynolds, Aina Niemetz
 *
 * This file is part of the cvc5 project.
 *
 * Copyright (c) 2009-2025 by the authors listed in the file AUTHORS
 * in the top-level source directory and their institutional affiliations.
 * All rights reserved.  See the file COPYING in the top-level source
 * directory for licensing information.
 * ****************************************************************************
 *
 * A class for mining interesting satisfiability queries from a stream
 * of generated expressions.
 */

#include "cvc5_private.h"

#ifndef CVC5__THEORY__QUANTIFIERS__QUERY_GENERATOR_H
#define CVC5__THEORY__QUANTIFIERS__QUERY_GENERATOR_H

#include "expr/node.h"
#include "theory/quantifiers/expr_miner.h"

namespace cvc5::internal {
namespace theory {
namespace quantifiers {

/** QueryGenerator
 *
 * This is the base class for modules that print queries based on sygus
 * enumeration.
 */
class QueryGenerator : public ExprMiner
{
 public:
  QueryGenerator(Env& env);
  ~QueryGenerator() {}
  /** initialize */
  void initialize(const std::vector<Node>& vars,
                  SygusSampler* ss = nullptr) override;

 protected:
  /** total number of queries generated by this class */
  size_t d_queryCount;
  /**
   * Dumps query qy to the a file queryN.smt2 for the current counter N
   */
  void dumpQuery(Node qy, const Result& r, std::vector<Node>& queries);
  /** ensure that node n added to the generator is Boolean */
  void ensureBoolean(const Node& n) const;
};

/**
 * QueryGeneratorBasic
 *
 * Generates query based on the sygus enumeration only.
 */
class QueryGeneratorBasic : public QueryGenerator
{
 public:
  QueryGeneratorBasic(Env& env);
  ~QueryGeneratorBasic() {}
  /**
   * Add term to this module. This may add formulas to queries.
   */
  bool addTerm(Node n, std::vector<Node>& queries) override;
};

}  // namespace quantifiers
}  // namespace theory
}  // namespace cvc5::internal

#endif /* CVC5__THEORY__QUANTIFIERS___H */
