.\"$Id: crossfire-client-gtk2.man 6716 2007-06-27 18:57:31Z akirschbaum $
.TH crossfire-client-gtk2
.SH NAME
crossfire-client-gtk2 - second generation GTK client for Crossfire servers.
.SH SYNOPSIS
.B crossfire-client-gtk2
[-cache|-nocache] [-darkness|-nodarkness] [-display display]
[-download-all-faces] [-echo|-noecho] [-faceset name]
[-fasttcpsend|-nofasttcpsend] [-fog] [-help] [-iconscale percentage]
[-loglevel level] [-mapscale percentage] [-mapsize xXy]
[-opengl|-pixmap|-sdl] [-port number] [-server name] [-showicon]
[-smooth|-nosmooth] [-sound|-nosound] [-sound_server executable]
[-splash|-nosplash] [-resists value] [-split] [-splitinfo]
[-timemapredraw] [-triminfowindow|-notriminfowindow] [-updatekeycodes]
[-window_xml path] [-dialog_xml path]
.SH DESCRIPTION
.PP
.I crossfire-client-gtk2
is a GTK program for connecting to Crossfire servers.  Crossfire is a
multiplayer graphical adventure game that mixes aspects of Gauntlet (TM),
Nethack, Moria, and Ultima (TM).

This man page describes options for the second generation gtk client
(crossfire-client-gtk2) for the Crossfire game server.  There are many
other clients, and each is unique.  This documentation is not intended
to cover them.

.SH OPTIONS
.TP
.B -cache|-nocache
Determines if the client will cache images for future runs.  With -nocache,
when the server is about to reference an image that the client has
yet to receive, it sends that image along to the client.  These downloaded
images are discarded once the client exists.  With -cache, the server
sends information about the image it is about to reference.  The client
can then check its local cache (stored in ~/.crossfire/image-cache) - if it
has the image, it creates it off the disk.  If it does not have it,
it requests it from the server and then stores it in its cache.  In the
brief time between the request of the image and it actually receives it,
that image will be represented by a ? in the map.

-cache option is strongly recommended anytime when your link to the server
is slower than home directory access - this is likely to be the case
except in case of NFS mounted home directories on the server on the local
LAN.

.TP
.B -darkness|-nodarkness
Controls whether the server sends darkness information to the client
or not.  Turning off darkness results in a savings off bandwidth
for maps that use darkness code (currently, very few maps use darkness
code).  Turning off darkness may also be desirable as in some graphics
mode the quality of darkness may not add much to the map.

.TP
.B -display <display>
The display to open the windows on.  If this option is not given, it
will use the DISPLAY environmental variable to determine the display.

.TP
.B -download_all_faces
The client will get all the checksums from the server, and download any
images necessary before starting play.  This saves a small amount of
bandwidth, but more importantly reduces possible latency during
important play when it may not be desirable.

.TP
.B -echo|-noecho
Echo commands as they are entered.  Normally, commands bound to keys
are just sent to the server without any echoing on the client of what
that command actually was.  This option causes the commands to also be
printed in the information window as they are sent to the server.

.TP
.B -faceset <name>
Uses faceset <name> if available on the server.  What facesets are available
on each server may differ.  The client will request the information
about the different facesets available on the server, and try to find the
one that matches best.  The default is the standard set.  At current
time (March 2002), the only one typically available is the classic set.

.TP
.B -fasttcpsend|-nofasttcpsend
Send or do not send data immediately to the server.  This setting may
decrease latency if set at the expense of greater outgoing bandwidth use.

.TP
.B -fog
Enables fog of war code.  In this mode, spaces which have been seen
before but are no longer visible will still be shown on the game
window half darkened.  The data in these spaces is not up to date
since it is currently out of site.  This has no effect on bandwidth,
but may consume more CPU time.

.TP
.B -help
Prints out a brief description of the options to standard output.

.TP
.B -iconscale percentage
Causes the images for the inventory icons
to be scaled some percentage value.
Minimum value is 25%.  Setting this to 50% is
very useful - doubles amount of data visible in the inventory
window.

.TP
.B -loglevel level
Set default logging level with 0 being most verbose.

.TP
.B -mapscale percentage
Causes the images for the map surface (-mapscale) to be scaled some
percentage value.  Minimum value is 25%.  This value does not need
to be the same as the iconscale value.  Scaling down the size of
the map images can be useful when playing on low resolution screens.
Smaller images will also consume less CPU as there will be less
information to draw.

.TP
.B -mapsize XxY
Sets the desired viewable map window.  X and Y are number of tiles.
Note that larger map sizes are likely to consume more bandwidth,
CPU time, as well as just screen real estate.

The maximum map size may vary server to server.  The client will
try to negotiate the largest viewable map in each dimension.  Note
that there is no requirement that the viewable map be square.

Due to performance issues, it is strongly suggested that experimentation
is done with this value to find a size that gets acceptable performance
n(simple test - go to the start town, run in some direction, stop
running and see how long it takes before the client stops moving
you).

.TP
.B -opengl | -pixmap | -sdl
The graphics drawing mode to use.  The -opengl and -sdl options may
only be used of the client was compiled with support for those mode.
Generally, -opengl provides the best quality, followed by -sdl, and
then -pixmap.

.B -sdl
Using this option allows for more complex graphics - true alpha
channel, improved darkness handling.  Performance may be worse
when using this option - this depends on many factors.  Like
the mapsize option above, it is suggested the experimentation is
done to make performance is still acceptable.  This option does
not affect bandwidth - it only affects CPU performance.

.TP
.B -port number
The port number of the server to connect to.  By default, it will use
port 13327 (standard port).  However, certain servers may use other
ports.

.TP
.B -resists value
Control look of resistances.

.TP
.B -server name
Sets the server to play on.  If no option is given, it will default to
localhost.

.TP
.B -showicon
This shows a little icon next to items in your inventory that contains
a brief description of some of the item properties (magic, cursed,
equipped, etc.)  This can make spotting some items easier, but some
players may not like the extra space these icons take up or the

.TP
.B -smooth | -nosmooth
This option causes map tile edges to be blended together so that the
map has a less artificially tiled appearance.  Use of this option
incurs greater CPU and bandwidth usage.

.TP
.B -sound|-nosound
Enable/Disables sound effects.  Disabling sound has a minor savings
on bandwidth.  It is most useful if you do not want sound, due to
lack of hardware or lack of desire for sound.  Default is sound
enabled.

.TP
.B -sound_server <executable>
This is the name of the sound server process to execute.  If the path starts
with a slash, this is the absolute path to the executable.  Otherwise,
the value of BINDIR (install location of client executable) will be
prepended.  This defaults to cfsndserv.  Changing this value may be necessary
if the default sound daemon does not work as expected.

Note that the input that the executable takes is special, requiring an
executable especially designed for crossfire to work. You can not point
generic sound playing programs and expect it to work.

.TP
.B -splash|-nosplash
Enable/Disables splash screen.  When enabled, a window with a Crossfire
logo is displayed while the client is starting up.
Default is the splash screen is enabled.

.TP
.B -split|-nosplit
-split starts the windows up in split windows mode.  In split windows
mode, 6 separate windows are created - these individual windows can then
be moved around and resized as desired.  -nosplit starts the game up with
a single window - this is the default.  The option is useful if your
saved defaults are set for -split (see Saved Defaults further down).

.TP
.B -splitinfo
This splits the information pane window into two sub windows.  One contains
all the attack messages and otherwise fairly mundane information, and the
other contains important messages, like changes in protection values,
levels, etc.

.TP
.B -timemapredraw
Prints out debugging time information to stderr.  This timing information
can be useful when trying to find performance problems, or just how
different client options change the time it takes for the map to get
drawn, which is the biggest CPU consumer in the client.

.TP
.B -triminfowindow | -notriminfowindw
Causes the information window to get 'trimmed', eg, remove text
so that the total contents of the information window remains
roughly the same size (20,000 bytes or so).  As of 2001-11-03,
using this option resulted in client periodically crashing.
The problem appears to be within gtk, so using this is not
encouraged.  However, the problems in gtk may get fixed, or this
may be more reliable on other platforms so is included.

.TP
.B -updatekeycodes
The standard behaviour when a player uses the bind command to bind
new actions is that they keycode is saved with that binding.  Keycodes
are specific to keyboards - a sun keyboard will generate a different
keycode compared to a PC style keyboard.  In most cases, it is not
always desirable to have the keycodes get updated, as this may make
some bindings unavailable.  Using this option will force custom keybindings
to get updated for the current keyboard when the client is run.

.TP
.B -window_xml window_layout
This client is uses libglade to allow the main client window to be
customized.  This option is used to specify how the main game window
looks.  Various layout options are usually supplied with the client.
The default window layout is gtk-v2.glade.

.TP
.B -dialog_xml window_layout
This client is uses libglade to allow the various client dialogs to
be customized.  This option is used to specify the appearance of the
various dialog used by the client.  Presently there are no alternate
dialog layouts supplied with the client.  The default dialog layout
setting is dialogs.glade.


.SH SAVED DEFAULTS

Once you have logged onto a server, you may enter extended commands
by typing ' (apostrophe) followed by the extended commands.  One of
these extended commands is savedefaults.  This command saves many of
the options listed above.  Note that the saved defaults are read
first, so using the command line switches can be used to override
settings in the gdefaults2 file.

The settings are saved into
~/.crossfire/gdefaults2.

You can enter savewinpos as an extended command.  By default, this saves
the current window positions and sizes to the file ~/.crossfire/gtk-v2.pos.
The actual file name is based on the name of the window layout file (see
the -window_xml option).  So, for example, if -window_xml caelestis.glade
is used, window positions are actually saved to ~/.crossfire/caelestis.pos.
Next time you run the client, with this window layout selected, it will
restore the window layout as specified.

.SH PLAYING WITH THE CLIENT

This is by far a complete tutorial of gameplay.  This section is to
provide a basic introduction to logging in and doing a few very
basic actions.

The first thing to do after the client successfully connects to a
server is to enter a character name.  There are some restrictions to
the name you can choose, but alphanumeric characters are all safe.

After entering the name, you will then be prompted for a password.  If
creating a new character, enter whatever you want your password to be.
If you get a 'login incorrect' someone else already has that character
name with a different password - try another name.  If no one has used
that name, you will be prompted for the password again to confirm it.

You now start the character creation process.  It is beyond the scope
of the document to fully describe the pros and cons of different
stats and classes.  The creation process has different options for
swapping stats and choosing a class.

Once you have chosen your class, you will find yourself in a nexus
that allows you to select a map on which to start playing.  The best
place to start is directly above you as it contains a miniature map
that is designed to be a tutorial on the basics of playing Crossfire.
More experienced players may elect to skip this training map and may
start playing in either Scorn or Navar.  Navar is only recommended
for experienced players.

The arrow keys will move you in the various directions.

If starting in Scorn, there will be a red building almost directly
above you - this is the inn where you save your character.  There
are some signs to your right.  To read them, move on top of them and
press the 'a' key.  This applies the object below you - in the case
of signs, it reads it.  In the case of buildings, it will cause you
to enter the building.

To the left of the signs are two small buildings - these are more
beginner dungeons.  Enter them, and follow the directions on the
signs.   They provide another pretty good tutorial on some of the
basic actions and features of the game.

To enter extended commands, type the ' (apostrophe) followed by the
command.  An example would be 'help (apostrophe followed by the
help command).  Enter command to execute the command.

.SH USEFUL EXTENDED COMMANDS

.TP
.B savewinpos savedefaults
These commands were described in the SAVED DEFAULTS options above.

.TP
.B scroll
This toggles whether or the information windows scrolls when it gets to
the bottom of the window or wraps to the top.  Wrapping is slightly less
CPU intensive, but is generally harder to read.

.TP
.B bind unbind
bind is used to add new keybindings.  Do you want to be able to press
one key to cast a fireball?  This is what the bind command does.
\'help bind gives much more detailed information.  Once a command
is bound, it is stored in ~/.crossfire/keys and will be used in future
plays.
.TP
.B scroll
crossfire-client-x11 only. Toggles between scroll and wrap
mode.  In wrap mode, when text gets to the bottom of the
message window, it starts new messages at the top.
Scroll is only really useful on very slow systems where
the performance hit of scrolling the window is too costly.
.TP
.B magicmap
Displays the data from the last time the magic mapping
spell was cast.  This information can be completely useless
if you are now on another map.
.TP
.B cwindow <number>
Specifies the number of unprocessed commands to the server.
The server processes player commands as the character has
actions to perform them - having this number too high
can result in extended lengths of time that after you stop
entering commands the character is still performing actions.
Having this value too low on slow links can result in the
character sitting idle even though they have an action
coming to them.


.SH FILES
.TP
.B ~/.crossfire
This is a directory that is created that is used to store various
files.
.TP
.B ~/.crossfire/gdefaults2
This contains default settings.  This file can in theory be edited
by hand - just be careful to keep the same case and whitespace.
.TP
.B ~/.crossfire/image-cache
This directory is used for the image cache if -cache is being used.
.TP
.B ~/.crossfire/keys
This contains keybindings you have edited.  This file can also be
theoretically edited - changing existing entries is much safer than
trying to figure out the syntax for new entries.
.TP
.B ~/.crossfire/*.pos
Window layout positions and sizes to use.  The actual file name is
based upon the name of the window layout file in use (-window_xml).
The file may be edited by hand.

.PP
Please let the maintainers know about any bugs found in the client.
.SH AUTHOR
Copyright (C) 2008 Mark Wedel & Crossfire Development Team
GTK port by David Sundqvist (azzie@netpolicy.com)
SDL support added by Scott MacFiggen (smurf@CSUA.Berkeley.EDU)
LibGlade port by Kevin Bulgrien (kbulgrien@att.net)

There are a great many other contributors to both the client and server
that are not mentioned here.

.ft R
.RE
.LP
.\" This program is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.

.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.

.\" You should have received a copy of the GNU General Public License
.\" along with this program; if not, write to the Free Software
.\" Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

.\" The author can be reached via e-mail to crossfire-devel@real-time.com
