/*                                                                           *
 *   This file is part of the ESO X-shooter Pipeline                         *
 *   Copyright (C) 2006 European Southern Observatory                        *
 *                                                                           *
 *   This library is free software; you can redistribute it and/or modify    *
 *   it under the terms of the GNU General Public License as published by    *
 *   the Free Software Foundation; either version 2 of the License, or       *
 *   (at your option) any later version.                                     *
 *                                                                           *
 *   This program is distributed in the hope that it will be useful,         *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *   GNU General Public License for more details.                            *
 *                                                                           *
 *   You should have received a copy of the GNU General Public License       *
 *   along with this program; if not, write to the Free Software             *
 *   Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA    *
 *                                                                           */

/*
 * $Author: amodigli $
 * $Date: 2013-10-02 15:48:17 $
 * $Revision: 1.231 $
 * $Name: not supported by cvs2svn $
 */

#ifndef XSH_DFS_H
#define XSH_DFS_H

/*-----------------------------------------------------------------------------
   				   Includes
 ----------------------------------------------------------------------------*/
#include <string.h>
#include <xsh_data_instrument.h>
#include <cpl.h>
#include <xsh_dump.h>

/*-----------------------------------------------------------------------------
   				   Define
 ----------------------------------------------------------------------------*/

/* Define here the DO.CATG keywords */

/* RAW */


#define XSH_IFU_CFG_TAB "IFU_CFG_TAB"
#define XSH_IFU_CFG_TAB_UVB "IFU_CFG_TAB_UVB"
#define XSH_IFU_CFG_TAB_VIS "IFU_CFG_TAB_VIS"
#define XSH_IFU_CFG_TAB_NIR "IFU_CFG_TAB_NIR"

#define XSH_IFU_CFG_COR "IFU_CFG_COR"
#define XSH_IFU_CFG_COR_UVB "IFU_CFG_COR_UVB"
#define XSH_IFU_CFG_COR_VIS "IFU_CFG_COR_VIS"
#define XSH_IFU_CFG_COR_NIR "IFU_CFG_COR_NIR"

#define XSH_IFU_MAP_SKY "IFU_MAP_SKY"
#define XSH_IFU_MAP_SKY_UVB "IFU_MAP_SKY_UVB"
#define XSH_IFU_MAP_SKY_VIS "IFU_MAP_SKY_VIS"
#define XSH_IFU_MAP_SKY_NIR "IFU_MAP_SKY_NIR"

#define XSH_ARC_LINE_LIST_INTMON "ARC_LINE_LIST_INTMON"
#define XSH_ARC_LINE_LIST_INTMON_UVB "ARC_LINE_LIST_INTMON_UVB"
#define XSH_ARC_LINE_LIST_INTMON_VIS "ARC_LINE_LIST_INTMON_VIS"
#define XSH_ARC_LINE_LIST_INTMON_NIR "ARC_LINE_LIST_INTMON_NIR"

#define XSH_CORRECTIFU_LAMBDAREF_PIPE_UVB 400
#define XSH_CORRECTIFU_LAMBDAREF_PIPE_VIS 700
#define XSH_CORRECTIFU_LAMBDAREF_PIPE_NIR 1500

#define XSH_SLIT_BIN_SIZE_AUTO_PIPE_UVB 0.16
#define XSH_SLIT_BIN_SIZE_AUTO_PIPE_VIS 0.16
#define XSH_SLIT_BIN_SIZE_AUTO_PIPE_NIR 0.21

#define XSH_WAVE_BIN_SIZE_AUTO_PIPE_UVB 0.04
#define XSH_WAVE_BIN_SIZE_AUTO_PIPE_VIS 0.04
#define XSH_WAVE_BIN_SIZE_AUTO_PIPE_NIR 0.1


#define XSH_SLIT_BIN_SIZE_NARROW_SLIT_UVB 0.16
#define XSH_SLIT_BIN_SIZE_NARROW_SLIT_VIS 0.16
#define XSH_SLIT_BIN_SIZE_NARROW_SLIT_NIR 0.21

#define XSH_WAVE_BIN_SIZE_NARROW_SLIT_UVB 0.015
#define XSH_WAVE_BIN_SIZE_NARROW_SLIT_VIS 0.015
#define XSH_WAVE_BIN_SIZE_NARROW_SLIT_NIR 0.06


#define XSH_SLIT_BIN_SIZE_BROAD_SLIT_UVB 0.16
#define XSH_SLIT_BIN_SIZE_BROAD_SLIT_VIS 0.16
#define XSH_SLIT_BIN_SIZE_BROAD_SLIT_NIR 0.21

#define XSH_WAVE_BIN_SIZE_BROAD_SLIT_UVB 0.02
#define XSH_WAVE_BIN_SIZE_BROAD_SLIT_VIS 0.02
#define XSH_WAVE_BIN_SIZE_BROAD_SLIT_NIR 0.06


#define XSH_SLIT_BIN_SIZE_PIPE_UVB XSH_SLIT_BIN_SIZE_BROAD_SLIT_UVB
#define XSH_SLIT_BIN_SIZE_PIPE_VIS XSH_SLIT_BIN_SIZE_BROAD_SLIT_VIS
#define XSH_SLIT_BIN_SIZE_PIPE_NIR XSH_SLIT_BIN_SIZE_BROAD_SLIT_NIR

#define XSH_WAVE_BIN_SIZE_PIPE_UVB XSH_WAVE_BIN_SIZE_BROAD_SLIT_UVB
#define XSH_WAVE_BIN_SIZE_PIPE_VIS XSH_WAVE_BIN_SIZE_BROAD_SLIT_VIS
#define XSH_WAVE_BIN_SIZE_PIPE_NIR XSH_WAVE_BIN_SIZE_BROAD_SLIT_NIR


#define XSH_DRS_MBIAS         "DRS_MBIAS"
#define XSH_DRS_MBIAS_UVB     "DRS_MBIAS_UVB"
#define XSH_DRS_MBIAS_VIS     "DRS_MBIAS_VIS"
#define XSH_DRS_MBIAS_NIR     "DRS_MBIAS_NIR"

#define XSH_DRS_MDARK         "DRS_MDARK"
#define XSH_DRS_MDARK_UVB     "DRS_MDARK_UVB"
#define XSH_DRS_MDARK_VIS     "DRS_MDARK_VIS"
#define XSH_DRS_MDARK_NIR     "DRS_MDARK_NIR"

#define XSH_DRS         "DRS"
#define XSH_DRS_UVB     "DRS_UVB"
#define XSH_DRS_VIS     "DRS_VIS"
#define XSH_DRS_NIR     "DRS_NIR"

#define XSH_RESP_FIT_POINTS_CAT         "RESP_FIT_POINTS_CAT"
#define XSH_RESP_FIT_POINTS_CAT_UVB     "RESP_FIT_POINTS_CAT_UVB"
#define XSH_RESP_FIT_POINTS_CAT_VIS     "RESP_FIT_POINTS_CAT_VIS"
#define XSH_RESP_FIT_POINTS_CAT_NIR     "RESP_FIT_POINTS_CAT_NIR"


#define XSH_LINEARITY "LINEARITY"

#define XSH_LINGAIN "LINGAIN"
#define XSH_LINGAIN_UVB "LINGAIN_UVB"
#define XSH_LINGAIN_VIS "LINGAIN_VIS"
#define XSH_LINGAIN_NIR "LINGAIN_NIR"

#define XSH_TRACE "TRACE"

#define XSH_IFU_DETECT_IFU_TRACE     "IFU_DETECT_IFU_TRACE"
#define XSH_IFU_DETECT_IFU_TRACE_UVB "IFU_DETECT_IFU_TRACE_UVB"
#define XSH_IFU_DETECT_IFU_TRACE_VIS "IFU_DETECT_IFU_TRACE_VIS"
#define XSH_IFU_DETECT_IFU_TRACE_NIR "IFU_DETECT_IFU_TRACE_NIR"

#define XSH_SLIT_MAP_MODEL         "SLIT_MAP"
#define XSH_SLIT_MAP_MODEL_UVB     "SLIT_MAP_UVB"
#define XSH_SLIT_MAP_MODEL_VIS     "SLIT_MAP_VIS"
#define XSH_SLIT_MAP_MODEL_NIR     "SLIT_MAP_NIR"

#define XSH_SLIT_MAP_POLY         "SLIT_MAP"
#define XSH_SLIT_MAP_POLY_UVB     "SLIT_MAP_UVB"
#define XSH_SLIT_MAP_POLY_VIS     "SLIT_MAP_VIS"
#define XSH_SLIT_MAP_POLY_NIR     "SLIT_MAP_NIR"

#define XSH_SLIT_STARE_REMOVE_CRH     "SLIT_STARE_REMOVE_CRH"
#define XSH_SLIT_STARE_REMOVE_CRH_UVB "SLIT_STARE_REMOVE_CRH_UVB"
#define XSH_SLIT_STARE_REMOVE_CRH_VIS "SLIT_STARE_REMOVE_CRH_VIS"
#define XSH_SLIT_STARE_REMOVE_CRH_NIR "SLIT_STARE_REMOVE_CRH_NIR"

#define XSH_IFU_STARE_REMOVE_CRH     "IFU_STARE_REMOVE_CRH"
#define XSH_IFU_STARE_REMOVE_CRH_UVB "IFU_STARE_REMOVE_CRH_UVB"
#define XSH_IFU_STARE_REMOVE_CRH_VIS "IFU_STARE_REMOVE_CRH_VIS"
#define XSH_IFU_STARE_REMOVE_CRH_NIR "IFU_STARE_REMOVE_CRH_NIR"

#define XSH_BIAS_REMOVE_CRH     "BIAS_REMOVE_CRH"
#define XSH_BIAS_REMOVE_CRH_UVB "BIAS_REMOVE_CRH_UVB"
#define XSH_BIAS_REMOVE_CRH_VIS "BIAS_REMOVE_CRH_VIS"
#define XSH_BIAS_REMOVE_CRH_NIR "BIAS_REMOVE_CRH_NIR"

#define XSH_FLAT_REMOVE_CRH     "FLAT_REMOVE_CRH"
#define XSH_FLAT_REMOVE_CRH_UVB "FLAT_REMOVE_CRH_UVB"
#define XSH_FLAT_REMOVE_CRH_VIS "FLAT_REMOVE_CRH_VIS"
#define XSH_FLAT_REMOVE_CRH_NIR "FLAT_REMOVE_CRH_NIR"

#define XSH_HIGH_ABS_WIN     "HIGH_ABS_WIN"
#define XSH_HIGH_ABS_WIN_UVB "HIGH_ABS_WIN_UVB"
#define XSH_HIGH_ABS_WIN_VIS "HIGH_ABS_WIN_VIS"
#define XSH_HIGH_ABS_WIN_NIR "HIGH_ABS_WIN_NIR"

#define XSH_TELL_MOD_CAT     "TELL_MOD_CAT"
#define XSH_TELL_MOD_CAT_UVB "TELL_MOD_CAT_UVB"
#define XSH_TELL_MOD_CAT_VIS "TELL_MOD_CAT_VIS"
#define XSH_TELL_MOD_CAT_NIR "TELL_MOD_CAT_NIR"


#define XSH_ONOFF_REMOVE_CRH     "ONOFF_REMOVE_CRH"
#define XSH_ONOFF_REMOVE_CRH_UVB "ONOFF_REMOVE_CRH_UVB"
#define XSH_ONOFF_REMOVE_CRH_VIS "ONOFF_REMOVE_CRH_VIS"
#define XSH_ONOFF_REMOVE_CRH_NIR "ONOFF_REMOVE_CRH_NIR"

#define XSH_FLAT_QTH_SLIT_UVB "FLAT_QTH_SLIT_UVB"
#define XSH_FLAT_D2_SLIT_UVB "FLAT_D2_SLIT_UVB"
#define XSH_FLAT_SLIT_VIS "FLAT_SLIT_VIS"
#define XSH_FLAT_SLIT_NIR "FLAT_SLIT_NIR_ON"
#define XSH_FLAT_SLIT_OFF "FLAT_SLIT_NIR_OFF"
#define XSH_FLAT_QTH_IFU_UVB "FLAT_QTH_IFU_UVB"
#define XSH_FLAT_D2_IFU_UVB "FLAT_D2_IFU_UVB"
#define XSH_FLAT_IFU_VIS "FLAT_IFU_VIS"
#define XSH_FLAT_IFU_NIR "FLAT_IFU_NIR_ON"
#define XSH_FLAT_IFU_OFF "FLAT_IFU_NIR_OFF"

#define XSH_MEASURE_FLAT_SLIT_EDGES "MEASURE_FLAT_SLIT_EDGES"
#define XSH_MEASURE_FLAT_D2_SLIT_EDGES_UVB "MEASURE_FLAT_D2_SLIT_EDGES_UVB"
#define XSH_MEASURE_FLAT_QTH_SLIT_EDGES_UVB "MEASURE_FLAT_QTH_SLIT_EDGES_UVB"
#define XSH_MEASURE_FLAT_SLIT_EDGES_UVB "MEASURE_FLAT_SLIT_EDGES_UVB"
#define XSH_MEASURE_FLAT_SLIT_EDGES_VIS "MEASURE_FLAT_SLIT_EDGES_VIS"
#define XSH_MEASURE_FLAT_SLIT_EDGES_NIR "MEASURE_FLAT_SLIT_EDGES_NIR"

#define XSH_MEASURE_FLAT_IFU_EDGES "MEASURE_FLAT_IFU_EDGES"
#define XSH_MEASURE_FLAT_D2_IFU_EDGES_UVB "MEASURE_FLAT_D2_IFU_EDGES_UVB"
#define XSH_MEASURE_FLAT_QTH_IFU_EDGES_UVB "MEASURE_FLAT_QTH_IFU_EDGES_UVB"
#define XSH_MEASURE_FLAT_IFU_EDGES_UVB "MEASURE_FLAT_IFU_EDGES_UVB"
#define XSH_MEASURE_FLAT_IFU_EDGES_VIS "MEASURE_FLAT_IFU_EDGES_VIS"
#define XSH_MEASURE_FLAT_IFU_EDGES_NIR "MEASURE_FLAT_IFU_EDGES_NIR"

#define XSH_EFFICIENCY "EFFICIENCY"

#define XSH_BIAS "BIAS"
#define XSH_DARK "DARK"
#define XSH_FMTCHK "FMTCHK"
#define XSH_FLAT "FLAT"
#define XSH_ORDERDEF "ORDERDEF"
#define XSH_WAVECAL "ARC"
#define XSH_WAVE "WAVE"
#define XSH_OBJECT_SLIT_STARE "OBJECT_SLIT_STARE"
#define XSH_FLUX_OFFSET "STD_FLUX_OFFSET"
#define XSH_OBJECT_SLIT_NOD "OBJECT_SLIT_NOD"
#define XSH_OBJECT_SLIT_OFFSET "OBJECT_SLIT_OFFSET"
#define XSH_OBJECT_IFU_STARE "OBJECT_IFU_STARE"
#define XSH_OBJECT_IFU_OFFSET "OBJECT_IFU_OFFSET"

#define XSH_SKY_SLIT "SKY_SLIT"
#define XSH_SKY_IFU "SKY_IFU"

#define XSH_IMA "IMA"
#define XSH_IMA_UVB "IMA_UVB"
#define XSH_IMA_VIS "IMA_VIS"
#define XSH_IMA_NIR "IMA_NIR"

#define XSH_RAW_IMA_SLIT     "RAW_IMA_SLIT"
#define XSH_RAW_IMA_SLIT_VIS "RAW_IMA_SLIT_VIS"
#define XSH_RAW_IMA_SLIT_UVB "RAW_IMA_SLIT_UVB"
#define XSH_RAW_IMA_SLIT_NIR "RAW_IMA_SLIT_NIR"

#define XSH_RAW_IMA_IFU     "RAW_IMA_IFU"
#define XSH_RAW_IMA_IFU_VIS "RAW_IMA_IFU_VIS"
#define XSH_RAW_IMA_IFU_UVB "RAW_IMA_IFU_UVB"
#define XSH_RAW_IMA_IFU_NIR "RAW_IMA_IFU_NIR"

#define XSH_SKY_SUB_BKPTS "SKY_SUB_BKPTS"
#define XSH_SKY_SUB_BKPTS_UVB "SKY_SUB_BKPTS_UVB"
#define XSH_SKY_SUB_BKPTS_VIS "SKY_SUB_BKPTS_VIS"
#define XSH_SKY_SUB_BKPTS_NIR "SKY_SUB_BKPTS_NIR"

#define XSH_GAIN "GAIN_INFO"
#define XSH_GAIN_UVB "GAIN_INFO_UVB"
#define XSH_GAIN_VIS "GAIN_INFO_VIS"
#define XSH_GAIN_NIR "GAIN_INFO_NIR"

#define XSH_FLUX_STD_TAB "FLUX_STD_TABLE"
#define XSH_FLUX_STD_TAB_UVB "FLUX_STD_TABLE_UVB"
#define XSH_FLUX_STD_TAB_VIS "FLUX_STD_TABLE_VIS"
#define XSH_FLUX_STD_TAB_NIR "FLUX_STD_TABLE_NIR"


#define XSH_FLUX_STD_CAT "FLUX_STD_CATALOG"
#define XSH_FLUX_STD_CAT_UVB "FLUX_STD_CATALOG_UVB"
#define XSH_FLUX_STD_CAT_VIS "FLUX_STD_CATALOG_VIS"
#define XSH_FLUX_STD_CAT_NIR "FLUX_STD_CATALOG_NIR"

#define XSH_EXTCOEFF_TAB "EXTCOEFF_TABLE"
#define XSH_EXTCOEFF_TAB_UVB "EXTCOEFF_TABLE_UVB"
#define XSH_EXTCOEFF_TAB_VIS "EXTCOEFF_TABLE_VIS"
#define XSH_EXTCOEFF_TAB_NIR "EXTCOEFF_TABLE_NIR"



#define XSH_CPIX_MAP     "CPIX_MAP"
#define XSH_CPIX_MAP_UVB "CPIX_MAP_UVB"
#define XSH_CPIX_MAP_VIS "CPIX_MAP_VIS"
#define XSH_CPIX_MAP_NIR "CPIX_MAP_NIR"


#define XSH_HPIX_MAP     "HPIX_MAP"
#define XSH_HPIX_MAP_UVB "HPIX_MAP_UVB"
#define XSH_HPIX_MAP_VIS "HPIX_MAP_VIS"
#define XSH_HPIX_MAP_NIR "HPIX_MAP_NIR"

#define XSH_CRH_MAP "CRH_MAP"
#define XSH_CRH_MAP_UVB "CRH_MAP_UVB"
#define XSH_CRH_MAP_VIS "CRH_MAP_VIS"
#define XSH_CRH_MAP_NIR "CRH_MAP_NIR"


#define XSH_CRH_LIST "CRH_LIST"
#define XSH_CRH_LIST_UVB "CRH_LIST_UVB"
#define XSH_CRH_LIST_VIS "CRH_LIST_VIS"
#define XSH_CRH_LIST_NIR "CRH_LIST_NIR"

#define XSH_STD_FLUX_SLIT_STARE_ORDER1D "STD_FLUX_SLIT_STARE_ORDER1D"
#define XSH_STD_FLUX_SLIT_STARE_ORDER1D_UVB "STD_FLUX_SLIT_STARE_ORDER1D_UVB"
#define XSH_STD_FLUX_SLIT_STARE_ORDER1D_VIS "STD_FLUX_SLIT_STARE_ORDER1D_VIS"
#define XSH_STD_FLUX_SLIT_STARE_ORDER1D_NIR "STD_FLUX_SLIT_STARE_ORDER1D_NIR"


#define XSH_STD_FLUX_SLIT_STARE_MERGE1D "STD_FLUX_SLIT_STARE_MERGE1D"
#define XSH_STD_FLUX_SLIT_STARE_MERGE1D_UVB "STD_FLUX_SLIT_STARE_MERGE1D_UVB"
#define XSH_STD_FLUX_SLIT_STARE_MERGE1D_VIS "STD_FLUX_SLIT_STARE_MERGE1D_VIS"
#define XSH_STD_FLUX_SLIT_STARE_MERGE1D_NIR "STD_FLUX_SLIT_STARE_MERGE1D_NIR"

#define XSH_ORDERPOS_RESID_TAB     "ORDERPOS_RESID_TAB"
#define XSH_ORDERPOS_RESID_TAB_UVB "ORDERPOS_RESID_TAB_UVB"
#define XSH_ORDERPOS_RESID_TAB_VIS "ORDERPOS_RESID_TAB_VIS"
#define XSH_ORDERPOS_RESID_TAB_NIR "ORDERPOS_RESID_TAB_NIR"

#define XSH_DET_LIN_INFO_UVB "DET_LIN_INFO_UVB"
#define XSH_DET_LIN_INFO_VIS "DET_LIN_INFO_VIS"
#define XSH_DET_LIN_INFO_NIR "DET_LIN_INFO_NIR"

#define XSH_GAIN_INFO_UVB "GAIN_INFO_UVB"
#define XSH_GAIN_INFO_VIS "GAIN_INFO_VIS"
#define XSH_GAIN_INFO_NIR "GAIN_INFO_NIR"

#define XSH_COEFFS_CUBE_UVB "COEFFS_CUBE_UVB"
#define XSH_COEFFS_CUBE_VIS "COEFFS_CUBE_VIS"
#define XSH_COEFFS_CUBE_NIR "COEFFS_CUBE_NIR"


#define XSH_BP_MAP       "BP_MAP"
#define XSH_BP_MAP_UVB   "BP_MAP_UVB"
#define XSH_BP_MAP_VIS   "BP_MAP_VIS"
#define XSH_BP_MAP_NIR   "BP_MAP_NIR"

#define XSH_BP_MAP_NP       "BP_MAP_NP"
#define XSH_BP_MAP_NP_UVB   "BP_MAP_NP_UVB"
#define XSH_BP_MAP_NP_VIS   "BP_MAP_NP_VIS"
#define XSH_BP_MAP_NP_NIR   "BP_MAP_NP_NIR"


#define XSH_BP_MAP_PN       "BP_MAP_PN"
#define XSH_BP_MAP_PN_UVB   "BP_MAP_PN_UVB"
#define XSH_BP_MAP_PN_VIS   "BP_MAP_PN_VIS"
#define XSH_BP_MAP_PN_NIR   "BP_MAP_PN_NIR"


#define XSH_BP_MAP_RP      "BP_MAP_RP"
#define XSH_BP_MAP_RP_UVB  "BP_MAP_RP_UVB"
#define XSH_BP_MAP_RP_VIS  "BP_MAP_RP_VIS"
#define XSH_BP_MAP_RP_NIR  "BP_MAP_RP_NIR"

#define XSH_BP_MAP_NL      "BP_MAP_NL"
#define XSH_BP_MAP_NL_UVB  "BP_MAP_NL_UVB"
#define XSH_BP_MAP_NL_VIS  "BP_MAP_NL_VIS"
#define XSH_BP_MAP_NL_NIR  "BP_MAP_NL_NIR"

#define XSH_RAW_BP_MAP_NL      "RAW_BP_MAP_NL"
#define XSH_RAW_BP_MAP_NL_UVB  "RAW_BP_MAP_NL_UVB"
#define XSH_RAW_BP_MAP_NL_VIS  "RAW_BP_MAP_NL_VIS"
#define XSH_RAW_BP_MAP_NL_NIR  "RAW_BP_MAP_NL_NIR"

#define XSH_AUTOCORR_UVB "AUTOCORR_UVB"
#define XSH_AUTOCORR_VIS "AUTOCORR_VIS"
#define XSH_AUTOCORR_NIR "AUTOCORR_NIR"

#define XSH_DIFF_FLAT_UVB "DIFF_FLAT_UVB"
#define XSH_DIFF_FLAT_VIS "DIFF_FLAT_VIS"
#define XSH_DIFF_FLAT_NIR "DIFF_FLAT_NIR"

#define XSH_GUESS_LINES_POS     "GUESS_LINES_POS"
#define XSH_GUESS_LINES_POS_UVB "GUESS_LINES_POS_UVB"
#define XSH_GUESS_LINES_POS_VIS "GUESS_LINES_POS_VIS"
#define XSH_GUESS_LINES_POS_NIR "GUESS_LINES_POS_NIR"

#define XSH_LINEARITY_UVB "LINEARITY_UVB"
#define XSH_LINEARITY_VIS "LINEARITY_VIS"
#define XSH_LINEARITY_NIR "LINEARITY_NIR"
#define XSH_LINEARITY_UVB_ON  "LINEARITY_UVB_ON"
#define XSH_LINEARITY_UVB_OFF "LINEARITY_UVB_OFF"
#define XSH_LINEARITY_VIS_ON  "LINEARITY_VIS_ON"
#define XSH_LINEARITY_VIS_OFF "LINEARITY_VIS_OFF"
#define XSH_LINEARITY_NIR_ON  "LINEARITY_NIR_ON"
#define XSH_LINEARITY_NIR_OFF "LINEARITY_NIR_OFF"

#define XSH_WAVECAL_NIR "WAVECAL_NIR"
#define XSH_BIAS_UVB "BIAS_UVB"
#define XSH_BIAS_VIS "BIAS_VIS"
#define XSH_BIAS_NIR "BIAS_NIR" //not real, added to use XSH_GET_TAG_ARM macro
#define XSH_BIAS_AGC "BIAS_AGC"
#define XSH_DARK_UVB "DARK_UVB"
#define XSH_DARK_VIS "DARK_VIS"
#define XSH_DARK_NIR "DARK_NIR"
#define XSH_DARK_AGC "DARK_AGC"
#define XSH_DARK_NIR_ON "DARK_NIR_ON"
#define XSH_DARK_NIR_OFF "DARK_NIR_OFF"
#define XSH_FMTCHK_UVB "FMTCHK_UVB"
#define XSH_FMTCHK_VIS "FMTCHK_VIS"
#define XSH_FMTCHK_NIR "FMTCHK_NIR_ON"
#define XSH_FMTCHK_OFF "FMTCHK_NIR_OFF"

#define XSH_ORDERDEF_QTH_UVB "ORDERDEF_QTH_UVB"
#define XSH_ORDERDEF_D2_UVB "ORDERDEF_D2_UVB"
#define XSH_ORDERDEF_VIS "ORDERDEF_VIS"
#define XSH_ORDERDEF_NIR "ORDERDEF_NIR_ON"
#define XSH_ORDERDEF_OFF "ORDERDEF_NIR_OFF"

#define XSH_FLAT_QTH_SLIT_UVB "FLAT_QTH_SLIT_UVB"
#define XSH_FLAT_D2_SLIT_UVB "FLAT_D2_SLIT_UVB"
#define XSH_FLAT_SLIT_VIS "FLAT_SLIT_VIS"
#define XSH_FLAT_SLIT_NIR "FLAT_SLIT_NIR_ON"
#define XSH_FLAT_SLIT_OFF "FLAT_SLIT_NIR_OFF"
#define XSH_FLAT_QTH_IFU_UVB "FLAT_QTH_IFU_UVB"
#define XSH_FLAT_D2_IFU_UVB "FLAT_D2_IFU_UVB"
#define XSH_FLAT_IFU_VIS "FLAT_IFU_VIS"
#define XSH_FLAT_IFU_NIR "FLAT_IFU_NIR_ON"
#define XSH_FLAT_IFU_OFF "FLAT_IFU_NIR_OFF"

#define XSH_WAVE_UVB "WAVE_UVB"
#define XSH_WAVE_VIS "WAVE_VIS"
#define XSH_WAVE_NIR "WAVE_NIR_ON"
#define XSH_WAVE_OFF "WAVE_NIR_OFF"
#define XSH_ARC_SLIT_UVB "ARC_SLIT_UVB"
#define XSH_ARC_SLIT_VIS "ARC_SLIT_VIS"
#define XSH_ARC_SLIT_NIR "ARC_SLIT_NIR_ON"
#define XSH_ARC_SLIT_OFF "ARC_SLIT_NIR_OFF"
#define XSH_ARC_IFU_UVB "ARC_IFU_UVB"
#define XSH_ARC_IFU_VIS "ARC_IFU_VIS"
#define XSH_ARC_IFU_NIR "ARC_IFU_NIR_ON"
#define XSH_ARC_IFU_OFF "ARC_IFU_NIR_OFF"
#define XSH_FLEX_UVB "FLEX_UVB"
#define XSH_FLEX_VIS "FLEX_VIS"
#define XSH_FLEX_NIR "FLEX_NIR"
#define XSH_TRACE_UVB "TRACE_UVB"
#define XSH_TRACE_VIS "TRACE_VIS"
#define XSH_TRACE_NIR "TRACE_NIR"

#define XSH_STD_TELL_SLIT_UVB "STD_TELL_SLIT_UVB"
#define XSH_STD_TELL_SLIT_VIS "STD_TELL_SLIT_VIS"
#define XSH_STD_TELL_SLIT_NIR "STD_TELL_SLIT_NIR"

#define XSH_STD_FLUX_SLIT_STARE "STD_FLUX_SLIT_STARE"
#define XSH_STD_FLUX_SLIT_STARE_UVB "STD_FLUX_SLIT_STARE_UVB"
#define XSH_STD_FLUX_SLIT_STARE_VIS "STD_FLUX_SLIT_STARE_VIS"
#define XSH_STD_FLUX_SLIT_STARE_NIR "STD_FLUX_SLIT_STARE_NIR"


#define XSH_STD_FLUX_IFU_STARE "STD_FLUX_IFU_STARE"
#define XSH_STD_FLUX_IFU_STARE_UVB "STD_FLUX_IFU_STARE_UVB"
#define XSH_STD_FLUX_IFU_STARE_VIS "STD_FLUX_IFU_STARE_VIS"
#define XSH_STD_FLUX_IFU_STARE_NIR "STD_FLUX_IFU_STARE_NIR"


/* telluric STD are observed only in stare mode */
#define XSH_STD_TELL_SLIT_STARE "STD_TELL_SLIT_STARE"
#define XSH_STD_TELL_SLIT_STARE_UVB "STD_TELL_SLIT_STARE_UVB"
#define XSH_STD_TELL_SLIT_STARE_VIS "STD_TELL_SLIT_STARE_VIS"
#define XSH_STD_TELL_SLIT_STARE_NIR "STD_TELL_SLIT_STARE_NIR"



#define XSH_STD_TELL_IFU_STARE "STD_TELL_IFU_STARE"
#define XSH_STD_TELL_IFU_STARE_UVB "STD_TELL_IFU_STARE_UVB"
#define XSH_STD_TELL_IFU_STARE_VIS "STD_TELL_IFU_STARE_VIS"
#define XSH_STD_TELL_IFU_STARE_NIR "STD_TELL_IFU_STARE_NIR"


#define XSH_STD_TELL_IFU_OFFSET "STD_TELL_IFU_OFFSET"
#define XSH_STD_TELL_IFU_OFFSET_UVB "STD_TELL_IFU_OFFSET_UVB"
#define XSH_STD_TELL_IFU_OFFSET_VIS "STD_TELL_IFU_OFFSET_VIS"
#define XSH_STD_TELL_IFU_OFFSET_NIR "STD_TELL_IFU_OFFSET_NIR"


#define XSH_STD_TELL_SLIT_NOD "STD_TELL_SLIT_NOD"
#define XSH_STD_TELL_SLIT_NOD_UVB "STD_TELL_SLIT_NOD_UVB"
#define XSH_STD_TELL_SLIT_NOD_VIS "STD_TELL_SLIT_NOD_VIS"
#define XSH_STD_TELL_SLIT_NOD_NIR "STD_TELL_SLIT_NOD_NIR"

#define XSH_STD_FLUX_SLIT_NOD "STD_FLUX_SLIT_NOD"
#define XSH_STD_FLUX_SLIT_NOD_UVB "STD_FLUX_SLIT_NOD_UVB"
#define XSH_STD_FLUX_SLIT_NOD_VIS "STD_FLUX_SLIT_NOD_VIS"
#define XSH_STD_FLUX_SLIT_NOD_NIR "STD_FLUX_SLIT_NOD_NIR"


/* flux STD are observed only in offset mode */
#define XSH_STD_FLUX_SLIT_OFFSET "STD_FLUX_SLIT_OFFSET"
#define XSH_STD_FLUX_SLIT_OFFSET_UVB "STD_FLUX_SLIT_OFFSET_UVB"
#define XSH_STD_FLUX_SLIT_OFFSET_VIS "STD_FLUX_SLIT_OFFSET_VIS"
#define XSH_STD_FLUX_SLIT_OFFSET_NIR "STD_FLUX_SLIT_OFFSET_NIR"


#define XSH_STD_FLUX_IFU_OFFSET "STD_FLUX_IFU_OFFSET"
#define XSH_STD_FLUX_IFU_OFFSET_UVB "STD_FLUX_IFU_OFFSET_UVB"
#define XSH_STD_FLUX_IFU_OFFSET_VIS "STD_FLUX_IFU_OFFSET_VIS"
#define XSH_STD_FLUX_IFU_OFFSET_NIR "STD_FLUX_IFU_OFFSET_NIR"

#define XSH_STD_FLUX_NOD "STD_FLUX_NOD"
#define XSH_STD_FLUX_NOD_UVB "STD_FLUX_NOD_UVB"
#define XSH_STD_FLUX_NOD_VIS "STD_FLUX_NOD_VIS"
#define XSH_STD_FLUX_NOD_NIR "STD_FLUX_NOD_NIR"
#define XSH_OBJECT_SLIT_STARE_UVB "OBJECT_SLIT_STARE_UVB"
#define XSH_OBJECT_SLIT_STARE_VIS "OBJECT_SLIT_STARE_VIS"
#define XSH_OBJECT_SLIT_STARE_NIR "OBJECT_SLIT_STARE_NIR"
#define XSH_OBJECT_SLIT_NOD_UVB "OBJECT_SLIT_NOD_UVB"
#define XSH_OBJECT_SLIT_NOD_VIS "OBJECT_SLIT_NOD_VIS"
#define XSH_OBJECT_SLIT_NOD_NIR "OBJECT_SLIT_NOD_NIR"
#define XSH_OBJECT_SLIT_OFFSET_UVB "OBJECT_SLIT_OFFSET_UVB"
#define XSH_OBJECT_SLIT_OFFSET_VIS "OBJECT_SLIT_OFFSET_VIS"
#define XSH_OBJECT_SLIT_OFFSET_NIR "OBJECT_SLIT_OFFSET_NIR"
#define XSH_OBJECT_IFU_STARE_UVB "OBJECT_IFU_STARE_UVB"
#define XSH_OBJECT_IFU_STARE_VIS "OBJECT_IFU_STARE_VIS"
#define XSH_OBJECT_IFU_STARE_NIR "OBJECT_IFU_STARE_NIR"
#define XSH_OBJECT_IFU_OFFSET_UVB "OBJECT_IFU_OFFSET_UVB"
#define XSH_OBJECT_IFU_OFFSET_VIS "OBJECT_IFU_OFFSET_VIS"
#define XSH_OBJECT_IFU_OFFSET_NIR "OBJECT_IFU_OFFSET_NIR"
#define XSH_SKY_SLIT_UVB "SKY_SLIT_UVB"
#define XSH_SKY_SLIT_VIS "SKY_SLIT_VIS"
#define XSH_SKY_SLIT_NIR "SKY_SLIT_NIR"
#define XSH_SKY_IFU_UVB "SKY_IFU_UVB"
#define XSH_SKY_IFU_VIS "SKY_IFU_VIS"
#define XSH_SKY_IFU_NIR "SKY_IFU_NIR"

#define XSH_AFC_POS "AFC_POS"
#define XSH_AFC_POS_UVB "AFC_POS_UVB"
#define XSH_AFC_POS_VIS "AFC_POS_VIS"
#define XSH_AFC_POS_NIR "AFC_POS_NIR"
#define XSH_AFC_SLT "AFC_SLT"
#define XSH_AFC_SLT_UVB "AFC_SLT_UVB"
#define XSH_AFC_SLT_VIS "AFC_SLT_VIS"
#define XSH_AFC_SLT_NIR "AFC_SLT_NIR"

#define XSH_AFC_CAL     "AFC_CAL"
#define XSH_AFC_CAL_UVB "AFC_CAL_UVB"
#define XSH_AFC_CAL_VIS "AFC_CAL_VIS"
#define XSH_AFC_CAL_NIR "AFC_CAL_NIR"
#define XSH_AFC_ATT     "AFC_ATT"
#define XSH_AFC_ATT_UVB "AFC_ATT_UVB"
#define XSH_AFC_ATT_VIS "AFC_ATT_VIS"
#define XSH_AFC_ATT_NIR "AFC_ATT_NIR"

/* CALIB */
#define XSH_MASTER_BIAS "MASTER_BIAS"
#define XSH_MASTER_DARK "MASTER_DARK"
#define XSH_ORDER_TAB_RECOV "ORDER_TAB_RECOV"
#define XSH_ORDER_TAB_GUESS "ORDER_TAB_GUESS"
#define XSH_ORDER_TAB_CENTR "ORDER_TAB_CENTR"
#define XSH_ORDER_TAB_EDGES "ORDER_TAB_EDGES"
#define XSH_WAVE_TAB_GUESS "WAVE_TAB_GUESS"
#define XSH_WAVE_TAB_2D "WAVE_TAB_2D"
#define XSH_WAVE_TAB_AFC "WAVE_TAB_AFC"
#define XSH_WAVE_TAB_ARC "WAVE_TAB_ARC"
#define XSH_WAVE_TAB_ARC_DOWN_IFU "WAVE_TAB_ARC_DOWN_IFU"
#define XSH_WAVE_TAB_ARC_CEN_IFU "WAVE_TAB_ARC_CEN_IFU"
#define XSH_WAVE_TAB_ARC_UP_IFU "WAVE_TAB_ARC_UP_IFU"

#define XSH_RESID_TAB "RESID_TAB"
#define XSH_RESID_TAB_DOWN_IFU "RESID_TAB_DOWN_IFU"
#define XSH_RESID_TAB_CEN_IFU "RESID_TAB_CEN_IFU"
#define XSH_RESID_TAB_UP_IFU "RESID_TAB_UP_IFU"

#define XSH_RESID_ORDER_TAB "RESID_ORDER_TAB"
#define XSH_MASTER_FLAT "MASTER_FLAT"

#define XSH_TILT_TAB "TILT_TAB"
#define XSH_TILT_TAB_DOWN_IFU "TILT_TAB_DOWN_IFU"
#define XSH_TILT_TAB_CEN_IFU "TILT_TAB_CEN_IFU"
#define XSH_TILT_TAB_UP_IFU "TILT_TAB_UP_IFU"

#define XSH_SHIFT_TAB "SHIFT_TAB"
#define XSH_SHIFT_TAB_SLIT "SHIFT_TAB_SLIT"
#define XSH_SHIFT_TAB_IFU "SHIFT_TAB_IFU"
#define XSH_SHIFT_TAB_SLIT_UVB "SHIFT_TAB_SLIT_UVB"
#define XSH_SHIFT_TAB_SLIT_VIS "SHIFT_TAB_SLIT_VIS"
#define XSH_SHIFT_TAB_SLIT_NIR "SHIFT_TAB_SLIT_NIR"
#define XSH_SHIFT_TAB_IFU_UVB "SHIFT_TAB_IFU_UVB"
#define XSH_SHIFT_TAB_IFU_VIS "SHIFT_TAB_IFU_VIS"
#define XSH_SHIFT_TAB_IFU_NIR "SHIFT_TAB_IFU_NIR"


#define XSH_ORDER1D "ORDER1D"
#define XSH_ORDER2D "ORDER2D"
#define XSH_ORDER1D_IFU "ORDER1D_IFU"
#define XSH_ORDER2D_IFU "ORDER2D_IFU"

#define XSH_MERGE1D "MERGE1D"
#define XSH_MERGE_EXT1D "MERGE_EXT1D"
#define XSH_MERGE2D "MERGE2D"
#define XSH_MERGE3D_IFU "MERGE3D_IFU"

#define XSH_PHYS_MERGE1D "PHYS_MERGE1D"
#define XSH_PHYS_MERGE2D "PHYS_MERGE2D"

#define XSH_LOCALIZATION "LOC_TABLE"
#define XSH_SLICE_OFFSET "SLICE_OFFSET_TABLE"


#define XSH_PICKUP_NOISE_MAP     "PICKUP_NOISE_MAP"
#define XSH_PICKUP_NOISE_MAP_UVB "PICKUP_NOISE_MAP_UVB"
#define XSH_PICKUP_NOISE_MAP_VIS "PICKUP_NOISE_MAP_VIS"
#define XSH_PICKUP_NOISE_MAP_NIR "PICKUP_NOISE_MAP_NIR"


#define XSH_BP_MAP_REF "BP_MAP_REF"
#define XSH_BP_MAP_REF_UVB "BP_MAP_REF_UVB"
#define XSH_BP_MAP_REF_VIS "BP_MAP_REF_VIS"
#define XSH_BP_MAP_REF_NIR "BP_MAP_REF_NIR"

#define XSH_BP_MAP_LIN "BP_MAP_LIN"
#define XSH_BP_MAP_LIN_UVB "BP_MAP_LIN_UVB"
#define XSH_BP_MAP_LIN_VIS "BP_MAP_LIN_VIS"
#define XSH_BP_MAP_LIN_NIR "BP_MAP_LIN_NIR"

#define XSH_BP_MAP_HP "BP_MAP_HP"
#define XSH_BP_MAP_HP_UVB "BP_MAP_HP_UVB"
#define XSH_BP_MAP_HP_VIS "BP_MAP_HP_VIS"
#define XSH_BP_MAP_HP_NIR "BP_MAP_HP_NIR"

#define XSH_BP_MAP_CP     "BP_MAP_CP"
#define XSH_BP_MAP_CP_UVB "BP_MAP_CP_UVB"
#define XSH_BP_MAP_CP_VIS "BP_MAP_CP_VIS"
#define XSH_BP_MAP_CP_NIR "BP_MAP_CP_NIR"


#define XSH_BP_MAP_SP     "BP_MAP_SP"
#define XSH_BP_MAP_SP_UVB "BP_MAP_SP_UVB"
#define XSH_BP_MAP_SP_VIS "BP_MAP_SP_VIS"
#define XSH_BP_MAP_SP_NIR "BP_MAP_SP_NIR"


#define XSH_BP_MAP_DP     "BP_MAP_DP"
#define XSH_BP_MAP_DP_UVB "BP_MAP_DP_UVB"
#define XSH_BP_MAP_DP_VIS "BP_MAP_DP_VIS"
#define XSH_BP_MAP_DP_NIR "BP_MAP_DP_NIR"


#define XSH_MASTER_BP_MAP "MASTER_BP_MAP"
#define XSH_MASTER_BP_MAP_UVB "MASTER_BP_MAP_UVB"
#define XSH_MASTER_BP_MAP_VIS "MASTER_BP_MAP_VIS"
#define XSH_MASTER_BP_MAP_NIR "MASTER_BP_MAP_NIR"



#define XSH_MASTER_BP_MAP_NLIN "MASTER_BP_MAP_NLIN"
#define XSH_MASTER_BP_MAP_NLIN_UVB "MASTER_BP_MAP_NLIN_UVB"
#define XSH_MASTER_BP_MAP_NLIN_VIS "MASTER_BP_MAP_NLIN_VIS"
#define XSH_MASTER_BP_MAP_NLIN_NIR "MASTER_BP_MAP_NLIN_NIR"

#define XSH_MASTER_BP_MAP_BIAS "MASTER_BP_MAP_BIAS"
#define XSH_MASTER_BP_MAP_BIAS_UVB "MASTER_BP_MAP_BIAS_UVB"
#define XSH_MASTER_BP_MAP_BIAS_VIS "MASTER_BP_MAP_BIAS_VIS"
#define XSH_MASTER_BP_MAP_BIAS_NIR "MASTER_BP_MAP_BIAS_NIR"

#define XSH_MASTER_BP_MAP_DARK "MASTER_BP_MAP_DARK"
#define XSH_MASTER_BP_MAP_DARK_UVB "MASTER_BP_MAP_DARK_UVB"
#define XSH_MASTER_BP_MAP_DARK_VIS "MASTER_BP_MAP_DARK_VIS"
#define XSH_MASTER_BP_MAP_DARK_NIR "MASTER_BP_MAP_DARK_NIR"

#define XSH_MASTER_BP_MAP_FLAT "MASTER_BP_MAP_FLAT"
#define XSH_MASTER_BP_MAP_FLAT_UVB "MASTER_BP_MAP_FLAT_UVB"
#define XSH_MASTER_BP_MAP_FLAT_VIS "MASTER_BP_MAP_FLAT_VIS"
#define XSH_MASTER_BP_MAP_FLAT_NIR "MASTER_BP_MAP_FLAT_NIR"



#define XSH_MASTER_BIAS_UVB "MASTER_BIAS_UVB"
#define XSH_MASTER_BIAS_VIS "MASTER_BIAS_VIS"
#define XSH_MASTER_BIAS_AGC "MASTER_BIAS_AGC"
#define XSH_MASTER_BIAS_NIR "??TAG??"
#define XSH_MASTER_DARK_UVB "MASTER_DARK_UVB"
#define XSH_MASTER_DARK_VIS "MASTER_DARK_VIS"
#define XSH_MASTER_DARK_NIR "MASTER_DARK_NIR"
#define XSH_ORDER_TAB_RECOV_UVB "ORDER_TAB_RECOV_UVB"
#define XSH_ORDER_TAB_RECOV_VIS "ORDER_TAB_RECOV_VIS"
#define XSH_ORDER_TAB_RECOV_NIR "ORDER_TAB_RECOV_NIR"
#define XSH_ORDER_TAB_GUESS_UVB "ORDER_TAB_GUESS_UVB"
#define XSH_ORDER_TAB_GUESS_VIS "ORDER_TAB_GUESS_VIS"
#define XSH_ORDER_TAB_GUESS_NIR "ORDER_TAB_GUESS_NIR"
#define XSH_ORDER_TAB_CENTR_UVB "ORDER_TAB_CENTR_UVB"
#define XSH_ORDER_TAB_CENTR_VIS "ORDER_TAB_CENTR_VIS"
#define XSH_ORDER_TAB_CENTR_NIR "ORDER_TAB_CENTR_NIR"

#define XSH_ORDER_TAB_EDGES_SLIT     "ORDER_TAB_EDGES_SLIT"
#define XSH_ORDER_TAB_EDGES_SLIT_UVB "ORDER_TAB_EDGES_SLIT_UVB"
#define XSH_ORDER_TAB_EDGES_SLIT_VIS "ORDER_TAB_EDGES_SLIT_VIS"
#define XSH_ORDER_TAB_EDGES_SLIT_NIR "ORDER_TAB_EDGES_SLIT_NIR"

#define XSH_ORDER_TAB_EDGES_IFU     "ORDER_TAB_EDGES_IFU"
#define XSH_ORDER_TAB_EDGES_IFU_UVB "ORDER_TAB_EDGES_IFU_UVB"
#define XSH_ORDER_TAB_EDGES_IFU_VIS "ORDER_TAB_EDGES_IFU_VIS"
#define XSH_ORDER_TAB_EDGES_IFU_NIR "ORDER_TAB_EDGES_IFU_NIR"
#define XSH_ORDER_TAB_EDGES_QTH_SLIT_UVB "ORDER_TAB_EDGES_QTH_SLIT_UVB"
#define XSH_ORDER_TAB_EDGES_QTH_IFU_UVB "ORDER_TAB_EDGES_QTH_IFU_UVB"
#define XSH_ORDER_TAB_EDGES_D2_SLIT_UVB "ORDER_TAB_EDGES_D2_SLIT_UVB"
#define XSH_ORDER_TAB_EDGES_D2_IFU_UVB "ORDER_TAB_EDGES_D2_IFU_UVB"

#define XSH_ORDER_TAB_AFC "ORDER_TAB_AFC"

#define XSH_ORDER_TAB_AFC_SLIT "ORDER_TAB_AFC_SLIT"
#define XSH_ORDER_TAB_AFC_SLIT_UVB "ORDER_TAB_AFC_SLIT_UVB"
#define XSH_ORDER_TAB_AFC_SLIT_VIS "ORDER_TAB_AFC_SLIT_VIS"
#define XSH_ORDER_TAB_AFC_SLIT_NIR "ORDER_TAB_AFC_SLIT_NIR"

#define XSH_ORDER_TAB_AFC_IFU "ORDER_TAB_AFC_IFU"
#define XSH_ORDER_TAB_AFC_IFU_UVB "ORDER_TAB_AFC_IFU_UVB"
#define XSH_ORDER_TAB_AFC_IFU_VIS "ORDER_TAB_AFC_IFU_VIS"
#define XSH_ORDER_TAB_AFC_IFU_NIR "ORDER_TAB_AFC_IFU_NIR"


#define XSH_WAVE_TAB_GUESS_UVB "WAVE_TAB_GUESS_UVB"
#define XSH_WAVE_TAB_GUESS_VIS "WAVE_TAB_GUESS_VIS"
#define XSH_WAVE_TAB_GUESS_NIR "WAVE_TAB_GUESS_NIR"
#define XSH_WAVE_TAB_2D_UVB "WAVE_TAB_2D_UVB"
#define XSH_WAVE_TAB_2D_VIS "WAVE_TAB_2D_VIS"
#define XSH_WAVE_TAB_2D_NIR "WAVE_TAB_2D_NIR"
#define XSH_WAVE_TAB_AFC_UVB "WAVE_TAB_AFC_UVB"
#define XSH_WAVE_TAB_AFC_VIS "WAVE_TAB_AFC_VIS"
#define XSH_WAVE_TAB_AFC_NIR "WAVE_TAB_AFC_NIR"
#define XSH_WAVE_TAB_ARC_SLIT_UVB "WAVE_TAB_ARC_SLIT_UVB"
#define XSH_WAVE_TAB_ARC_SLIT_VIS "WAVE_TAB_ARC_SLIT_VIS"
#define XSH_WAVE_TAB_ARC_SLIT_NIR "WAVE_TAB_ARC_SLIT_NIR"


#define XSH_WAVE_TAB_ARC_IFU_UVB "WAVE_TAB_ARC_IFU_UVB"
#define XSH_WAVE_TAB_ARC_DOWN_IFU_UVB "WAVE_TAB_ARC_DOWN_IFU_UVB"
#define XSH_WAVE_TAB_ARC_CEN_IFU_UVB "WAVE_TAB_ARC_CEN_IFU_UVB"
#define XSH_WAVE_TAB_ARC_UP_IFU_UVB "WAVE_TAB_ARC_UP_IFU_UVB"

#define XSH_WAVE_TAB_ARC_IFU_VIS "WAVE_TAB_ARC_IFU_VIS"
#define XSH_WAVE_TAB_ARC_DOWN_IFU_VIS "WAVE_TAB_ARC_DOWN_IFU_VIS"
#define XSH_WAVE_TAB_ARC_CEN_IFU_VIS "WAVE_TAB_ARC_CEN_IFU_VIS"
#define XSH_WAVE_TAB_ARC_UP_IFU_VIS "WAVE_TAB_ARC_UP_IFU_VIS"

#define XSH_WAVE_TAB_ARC_IFU_NIR "WAVE_TAB_ARC_IFU_NIR"
#define XSH_WAVE_TAB_ARC_DOWN_IFU_NIR "WAVE_TAB_ARC_DOWN_IFU_NIR"
#define XSH_WAVE_TAB_ARC_CEN_IFU_NIR "WAVE_TAB_ARC_CEN_IFU_NIR"
#define XSH_WAVE_TAB_ARC_UP_IFU_NIR "WAVE_TAB_ARC_UP_IFU_NIR"

#define XSH_ORDER1D_IFU_UVB "ORDER1D_IFU_UVB"
#define XSH_ORDER1D_DOWN_IFU_UVB "ORDER1D_DOWN_IFU_UVB"
#define XSH_ORDER1D_CEN_IFU_UVB "ORDER1D_CEN_IFU_UVB"
#define XSH_ORDER1D_UP_IFU_UVB "ORDER1D_UP_IFU_UVB"

#define XSH_ORDER1D_IFU_VIS "ORDER1D_IFU_VIS"
#define XSH_ORDER1D_DOWN_IFU_VIS "ORDER1D_DOWN_IFU_VIS"
#define XSH_ORDER1D_CEN_IFU_VIS "ORDER1D_CEN_IFU_VIS"
#define XSH_ORDER1D_UP_IFU_VIS "ORDER1D_UP_IFU_VIS"

#define XSH_ORDER1D_IFU_NIR "ORDER1D_IFU_NIR"
#define XSH_ORDER1D_DOWN_IFU_NIR "ORDER1D_DOWN_IFU_NIR"
#define XSH_ORDER1D_CEN_IFU_NIR "ORDER1D_CEN_IFU_NIR"
#define XSH_ORDER1D_UP_IFU_NIR "ORDER1D_UP_IFU_NIR"

#define XSH_ORDER2D_IFU_UVB "ORDER2D_IFU_UVB"
#define XSH_ORDER2D_DOWN_IFU_UVB "ORDER2D_DOWN_IFU_UVB"
#define XSH_ORDER2D_CEN_IFU_UVB "ORDER2D_CEN_IFU_UVB"
#define XSH_ORDER2D_UP_IFU_UVB "ORDER2D_UP_IFU_UVB"

#define XSH_ORDER2D_IFU_VIS "ORDER2D_IFU_VIS"
#define XSH_ORDER2D_DOWN_IFU_VIS "ORDER2D_DOWN_IFU_VIS"
#define XSH_ORDER2D_CEN_IFU_VIS "ORDER2D_CEN_IFU_VIS"
#define XSH_ORDER2D_UP_IFU_VIS "ORDER2D_UP_IFU_VIS"

#define XSH_ORDER2D_IFU_NIR "ORDER2D_IFU_NIR"
#define XSH_ORDER2D_DOWN_IFU_NIR "ORDER2D_DOWN_IFU_NIR"
#define XSH_ORDER2D_CEN_IFU_NIR "ORDER2D_CEN_IFU_NIR"
#define XSH_ORDER2D_UP_IFU_NIR "ORDER2D_UP_IFU_NIR"

#define XSH_MERGE1D_IFU_UVB "MERGE1D_IFU_UVB"
#define XSH_MERGE1D_DOWN_IFU_UVB "MERGE1D_DOWN_IFU_UVB"
#define XSH_MERGE1D_CEN_IFU_UVB "MERGE1D_CEN_IFU_UVB"
#define XSH_MERGE1D_UP_IFU_UVB "MERGE1D_UP_IFU_UVB"

#define XSH_MERGE1D_IFU_VIS "MERGE1D_IFU_VIS"
#define XSH_MERGE1D_DOWN_IFU_VIS "MERGE1D_DOWN_IFU_VIS"
#define XSH_MERGE1D_CEN_IFU_VIS "MERGE1D_CEN_IFU_VIS"
#define XSH_MERGE1D_UP_IFU_VIS "MERGE1D_UP_IFU_VIS"

#define XSH_MERGE1D_IFU_NIR "MERGE1D_IFU_NIR"
#define XSH_MERGE1D_DOWN_IFU_NIR "MERGE1D_DOWN_IFU_NIR"
#define XSH_MERGE1D_CEN_IFU_NIR "MERGE1D_CEN_IFU_NIR"
#define XSH_MERGE1D_UP_IFU_NIR "MERGE1D_UP_IFU_NIR"



#define XSH_MERGE2D_IFU_UVB "MERGE2D_IFU_UVB"
#define XSH_MERGE2D_DOWN_IFU_UVB "MERGE2D_DOWN_IFU_UVB"
#define XSH_MERGE2D_CEN_IFU_UVB "MERGE2D_CEN_IFU_UVB"
#define XSH_MERGE2D_UP_IFU_UVB "MERGE2D_UP_IFU_UVB"

#define XSH_MERGE2D_IFU_VIS "MERGE2D_IFU_VIS"
#define XSH_MERGE2D_DOWN_IFU_VIS "MERGE2D_DOWN_IFU_VIS"
#define XSH_MERGE2D_CEN_IFU_VIS "MERGE2D_CEN_IFU_VIS"
#define XSH_MERGE2D_UP_IFU_VIS "MERGE2D_UP_IFU_VIS"

#define XSH_MERGE2D_IFU_NIR "MERGE2D_IFU_NIR"
#define XSH_MERGE2D_DOWN_IFU_NIR "MERGE2D_DOWN_IFU_NIR"
#define XSH_MERGE2D_CEN_IFU_NIR "MERGE2D_CEN_IFU_NIR"
#define XSH_MERGE2D_UP_IFU_NIR "MERGE2D_UP_IFU_NIR"


#define XSH_SKY_MERGE2D_IFU_UVB "SKY_MERGE2D_IFU_UVB"
#define XSH_SKY_MERGE2D_DOWN_IFU_UVB "SKY_MERGE2D_DOWN_IFU_UVB"
#define XSH_SKY_MERGE2D_CEN_IFU_UVB "SKY_MERGE2D_CEN_IFU_UVB"
#define XSH_SKY_MERGE2D_UP_IFU_UVB "SKY_MERGE2D_UP_IFU_UVB"

#define XSH_SKY_MERGE2D_IFU_VIS "SKY_MERGE2D_IFU_VIS"
#define XSH_SKY_MERGE2D_DOWN_IFU_VIS "SKY_MERGE2D_DOWN_IFU_VIS"
#define XSH_SKY_MERGE2D_CEN_IFU_VIS "SKY_MERGE2D_CEN_IFU_VIS"
#define XSH_SKY_MERGE2D_UP_IFU_VIS "SKY_MERGE2D_UP_IFU_VIS"

#define XSH_SKY_MERGE2D_IFU_NIR "SKY_MERGE2D_IFU_NIR"
#define XSH_SKY_MERGE2D_DOWN_IFU_NIR "SKY_MERGE2D_DOWN_IFU_NIR"
#define XSH_SKY_MERGE2D_CEN_IFU_NIR "SKY_MERGE2D_CEN_IFU_NIR"
#define XSH_SKY_MERGE2D_UP_IFU_NIR "SKY_MERGE2D_UP_IFU_NIR"



#define XSH_MERGE3D_IFU_NIR "MERGE3D_IFU_NIR"
#define XSH_MERGE3D_IFU_UVB "MERGE3D_IFU_UVB"
#define XSH_MERGE3D_IFU_VIS "MERGE3D_IFU_VIS"

#define XSH_COMBINED_OFFSET_2D_IFU     "COMBINED_OFFSET_2D_IFU_"
#define XSH_COMBINED_OFFSET_2D_IFU_UVB "COMBINED_OFFSET_2D_IFU_UVB"
#define XSH_COMBINED_OFFSET_2D_DOWN_IFU_UVB "COMBINED_OFFSET_2D_DOWN_IFU_UVB"
#define XSH_COMBINED_OFFSET_2D_CEN_IFU_UVB "COMBINED_OFFSET_2D_CEN_IFU_UVB"
#define XSH_COMBINED_OFFSET_2D_UP_IFU_UVB "COMBINED_OFFSET_2D_UP_IFU_UVB"

#define XSH_COMBINED_OFFSET_2D_IFU_VIS "COMBINED_OFFSET_2D_IFU_VIS"
#define XSH_COMBINED_OFFSET_2D_DOWN_IFU_VIS "COMBINED_OFFSET_2D_DOWN_IFU_VIS"
#define XSH_COMBINED_OFFSET_2D_CEN_IFU_VIS "COMBINED_OFFSET_2D_CEN_IFU_VIS"
#define XSH_COMBINED_OFFSET_2D_UP_IFU_VIS "COMBINED_OFFSET_2D_UP_IFU_VIS"

#define XSH_COMBINED_OFFSET_2D_IFU_NIR "COMBINED_OFFSET_2D_IFU_NIR"
#define XSH_COMBINED_OFFSET_2D_DOWN_IFU_NIR "COMBINED_OFFSET_2D_DOWN_IFU_NIR"
#define XSH_COMBINED_OFFSET_2D_CEN_IFU_NIR "COMBINED_OFFSET_2D_CEN_IFU_NIR"
#define XSH_COMBINED_OFFSET_2D_UP_IFU_NIR "COMBINED_OFFSET_2D_UP_IFU_NIR"

#define XSH_COMBINED_OFFSET_2D_SLIT     "COMBINED_OFFSET_2D_SLIT_"
#define XSH_COMBINED_OFFSET_2D_SLIT_UVB "COMBINED_OFFSET_2D_SLIT_UVB"
#define XSH_COMBINED_OFFSET_2D_SLIT_VIS "COMBINED_OFFSET_2D_SLIT_VIS"
#define XSH_COMBINED_OFFSET_2D_SLIT_NIR "COMBINED_OFFSET_2D_SLIT_NIR"

#define XSH_RESID_TAB_SLIT_UVB "RESID_TAB_SLIT_UVB"
#define XSH_RESID_TAB_SLIT_VIS "RESID_TAB_SLIT_VIS"
#define XSH_RESID_TAB_SLIT_NIR "RESID_TAB_SLIT_NIR"
#define XSH_RESID_TAB_IFU_UVB "RESID_TAB_IFU_UVB"
#define XSH_RESID_TAB_IFU_VIS "RESID_TAB_IFU_VIS"
#define XSH_RESID_TAB_IFU_NIR "RESID_TAB_IFU_NIR"
#define XSH_RESID_ORDER_TAB_NIR "RESID_ORDER_TAB_NIR"
#define XSH_RESID_ORDER_TAB_UVB "RESID_ORDER_TAB_UVB"
#define XSH_RESID_ORDER_TAB_VIS "RESID_ORDER_TAB_VIS"

#define XSH_MASTER_FLAT_SLIT      "MASTER_FLAT_SLIT"
#define XSH_MASTER_FLAT_SLIT_UVB "MASTER_FLAT_SLIT_UVB"
#define XSH_MASTER_FLAT_SLIT_VIS "MASTER_FLAT_SLIT_VIS"
#define XSH_MASTER_FLAT_SLIT_NIR "MASTER_FLAT_SLIT_NIR"
#define XSH_MASTER_FLAT_IFU_UVB "MASTER_FLAT_IFU_UVB"
#define XSH_MASTER_FLAT_IFU_VIS "MASTER_FLAT_IFU_VIS"
#define XSH_MASTER_FLAT_IFU_NIR "MASTER_FLAT_IFU_NIR"
#define XSH_MASTER_FLAT_QTH_SLIT_UVB "MASTER_FLAT_QTH_SLIT_UVB"
#define XSH_MASTER_FLAT_QTH_SLIT_VIS "MASTER_FLAT_QTH_SLIT_VIS"
#define XSH_MASTER_FLAT_QTH_SLIT_NIR "MASTER_FLAT_QTH_SLIT_NIR"
#define XSH_MASTER_FLAT_QTH_IFU_UVB "MASTER_FLAT_QTH_IFU_UVB"
#define XSH_MASTER_FLAT_QTH_IFU_VIS "MASTER_FLAT_QTH_IFU_VIS"
#define XSH_MASTER_FLAT_QTH_IFU_NIR "MASTER_FLAT_QTH_IFU_NIR"
#define XSH_MASTER_FLAT_D2_SLIT_UVB "MASTER_FLAT_D2_SLIT_UVB"
#define XSH_MASTER_FLAT_D2_SLIT_VIS "MASTER_FLAT_D2_SLIT_VIS"
#define XSH_MASTER_FLAT_D2_SLIT_NIR "MASTER_FLAT_D2_SLIT_NIR"
#define XSH_MASTER_FLAT_D2_IFU_UVB "MASTER_FLAT_D2_IFU_UVB"
#define XSH_MASTER_FLAT_D2_IFU_VIS "MASTER_FLAT_D2_IFU_VIS"
#define XSH_MASTER_FLAT_D2_IFU_NIR "MASTER_FLAT_D2_IFU_NIR"

#define XSH_TILT_TAB_SLIT_UVB "TILT_TAB_SLIT_UVB"
#define XSH_TILT_TAB_SLIT_VIS "TILT_TAB_SLIT_VIS"
#define XSH_TILT_TAB_SLIT_NIR "TILT_TAB_SLIT_NIR"
#define XSH_TILT_TAB_IFU_UVB "TILT_TAB_IFU_UVB"
#define XSH_TILT_TAB_IFU_VIS "TILT_TAB_IFU_VIS"
#define XSH_TILT_TAB_IFU_NIR "TILT_TAB_IFU_NIR"


#define XSH_DISP_TAB     "DISP_TAB"
#define XSH_DISP_TAB_UVB "DISP_TAB_UVB"
#define XSH_DISP_TAB_VIS "DISP_TAB_VIS"
#define XSH_DISP_TAB_NIR "DISP_TAB_NIR"

#define XSH_DISP_TAB_AFC     "DISP_TAB_AFC"
#define XSH_DISP_TAB_AFC_UVB "DISP_TAB_AFC_UVB"
#define XSH_DISP_TAB_AFC_VIS "DISP_TAB_AFC_VIS"
#define XSH_DISP_TAB_AFC_NIR "DISP_TAB_AFC_NIR"

#define XSH_SLIT_MAP     "SLIT_MAP"
#define XSH_SLIT_MAP_UVB "SLIT_MAP_UVB"
#define XSH_SLIT_MAP_VIS "SLIT_MAP_VIS"
#define XSH_SLIT_MAP_NIR "SLIT_MAP_NIR"
/* Same file, but IFU tag ! */
#define XSH_IFU_MAP     "IFU_MAP"
#define XSH_IFU_MAP_UVB "IFU_MAP_UVB"
#define XSH_IFU_MAP_VIS "IFU_MAP_VIS"
#define XSH_IFU_MAP_NIR "IFU_MAP_NIR"


#define XSH_WAVE_MAP_POLY "WAVE_MAP"
#define XSH_WAVE_MAP_POLY_UVB "WAVE_MAP_UVB"
#define XSH_WAVE_MAP_POLY_VIS "WAVE_MAP_VIS"
#define XSH_WAVE_MAP_POLY_NIR "WAVE_MAP_NIR"

#define XSH_WAVE_MAP_MODEL "WAVE_MAP"
#define XSH_WAVE_MAP_MODEL_UVB "WAVE_MAP_UVB"
#define XSH_WAVE_MAP_MODEL_VIS "WAVE_MAP_VIS"
#define XSH_WAVE_MAP_MODEL_NIR "WAVE_MAP_NIR"

#define XSH_WAVE_MAP "WAVE_MAP"
#define XSH_WAVE_MAP_UVB "WAVE_MAP_UVB"
#define XSH_WAVE_MAP_VIS "WAVE_MAP_VIS"
#define XSH_WAVE_MAP_NIR "WAVE_MAP_NIR"

#define XSH_WAVE_MAP_QTH_SLIT_UVB "WAVE_MAP_QTH_SLIT_UVB"
#define XSH_WAVE_MAP_D2_SLIT_UVB "WAVE_MAP_D2_SLIT_UVB"
#define XSH_WAVE_MAP_SLIT_UVB "WAVE_MAP_SLIT_UVB"
#define XSH_WAVE_MAP_SLIT_VIS "WAVE_MAP_SLIT_VIS" 
#define XSH_WAVE_MAP_SLIT_NIR "WAVE_MAP_SLIT_NIR"
#define XSH_WAVE_MAP_IFU_UVB "WAVE_MAP_IFU_UVB"
#define XSH_WAVE_MAP_QTH_IFU_UVB "WAVE_MAP_QTH_IFU_UVB"
#define XSH_WAVE_MAP_D2_IFU_UVB "WAVE_MAP_D2_IFU_UVB"
#define XSH_WAVE_MAP_IFU_VIS "WAVE_MAP_IFU_VIS"
#define XSH_WAVE_MAP_IFU_NIR "WAVE_MAP_IFU_NIR"

#define XSH_SKY_LINE_LIST "SKY_LINE_LIST"
#define XSH_SKY_LINE_LIST_UVB "SKY_LINE_LIST_UVB"
#define XSH_SKY_LINE_LIST_VIS "SKY_LINE_LIST_VIS"
#define XSH_SKY_LINE_LIST_NIR "SKY_LINE_LIST_NIR"


#define XSH_ARC_LINE_LIST_AFC "ARC_LINE_LIST_AFC"
#define XSH_ARC_LINE_LIST_AFC_UVB "ARC_LINE_LIST_AFC_UVB"
#define XSH_ARC_LINE_LIST_AFC_VIS "ARC_LINE_LIST_AFC_VIS"
#define XSH_ARC_LINE_LIST_AFC_NIR "ARC_LINE_LIST_AFC_NIR"

#define XSH_ARC_LINE_LIST "ARC_LINE_LIST"
#define XSH_ARC_LINE_LIST_UVB "ARC_LINE_LIST_UVB"
#define XSH_ARC_LINE_LIST_VIS "ARC_LINE_LIST_VIS"
#define XSH_ARC_LINE_LIST_NIR "ARC_LINE_LIST_NIR"

#define XSH_ARC_LINE_LIST_PREDICT "ARC_LINE_LIST_PREDICT"
#define XSH_ARC_LINE_LIST_PREDICT_UVB "ARC_LINE_LIST_PREDICT_UVB"
#define XSH_ARC_LINE_LIST_PREDICT_VIS "ARC_LINE_LIST_PREDICT_VIS"
#define XSH_ARC_LINE_LIST_PREDICT_NIR "ARC_LINE_LIST_PREDICT_NIR"

#define XSH_ARC_LINE_LIST_2DMAP "ARC_LINE_LIST_2DMAP"
#define XSH_ARC_LINE_LIST_2DMAP_UVB "ARC_LINE_LIST_2DMAP_UVB"
#define XSH_ARC_LINE_LIST_2DMAP_VIS "ARC_LINE_LIST_2DMAP_VIS"
#define XSH_ARC_LINE_LIST_2DMAP_NIR "ARC_LINE_LIST_2DMAP_NIR"

#define XSH_ORDER1D_NIR "ORDER1D_NIR"
#define XSH_ORDER1D_UVB "ORDER1D_UVB"
#define XSH_ORDER1D_VIS "ORDER1D_VIS"


#define XSH_NORM_OXT1D "NORM_OXT1D"
#define XSH_NORM_OXT1D_NIR "NORM_OXT1D_NIR"
#define XSH_NORM_OXT1D_UVB "NORM_OXT1D_UVB"
#define XSH_NORM_OXT1D_VIS "NORM_OXT1D_VIS"


#define XSH_NORM_ORDER1D "NORM_ORDER1D"
#define XSH_NORM_ORDER1D_NIR "NORM_ORDER1D_NIR"
#define XSH_NORM_ORDER1D_UVB "NORM_ORDER1D_UVB"
#define XSH_NORM_ORDER1D_VIS "NORM_ORDER1D_VIS"

#define XSH_NORM_ORDER2D "NORM_ORDER2D"
#define XSH_NORM_ORDER2D_NIR "NORM_ORDER2D_NIR"
#define XSH_NORM_ORDER2D_UVB "NORM_ORDER2D_UVB"
#define XSH_NORM_ORDER2D_VIS "NORM_ORDER2D_VIS"

#define XSH_NORM_MERGE1D "NORM_MERGE1D"
#define XSH_NORM_MERGE1D_NIR "NORM_MERGE1D_NIR"
#define XSH_NORM_MERGE1D_UVB "NORM_MERGE1D_UVB"
#define XSH_NORM_MERGE1D_VIS "NORM_MERGE1D_VIS"


#define XSH_NORM_MERGE2D "NORM_MERGE2D"
#define XSH_NORM_MERGE2D_NIR "NORM_MERGE2D_NIR"
#define XSH_NORM_MERGE2D_UVB "NORM_MERGE2D_UVB"
#define XSH_NORM_MERGE2D_VIS "NORM_MERGE2D_VIS"


#define XSH_FLUX_ORDER1D "FLUX_ORDER1D"
#define XSH_FLUX_ORDER1D_NIR "FLUX_ORDER1D_NIR"
#define XSH_FLUX_ORDER1D_UVB "FLUX_ORDER1D_UVB"
#define XSH_FLUX_ORDER1D_VIS "FLUX_ORDER1D_VIS"


#define XSH_FLUX_OXT1D "FLUX_OXT1D"
#define XSH_FLUX_OXT1D_NIR "FLUX_OXT1D_NIR"
#define XSH_FLUX_OXT1D_UVB "FLUX_OXT1D_UVB"
#define XSH_FLUX_OXT1D_VIS "FLUX_OXT1D_VIS"

#define XSH_FLUX_ORDER2D "FLUX_ORDER2D"
#define XSH_FLUX_ORDER2D_NIR "FLUX_ORDER2D_NIR"
#define XSH_FLUX_ORDER2D_UVB "FLUX_ORDER2D_UVB"
#define XSH_FLUX_ORDER2D_VIS "FLUX_ORDER2D_VIS"

#define XSH_FLUX_MERGE1D "FLUX_MERGE1D"
#define XSH_FLUX_MERGE1D_NIR "FLUX_MERGE1D_NIR"
#define XSH_FLUX_MERGE1D_UVB "FLUX_MERGE1D_UVB"
#define XSH_FLUX_MERGE1D_VIS "FLUX_MERGE1D_VIS"

#define XSH_FLUX_MERGE2D "FLUX_MERGE2D"
#define XSH_FLUX_MERGE2D_NIR "FLUX_MERGE2D_NIR"
#define XSH_FLUX_MERGE2D_UVB "FLUX_MERGE2D_UVB"
#define XSH_FLUX_MERGE2D_VIS "FLUX_MERGE2D_VIS"

#define XSH_ORDER_EXT1D "ORDER_EXT1D"
#define XSH_ORDER_EXT1D_NIR "ORDER_EXT1D_NIR"
#define XSH_ORDER_EXT1D_UVB "ORDER_EXT1D_UVB"
#define XSH_ORDER_EXT1D_VIS "ORDER_EXT1D_VIS"

#define XSH_ORDER_OXT1D "ORDER_OXT1D"
#define XSH_ORDER_OXT1D_NIR "ORDER_OXT1D_NIR"
#define XSH_ORDER_OXT1D_UVB "ORDER_OXT1D_UVB"
#define XSH_ORDER_OXT1D_VIS "ORDER_OXT1D_VIS"

#define XSH_MERGE1D_NIR "MERGE1D_NIR"
#define XSH_MERGE1D_UVB "MERGE1D_UVB"
#define XSH_MERGE1D_VIS "MERGE1D_VIS"

#define XSH_MERGE_EXT1D_NIR "MERGE_EXT1D_NIR"
#define XSH_MERGE_EXT1D_UVB "MERGE_EXT1D_UVB"
#define XSH_MERGE_EXT1D_VIS "MERGE_EXT1D_VIS"

#define XSH_MERGE_OXT1D "MERGE_OXT1D"
#define XSH_MERGE_OXT1D_NIR "MERGE_OXT1D_NIR"
#define XSH_MERGE_OXT1D_UVB "MERGE_OXT1D_UVB"
#define XSH_MERGE_OXT1D_VIS "MERGE_OXT1D_VIS"

#define XSH_FLUX_MOXT1D "FLUX_MOXT1D"
#define XSH_FLUX_MOXT1D_NIR "FLUX_MOXT1D_NIR"
#define XSH_FLUX_MOXT1D_UVB "FLUX_MOXT1D_UVB"
#define XSH_FLUX_MOXT1D_VIS "FLUX_MOXT1D_VIS"

#define XSH_PHYS_MERGE1D_NIR "PHYS_MERGE1D_NIR"
#define XSH_PHYS_MERGE1D_UVB "PHYS_MERGE1D_UVB"
#define XSH_PHYS_MERGE1D_VIS "PHYS_MERGE1D_VIS"

#define XSH_ORDER2D_NIR "ORDER2D_NIR"
#define XSH_ORDER2D_UVB "ORDER2D_UVB"
#define XSH_ORDER2D_VIS "ORDER2D_VIS"

#define XSH_SKY_ORDER2D  "SKY_ORDER2D"
#define XSH_SKY_ORDER2D_NIR "SKY_ORDER2D_NIR"
#define XSH_SKY_ORDER2D_UVB "SKY_ORDER2D_UVB"
#define XSH_SKY_ORDER2D_VIS "SKY_ORDER2D_VIS"

#define XSH_MERGE2D_NIR "MERGE2D_NIR"
#define XSH_MERGE2D_UVB "MERGE2D_UVB"
#define XSH_MERGE2D_VIS "MERGE2D_VIS"

#define XSH_SKY_MERGE2D "SKY_MERGE2D"
#define XSH_SKY_MERGE2D_NIR "SKY_MERGE2D_NIR"
#define XSH_SKY_MERGE2D_UVB "SKY_MERGE2D_UVB"
#define XSH_SKY_MERGE2D_VIS "SKY_MERGE2D_VIS"


#define XSH_PHYS_MERGE2D_NIR "PHYS_MERGE2D_NIR"
#define XSH_PHYS_MERGE2D_UVB "PHYS_MERGE2D_UVB"
#define XSH_PHYS_MERGE2D_VIS "PHYS_MERGE2D_VIS"

#define XSH_THEO_TAB_SING "THEO_TAB_SING"
#define XSH_THEO_TAB_SING_UVB "THEO_TAB_SING_UVB"
#define XSH_THEO_TAB_SING_VIS "THEO_TAB_SING_VIS"
#define XSH_THEO_TAB_SING_NIR "THEO_TAB_SING_NIR"

#define XSH_THEO_TAB_MULT "THEO_TAB_MULT"
#define XSH_THEO_TAB_MULT_UVB "THEO_TAB_MULT_UVB"
#define XSH_THEO_TAB_MULT_VIS "THEO_TAB_MULT_VIS"
#define XSH_THEO_TAB_MULT_NIR "THEO_TAB_MULT_NIR"

#define XSH_THEO_TAB_IFU "THEO_TAB_IFU"
#define XSH_THEO_TAB_IFU_UVB "THEO_TAB_IFU_UVB"
#define XSH_THEO_TAB_IFU_VIS "THEO_TAB_IFU_VIS"
#define XSH_THEO_TAB_IFU_NIR "THEO_TAB_IFU_NIR"

#define XSH_SKY_TAB_MULT "SKY_TAB_MULT"
#define XSH_SKY_TAB_MULT_UVB "SKY_TAB_MULT_UVB"
#define XSH_SKY_TAB_MULT_VIS "SKY_TAB_MULT_VIS"
#define XSH_SKY_TAB_MULT_NIR "SKY_TAB_MULT_NIR"


#define XSH_SKY_TAB_SING "SKY_TAB_SING"
#define XSH_SKY_TAB_SING_UVB "SKY_TAB_SING_UVB"
#define XSH_SKY_TAB_SING_VIS "SKY_TAB_SING_VIS"
#define XSH_SKY_TAB_SING_NIR "SKY_TAB_SING_NIR"

#define XSH_LOCALIZATION_VIS "LOC_TABLE_VIS"
#define XSH_LOCALIZATION_UVB "LOC_TABLE_UVB"
#define XSH_LOCALIZATION_NIR "LOC_TABLE_NIR"

#define XSH_SLICE_OFFSET_VIS "SLICE_OFFSET_TABLE_VIS"
#define XSH_SLICE_OFFSET_UVB "SLICE_OFFSET_TABLE_UVB"
#define XSH_SLICE_OFFSET_NIR "SLICE_OFFSET_TABLE_NIR"

#define XSH_OFFSET "OFFSET_TAB"
#define XSH_OFFSET_DOWN_IFU "OFFSET_TAB_DOWN_IFU"
#define XSH_OFFSET_CEN_IFU "OFFSET_TAB_CEN_IFU"
#define XSH_OFFSET_UP_IFU "OFFSET_TAB_UP_IFU"
#define XSH_OFFSET_DOWN_IFU_VIS "OFFSET_TAB_DOWN_IFU_VIS"
#define XSH_OFFSET_CEN_IFU_VIS "OFFSET_TAB_CEN_IFU_VIS"
#define XSH_OFFSET_UP_IFU_VIS "OFFSET_TAB_UP_IFU_VIS"
#define XSH_OFFSET_DOWN_IFU_UVB "OFFSET_TAB_DOWN_IFU_UVB"
#define XSH_OFFSET_CEN_IFU_UVB "OFFSET_TAB_CEN_IFU_UVB"
#define XSH_OFFSET_UP_IFU_UVB "OFFSET_TAB_UP_IFU_UVB"
#define XSH_OFFSET_DOWN_IFU_NIR "OFFSET_TAB_DOWN_IFU_NIR"
#define XSH_OFFSET_CEN_IFU_NIR "OFFSET_TAB_CEN_IFU_NIR"
#define XSH_OFFSET_UP_IFU_NIR "OFFSET_TAB_UP_IFU_NIR"


/* old tags */
#define XSH_BADPIXEL_MAP     "BADPIXEL_MAP"
#define XSH_BADPIXEL_MAP_UVB "BADPIXEL_MAP_UVB"
#define XSH_BADPIXEL_MAP_VIS "BADPIXEL_MAP_VIS"
#define XSH_BADPIXEL_MAP_NIR "BADPIXEL_MAP_NIR"

#define XSH_TELL_LINE_LIST "TELL_LINE_LIST"
#define XSH_TELL_LINE_LIST_UVB "TELL_LINE_LIST_UVB"
#define XSH_TELL_LINE_LIST_VIS "TELL_LINE_LIST_VIS"
#define XSH_TELL_LINE_LIST_NIR "TELL_LINE_LIST_NIR"

#define XSH_RESPONSE_SLIT     "RESPONSE_SLIT"
#define XSH_RESPONSE_SLIT_UVB "RESPONSE_SLIT_UVB"
#define XSH_RESPONSE_SLIT_VIS "RESPONSE_SLIT_VIS"
#define XSH_RESPONSE_SLIT_NIR "RESPONSE_SLIT_NIR"

#define XSH_RESPONSE_MERGE1D_SLIT     "RESPONSE_MERGE1D_SLIT"
#define XSH_RESPONSE_MERGE1D_SLIT_UVB "RESPONSE_MERGE1D_SLIT_UVB"
#define XSH_RESPONSE_MERGE1D_SLIT_VIS "RESPONSE_MERGE1D_SLIT_VIS"
#define XSH_RESPONSE_MERGE1D_SLIT_NIR "RESPONSE_MERGE1D_SLIT_NIR"


#define XSH_MRESPONSE_MERGE1D_SLIT     "MRESPONSE_MERGE1D_SLIT"
#define XSH_MRESPONSE_MERGE1D_SLIT_UVB "MRESPONSE_MERGE1D_SLIT_UVB"
#define XSH_MRESPONSE_MERGE1D_SLIT_VIS "MRESPONSE_MERGE1D_SLIT_VIS"
#define XSH_MRESPONSE_MERGE1D_SLIT_NIR "MRESPONSE_MERGE1D_SLIT_NIR"


#define XSH_RESPONSE_ORDER1D_SLIT     "RESPONSE_ORDER1D_SLIT"
#define XSH_RESPONSE_ORDER1D_SLIT_UVB "RESPONSE_ORDER1D_SLIT_UVB"
#define XSH_RESPONSE_ORDER1D_SLIT_VIS "RESPONSE_ORDER1D_SLIT_VIS"
#define XSH_RESPONSE_ORDER1D_SLIT_NIR "RESPONSE_ORDER1D_SLIT_NIR"

#define XSH_RESPONSE_OFFSET     "RESPONSE_OFFSET"
#define XSH_RESPONSE_OFFSET_UVB "RESPONSE_OFFSET_UVB"
#define XSH_RESPONSE_OFFSET_VIS "RESPONSE_OFFSET_VIS"
#define XSH_RESPONSE_OFFSET_NIR "RESPONSE_OFFSET_NIR"


#define XSH_RESPONSE_IFU_UVB "RESPONSE_IFU_UVB"
#define XSH_RESPONSE_IFU_VIS "RESPONSE_IFU_VIS"
#define XSH_RESPONSE_IFU_NIR "RESPONSE_IFU_NIR"
#define XSH_OFFSET_TABLE_UVB "OFFSET_TABLE_UVB"
#define XSH_OFFSET_TABLE_VIS "OFFSET_TABLE_VIS"
#define XSH_OFFSET_TABLE_NIR "OFFSET_TABLE_NIR"

#define XSH_TELL_MASK "TELL_MASK"
#define XSH_TELL_MASK_UVB "TELL_MASK_UVB"
#define XSH_TELL_MASK_VIS "TELL_MASK_VIS"
#define XSH_TELL_MASK_NIR "TELL_MASK_NIR"

#define XSH_STD_STAR_FLUX_UVB "STD_STAR_FLUX_UVB"
#define XSH_STD_STAR_FLUX_VIS "STD_STAR_FLUX_VIS"
#define XSH_STD_STAR_FLUX_NIR "STD_STAR_FLUX_NIR"
#define XSH_ATMOS_EXT         "ATMOS_EXT"
#define XSH_ATMOS_EXT_UVB     "ATMOS_EXT_UVB"
#define XSH_ATMOS_EXT_VIS     "ATMOS_EXT_VIS"
#define XSH_ATMOS_EXT_NIR     "ATMOS_EXT_NIR"

#define XSH_SPECTRAL_FORMAT "SPECTRAL_FORMAT_TAB_"
#define XSH_SPECTRAL_FORMAT_NIR "SPECTRAL_FORMAT_TAB_NIR"
#define XSH_SPECTRAL_FORMAT_UVB "SPECTRAL_FORMAT_TAB_UVB"
#define XSH_SPECTRAL_FORMAT_VIS "SPECTRAL_FORMAT_TAB_VIS"

//#define XSH_SPECTRAL_FORMAT_JH "SPECTRAL_FORMAT_TAB_JH_"
//#define XSH_SPECTRAL_FORMAT_JH_UVB "SPECTRAL_FORMAT_TAB_JH_UVB"
//#define XSH_SPECTRAL_FORMAT_JH_VIS "SPECTRAL_FORMAT_TAB_JH_VIS"
#define XSH_SPECTRAL_FORMAT_JH_NIR "SPECTRAL_FORMAT_TAB_JH_NIR"

/* Model */
#define XSH_MODEL_WAVE_LIST          "XSH_MODEL_COMPUTE_WAVE_LIST_"
#define XSH_MODEL_WAVE_LIST_UVB      "XSH_MODEL_COMPUTE_WAVE_LIST_UVB"
#define XSH_MODEL_WAVE_LIST_VIS      "XSH_MODEL_COMPUTE_WAVE_LIST_VIS"
#define XSH_MODEL_WAVE_LIST_NIR      "XSH_MODEL_COMPUTE_WAVE_LIST_NIR"

#define XSH_MODEL_TEST_PAR           "XSH_MODEL_COMPUTE_TEST_PAR_"
#define XSH_MODEL_TEST_PAR_UVB       "XSH_MODEL_COMPUTE_TEST_PAR_UVB"
#define XSH_MODEL_TEST_PAR_VIS       "XSH_MODEL_COMPUTE_TEST_PAR_VIS"
#define XSH_MODEL_TEST_PAR_NIR       "XSH_MODEL_COMPUTE_TEST_PAR_NIR"

#define XSH_ANNEAL_ZNSE              "XSH_MODEL_ANNEAL_ZNSE"
#define XSH_ANNEAL_CONFIG            "XSH_MODEL_ANNEAL_CONFIG"
#define XSH_ANNEAL_MEAS_COORD        "XSH_MODEL_ANNEAL_MEAS_COORD"


#define XSH_MOD_CFG_OPT_REC     "XSH_MOD_CFG_OPT_REC"
#define XSH_MOD_CFG_OPT_REC_UVB "XSH_MOD_CFG_OPT_REC_UVB"
#define XSH_MOD_CFG_OPT_REC_VIS "XSH_MOD_CFG_OPT_REC_VIS"
#define XSH_MOD_CFG_OPT_REC_NIR "XSH_MOD_CFG_OPT_REC_NIR"

#define XSH_MOD_CFG_OPT_FMT     "XSH_MOD_CFG_OPT_FMT"
#define XSH_MOD_CFG_OPT_FMT_UVB "XSH_MOD_CFG_OPT_FMT_UVB"
#define XSH_MOD_CFG_OPT_FMT_VIS "XSH_MOD_CFG_OPT_FMT_VIS"
#define XSH_MOD_CFG_OPT_FMT_NIR "XSH_MOD_CFG_OPT_FMT_NIR"


#define XSH_MOD_CFG_OPT_2D     "XSH_MOD_CFG_OPT_2D"
#define XSH_MOD_CFG_OPT_2D_UVB "XSH_MOD_CFG_OPT_2D_UVB"
#define XSH_MOD_CFG_OPT_2D_VIS "XSH_MOD_CFG_OPT_2D_VIS"
#define XSH_MOD_CFG_OPT_2D_NIR "XSH_MOD_CFG_OPT_2D_NIR"


#define XSH_MOD_CFG_OPT_WAV_SLIT     "XSH_MOD_CFG_OPT_WAV_SLIT"
#define XSH_MOD_CFG_OPT_WAV_SLIT_UVB "XSH_MOD_CFG_OPT_WAV_SLIT_UVB"
#define XSH_MOD_CFG_OPT_WAV_SLIT_VIS "XSH_MOD_CFG_OPT_WAV_SLIT_VIS"
#define XSH_MOD_CFG_OPT_WAV_SLIT_NIR "XSH_MOD_CFG_OPT_WAV_SLIT_NIR"


#define XSH_MOD_CFG_OPT_WAV_IFU     "XSH_MOD_CFG_OPT_WAV_IFU"
#define XSH_MOD_CFG_OPT_WAV_IFU_UVB "XSH_MOD_CFG_OPT_WAV_IFU_UVB"
#define XSH_MOD_CFG_OPT_WAV_IFU_VIS "XSH_MOD_CFG_OPT_WAV_IFU_VIS"
#define XSH_MOD_CFG_OPT_WAV_IFU_NIR "XSH_MOD_CFG_OPT_WAV_IFU_NIR"


#define XSH_MOD_CFG_TAB "XSH_MOD_CFG_TAB"
#define XSH_MOD_CFG_TAB_UVB "XSH_MOD_CFG_TAB_UVB"
#define XSH_MOD_CFG_TAB_VIS "XSH_MOD_CFG_TAB_VIS"
#define XSH_MOD_CFG_TAB_NIR "XSH_MOD_CFG_TAB_NIR"

#define XSH_MOD_CFG_OPT_AFC "XSH_MOD_CFG_OPT_AFC"
#define XSH_MOD_CFG_OPT_AFC_UVB "XSH_MOD_CFG_OPT_AFC_UVB"
#define XSH_MOD_CFG_OPT_AFC_VIS "XSH_MOD_CFG_OPT_AFC_VIS"
#define XSH_MOD_CFG_OPT_AFC_NIR "XSH_MOD_CFG_OPT_AFC_NIR"

#define XSH_MOD_CFG      "XSH_MOD_CFG_TAB"
#define XSH_MOD_CFG_UVB  "XSH_MOD_CFG_TAB_UVB"
#define XSH_MOD_CFG_VIS  "XSH_MOD_CFG_TAB_VIS"
#define XSH_MOD_CFG_NIR  "XSH_MOD_CFG_TAB_NIR"

#define XSH_MOD_CFG_OPEN      "XSH_MOD_CFG_OPEN_"
#define XSH_MOD_CFG_OPEN_UVB  "XSH_MOD_CFG_OPEN_UVB"
#define XSH_MOD_CFG_OPEN_VIS  "XSH_MOD_CFG_OPEN_VIS"
#define XSH_MOD_CFG_OPEN_NIR  "XSH_MOD_CFG_OPEN_NIR"

#define XSH_MEASCOORD   "XSH_MEASCOORD"
#define XSH_MEASCOORD_UVB   "XSH_MEASCOORD_UVB"
#define XSH_MEASCOORD_VIS   "XSH_MEASCOORD_VIS"
#define XSH_MEASCOORD_NIR   "XSH_MEASCOORD_NIR"

#define XSH_MOD_CFG_FAN     "XSH_MOD_CFG_FAN"
#define XSH_MOD_CFG_FAN_UVB "XSH_MOD_CFG_FAN_UVB"
#define XSH_MOD_CFG_FAN_VIS "XSH_MOD_CFG_FAN_VIS"
#define XSH_MOD_CFG_FAN_NIR "XSH_MOD_CFG_FAN_NIR"

#define XSH_MODEL_GUESS_XY     "XSH_MODEL_GUESS_XY"
#define XSH_MODEL_GUESS_XY_UVB "XSH_MODEL_GUESS_XY_UVB"
#define XSH_MODEL_GUESS_XY_VIS "XSH_MODEL_GUESS_XY_VIS"
#define XSH_MODEL_GUESS_XY_NIR "XSH_MODEL_GUESS_XY_NIR"

#define XSH_MEASURE_LINE_POS_XY "MEASURE_LINE_POS_XY"
#define XSH_MEASURE_LINE_POS_XY_UVB "MEASURE_LINE_POS_XY_UVB"
#define XSH_MEASURE_LINE_POS_XY_VIS "MEASURE_LINE_POS_XY_VIS"
#define XSH_MEASURE_LINE_POS_XY_NIR "MEASURE_LINE_POS_XY_NIR"


#define XSH_COL_MODEL_CONF_NAME  "Parameter_Name"    /* String */
#define XSH_COL_MODEL_CONF_UNITS  "Parameter_Units"    /* String */
#define XSH_COL_MODEL_CONF_BEST  "Best_Guess"        /* Double */
#define XSH_COL_MODEL_CONF_LOW   "Low_Limit"         /* Double */
#define XSH_COL_MODEL_CONF_HIGH  "High_Limit"        /* Double */
#define XSH_COL_MODEL_CONF_FLAG  "Compute_Flag"      /* Integer */
#define XSH_UTIL_GENCONFIG_RAW       "CONFIG"

/* products */
#define XSH_PRODUCT_PREFIX ""

#define XSH_SCIENCE_SPECTRUM    "SCIENCE.SPECTRUM"

#define XSH_IS_RAW(tag) (						\
			 XSH_CMP_TAG_ARM( tag, XSH_LINEARITY) ||	\
			 XSH_CMP_TAG_ARM( tag, XSH_DARK) ||	\
			 (strcmp(tag,XSH_DARK_AGC ) == 0) ||	\
			 (strcmp(tag,XSH_LINEARITY_UVB_OFF ) == 0) ||	\
			 (strcmp(tag,XSH_LINEARITY_UVB_ON ) == 0) ||	\
			 (strcmp(tag,XSH_LINEARITY_VIS_OFF ) == 0) ||	\
			 (strcmp(tag,XSH_LINEARITY_VIS_ON ) == 0) ||	\
			 (strcmp(tag,XSH_LINEARITY_NIR_OFF ) == 0) ||	\
			 (strcmp(tag,XSH_LINEARITY_NIR_ON ) == 0) ||	\
			 (strcmp(tag,XSH_BIAS_UVB ) == 0) ||		\
			 (strcmp(tag,XSH_BIAS_VIS ) == 0) ||		\
			 (strcmp(tag,XSH_BIAS_AGC ) == 0) ||		\
			 (strcmp(tag,XSH_FMTCHK_UVB) == 0) ||		\
			 (strcmp(tag,XSH_FMTCHK_VIS) == 0) ||		\
			 (strcmp(tag,XSH_FMTCHK_NIR) == 0) ||		\
			 (strcmp(tag,XSH_FMTCHK_OFF) == 0) ||		\
			 (strcmp(tag,XSH_ORDERDEF_QTH_UVB) == 0) ||	\
			 (strcmp(tag,XSH_ORDERDEF_D2_UVB) == 0) ||	\
			 (strcmp(tag,XSH_ORDERDEF_VIS) == 0) ||		\
			 (strcmp(tag,XSH_ORDERDEF_NIR) == 0) ||		\
			 (strcmp(tag,XSH_ORDERDEF_OFF) == 0) ||		\
			 (strcmp(tag,XSH_FLAT_QTH_SLIT_UVB) == 0) ||	\
			 (strcmp(tag,XSH_FLAT_D2_SLIT_UVB) == 0) ||	\
			 (strcmp(tag,XSH_FLAT_SLIT_VIS) == 0) ||	\
			 (strcmp(tag,XSH_FLAT_SLIT_NIR) == 0) ||	\
			 (strcmp(tag,XSH_FLAT_SLIT_OFF) == 0) ||	\
			 (strcmp(tag,XSH_FLAT_QTH_IFU_UVB) == 0) ||	\
			 (strcmp(tag,XSH_FLAT_D2_IFU_UVB) == 0) ||	\
			 (strcmp(tag,XSH_FLAT_IFU_VIS) == 0) ||		\
			 (strcmp(tag,XSH_FLAT_IFU_NIR) == 0) ||		\
			 (strcmp(tag,XSH_FLAT_IFU_OFF) == 0) ||		\
			 (strcmp(tag,XSH_WAVE_UVB) == 0) ||		\
			 (strcmp(tag,XSH_WAVE_VIS) == 0) ||		\
			 (strcmp(tag,XSH_WAVE_NIR) == 0) ||		\
			 (strcmp(tag,XSH_WAVE_OFF) == 0) ||		\
			 (strcmp(tag,XSH_ARC_IFU_UVB) == 0) ||		\
			 (strcmp(tag,XSH_ARC_IFU_VIS) == 0) ||		\
			 (strcmp(tag,XSH_ARC_IFU_NIR) == 0) ||		\
			 (strcmp(tag,XSH_ARC_IFU_OFF) == 0) ||		\
			 (strcmp(tag,XSH_ARC_SLIT_UVB) == 0) ||		\
			 (strcmp(tag,XSH_ARC_SLIT_VIS) == 0) ||		\
			 (strcmp(tag,XSH_ARC_SLIT_NIR) == 0) ||		\
			 (strcmp(tag,XSH_ARC_SLIT_OFF) == 0) ||		\
			XSH_CMP_TAG_ARM( tag, XSH_FLEX) ||            \
			XSH_CMP_TAG_ARM( tag, XSH_TRACE) ||            \
			XSH_CMP_TAG_ARM( tag, XSH_STD_TELL_SLIT_STARE) || \
			XSH_CMP_TAG_ARM( tag, XSH_STD_TELL_SLIT_NOD) || \
			XSH_CMP_TAG_ARM( tag, XSH_STD_TELL_IFU_STARE) || \
			XSH_CMP_TAG_ARM( tag, XSH_STD_TELL_IFU_OFFSET) || \
			XSH_CMP_TAG_ARM( tag, XSH_STD_FLUX_SLIT_STARE) || \
			XSH_CMP_TAG_ARM( tag, XSH_STD_FLUX_SLIT_OFFSET) || \
			XSH_CMP_TAG_ARM( tag, XSH_STD_FLUX_SLIT_NOD) || \
			XSH_CMP_TAG_ARM( tag, XSH_STD_FLUX_NOD) || \
			XSH_CMP_TAG_ARM( tag, XSH_STD_FLUX_IFU_STARE) || \
			XSH_CMP_TAG_ARM( tag, XSH_STD_FLUX_IFU_OFFSET) || \
			XSH_CMP_TAG_ARM( tag, XSH_OBJECT_SLIT_STARE) || \
			XSH_CMP_TAG_ARM( tag, XSH_OBJECT_SLIT_OFFSET) || \
			XSH_CMP_TAG_ARM( tag, XSH_OBJECT_SLIT_NOD) || \
			XSH_CMP_TAG_ARM( tag, XSH_OBJECT_IFU_STARE) || \
			XSH_CMP_TAG_ARM( tag, XSH_OBJECT_IFU_OFFSET) || \
			XSH_CMP_TAG_ARM( tag, XSH_SKY_SLIT) || \
			XSH_CMP_TAG_ARM( tag, XSH_IMA) || \
			 (strcmp(tag,XSH_IMA) == 0) ||			\
			XSH_CMP_TAG_ARM( tag, XSH_AFC_POS) || \
			XSH_CMP_TAG_ARM( tag, XSH_AFC_SLT) || \
			XSH_CMP_TAG_ARM( tag, XSH_AFC_CAL) || \
			XSH_CMP_TAG_ARM( tag, XSH_AFC_ATT) || \
			XSH_CMP_TAG_ARM( tag, XSH_RAW_IMA_SLIT) || \
			XSH_CMP_TAG_ARM( tag, XSH_RAW_IMA_IFU) || \
                         XSH_CMP_TAG_ARM( tag, XSH_SKY_IFU))



#define XSH_IS_CALIB(tag) (						\
			   XSH_CMP_TAG_ARM( tag, XSH_IFU_CFG_TAB) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_IFU_CFG_COR) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_DRS) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_DRS_MBIAS) ||  \
			   XSH_CMP_TAG_ARM( tag, XSH_DRS_MDARK) ||  \
			   XSH_CMP_TAG_ARM( tag, XSH_BADPIXEL_MAP) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_MASTER_BP_MAP) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_MASTER_BP_MAP_NLIN) || \
			   XSH_CMP_TAG_ARM( tag, XSH_MASTER_BP_MAP_BIAS) || \
			   XSH_CMP_TAG_ARM( tag, XSH_MASTER_BP_MAP_DARK) || \
			   XSH_CMP_TAG_ARM( tag, XSH_MASTER_BP_MAP_FLAT) || \
			   XSH_CMP_TAG_ARM( tag, XSH_BP_MAP) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_BP_MAP_CP) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_BP_MAP_HP) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_BP_MAP_SP) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_BP_MAP_DP) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_BP_MAP_NL) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_RAW_BP_MAP_NL) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_BP_MAP_RP) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_BP_MAP_NP) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_BP_MAP_PN) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_MASTER_BIAS) ||	\
			 (strcmp(tag,XSH_MASTER_BIAS_AGC) == 0) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_MASTER_DARK) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_ORDER_TAB_RECOV) || \
			   XSH_CMP_TAG_ARM( tag, XSH_ORDER_TAB_GUESS) || \
			   XSH_CMP_TAG_ARM( tag, XSH_ORDER_TAB_CENTR) || \
			   XSH_CMP_TAG_LAMP( tag, XSH_ORDER_TAB_EDGES) || \
                           XSH_CMP_TAG_MODE( tag, XSH_ORDER_TAB_AFC) || \
			   XSH_CMP_TAG_LAMP( tag, XSH_MASTER_FLAT) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_WAVE_TAB_GUESS) || \
			   XSH_CMP_TAG_ARM( tag, XSH_WAVE_TAB_2D) ||	\
                           XSH_CMP_TAG_ARM( tag, XSH_WAVE_TAB_AFC) ||    \
			   XSH_CMP_TAG_MODE( tag, XSH_WAVE_TAB_ARC) ||	\
                           XSH_CMP_TAG_MODE( tag, XSH_SHIFT_TAB) ||  \
			   XSH_CMP_TAG_ARM( tag, XSH_HIGH_ABS_WIN) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_TELL_MOD_CAT) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_ARC_LINE_LIST) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_ARC_LINE_LIST_INTMON) || \
			   XSH_CMP_TAG_ARM( tag, XSH_ARC_LINE_LIST_AFC) || \
			   XSH_CMP_TAG_ARM( tag, XSH_SKY_LINE_LIST) || \
			   XSH_CMP_TAG_ARM( tag, XSH_ARC_LINE_LIST_PREDICT) || \
			   XSH_CMP_TAG_ARM( tag, XSH_ARC_LINE_LIST_2DMAP) || \
			   XSH_CMP_TAG_ARM( tag, XSH_MOD_CFG_TAB) || \
                           XSH_CMP_TAG_ARM( tag, XSH_MOD_CFG_OPT_AFC) || \
                        /* Duplicate of XSH_MOD_CFG_TAB \
                           XSH_CMP_TAG_ARM( tag, XSH_MOD_CFG) || */ \
                           XSH_CMP_TAG_ARM( tag, XSH_MOD_CFG_OPT_REC) || \
                           XSH_CMP_TAG_ARM( tag, XSH_MOD_CFG_OPT_FMT) || \
                           XSH_CMP_TAG_ARM( tag, XSH_MOD_CFG_OPT_2D) || \
                    (strcmp(tag,XSH_MEASURE_FLAT_D2_SLIT_EDGES_UVB) == 0) || \
                    (strcmp(tag,XSH_MEASURE_FLAT_QTH_SLIT_EDGES_UVB) == 0) || \
		    (strcmp(tag,XSH_MEASURE_FLAT_SLIT_EDGES_VIS) == 0) || \
		    (strcmp(tag,XSH_MEASURE_FLAT_SLIT_EDGES_NIR) == 0) || \
		    (strcmp(tag,XSH_MEASURE_FLAT_D2_IFU_EDGES_UVB) == 0) || \
		    (strcmp(tag,XSH_MEASURE_FLAT_QTH_IFU_EDGES_UVB) == 0) || \
		    (strcmp(tag,XSH_MEASURE_FLAT_IFU_EDGES_VIS) == 0) || \
		    (strcmp(tag,XSH_MEASURE_FLAT_IFU_EDGES_NIR) == 0) || \
                           XSH_CMP_TAG_ARM( tag, XSH_MEASCOORD) || \
                           XSH_CMP_TAG_ARM( tag, XSH_MOD_CFG_OPEN) || \
                           XSH_CMP_TAG_ARM( tag, XSH_MOD_CFG_FAN) || \
                           XSH_CMP_TAG_ARM( tag, XSH_MODEL_WAVE_LIST) || \
                           XSH_CMP_TAG_ARM( tag, XSH_TELL_LINE_LIST) || \
                           XSH_CMP_TAG_ARM( tag, XSH_DISP_TAB) ||       \
                           XSH_CMP_TAG_ARM( tag, XSH_DISP_TAB_AFC) ||   \
                           XSH_CMP_TAG_ARM( tag, XSH_SLIT_MAP) ||       \
                           XSH_CMP_TAG_ARM( tag, XSH_IFU_MAP) ||       \
                           XSH_CMP_TAG_ARM( tag, XSH_RESPONSE_OFFSET) ||       \
                           XSH_CMP_TAG_ARM( tag, XSH_RESPONSE_SLIT) ||       \
                           XSH_CMP_TAG_ARM( tag, XSH_RESPONSE_ORDER1D_SLIT) || \
                           XSH_CMP_TAG_ARM( tag, XSH_RESPONSE_MERGE1D_SLIT) || \
                           XSH_CMP_TAG_ARM( tag, XSH_MRESPONSE_MERGE1D_SLIT) || \
 			   XSH_CMP_TAG_ARM( tag, XSH_RESPONSE_IFU) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_OFFSET_TABLE) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_TELL_MASK) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_STD_STAR_FLUX) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_THEO_TAB_SING) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_THEO_TAB_MULT) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_THEO_TAB_IFU) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_WAVE_MAP) ||	\
			   XSH_CMP_TAG_ARM( tag, XSH_SKY_SUB_BKPTS) ||	\
		           (strcmp(tag,XSH_SPECTRAL_FORMAT_JH_NIR) == 0) || \
			   XSH_CMP_TAG_ARM( tag, XSH_SPECTRAL_FORMAT) || \
			   XSH_CMP_TAG_ARM( tag, XSH_GUESS_LINES_POS) || \
			   XSH_CMP_TAG_ARM( tag, XSH_WAVE_TAB_ARC_DOWN_IFU) || \
			   XSH_CMP_TAG_ARM( tag, XSH_OFFSET_UP_IFU) || \
			   XSH_CMP_TAG_ARM( tag, XSH_OFFSET_CEN_IFU) || \
			   XSH_CMP_TAG_ARM( tag, XSH_OFFSET_DOWN_IFU) || \
			   XSH_CMP_TAG_ARM( tag, XSH_FLUX_STD_TAB) || \
			   XSH_CMP_TAG_ARM( tag, XSH_FLUX_STD_CAT) || \
			   XSH_CMP_TAG_ARM( tag, XSH_RESP_FIT_POINTS_CAT) || \
			   XSH_CMP_TAG_ARM( tag, XSH_EXTCOEFF_TAB) || \
			   XSH_CMP_TAG_ARM( tag, XSH_WAVE_TAB_ARC_CEN_IFU) || \
			   XSH_CMP_TAG_ARM( tag, XSH_WAVE_TAB_ARC_UP_IFU) || \
			   XSH_CMP_TAG_ARM( tag, XSH_STD_FLUX_SLIT_STARE_ORDER1D) || \
			   XSH_CMP_TAG_ARM( tag, XSH_STD_FLUX_SLIT_STARE_MERGE1D) || \
			   XSH_CMP_TAG_ARM( tag, XSH_SLICE_OFFSET) || \
                        /* Duplicated above: \
			   XSH_CMP_TAG_ARM( tag, XSH_IFU_MAP) || \
			   XSH_CMP_TAG_ARM( tag, XSH_SLIT_MAP) || \
			   XSH_CMP_TAG_ARM( tag, XSH_SLIT_MAP_POLY) || \
			   XSH_CMP_TAG_ARM( tag, XSH_SLIT_MAP_MODEL) || */ \
			   XSH_CMP_TAG_ARM( tag, XSH_ATMOS_EXT))


#define XSH_STD_TELL_SLIT(arm)\
  (arm) == XSH_ARM_UVB ? "STD_TELL_SLIT_STARE_UVB" :    \
  (arm) == XSH_ARM_VIS ? "STD_TELL_SLIT_STARE_VIS" :    \
  (arm) == XSH_ARM_NIR ? "STD_TELL_SLIT_STARE_NIR" : "??TAG??"

#define XSH_STD_FLUX_SLIT(arm)\
  (arm) == XSH_ARM_UVB ? "STD_FLUX_SLIT_STARE_UVB" :    \
  (arm) == XSH_ARM_VIS ? "STD_FLUX_SLIT_STARE_VIS" :    \
  (arm) == XSH_ARM_NIR ? "STD_FLUX_SLIT_STARE_NIR" : "??TAG??"


#define XSH_STD_TELL_OFFSET(arm)\
  (arm) == XSH_ARM_UVB ? "STD_TELL_SLIT_OFFSET_UVB" :    \
  (arm) == XSH_ARM_VIS ? "STD_TELL_SLIT_OFFSET_VIS" :    \
  (arm) == XSH_ARM_NIR ? "STD_TELL_SLIT_OFFSET_NIR" : "??TAG??"

#define XSH_STD_FLUX_OFFSET(arm)\
  (arm) == XSH_ARM_UVB ? "STD_FLUX_SLIT_OFFSET_UVB" :    \
  (arm) == XSH_ARM_VIS ? "STD_FLUX_SLIT_OFFSET_VIS" :    \
  (arm) == XSH_ARM_NIR ? "STD_FLUX_SLIT_OFFSET_NIR" : "??TAG??"


#define XSH_STD_FLUX(arm)\
  (arm) == XSH_ARM_UVB ? "STD_FLUX_STARE_UVB" :    \
  (arm) == XSH_ARM_VIS ? "STD_FLUX_STARE_VIS" :    \
  (arm) == XSH_ARM_NIR ? "STD_FLUX_STARE_NIR" : "??TAG??"

#define XSH_STD_STAR_FLUX(arm)\
  (arm) == XSH_ARM_UVB ? "STD_STAR_FLUX_UVB" :    \
  (arm) == XSH_ARM_VIS ? "STD_STAR_FLUX_VIS" :    \
  (arm) == XSH_ARM_NIR ? "STD_STAR_FLUX_NIR" : "??TAG??"

#define XSH_RESPONSE(arm)\
  (arm) == XSH_ARM_UVB ? "RESPONSE_UVB" :    \
  (arm) == XSH_ARM_VIS ? "RESPONSE_VIS" :    \
  (arm) == XSH_ARM_NIR ? "RESPONSE_NIR" : "??TAG??"

#define XSH_CMP_TAG_ARM( tag_in, TAG) \
  ( strcmp(tag_in, TAG##_UVB) == 0) || \
  ( strcmp(tag_in, TAG##_VIS) == 0) || \
  ( strcmp(tag_in, TAG##_NIR) == 0)

#define XSH_CMP_TAG_MODE( tag_in, TAG) \
  ( strcmp( tag_in, TAG##_SLIT##_UVB) == 0) || \
  ( strcmp( tag_in, TAG##_SLIT##_VIS) == 0) || \
  ( strcmp( tag_in, TAG##_SLIT##_NIR) == 0) || \
  ( strcmp( tag_in, TAG##_IFU##_UVB) == 0) || \
  ( strcmp( tag_in, TAG##_IFU##_VIS) == 0) || \
  ( strcmp( tag_in, TAG##_IFU##_NIR) == 0)

#define XSH_CMP_TAG_LAMP( tag_in, TAG) \
  ( strcmp( tag_in, TAG##_SLIT##_UVB) == 0) || \
  ( strcmp( tag_in, TAG##_SLIT##_VIS) == 0) || \
  ( strcmp( tag_in, TAG##_SLIT##_NIR) == 0) || \
  ( strcmp( tag_in, TAG##_IFU##_UVB) == 0) || \
  ( strcmp( tag_in, TAG##_IFU##_VIS) == 0) || \
  ( strcmp( tag_in, TAG##_IFU##_NIR) == 0) || \
  ( strcmp( tag_in, TAG##_QTH_SLIT##_UVB) == 0) || \
  ( strcmp( tag_in, TAG##_D2_SLIT##_UVB) == 0) || \
  ( strcmp( tag_in, TAG##_QTH_IFU##_UVB) == 0) || \
  ( strcmp( tag_in, TAG##_D2_IFU##_UVB) == 0)

#define XSH_GET_TAG_FROM_ARM(TAG, instr)\
  (xsh_instrument_get_arm(instr)) == XSH_ARM_UVB ? TAG##_UVB : \
  (xsh_instrument_get_arm(instr)) == XSH_ARM_VIS ? TAG##_VIS :    \
  (xsh_instrument_get_arm(instr)) == XSH_ARM_NIR ? TAG##_NIR : "??TAG??"

#define XSH_GET_TAG_FROM_ARM_EXT(TAG, instr)\
  (xsh_instrument_get_arm(instr)) == XSH_ARM_UVB ? TAG##_UVB : \
  (xsh_instrument_get_arm(instr)) == XSH_ARM_VIS ? TAG##_VIS :    \
  (xsh_instrument_get_arm(instr)) == XSH_ARM_NIR ? TAG##_NIR :    \
  (xsh_instrument_get_arm(instr)) == XSH_ARM_AGC ? TAG##_AGC : "??TAG??"

#define XSH_GET_TAG_FROM_SLITLET( TAG, slitlet, instr)\
 ( (xsh_instrument_get_arm(instr)) == XSH_ARM_UVB && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_SLIT)) ? TAG##_UVB : \
 ( (xsh_instrument_get_arm(instr)) == XSH_ARM_VIS && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_SLIT)) ? TAG##_VIS : \
 ( (xsh_instrument_get_arm(instr)) == XSH_ARM_NIR && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_SLIT)) ? TAG##_NIR : \
 ( (xsh_instrument_get_arm(instr) == XSH_ARM_UVB) && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_IFU) && \
   (slitlet == LOWER_IFU_SLITLET)) ? TAG##_DOWN_IFU_UVB :\
 ( (xsh_instrument_get_arm(instr) == XSH_ARM_UVB) && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_IFU) && \
   (slitlet == CENTER_IFU_SLITLET)) ? TAG##_CEN_IFU_UVB :\
 ( (xsh_instrument_get_arm(instr) == XSH_ARM_UVB) && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_IFU) && \
   (slitlet == UPPER_IFU_SLITLET)) ? TAG##_UP_IFU_UVB :\
 ( (xsh_instrument_get_arm(instr) == XSH_ARM_VIS) && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_IFU) && \
   (slitlet == LOWER_IFU_SLITLET)) ? TAG##_DOWN_IFU_VIS :\
 ( (xsh_instrument_get_arm(instr) == XSH_ARM_VIS) && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_IFU) && \
   (slitlet == CENTER_IFU_SLITLET)) ? TAG##_CEN_IFU_VIS :\
 ( (xsh_instrument_get_arm(instr) == XSH_ARM_VIS) && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_IFU) && \
   (slitlet == UPPER_IFU_SLITLET)) ? TAG##_UP_IFU_VIS :\
 ( (xsh_instrument_get_arm(instr) == XSH_ARM_NIR) && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_IFU) && \
   (slitlet == LOWER_IFU_SLITLET)) ? TAG##_DOWN_IFU_NIR :\
 ( (xsh_instrument_get_arm(instr) == XSH_ARM_NIR) && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_IFU) && \
   (slitlet == CENTER_IFU_SLITLET)) ? TAG##_CEN_IFU_NIR :\
 ( (xsh_instrument_get_arm(instr) == XSH_ARM_NIR) && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_IFU) && \
   (slitlet == UPPER_IFU_SLITLET)) ? TAG##_UP_IFU_NIR : "??TAG??"

#define XSH_GET_TAG_FROM_MODE(TAG, instr)\
 ( (xsh_instrument_get_arm(instr)) == XSH_ARM_UVB && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_SLIT)) ? TAG##_SLIT##_UVB : \
 ( (xsh_instrument_get_arm(instr)) == XSH_ARM_VIS && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_SLIT)) ? TAG##_SLIT##_VIS : \
 ( (xsh_instrument_get_arm(instr)) == XSH_ARM_NIR && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_SLIT)) ? TAG##_SLIT##_NIR : \
 ( (xsh_instrument_get_arm(instr)) == XSH_ARM_UVB && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_IFU)) ? TAG##_IFU##_UVB : \
 ( (xsh_instrument_get_arm(instr)) == XSH_ARM_VIS && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_IFU)) ? TAG##_IFU##_VIS : \
 ( (xsh_instrument_get_arm(instr)) == XSH_ARM_NIR && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_IFU)) ? TAG##_IFU##_NIR : "??TAG??"

#define XSH_GET_TAG_FROM_LAMP(TAG, instr)\
 ( (xsh_instrument_get_arm(instr)) == XSH_ARM_UVB && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_SLIT) && \
   (xsh_instrument_get_lamp(instr) == XSH_LAMP_UNDEFINED)) ? TAG##_SLIT##_UVB : \
 ( (xsh_instrument_get_arm(instr)) == XSH_ARM_UVB && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_SLIT) && \
   (xsh_instrument_get_lamp(instr) == XSH_LAMP_QTH)) ? TAG##_QTH_SLIT##_UVB : \
 ( (xsh_instrument_get_arm(instr)) == XSH_ARM_UVB && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_SLIT) && \
   (xsh_instrument_get_lamp(instr) == XSH_LAMP_D2)) ? TAG##_D2_SLIT##_UVB : \
 ( (xsh_instrument_get_arm(instr)) == XSH_ARM_VIS && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_SLIT) && \
   (xsh_instrument_get_lamp(instr) == XSH_LAMP_UNDEFINED)) ? TAG##_SLIT##_VIS : \
 ( (xsh_instrument_get_arm(instr)) == XSH_ARM_NIR && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_SLIT) && \
   (xsh_instrument_get_lamp(instr) == XSH_LAMP_UNDEFINED)) ? TAG##_SLIT##_NIR : \
 ( (xsh_instrument_get_arm(instr)) == XSH_ARM_UVB && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_IFU) && \
   (xsh_instrument_get_lamp(instr) == XSH_LAMP_UNDEFINED)) ? TAG##_IFU##_UVB : \
 ( (xsh_instrument_get_arm(instr)) == XSH_ARM_UVB && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_IFU) && \
   (xsh_instrument_get_lamp(instr) == XSH_LAMP_QTH)) ? TAG##_QTH_IFU##_UVB : \
 ( (xsh_instrument_get_arm(instr)) == XSH_ARM_UVB && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_IFU) && \
   (xsh_instrument_get_lamp(instr) == XSH_LAMP_D2)) ? TAG##_D2_IFU##_UVB : \
 ( (xsh_instrument_get_arm(instr)) == XSH_ARM_VIS && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_IFU) && \
   (xsh_instrument_get_lamp(instr) == XSH_LAMP_UNDEFINED))? TAG##_IFU##_VIS : \
 ( (xsh_instrument_get_arm(instr)) == XSH_ARM_NIR && \
   (xsh_instrument_get_mode(instr) == XSH_MODE_IFU) && \
   (xsh_instrument_get_lamp(instr) == XSH_LAMP_UNDEFINED))? TAG##_IFU##_NIR : "??TAG??"

/*----------------------------------------------------------------------------
                                Functions prototypes
 ----------------------------------------------------------------------------*/

cpl_frame* 
xsh_frame_product(const char* fname, const char* tag, cpl_frame_type type, 
                  cpl_frame_group group,cpl_frame_level level);

void
xsh_frame_config(const char* fname, const char* tag, cpl_frame_type type, 
                  cpl_frame_group group,cpl_frame_level level,cpl_frame** frm);

int xsh_print_rec_status(const int val);

cpl_frameset *
xsh_frameset_extract(const cpl_frameset *frames,
                     const char *tag);

cpl_error_code
xsh_dfs_extract_calib_frames (cpl_frameset * input, cpl_frameset * calib);
cpl_error_code
xsh_dfs_extract_raw_frames (cpl_frameset * input, cpl_frameset * raws);
cpl_error_code
xsh_dfs_extract_pro_frames (cpl_frameset * input, cpl_frameset * pros);


xsh_instrument* xsh_dfs_set_groups(cpl_frameset *);
void xsh_dfs_split_in_group(cpl_frameset* input,cpl_frameset* raws, 
		cpl_frameset* calib);
void xsh_dfs_split_nir(cpl_frameset * input, cpl_frameset** on,
  cpl_frameset** off);
void xsh_dfs_split_qth_d2(cpl_frameset * input, cpl_frameset** qth,
  cpl_frameset** d2);
void xsh_dfs_filter( cpl_frameset* raws,const char* tag[], int size);


void xsh_add_product_spectrum( cpl_frame *product_frame, cpl_frameset *frameset,
  const cpl_parameterlist *parameters, const char *recipe_id,
  xsh_instrument* instr, cpl_frame ** result_frame);

void xsh_add_product_pre( cpl_frame *product_frame, cpl_frameset *frameset,
  const cpl_parameterlist *parameters, const char *recipe_id,
  xsh_instrument* instr);

void xsh_add_product_pre_3d ( cpl_frame * frame, cpl_frameset * frameset, 
			      const cpl_parameterlist *parameters,
			      const char *recipe_id,
			      xsh_instrument* instr) ;

void xsh_add_product_bpmap(cpl_frame *product_frame,
			   cpl_frameset *frameset,
			   const cpl_parameterlist *parameters,
			   const char *recipe_id,
			   xsh_instrument* instr,
			   const char *prefix );

void xsh_add_product_image( cpl_frame *frame, cpl_frameset * frameset,
			    const cpl_parameterlist * parameters,
			    const char *recipe_id,
			    xsh_instrument* instrument,
			    const char *final_prefix ) ;

void xsh_add_product_vector( cpl_frame *frame, cpl_frameset * frameset,
			    const cpl_parameterlist * parameters,
			    const char *recipe_id,
			    xsh_instrument* instrument,
			    const char *final_prefix ) ;
			    
void xsh_add_product_imagelist( cpl_frame *frame, cpl_frameset * frameset,
			    const cpl_parameterlist * parameters,
			    const char *recipe_id,
			    xsh_instrument* instrument,
			    const char *final_prefix ) ;

void xsh_add_product_table( cpl_frame *frame, cpl_frameset * frameset,
                                  const cpl_parameterlist * parameters, 
                                  const char *recipe_id,
                                  xsh_instrument* instrument,
                                  const char* tag_prefix);

void xsh_add_sdp_product_spectrum(const cpl_frame *flux_cal_frame,
                                  const cpl_frame *uncal_frame,
                                  cpl_frameset *frameset,
                                  const cpl_frameset *usedframes,
                                  const cpl_parameterlist *parameters,
                                  const char *recipe_id,
                                  xsh_instrument* instrument);

char *
xsh_unique_filename(const char *context, const char *caller_id,
		    const char *pro_catg);

cpl_frame *xsh_find_bpmap(cpl_frameset * set);
cpl_frame *xsh_find_master_bpmap(cpl_frameset * set);

void xsh_dfs_find_flat(cpl_frameset* raws,cpl_frameset* flat);
cpl_frame * xsh_find_std_flux(cpl_frameset *frames);
cpl_frame * xsh_find_std_star_flux(cpl_frameset *frames);
cpl_frame *xsh_find_master_bias(cpl_frameset *frames,xsh_instrument* instr);
cpl_frame *xsh_find_master_dark(cpl_frameset *frames,xsh_instrument* instr);
cpl_frame *xsh_find_master_flat(cpl_frameset *frames,xsh_instrument* instr);
cpl_frame *xsh_find_order_tab_recov( cpl_frameset *frames,
  xsh_instrument* instr);
cpl_frame *xsh_find_order_tab_guess( cpl_frameset *frames,
  xsh_instrument* instr);
cpl_frame *xsh_find_order_tab_centr( cpl_frameset *frames,
  xsh_instrument* instr);
cpl_frame *xsh_find_order_tab_edges( cpl_frameset *frames,
  xsh_instrument* instr);
cpl_frame *xsh_find_theo_tab_sing( cpl_frameset *frames, 
  xsh_instrument* instr);
cpl_frame *xsh_find_theo_tab_mult( cpl_frameset *frames, 
  xsh_instrument* instr);
cpl_frame *xsh_find_theo_tab_mode( cpl_frameset *frames, 
  xsh_instrument* instr);
cpl_frame *xsh_find_wave_tab_guess( cpl_frameset *frames, 
  xsh_instrument* instr);
cpl_frame *xsh_find_wave_tab_2d( cpl_frameset *frames,
  xsh_instrument* instr);
cpl_frame *xsh_find_slitmap( cpl_frameset *frames,
			     xsh_instrument* instr);
cpl_frame *xsh_find_model_config_tab( cpl_frameset *frames,
  xsh_instrument* instr);
cpl_frame *xsh_find_wave_tab( cpl_frameset *frames,
  xsh_instrument* instr);
cpl_frame *xsh_find_model_config( cpl_frameset *frames,
  xsh_instrument* instr);
cpl_frameset* xsh_find_wave_tab_ifu( cpl_frameset *frames,
  xsh_instrument* instr);
cpl_frameset* xsh_find_offset_tab_ifu( cpl_frameset *frames,
  xsh_instrument* instr);
cpl_frame *xsh_find_arc_line_list_clean( cpl_frameset *frames,
  xsh_instrument* instr);
cpl_frame *xsh_find_arc_line_list( cpl_frameset *frames,
  xsh_instrument* instr);
cpl_frame * xsh_find_raw_orderdef_vis_uvb ( cpl_frameset * frames ) ;
cpl_frame * xsh_find_raw_orderdef_nir ( cpl_frameset * frames ) ;
cpl_frame * xsh_find_raw_orderdef_nir_off ( cpl_frameset * frames ) ;
cpl_frame * xsh_find_on(cpl_frameset* set);
cpl_frame * xsh_find_off(cpl_frameset* set);
cpl_frame * xsh_find_raw_arc_slit_uvb_vis( cpl_frameset * frames,
					   XSH_ARM arm ) ;
cpl_frame * xsh_find_raw_arc_slit_nir_on( cpl_frameset * frames ) ;
cpl_frame * xsh_find_raw_arc_slit_nir_off( cpl_frameset * frames ) ;
cpl_frame * xsh_find_wavemap( cpl_frameset * frames,
			      xsh_instrument* instrument ) ;
cpl_frame * xsh_find_spectral_format( cpl_frameset * frames,
				      xsh_instrument * instr );

cpl_frame * xsh_find_calpro_model_config( cpl_frameset * frames,
                                   xsh_instrument * instr );


cpl_frame * xsh_find_model_config_open( cpl_frameset * frames,
                                   xsh_instrument * instr );

cpl_frame* xsh_find_disp_tab( cpl_frameset * frames,
			      xsh_instrument* instrument);


cpl_frame * xsh_find_model_wavelist( cpl_frameset * frames,
                                     xsh_instrument * instr );


cpl_frame * xsh_find_model_testpar( cpl_frameset * frames,
				    xsh_instrument * instr );

cpl_frame * xsh_find_calpro_model_meas_coord( cpl_frameset * frames,
					      xsh_instrument * instr );

cpl_frame *xsh_find_model_config_opt( cpl_frameset *frames,
				       xsh_instrument* instr);
cpl_frameset*
xsh_extract_obj_and_sky_pairs(cpl_frameset* raws, xsh_instrument* instrument);


cpl_frame* 
xsh_find_frame_with_tag (cpl_frameset * frames, 
                         const char* tag, 
                         xsh_instrument* instr);
char* xsh_get_tag_from_arm(const char* tag, xsh_instrument* instr);
cpl_frame *xsh_find_usr_lines_guess_tab( cpl_frameset *frames,
					 xsh_instrument* instr);


void xsh_add_product(cpl_frame *frame, 
                     cpl_frameset * frameset,
		     const cpl_parameterlist * parameters,
		     const char *recipe_id,
		     xsh_instrument* instrument,
		     const char *final_prefix ,const char* type) ;

int xsh_dfs_split_offset(cpl_frameset * input, const char * object_tag,
			  const char * sky_tag,
			  cpl_frameset ** object,
			  cpl_frameset ** sky) ;
cpl_frameset* 
xsh_frameset_ext_table_frames(cpl_frameset* set);
cpl_frameset*
xsh_frameset_ext_image_frames(cpl_frameset* set);
cpl_frameset*
xsh_frameset_drl_frames(cpl_frameset* set);
cpl_error_code
xsh_frameset_merge(cpl_frameset * set1, cpl_frameset* set2);
cpl_error_code xsh_ensure_raws_number_is_even(cpl_frameset* raws);

cpl_frameset *
xsh_frameset_extract_pre(cpl_frameset * set, const char* prefix);
int xsh_file_exists(const char * filename);
int xsh_dfs_files_dont_exist(cpl_frameset *frameset);
cpl_error_code
xsh_ensure_raws_input_offset_recipe_is_proper(cpl_frameset** raws, xsh_instrument* instrument);

cpl_frameset*
xsh_extract_nod_pairs(cpl_frameset* raws, 
                      cpl_vector* offset);


cpl_frameset*
xsh_frameset_extract_offsety_matches(cpl_frameset* raws,const double offset);

cpl_frameset*
xsh_frameset_extract_offsety_mismatches(cpl_frameset* raws,const double offset);
cpl_error_code xsh_validate_model_cfg(cpl_frame* mod, cpl_frameset* set);

int xsh_parameter_get_default_flag(const cpl_parameter* p);
cpl_propertylist*
xsh_frame_head_extract_qc(cpl_frame* frm);

cpl_boolean xsh_mode_is_physmod(cpl_frameset* set,xsh_instrument* instrument);

cpl_error_code
xsh_dfs_check_binning(cpl_frameset* raw,cpl_frameset* calib);

cpl_frameset*
xsh_correct_calib(cpl_frameset* raws, cpl_frameset* calib);

cpl_error_code
xsh_calib_nir_corr_if_JH(cpl_frameset* calib,xsh_instrument* instr, const char* recid);

cpl_error_code
xsh_calib_nir_respon_corr_if_JH(cpl_frameset* calib,xsh_instrument* instr);

cpl_error_code
xsh_dfs_check_mflat_is_proper(xsh_instrument* inst,cpl_frameset** calib);

cpl_error_code
xsh_frameset_check_uniform_exptime(cpl_frameset* raws, xsh_instrument* inst);

cpl_error_code
xsh_table_save(cpl_table* t, cpl_propertylist* ph, cpl_propertylist* xh, const char* fname, const int ext);

cpl_error_code
xsh_vector_save(cpl_vector* v, cpl_propertylist* ph, const char* fname, const int ext);

cpl_error_code
xsh_frameset_uniform_bin(cpl_frameset** raws, cpl_frameset** calib,xsh_instrument* instrument);


cpl_error_code
xsh_add_afc_info(cpl_frame* frm_m, cpl_frame* frm_o);

#endif
